/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.worker;

import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.algo.AlgoManager;
import kd.opmc.epa.business.domain.indicator.imp.constant.MCConfigConstant;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportBillData;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportQueue;
import kd.opmc.epa.business.domain.indicator.imp.log.ImportRowErrorLog;
import kd.opmc.epa.business.domain.indicator.imp.task.PutTempDataToOutQueueTask;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndImportWorker;

public class IndTempStoreDispatcher
extends IndImportWorker {
    private static Log log = LogFactory.getLog(IndTempStoreDispatcher.class);
    public static volatile boolean hasExtentColum = false;
    private Map<String, String> entityEntryFields;
    private AlgoManager algoManager;
    protected Map<String, ImportQueue<ImportBillData>> groupImportBillData = Maps.newHashMapWithExpectedSize((int)6);
    private Map<String, Set<Integer>> validatefailedBillDatasForMEMS = Maps.newHashMapWithExpectedSize((int)6);

    public IndTempStoreDispatcher(IndImportStart importStart) {
        super(IndTempStoreDispatcher.class.getSimpleName(), importStart, importStart.getTempStoreQueue(), importStart.getWaitInStoreQueue(), MCConfigConstant.getWorkerMaxThread());
        this.algoManager = new AlgoManager(importStart);
    }

    public AlgoManager getAlgoManager() {
        return this.algoManager;
    }

    public Map<String, String> getEntityEntryFields() {
        return this.entityEntryFields;
    }

    public Map<String, Set<Integer>> getValidatefailedBillDatasForMEMS() {
        return this.validatefailedBillDatasForMEMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        ImportQueue<ImportBillData> dataQueue;
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId(this.importStart.getImportContext().getRc());
        log.info(this.name + "_started.");
        ImportContext importContext = this.importStart.getImportContext();
        try {
            this.initEntityEntryFields();
        }
        catch (Throwable e) {
            log.error(e);
            this.importStart.writeErrorLog(e);
            super.interruptMainThread();
        }
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                List<ImportBillData> tempBilldatas = super.getBatchData(3000);
                log.info(this.name + "_receivedTempBilldatas.count=" + tempBilldatas.size());
                List<String> effectSheetNames = this.importStart.getImportContext().getEffectSheetNames();
                if (CollectionUtils.isNotEmpty(effectSheetNames) && effectSheetNames.size() > 1) {
                    this.groupImportBillData(tempBilldatas);
                    for (Map.Entry<String, ImportQueue<ImportBillData>> next : this.groupImportBillData.entrySet()) {
                        dataQueue = next.getValue();
                        this.submitTask(dataQueue);
                    }
                    continue;
                }
                if (tempBilldatas.size() <= 0) continue;
                this.algoManager.createDataSetBuilder(tempBilldatas);
                this.getAlgoManager().save(tempBilldatas);
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
                this.interruptMainThread();
            }
        }
        try {
            this.printGroupImportBillData();
            long start2 = System.currentTimeMillis();
            this.algoManager.buildDataSet();
            this.importStart.getMonitor().addExpenseStatistics("buildDataSet", (Long)(System.currentTimeMillis() - start2), true);
            log.info("algoManager.buildDataSet_finished.");
            if (this.importStart.isStoped()) {
                return null;
            }
            ConcurrentHashMap<String, ConcurrentHashMap<Integer, ImportRowErrorLog>> rowErrors = importContext.getImportLog().getRowErrors();
            if (!rowErrors.isEmpty() && importContext.isSerialModel()) {
                ImportQueue<ImportBillData> syncLock;
                this.algoManager.getDataSetMap().values().forEach(dataSet -> dataSet.close());
                super.end();
                dataQueue = syncLock = this.importStart.syncLock;
                synchronized (dataQueue) {
                    syncLock.notifyAll();
                }
                return null;
            }
            if (this.importStart.isStoped()) {
                return null;
            }
            if (importContext.isNeedRelationInStoreForMEMS()) {
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
                long freeMemorySize = (heapMemoryUsage.getMax() - heapMemoryUsage.getUsed()) / 1024L / 1024L;
                this.importStart.getMonitor().getImportTrace().getMems().put("relateTempData_start_HMF", freeMemorySize);
                this.importStart.getMonitor().getImportTrace().getMems().put("relateTempData_end_HMF", freeMemorySize);
            } else {
                for (Map.Entry<String, DataSet> next : this.algoManager.getDataSetMap().entrySet()) {
                    super.submitWithTimeOut(new PutTempDataToOutQueueTask(next.getKey(), this.importStart, this, this.childThreadMonitor));
                }
            }
        }
        catch (Throwable e) {
            log.error(e);
            this.importStart.writeErrorLog(e);
            this.interruptMainThread();
        }
        hasExtentColum = false;
        super.end();
        this.importStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        return null;
    }

    private void submitTask(ImportQueue<ImportBillData> dataQueue) {
        int size = dataQueue.getQueue().size();
        ArrayList<ImportBillData> dataCall = new ArrayList<ImportBillData>(size);
        dataQueue.getQueue().drainTo(dataCall, size);
        if (dataCall.size() == 0) {
            return;
        }
        log.info("submitTask__dataCall.count=" + dataCall.size());
        this.algoManager.createDataSetBuilder(dataCall);
        this.getAlgoManager().save(dataCall);
    }

    private void groupImportBillData(List<ImportBillData> importBillDataList) {
        for (ImportBillData data : importBillDataList) {
            boolean result;
            ImportQueue<ImportBillData> tempdataQueue = this.groupImportBillData.get(data.getSheetName());
            if (tempdataQueue == null) {
                tempdataQueue = new ImportQueue(this.name + "_groupQueue-".concat(data.getSheetName()), new LinkedBlockingQueue(3000), this.importStart);
                this.groupImportBillData.put(data.getSheetName(), tempdataQueue);
            }
            if (result = tempdataQueue.putOnce(data)) continue;
            this.submitTask(tempdataQueue);
            tempdataQueue.putOnce(data);
        }
    }

    private void initEntityEntryFields() {
        Map<String, IFormView> formIdEntityFormViewMap = this.importStart.getImportContext().getFormIdEntityFormViewMap();
        this.entityEntryFields = Maps.newHashMapWithExpectedSize((int)formIdEntityFormViewMap.size());
        for (Map.Entry<String, IFormView> next : formIdEntityFormViewMap.entrySet()) {
            StringBuilder builder = new StringBuilder();
            MainEntityType dataEntityType = next.getValue().getModel().getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            properties.forEach(pro -> {
                if (pro instanceof EntryProp) {
                    builder.append(pro.getName()).append(",");
                }
            });
            this.entityEntryFields.put(next.getKey(), builder.toString());
        }
    }

    private void printGroupImportBillData() {
        if (this.groupImportBillData != null && this.groupImportBillData.size() > 0) {
            StringBuilder builder = new StringBuilder("groupImportBillData_queue_size,");
            this.groupImportBillData.values().forEach(queue -> builder.append(queue.getName()).append("=").append(queue.getQueue().size()).append(","));
            log.info(builder.toString());
        }
    }
}

