/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.imp.worker;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.opmc.epa.business.domain.indicator.imp.IndImportStart;
import kd.opmc.epa.business.domain.indicator.imp.entity.ImportContext;
import kd.opmc.epa.business.domain.indicator.imp.util.MethodUtil;
import kd.opmc.epa.business.domain.indicator.imp.validators.IndDataValidateManager;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndImportWorker;
import kd.opmc.epa.business.domain.indicator.imp.worker.IndParser;

public class IndTimeRemainingAnalyser
extends IndImportWorker {
    private static Log log = LogFactory.getLog(IndTimeRemainingAnalyser.class);
    public static final String HAS_GETALL_ASSESS_TOTALBILLCOUNT = "hasGetAllAssessTotalBillCount";
    public static final String ASSESS_TOTALBILLCOUNT = "assessTotalBillCount";
    private Date hasFinishedstartTime;
    private int timeRemaining;
    private int validateTimeRemaining;
    private int totalBillCount;

    public int getTimeRemaining() {
        return this.timeRemaining;
    }

    public int getValidateTimeRemaining() {
        return this.validateTimeRemaining;
    }

    public IndTimeRemainingAnalyser(IndImportStart importStart) {
        super(IndTimeRemainingAnalyser.class.getSimpleName(), importStart);
    }

    @Override
    public Object call() throws Exception {
        MethodUtil.syncRequestTraceId(this.importStart.getImportContext().getRc());
        log.info(IndTimeRemainingAnalyser.class.getSimpleName() + "_started.");
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put(HAS_GETALL_ASSESS_TOTALBILLCOUNT, false);
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                ImportContext importContext = this.importStart.getImportContext();
                this.totalBillCount = importContext.getTotalBillCount();
                IndParser parser = (IndParser)this.importStart.getWorkers().get(IndParser.class.getSimpleName());
                if (parser != null && !parser.isEnd()) {
                    IndTimeRemainingAnalyser.getAssessTotalBillCount(importContext, params);
                    int assessTotalBillCount = (Integer)params.get(ASSESS_TOTALBILLCOUNT);
                    if (assessTotalBillCount > importContext.getTotalBillCount()) {
                        this.totalBillCount = assessTotalBillCount;
                        this.importStart.getMonitor().getImportTrace().getOther().put("TAUsedAssessCount", true);
                    }
                }
                if (importContext.isSerialModel()) {
                    this.computeValidateTimeRemaining();
                }
                this.computeTimeRemaining();
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
            }
        }
        this.end();
        return null;
    }

    private void computeValidateTimeRemaining() {
        ImportContext importContext = this.importStart.getImportContext();
        IndDataValidateManager validateManager = (IndDataValidateManager)this.importStart.getWorkers().get(IndDataValidateManager.class.getSimpleName());
        Date startTime = validateManager.getValidateStartTime();
        AtomicInteger finishedValidateBillCount = importContext.getFinishedValidateBillCount();
        if (startTime == null || finishedValidateBillCount.get() == 0) {
            return;
        }
        double avgSpense = (double)(System.currentTimeMillis() - startTime.getTime()) / (double)finishedValidateBillCount.get();
        long timeRemaining = (long)((double)(this.totalBillCount - finishedValidateBillCount.get()) * avgSpense);
        this.validateTimeRemaining = (int)(timeRemaining / 1000L);
    }

    private void computeTimeRemaining() {
        ImportContext importContext = this.importStart.getImportContext();
        AtomicInteger finishedBillCount = importContext.getFinishedBillCount();
        if (this.hasFinishedstartTime == null && finishedBillCount.get() > 0) {
            this.hasFinishedstartTime = new Date();
        }
        if (this.hasFinishedstartTime == null || finishedBillCount.get() == 0) {
            return;
        }
        double avgSpense = (double)(System.currentTimeMillis() - this.hasFinishedstartTime.getTime()) / (double)finishedBillCount.get();
        long remainTime = (long)((double)(this.totalBillCount - finishedBillCount.get()) * avgSpense);
        this.timeRemaining = (int)(remainTime / 1000L);
    }

    public static Map<String, Object> getAssessTotalBillCount(ImportContext importContext, Map<String, Object> params) {
        Boolean hasGetAllAssessTotalBillCount = (Boolean)params.get(HAS_GETALL_ASSESS_TOTALBILLCOUNT);
        if (hasGetAllAssessTotalBillCount.booleanValue()) {
            return params;
        }
        AtomicInteger assessTotalBillCount = new AtomicInteger(0);
        ConcurrentHashMap<String, Map<String, Integer>> sheetDataSizeMap = importContext.getSheetDataSizeMap();
        sheetDataSizeMap.values().forEach(item -> {
            Integer count = (Integer)item.get("totalCount");
            assessTotalBillCount.getAndAdd(count);
        });
        if (sheetDataSizeMap.size() == importContext.getSheetRowCountMap().size()) {
            params.put(HAS_GETALL_ASSESS_TOTALBILLCOUNT, true);
        }
        params.put(ASSESS_TOTALBILLCOUNT, assessTotalBillCount.get());
        return params;
    }
}

