/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.service;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activity.entityservice.AttachAreaInsEntityService;
import kd.opmc.epa.business.domain.activity.entityservice.GenAreaInstanceEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAttachAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAttachAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.assessrule.service.AssessRuleDomainService;
import kd.opmc.epa.business.domain.indicator.entity.AreaNameMappingBo;
import kd.opmc.epa.business.domain.indicator.entityservice.IndicatorGroupEntityService;
import kd.opmc.epa.business.domain.indicator.ext.IIndicatorGroupCopyGenAreaField;
import kd.opmc.epa.business.domain.indicator.ext.IndicatorGroupAreaCopy;
import kd.opmc.epa.business.domain.indicator.ext.impl.IndicatorGroupAreaCopyImpl;
import kd.opmc.epa.business.domain.scheme.service.ExecuteSchemeDomainService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.assessrule.AdjustTypeEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.common.enums.FieldTypeEnum;
import org.jetbrains.annotations.NotNull;

public class IndicatorGroupDomainService {
    private static final Log LOG = LogFactory.getLog(IndicatorGroupDomainService.class);
    private static final AssessRuleDomainService ASSESS_RULE_DOMAIN_SERVICE = AssessRuleDomainService.getInstance();
    private static final GenAreaInstanceEntityService GEN_AREA_INSTANCE_ENTITY = GenAreaInstanceEntityService.getInstance();
    private static final AddSubAreaInsEntityService ADD_SUB_AREA_INS_ENTITY = AddSubAreaInsEntityService.getInstance();
    private static final AttachAreaInsEntityService ATTACH_AREA_INS_ENTITY = AttachAreaInsEntityService.getInstance();
    private static final IndicatorGroupEntityService INDICATOR_GROUP_ENTITY = IndicatorGroupEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY = AssessFormEntityService.getInstance();
    private static final AssessActivityEntityService ASSESS_ACTIVITY_ENTITY = AssessActivityEntityService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREAINS_ENTITY = ObjGenAreaInsEntityService.getInstance();
    private static final ObjAddSubAreaInsEntityService OBJ_ADDSUB_AREAINS_ENTITY = ObjAddSubAreaInsEntityService.getInstance();
    private static final ObjAttachAreaInsEntityService OBJ_ATTACH_AREAINS_ENTITY = ObjAttachAreaInsEntityService.getInstance();
    private static final ObjGenAreaIndicatorEntityService OBJ_GEN_AREA_INDICATOR_ENTITY = ObjGenAreaIndicatorEntityService.getInstance();
    private static final ObjAddSubAreaIndicatorEntityService OBJ_ADDSUB_AREA_INDICATOR_ENTITY = ObjAddSubAreaIndicatorEntityService.getInstance();
    private static final ObjAttachAreaIndicatorEntityService OBJ_ATTACH_AREA_INDICATOR_ENTITY = ObjAttachAreaIndicatorEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_OBJ_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final ActivityEvaluationObjectDomainService OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ExecuteSchemeDomainService EXECUTE_SCHEME_DOMAIN_SERVICE = ExecuteSchemeDomainService.getInstance();
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final IndicatorGroupDomainService INDICATOR_GROUP_DOMAIN_SERVICE = IndicatorGroupDomainService.getInstance();
    private static final IIndicatorGroupCopyGenAreaField iIndicatorGroupCopyGenAreaField = IIndicatorGroupCopyGenAreaField.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();

    public static IndicatorGroupDomainService getInstance() {
        return ServiceFactory.getService(IndicatorGroupDomainService.class);
    }

    public Long initIndicatorArea(DynamicObject areaReg, long confId) {
        if (ObjectUtils.isEmpty((Object)areaReg)) {
            return 0L;
        }
        Long areaRegId = areaReg.getLong("id");
        Long assessTableId = 0L;
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            DynamicObject conf = ASSESS_RULE_DOMAIN_SERVICE.queryNormalConfigByPk(confId);
            DynamicObject dy = GEN_AREA_INSTANCE_ENTITY.generateEmptyDynamicObject();
            BigDecimal weight = conf.getBigDecimal("weight");
            DynamicObject scoreSystem = conf.getDynamicObject("scoresystem");
            dy.set("areascore", conf.get("areascore"));
            dy.set("areaweight", (Object)weight);
            dy.set("scoresystem", (Object)scoreSystem);
            dy.set("forcedtype", (Object)"10");
            assessTableId = this.createAssessTableInstance(GEN_AREA_INSTANCE_ENTITY, dy);
        } else if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            DynamicObject conf = ASSESS_RULE_DOMAIN_SERVICE.queryPlusMinusConfigByPk(confId);
            BigDecimal minusLimit = conf.getBigDecimal("minuslimit");
            BigDecimal plusLimit = conf.getBigDecimal("pluslimit");
            boolean isPartIn = conf.getBoolean("ispartin");
            DynamicObject dy = ADD_SUB_AREA_INS_ENTITY.generateEmptyDynamicObject();
            dy.set("minareascore", (Object)minusLimit);
            dy.set("maxareascore", (Object)plusLimit);
            dy.set("ispartin", (Object)isPartIn);
            assessTableId = this.createAssessTableInstance(ADD_SUB_AREA_INS_ENTITY, dy);
        } else if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            DynamicObject dy = ATTACH_AREA_INS_ENTITY.generateEmptyDynamicObject();
            assessTableId = this.createAssessTableInstance(ATTACH_AREA_INS_ENTITY, dy);
        }
        return assessTableId;
    }

    private Long createAssessTableInstance(OpmcEntityService entityService, DynamicObject dynamicObject) {
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObject assessTableDy = (DynamicObject)entityService.saveOne(dynamicObject);
        return assessTableDy.getLong("id");
    }

    public DynamicObject queryAssessForm(Object pk) {
        return ASSESS_FORM_ENTITY.queryOne(pk);
    }

    public DynamicObject[] queryIndicatorGroups(String selectProperties, QFilter[] filters, String orderBys) {
        return INDICATOR_GROUP_ENTITY.query(selectProperties, filters, orderBys);
    }

    public void deleteIndicatorGroup(DynamicObject dy) {
        DynamicObject dynamicObject = INDICATOR_GROUP_ENTITY.queryOne(dy.getLong("id"));
        DynamicObjectCollection areaConfEntry = dynamicObject.getDynamicObjectCollection("indareaconfentry");
        for (int i = 0; i < areaConfEntry.size(); ++i) {
            Long areaInstanceId = ((DynamicObject)areaConfEntry.get(i)).getLong("areainstance");
            DynamicObject areaReg = ((DynamicObject)areaConfEntry.get(i)).getDynamicObject("area");
            Long areaRegId = areaReg.getLong("id");
            this.deleteIndicatorArea(areaRegId, areaInstanceId);
        }
        INDICATOR_GROUP_ENTITY.deleteOne(dy.getLong("id"));
    }

    private void deleteIndicatorArea(Long areaRegId, Long areaId) {
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            GEN_AREA_INSTANCE_ENTITY.deleteOne(areaId);
        } else if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            ADD_SUB_AREA_INS_ENTITY.deleteOne(areaId);
        } else if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            ATTACH_AREA_INS_ENTITY.deleteOne(areaId);
        }
    }

    public DynamicObject queryAssessFormByActivityId(Long ActivityId) {
        String ass = "assessform, perfworkflow, scoresystem";
        DynamicObject[] activitys = ASSESS_ACTIVITY_ENTITY.query(ass, new QFilter[]{new QFilter("id", "=", (Object)ActivityId)});
        if (activitys.length == 0) {
            return null;
        }
        return this.queryAssessForm(activitys[0].getDynamicObject("assessform").getLong("id"));
    }

    public DynamicObject queryOne(Object pkId) {
        return INDICATOR_GROUP_ENTITY.queryOne(pkId);
    }

    public DynamicObject[] queryIndicatorGroups(List<Object> pkIds) {
        QFilter qFilter = new QFilter("id", "in", pkIds);
        return INDICATOR_GROUP_ENTITY.query("id,name,description,activity,indareaconfentry.area,indareaconfentry.areainstance,indareaconfentry.areaconf", new QFilter[]{qFilter}, "activity.period");
    }

    private boolean changeNumAccuracy(DynamicObject copyFromAssessFormDy, DynamicObject copyToAssessFormDy) {
        String fromNumAccuracy = copyFromAssessFormDy.getString("numaccuracy");
        String toNumAccuracy = copyToAssessFormDy.getString("numaccuracy");
        return HRStringUtils.isNotEmpty((String)fromNumAccuracy) && HRStringUtils.isNotEmpty((String)toNumAccuracy) && Integer.parseInt(toNumAccuracy) < Integer.parseInt(fromNumAccuracy);
    }

    public Tuple<Long, List<String>> copyIndicatorGroup(DynamicObject selectIndicatorGroup, Set<String> isExistNames, Long activityId) {
        ArrayList<String> msgList = new ArrayList<String>(16);
        DynamicObject assessForm = INDICATOR_GROUP_DOMAIN_SERVICE.queryAssessFormByActivityId(activityId);
        DynamicObject copyFromAssessFormDy = INDICATOR_GROUP_DOMAIN_SERVICE.queryAssessFormByActivityId(selectIndicatorGroup.getLong("activity.id"));
        if (assessForm == null) {
            msgList.add(ResManager.loadKDString((String)"\u5f53\u524d\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u914d\u7f6e\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
            return new Tuple((Object)0L, msgList);
        }
        if (HRObjectUtils.isEmpty((Object)selectIndicatorGroup)) {
            msgList.add(ResManager.loadKDString((String)"\u6240\u9009\u5206\u7ec4\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]));
            return new Tuple((Object)0L, msgList);
        }
        HashMap<String, AreaNameMappingBo> copyToAreaMap = new HashMap<String, AreaNameMappingBo>(16);
        HashMap<Long, String> copyToAreaRegIdMap = new HashMap<Long, String>(16);
        boolean changeNumAccuracy = this.changeNumAccuracy(copyFromAssessFormDy, assessForm);
        Map<String, Integer> isExistNameMap = this.getExistNameMap(isExistNames);
        long[] indicatorGroupLongIds = DBServiceHelper.genLongIds((String)"epa_indicatorgroup", (int)1);
        DynamicObject newIndicatorGroup = INDICATOR_GROUP_ENTITY.generateEmptyDynamicObject();
        newIndicatorGroup.set("id", (Object)indicatorGroupLongIds[0]);
        String oldName = selectIndicatorGroup.getString("name");
        String newName = this.getNewName(oldName, isExistNameMap, isExistNames);
        String userId = RequestContext.get().getUserId();
        Date date = new Date();
        newIndicatorGroup.set("name", (Object)newName);
        newIndicatorGroup.set("activity", (Object)activityId);
        newIndicatorGroup.set("creator", (Object)userId);
        newIndicatorGroup.set("createtime", (Object)date);
        newIndicatorGroup.set("modifytime", (Object)date);
        newIndicatorGroup.set("modifier", (Object)userId);
        DynamicObjectCollection assTableConfOfRule = assessForm.getDynamicObjectCollection("areaconfentry");
        DynamicObjectCollection newIndAreaConfEntry = newIndicatorGroup.getDynamicObjectCollection("indareaconfentry");
        this.initAreaIndicators(copyToAreaMap, copyToAreaRegIdMap, assTableConfOfRule, newIndAreaConfEntry);
        DynamicObjectCollection copyFromAreaEntry = selectIndicatorGroup.getDynamicObjectCollection("indareaconfentry");
        HashMap<String, AreaNameMappingBo> copyFromAreaMap = new HashMap<String, AreaNameMappingBo>(16);
        this.getCopyFromMap(copyFromAreaEntry, copyFromAreaMap);
        boolean allFlag = false;
        for (DynamicObject copyToArea : newIndAreaConfEntry) {
            Long areaRegId = copyToArea.getLong("area");
            Long confId = copyToArea.getLong("areaconf");
            String areaName = (String)copyToAreaRegIdMap.get(confId);
            boolean checkFlag = true;
            if (copyFromAreaMap.get(areaName) == null) {
                String msg = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u540d\u79f0\u4e0e\u5f53\u524d\u8bc4\u4f30\u8868\u5355\u533a\u57df\u540d\u79f0\u201c{1}\u201d\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_7", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                msgList.add(msg);
                continue;
            }
            AreaNameMappingBo fromAreaNameMappingBo = (AreaNameMappingBo)copyFromAreaMap.get(areaName);
            if (!HRObjectUtils.equals((Object)areaRegId, (Object)fromAreaNameMappingBo.getAreaEntry().getLong("area.id"))) {
                String msg = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u4e0e\u5f53\u524d\u8bc4\u4f30\u8868\u5355\u533a\u201c{1}\u201d\u7684\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_8", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                msgList.add(msg);
                checkFlag = false;
            }
            AreaNameMappingBo toAreaNameMappingBo = (AreaNameMappingBo)copyToAreaMap.get(areaName);
            DynamicObject fromArea = fromAreaNameMappingBo.getAreaEntry();
            String formId = AreaRegEnum.get((Long)areaRegId).getEvalObjAreaPageIdOfAssign();
            DynamicObject fromAreaConfig = fromAreaNameMappingBo.getAreaConfig();
            DynamicObject toAreaConfig = toAreaNameMappingBo.getAreaConfig();
            LOG.info("=============fromAreaConfig:{}==============", (Object)DynamicObjectUtil.serializeToMap((DynamicObject)fromAreaConfig));
            LOG.info("===============toAreaConfig:{}===============", (Object)DynamicObjectUtil.serializeToMap((DynamicObject)toAreaConfig));
            switch (formId) {
                case "epa_genareains_assign": {
                    String msg;
                    DynamicObject copyFromAreaObj;
                    DynamicObjectCollection fromEntryEntity;
                    String msg2;
                    ScoreCalcWayEnum scoreCalcWay;
                    String scoreCalcWayStr = assessForm.getString("scorecalcway");
                    String scoreCalc = copyFromAssessFormDy.getString("scorecalcway");
                    if (!HRStringUtils.equals((String)scoreCalcWayStr, (String)scoreCalc)) {
                        checkFlag = false;
                        String msg3 = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u914d\u7f6e\u4e0e\u5f53\u524d\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{1}\u201d\u7684\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_9", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                        msgList.add(msg3);
                    }
                    if (HRObjectUtils.equals((Object)(scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)scoreCalcWayStr)), (Object)ScoreCalcWayEnum.SUM)) {
                        if (!(!checkFlag || HRObjectUtils.equals((Object)fromAreaConfig.get("isalloweval"), (Object)toAreaConfig.get("isalloweval")) && HRObjectUtils.equals((Object)fromAreaConfig.get("ispartin"), (Object)toAreaConfig.get("ispartin")) && HRObjectUtils.equals((Object)fromAreaConfig.get("isforcedcontrol"), (Object)toAreaConfig.get("isforcedcontrol")) && HRObjectUtils.equals((Object)fromAreaConfig.get("areascore"), (Object)toAreaConfig.get("areascore")) && HRObjectUtils.equals((Object)fromAreaConfig.get("reversepoints"), (Object)toAreaConfig.get("reversepoints")))) {
                            checkFlag = false;
                            msg2 = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u914d\u7f6e\u4e0e\u5f53\u524d\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{1}\u201d\u7684\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_9", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                            msgList.add(msg2);
                        }
                        if (!(!checkFlag || !fromAreaConfig.getBoolean("reversepoints") || HRObjectUtils.equals((Object)fromAreaConfig.get("reversepoints"), (Object)toAreaConfig.get("reversepoints")) && HRObjectUtils.equals((Object)fromAreaConfig.get("adjusttype"), (Object)toAreaConfig.get("adjusttype")) && HRObjectUtils.equals((Object)fromAreaConfig.get("upperscore"), (Object)toAreaConfig.get("upperscore")) && HRObjectUtils.equals((Object)fromAreaConfig.get("lowerscore"), (Object)toAreaConfig.get("lowerscore")))) {
                            checkFlag = false;
                            msg2 = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u4e0e\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{1}\u201d\u7684\u914d\u7f6e\u4e0e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_10", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                            msgList.add(msg2);
                        }
                    } else if (HRObjectUtils.equals((Object)scoreCalcWay, (Object)ScoreCalcWayEnum.WEIGHT)) {
                        if (!(!checkFlag || HRObjectUtils.equals((Object)fromAreaConfig.get("isalloweval"), (Object)toAreaConfig.get("isalloweval")) && HRObjectUtils.equals((Object)fromAreaConfig.get("ispartin"), (Object)toAreaConfig.get("ispartin")) && HRObjectUtils.equals((Object)fromAreaConfig.get("isforcedcontrol"), (Object)toAreaConfig.get("isforcedcontrol")) && HRObjectUtils.equals((Object)fromAreaConfig.get("weight"), (Object)toAreaConfig.get("weight")) && HRObjectUtils.equals((Object)fromAreaConfig.get("scoresystem.id"), (Object)toAreaConfig.get("scoresystem.id")) && HRObjectUtils.equals((Object)fromAreaConfig.get("reversepoints"), (Object)toAreaConfig.get("reversepoints")))) {
                            checkFlag = false;
                            msg2 = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u7684\u914d\u7f6e\u4e0e\u5f53\u524d\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{1}\u201d\u7684\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_9", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                            msgList.add(msg2);
                        }
                        if (!(!checkFlag || !fromAreaConfig.getBoolean("reversepoints") || HRObjectUtils.equals((Object)fromAreaConfig.get("reversepoints"), (Object)toAreaConfig.get("reversepoints")) && HRObjectUtils.equals((Object)fromAreaConfig.get("adjusttype"), (Object)toAreaConfig.get("adjusttype")) && HRObjectUtils.equals((Object)fromAreaConfig.get("upperscore"), (Object)toAreaConfig.get("upperscore")) && HRObjectUtils.equals((Object)fromAreaConfig.get("lowerscore"), (Object)toAreaConfig.get("lowerscore")))) {
                            checkFlag = false;
                            msg2 = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u4e0e\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{1}\u201d\u7684\u914d\u7f6e\u4e0e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_10", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                            msgList.add(msg2);
                        }
                    }
                    if ((fromEntryEntity = (copyFromAreaObj = GEN_AREA_INSTANCE_ENTITY.loadSingle(fromArea.getLong("areainstance"))).getDynamicObjectCollection("entryentity")) == null || fromEntryEntity.isEmpty()) {
                        checkFlag = false;
                        msg = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{1}\u201d\u4e0d\u5b58\u5728\u6307\u6807\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_11", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                        msgList.add(msg);
                    }
                    if (!checkFlag) break;
                    this.saveGenAreaInstance(changeNumAccuracy, assessForm, copyToArea, copyFromAreaObj, toAreaConfig);
                    break;
                }
                case "epa_addsubareains_assign": {
                    DynamicObject copyFromAddSubAreaObj;
                    DynamicObjectCollection fromAddSubEntryEntity;
                    String msg;
                    if (!(!checkFlag || HRObjectUtils.equals((Object)fromAreaConfig.get("pluslimit"), (Object)toAreaConfig.get("pluslimit")) && HRObjectUtils.equals((Object)fromAreaConfig.get("minuslimit"), (Object)toAreaConfig.get("minuslimit")) && HRObjectUtils.equals((Object)fromAreaConfig.get("ispartin"), (Object)toAreaConfig.get("ispartin")) && HRObjectUtils.equals((Object)fromAreaConfig.get("iscrossscore"), (Object)toAreaConfig.get("iscrossscore")))) {
                        msg = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u4e0e\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{1}\u201d\u7684\u914d\u7f6e\u4e0e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_10", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                        msgList.add(msg);
                        checkFlag = false;
                    }
                    if ((fromAddSubEntryEntity = (copyFromAddSubAreaObj = ADD_SUB_AREA_INS_ENTITY.loadSingle(fromArea.getLong("areainstance"))).getDynamicObjectCollection("entryentity")) == null || fromAddSubEntryEntity.isEmpty()) {
                        checkFlag = false;
                        String msg4 = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{1}\u201d\u4e0d\u5b58\u5728\u6307\u6807\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_11", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                        msgList.add(msg4);
                    }
                    if (!checkFlag) break;
                    this.saveAddSubAreaIns(changeNumAccuracy, assessForm, copyToArea, copyFromAddSubAreaObj, toAreaConfig);
                    break;
                }
                case "epa_attachareains_assign": {
                    DynamicObject copyFromAttachAreaObj = ATTACH_AREA_INS_ENTITY.loadSingle(fromArea.getLong("areainstance"));
                    DynamicObjectCollection fromAttachEntryEntity = copyFromAttachAreaObj.getDynamicObjectCollection("entryentity");
                    if (fromAttachEntryEntity == null || fromAttachEntryEntity.isEmpty()) {
                        checkFlag = false;
                        String msg = ResManager.loadKDString((String)"{0}\uff1a\u8bc4\u4f30\u8868\u5355\u533a\u57df\u201c{1}\u201d\u4e0d\u5b58\u5728\u6307\u6807\uff0c\u65e0\u6cd5\u590d\u5236\u3002", (String)"IndicatorGroupDomainService_11", (String)"opmc-epa-business", (Object[])new Object[]{oldName, areaName});
                        msgList.add(msg);
                    }
                    if (!checkFlag) break;
                    this.saveAttachAreaIns(changeNumAccuracy, assessForm, copyToArea, copyFromAttachAreaObj, toAreaConfig);
                    break;
                }
            }
            if (allFlag) continue;
            allFlag = checkFlag;
        }
        if (allFlag) {
            INDICATOR_GROUP_ENTITY.saveOne(newIndicatorGroup);
            return new Tuple((Object)newIndicatorGroup.getLong("id"), msgList);
        }
        this.deleteFailAreaIndicators(newIndAreaConfEntry);
        return new Tuple((Object)0L, msgList);
    }

    private void saveAttachAreaIns(boolean changeNumAccuracy, DynamicObject toActivityAssessFrom, DynamicObject copyToArea, DynamicObject copyFromAreaObj, DynamicObject toAreaConfig) {
        DynamicObject copyToAreaObj = ATTACH_AREA_INS_ENTITY.loadSingle(copyToArea.getLong("areainstance"));
        DynamicObjectCollection toEntryEntity = copyToAreaObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection fromEntryEntity = copyFromAreaObj.getDynamicObjectCollection("entryentity");
        toEntryEntity.clear();
        String fields = this.getCopyFieldList(AssessRuleConstants.ATTACH_AREA_PK);
        List filedList = Arrays.stream(fields.split(",")).collect(Collectors.toList());
        for (Object filed : filedList) {
            if (((String)filed).startsWith("entryentity") || ((String)filed).equals("id") || !copyToAreaObj.getDataEntityType().getProperties().containsKey(filed) || !copyFromAreaObj.getDataEntityType().getProperties().containsKey(filed)) continue;
            copyToAreaObj.set((String)filed, copyFromAreaObj.get((String)filed));
        }
        int index = 0;
        for (DynamicObject dynamicObject : fromEntryEntity) {
            DynamicObject addNew = toEntryEntity.addNew();
            addNew.set("seq", (Object)index);
            ++index;
            DynamicObjectCollection configEntryEntity = toAreaConfig.getDynamicObjectCollection("entryentity");
            for (String filed : filedList) {
                String[] split;
                if (!filed.startsWith("entryentity") || (split = filed.split("\\.")).length != 2 || !addNew.getDataEntityType().getProperties().containsKey((Object)split[1]) || !dynamicObject.getDataEntityType().getProperties().containsKey((Object)split[1])) continue;
                addNew.set(split[1], dynamicObject.get(split[1]));
            }
            for (DynamicObject config : configEntryEntity) {
                String number = config.getString("areafield.number");
                String propType = config.getString("areafield.proptype");
                if (!addNew.getDynamicObjectType().getProperties().containsKey((Object)number)) continue;
                if (FieldTypeEnum.Decimal.getValue().equals(propType) && changeNumAccuracy) {
                    String numAccuracy = toActivityAssessFrom.getString("numaccuracy");
                    String scaleType = toActivityAssessFrom.getString("scaletype");
                    BigDecimal sumIndctrScore = dynamicObject.getBigDecimal(number);
                    String score = sumIndctrScore.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros().toPlainString();
                    addNew.set(number, (Object)score);
                    continue;
                }
                addNew.set(number, dynamicObject.get(number));
            }
        }
        boolean result = this.copyExtPointArea(toActivityAssessFrom, copyToAreaObj, copyFromAreaObj, "epa_attachareains");
        if (result) {
            ATTACH_AREA_INS_ENTITY.saveOne(copyToAreaObj);
        }
    }

    private void saveAddSubAreaIns(boolean changeNumAccuracy, DynamicObject toActivityAssessFrom, DynamicObject copyToArea, DynamicObject copyFromAreaObj, DynamicObject toAreaConfig) {
        DynamicObject copyToAreaObj = ADD_SUB_AREA_INS_ENTITY.loadSingle(copyToArea.getLong("areainstance"));
        copyToAreaObj.set("minareascore", (Object)this.getChangeNum(changeNumAccuracy, toActivityAssessFrom, copyFromAreaObj.getBigDecimal("minareascore")));
        copyToAreaObj.set("maxareascore", (Object)this.getChangeNum(changeNumAccuracy, toActivityAssessFrom, copyFromAreaObj.getBigDecimal("maxareascore")));
        DynamicObjectCollection toEntryEntity = copyToAreaObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection fromEntryEntity = copyFromAreaObj.getDynamicObjectCollection("entryentity");
        toEntryEntity.clear();
        String fields = this.getCopyFieldList(AssessRuleConstants.PLUS_MINUS_AREA_PK);
        List filedList = Arrays.stream(fields.split(",")).collect(Collectors.toList());
        for (Object filed : filedList) {
            if (((String)filed).startsWith("entryentity") || ((String)filed).equals("id") || !copyToAreaObj.getDataEntityType().getProperties().containsKey(filed) || !copyFromAreaObj.getDataEntityType().getProperties().containsKey(filed)) continue;
            copyToAreaObj.set((String)filed, copyFromAreaObj.get((String)filed));
        }
        int index = 0;
        for (DynamicObject dynamicObject : fromEntryEntity) {
            DynamicObject addNew = toEntryEntity.addNew();
            addNew.set("seq", (Object)index);
            ++index;
            DynamicObjectCollection configEntryEntity = toAreaConfig.getDynamicObjectCollection("entryentity");
            for (String filed : filedList) {
                String[] split;
                if (!filed.startsWith("entryentity") || (split = filed.split("\\.")).length != 2 || !addNew.getDataEntityType().getProperties().containsKey((Object)split[1]) || !dynamicObject.getDataEntityType().getProperties().containsKey((Object)split[1])) continue;
                addNew.set(split[1], dynamicObject.get(split[1]));
            }
            for (DynamicObject config : configEntryEntity) {
                String number = config.getString("areafield.number");
                String propType = config.getString("areafield.proptype");
                if (!addNew.getDynamicObjectType().getProperties().containsKey((Object)number)) continue;
                if (FieldTypeEnum.Decimal.getValue().equals(propType) && changeNumAccuracy) {
                    String numAccuracy = toActivityAssessFrom.getString("numaccuracy");
                    String scaleType = toActivityAssessFrom.getString("scaletype");
                    BigDecimal sumIndctrScore = dynamicObject.getBigDecimal(number);
                    String score = sumIndctrScore.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros().toPlainString();
                    addNew.set(number, (Object)score);
                    continue;
                }
                addNew.set(number, dynamicObject.get(number));
            }
            addNew.set("iseditable", dynamicObject.get("iseditable"));
        }
        boolean result = this.copyExtPointArea(toActivityAssessFrom, copyToAreaObj, copyFromAreaObj, "epa_addsubareains");
        if (result) {
            ADD_SUB_AREA_INS_ENTITY.saveOne(copyToAreaObj);
        }
    }

    private BigDecimal getChangeNum(boolean changeNumAccuracy, DynamicObject toActivityAssessFrom, BigDecimal data) {
        if (changeNumAccuracy && data != null) {
            String numAccuracy = toActivityAssessFrom.getString("numaccuracy");
            String scaleType = toActivityAssessFrom.getString("scaletype");
            return data.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros();
        }
        return data;
    }

    private void saveGenAreaInstance(boolean changeNumAccuracy, DynamicObject toActivityAssessFrom, DynamicObject copyToArea, DynamicObject copyFromAreaObj, DynamicObject toAreaConfig) {
        DynamicObject copyToAreaObj = GEN_AREA_INSTANCE_ENTITY.loadSingle(copyToArea.getLong("areainstance"));
        copyToAreaObj.set("areaweight", (Object)this.getChangeNum(changeNumAccuracy, toActivityAssessFrom, copyFromAreaObj.getBigDecimal("areaweight")));
        copyToAreaObj.set("areascore", (Object)this.getChangeNum(changeNumAccuracy, toActivityAssessFrom, copyFromAreaObj.getBigDecimal("areascore")));
        copyToAreaObj.set("minareascore", (Object)this.getChangeNum(changeNumAccuracy, toActivityAssessFrom, copyFromAreaObj.getBigDecimal("minareascore")));
        copyToAreaObj.set("maxareascore", (Object)this.getChangeNum(changeNumAccuracy, toActivityAssessFrom, copyFromAreaObj.getBigDecimal("maxareascore")));
        DynamicObjectCollection toEntryEntity = copyToAreaObj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection fromEntryEntity = copyFromAreaObj.getDynamicObjectCollection("entryentity");
        toEntryEntity.clear();
        String fields = this.getCopyFieldList(AssessRuleConstants.NORM_INDCTR_AREA_PK);
        List filedList = Arrays.stream(fields.split(",")).collect(Collectors.toList());
        ISimpleProperty primaryKeyObj = copyToAreaObj.getDataEntityType().getPrimaryKey();
        String primaryKey = "";
        if (primaryKeyObj != null) {
            primaryKey = primaryKeyObj.getName();
        }
        for (Object filed : filedList) {
            if (((String)filed).startsWith("entryentity") || ((String)filed).equals(primaryKey) || !copyToAreaObj.getDataEntityType().getProperties().containsKey(filed) || !copyFromAreaObj.getDataEntityType().getProperties().containsKey(filed)) continue;
            copyToAreaObj.set((String)filed, copyFromAreaObj.get((String)filed));
        }
        int index = 0;
        for (DynamicObject dynamicObject : fromEntryEntity) {
            DynamicObject addNew = toEntryEntity.addNew();
            addNew.set("seq", (Object)index);
            ++index;
            DynamicObjectCollection configEntryEntity = toAreaConfig.getDynamicObjectCollection("entryentity");
            for (String filed : filedList) {
                String[] split;
                if (!filed.startsWith("entryentity") || (split = filed.split("\\.")).length != 2 || !addNew.getDataEntityType().getProperties().containsKey((Object)split[1]) || !dynamicObject.getDataEntityType().getProperties().containsKey((Object)split[1])) continue;
                addNew.set(split[1], dynamicObject.get(split[1]));
            }
            for (DynamicObject config : configEntryEntity) {
                String number = config.getString("areafield.number");
                String propType = config.getString("areafield.proptype");
                if (!addNew.getDynamicObjectType().getProperties().containsKey((Object)number)) continue;
                if (FieldTypeEnum.Decimal.getValue().equals(propType) && changeNumAccuracy) {
                    String numAccuracy = toActivityAssessFrom.getString("numaccuracy");
                    String scaleType = toActivityAssessFrom.getString("scaletype");
                    BigDecimal sumIndctrScore = dynamicObject.getBigDecimal(number);
                    BigDecimal score = sumIndctrScore.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros();
                    addNew.set(number, (Object)score);
                    continue;
                }
                addNew.set(number, dynamicObject.get(number));
            }
            addNew.set("iseditable", dynamicObject.get("iseditable"));
            if (!toAreaConfig.getBoolean("reversepoints")) continue;
            if (HRStringUtils.equals((String)toAreaConfig.getString("adjusttype"), (String)AdjustTypeEnum.NORMAL.getValue())) {
                addNew.set("minevalscore", (Object)toAreaConfig.getBigDecimal("lowerscore"));
                addNew.set("maxevalscore", (Object)toAreaConfig.getBigDecimal("upperscore"));
                continue;
            }
            addNew.set("minevalscore", (Object)this.getChangeNum(changeNumAccuracy, toActivityAssessFrom, dynamicObject.getBigDecimal("minevalscore")));
            addNew.set("maxevalscore", (Object)this.getChangeNum(changeNumAccuracy, toActivityAssessFrom, dynamicObject.getBigDecimal("maxevalscore")));
        }
        boolean result = this.copyExtPointArea(toActivityAssessFrom, copyToAreaObj, copyFromAreaObj, "epa_genareainstance");
        if (result) {
            GEN_AREA_INSTANCE_ENTITY.saveOne(copyToAreaObj);
        }
    }

    private boolean copyExtPointArea(DynamicObject toAssessForm, DynamicObject toArea, DynamicObject fromArea, String entityName) {
        IndicatorGroupAreaCopyImpl indicatorGroupAreaCopy = new IndicatorGroupAreaCopyImpl();
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)indicatorGroupAreaCopy, IndicatorGroupAreaCopy.class, (String)"kd.opmc.epa.business.domain.indicator.ext.IndicatorGroupAreaCopy#copyArea", null);
        List results = pluginProxy.callReplaceIfPresent(p -> p.copyArea(toAssessForm, toArea, fromArea, entityName));
        if (results != null && !results.isEmpty()) {
            return results.get(0) != null && (Boolean)results.get(0) != false;
        }
        return true;
    }

    private void deleteFailAreaIndicators(DynamicObjectCollection newIndAreaConfEntry) {
        for (DynamicObject copyToArea : newIndAreaConfEntry) {
            String formId;
            Long toAreaLong = copyToArea.getLong("areainstance");
            if (HRObjectUtils.isEmpty((Object)toAreaLong) || toAreaLong == 0L) continue;
            Long areaRegId = copyToArea.getLong("area");
            switch (formId = AreaRegEnum.get((Long)areaRegId).getEvalObjAreaPageIdOfAssign()) {
                case "epa_genareains_assign": {
                    GEN_AREA_INSTANCE_ENTITY.deleteOne(toAreaLong);
                    break;
                }
                case "epa_addsubareains_assign": {
                    ADD_SUB_AREA_INS_ENTITY.deleteOne(toAreaLong);
                    break;
                }
                case "epa_attachareains_assign": {
                    ATTACH_AREA_INS_ENTITY.deleteOne(toAreaLong);
                    break;
                }
            }
        }
    }

    private void getCopyFromMap(DynamicObjectCollection copyFromAreaEntry, Map<String, AreaNameMappingBo> copyFromAreaMap) {
        for (DynamicObject dynamicObject : copyFromAreaEntry) {
            String formId;
            Long areaRegId = dynamicObject.getLong("area.id");
            Long confId = dynamicObject.getLong("areaconf");
            switch (formId = AreaRegEnum.get((Long)areaRegId).getEvalObjAreaPageIdOfAssign()) {
                case "epa_genareains_assign": {
                    DynamicObject normalConfig = ASSESS_FORM_DOMAIN_SERVICE.queryNormalConfigByPk(confId);
                    copyFromAreaMap.put(normalConfig.getString("areacustname"), new AreaNameMappingBo(normalConfig, dynamicObject));
                    break;
                }
                case "epa_addsubareains_assign": {
                    DynamicObject plusMinusConfig = ASSESS_FORM_DOMAIN_SERVICE.queryPlusMinusConfigByPk(confId);
                    copyFromAreaMap.put(plusMinusConfig.getString("areacustname"), new AreaNameMappingBo(plusMinusConfig, dynamicObject));
                    break;
                }
                case "epa_attachareains_assign": {
                    DynamicObject attachConfig = ASSESS_FORM_DOMAIN_SERVICE.queryAttachConfigByPk(confId);
                    copyFromAreaMap.put(attachConfig.getString("areacustname"), new AreaNameMappingBo(attachConfig, dynamicObject));
                    break;
                }
            }
        }
    }

    private void initAreaIndicators(Map<String, AreaNameMappingBo> copyToAreaMap, Map<Long, String> copyToAreaRegIdMap, DynamicObjectCollection assTableConfOfRule, DynamicObjectCollection newIndAreaConfEntry) {
        for (DynamicObject assTableConf : assTableConfOfRule) {
            String formId;
            DynamicObject areaReg = assTableConf.getDynamicObject("areareg");
            Long areaRegId = areaReg.getLong("id");
            if (!AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId) && !AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaRegId) && !AssessRuleConstants.ATTACH_AREA_PK.equals(areaRegId)) continue;
            Long areaInstanceId = INDICATOR_GROUP_DOMAIN_SERVICE.initIndicatorArea(areaReg, assTableConf.getLong("areaconf"));
            DynamicObject addNew = newIndAreaConfEntry.addNew();
            addNew.set("area", (Object)areaRegId);
            addNew.set("areainstance", (Object)areaInstanceId);
            addNew.set("areaconf", (Object)assTableConf.getLong("areaconf"));
            Long confId = assTableConf.getLong("areaconf");
            switch (formId = AreaRegEnum.get((Long)areaRegId).getEvalObjAreaPageIdOfAssign()) {
                case "epa_genareains_assign": {
                    DynamicObject normalConfig = ASSESS_FORM_DOMAIN_SERVICE.queryNormalConfigByPk(confId);
                    copyToAreaMap.put(normalConfig.getString("areacustname"), new AreaNameMappingBo(normalConfig, addNew));
                    copyToAreaRegIdMap.put(confId, normalConfig.getString("areacustname"));
                    break;
                }
                case "epa_addsubareains_assign": {
                    DynamicObject plusMinusConfig = ASSESS_FORM_DOMAIN_SERVICE.queryPlusMinusConfigByPk(confId);
                    copyToAreaMap.put(plusMinusConfig.getString("areacustname"), new AreaNameMappingBo(plusMinusConfig, addNew));
                    copyToAreaRegIdMap.put(confId, plusMinusConfig.getString("areacustname"));
                    break;
                }
                case "epa_attachareains_assign": {
                    DynamicObject attachConfig = ASSESS_FORM_DOMAIN_SERVICE.queryAttachConfigByPk(confId);
                    copyToAreaMap.put(attachConfig.getString("areacustname"), new AreaNameMappingBo(attachConfig, addNew));
                    copyToAreaRegIdMap.put(confId, attachConfig.getString("areacustname"));
                    break;
                }
            }
        }
    }

    private String getCopyFieldList(Long type) {
        String fields = "";
        if (type.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            String defaultField = "areascore,areaweight,scoresystem,forcedtype";
            HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)iIndicatorGroupCopyGenAreaField, IIndicatorGroupCopyGenAreaField.class, (String)"kd.opmc.epa.business.domain.indicator.ext.impl.DefaultIndicatorGroupCopyGenAreaField#setCustomField", (PluginFilter)null);
            List proxyResult = pluginProxy.callReplaceIfPresent(p -> p.setCustomField(defaultField));
            fields = (String)proxyResult.get(0);
        } else if (type.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            fields = "minareascore,maxareascore,ispartin";
        } else if (type.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            fields = "";
        }
        return fields;
    }

    public List<Long> copyIndicatorGroups(DynamicObject[] selectIndicatorGroups, Set<String> isExistNames, Long activityId) {
        List<String> genFieldList = this.areaListField(AssessRuleConstants.NORM_INDCTR_AREA_PK);
        String defaultField = "id,areascore,areaweight,scoresystem,forcedtype";
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)iIndicatorGroupCopyGenAreaField, IIndicatorGroupCopyGenAreaField.class, (String)"kd.opmc.epa.business.domain.indicator.ext.impl.DefaultIndicatorGroupCopyGenAreaField#setCustomField", (PluginFilter)null);
        List proxyResult = pluginProxy.callReplaceIfPresent(p -> p.setCustomField(defaultField));
        String genAreaInstanceFields = this.getEntryField(genFieldList, (String)proxyResult.get(0));
        List<String> addSubFieldList = this.areaListField(AssessRuleConstants.PLUS_MINUS_AREA_PK);
        String addSubAreaInstanceFields = this.getEntryField(addSubFieldList, "id,minareascore,maxareascore,ispartin");
        List<String> attachFieldList = this.areaListField(AssessRuleConstants.ATTACH_AREA_PK);
        String attachAreaInstanceFields = this.getEntryField(attachFieldList, "id");
        HashMap<Long, Long> oldAndNewIds = new HashMap<Long, Long>(16);
        ArrayList<Long> genAreaInstanceIds = new ArrayList<Long>(10);
        ArrayList<Long> addSubAreaInstanceIds = new ArrayList<Long>(10);
        ArrayList<Long> attachAreaInstanceIds = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : selectIndicatorGroups) {
            DynamicObjectCollection indareaconfentry = dynamicObject.getDynamicObjectCollection("indareaconfentry");
            for (DynamicObject object : indareaconfentry) {
                Long areaId = object.getLong("area.id");
                Long areaInstance = object.getLong("areainstance");
                if (areaId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
                    genAreaInstanceIds.add(areaInstance);
                    continue;
                }
                if (areaId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
                    addSubAreaInstanceIds.add(areaInstance);
                    continue;
                }
                if (!areaId.equals(AssessRuleConstants.ATTACH_AREA_PK)) continue;
                attachAreaInstanceIds.add(areaInstance);
            }
        }
        DynamicObject[] genAreaInstances = GEN_AREA_INSTANCE_ENTITY.query(genAreaInstanceFields, new QFilter[]{new QFilter("id", "in", genAreaInstanceIds)});
        DynamicObject[] addSubAreaInstances = ADD_SUB_AREA_INS_ENTITY.query(addSubAreaInstanceFields, new QFilter[]{new QFilter("id", "in", addSubAreaInstanceIds)});
        DynamicObject[] attachAreaInstances = ATTACH_AREA_INS_ENTITY.query(attachAreaInstanceFields, new QFilter[]{new QFilter("id", "in", attachAreaInstanceIds)});
        ArrayList<DynamicObject> copyGenAreaInstances = new ArrayList<DynamicObject>(genAreaInstances.length);
        ArrayList<DynamicObject> copyAddSubAreaInstances = new ArrayList<DynamicObject>(addSubAreaInstances.length);
        ArrayList<DynamicObject> copyAttachAreaInstances = new ArrayList<DynamicObject>(attachAreaInstances.length);
        ArrayList<DynamicObject> copyIndicatorGroups = new ArrayList<DynamicObject>(selectIndicatorGroups.length);
        long[] genLongIds = DBServiceHelper.genLongIds((String)"epa_genareainstance", (int)genAreaInstances.length);
        for (int i = 0; i < genAreaInstances.length; ++i) {
            DynamicObject newGenDynamicObject = GEN_AREA_INSTANCE_ENTITY.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)genAreaInstances[i], (DynamicObject)newGenDynamicObject);
            newGenDynamicObject.set("id", (Object)genLongIds[i]);
            copyGenAreaInstances.add(newGenDynamicObject);
            oldAndNewIds.put(genAreaInstances[i].getLong("id"), genLongIds[i]);
        }
        long[] addSubLongIds = DBServiceHelper.genLongIds((String)"epa_addsubareains", (int)addSubAreaInstances.length);
        for (int i = 0; i < addSubAreaInstances.length; ++i) {
            DynamicObject newAddSubDynamicObject = ADD_SUB_AREA_INS_ENTITY.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)addSubAreaInstances[i], (DynamicObject)newAddSubDynamicObject);
            newAddSubDynamicObject.set("id", (Object)addSubLongIds[i]);
            copyAddSubAreaInstances.add(newAddSubDynamicObject);
            oldAndNewIds.put(addSubAreaInstances[i].getLong("id"), addSubLongIds[i]);
        }
        long[] attachLongIds = DBServiceHelper.genLongIds((String)"epa_attachareains", (int)attachAreaInstances.length);
        for (int i = 0; i < attachAreaInstances.length; ++i) {
            DynamicObject newAttachDynamicObject = ATTACH_AREA_INS_ENTITY.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)attachAreaInstances[i], (DynamicObject)newAttachDynamicObject);
            newAttachDynamicObject.set("id", (Object)attachLongIds[i]);
            copyAttachAreaInstances.add(newAttachDynamicObject);
            oldAndNewIds.put(attachAreaInstances[i].getLong("id"), attachLongIds[i]);
        }
        long[] indicatorGroupLongIds = DBServiceHelper.genLongIds((String)"epa_indicatorgroup", (int)selectIndicatorGroups.length);
        ArrayList<Long> result = new ArrayList<Long>(indicatorGroupLongIds.length);
        DynamicObject activity = ASSESS_ACTIVITY_ENTITY.generateEmptyDynamicObject();
        activity.set("id", (Object)activityId);
        Map<String, Integer> isExistNameMap = this.getExistNameMap(isExistNames);
        for (int i = 0; i < selectIndicatorGroups.length; ++i) {
            DynamicObject newIndicatorGroup = INDICATOR_GROUP_ENTITY.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)selectIndicatorGroups[i], (DynamicObject)newIndicatorGroup);
            newIndicatorGroup.set("id", (Object)indicatorGroupLongIds[i]);
            String oldName = selectIndicatorGroups[i].getString("name");
            String newName = this.getNewName(oldName, isExistNameMap, isExistNames);
            String userId = RequestContext.get().getUserId();
            Date date = new Date();
            newIndicatorGroup.set("name", (Object)newName);
            newIndicatorGroup.set("activity", (Object)activity);
            newIndicatorGroup.set("creator", (Object)userId);
            newIndicatorGroup.set("createtime", (Object)date);
            newIndicatorGroup.set("modifytime", (Object)date);
            newIndicatorGroup.set("modifier", (Object)userId);
            DynamicObjectCollection newIndAreaConfEntry = newIndicatorGroup.getDynamicObjectCollection("indareaconfentry");
            for (DynamicObject dynamicObject : newIndAreaConfEntry) {
                Long areaInstance = dynamicObject.getLong("areainstance");
                Long newId = (Long)oldAndNewIds.get(areaInstance);
                dynamicObject.set("areainstance", (Object)newId);
            }
            copyIndicatorGroups.add(newIndicatorGroup);
            result.add(indicatorGroupLongIds[i]);
        }
        if (copyGenAreaInstances.size() > 0) {
            GEN_AREA_INSTANCE_ENTITY.save(copyGenAreaInstances.toArray(new DynamicObject[0]));
        }
        if (copyAddSubAreaInstances.size() > 0) {
            ADD_SUB_AREA_INS_ENTITY.save(copyAddSubAreaInstances.toArray(new DynamicObject[0]));
        }
        if (copyAttachAreaInstances.size() > 0) {
            ATTACH_AREA_INS_ENTITY.save(copyAttachAreaInstances.toArray(new DynamicObject[0]));
        }
        if (copyIndicatorGroups.size() > 0) {
            INDICATOR_GROUP_ENTITY.save(copyIndicatorGroups.toArray(new DynamicObject[0]));
        }
        return result;
    }

    @NotNull
    private Map<String, Integer> getExistNameMap(Set<String> isExistNames) {
        HashMap<String, Integer> isExistNameMap = new HashMap<String, Integer>(16);
        for (String isExistName : isExistNames) {
            if (!this.isNumberIndex(isExistName)) {
                if (isExistNameMap.containsKey(isExistName)) continue;
                isExistNameMap.put(isExistName, -1);
                continue;
            }
            int i = isExistName.lastIndexOf("\uff08");
            int j = isExistName.lastIndexOf("\uff09");
            String index = isExistName.substring(i + 1, j);
            int curIndex = Integer.parseInt(index);
            String subName = isExistName.substring(0, i);
            if (!isExistNameMap.containsKey(subName)) {
                isExistNameMap.put(subName, Integer.parseInt(index));
                continue;
            }
            Integer integer = (Integer)isExistNameMap.get(subName);
            int max = Math.max(curIndex, integer);
            isExistNameMap.put(subName, max);
        }
        return isExistNameMap;
    }

    private boolean isNumberIndex(String name) {
        if (!name.endsWith("\uff09")) {
            return false;
        }
        if (!name.contains("\uff08")) {
            return false;
        }
        int i = name.lastIndexOf("\uff08");
        int j = name.lastIndexOf("\uff09");
        String index = name.substring(i + 1, j);
        String pattern = "^(0|[1-9][0-9]*)$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(index);
        return m.matches();
    }

    private String getNewName(String oldName, Map<String, Integer> isExistNameMap, Set<String> isExistNames) {
        if (!isExistNames.contains(oldName)) {
            this.addExistNameMap(oldName, isExistNameMap, isExistNames);
            return oldName;
        }
        boolean flag = this.isNumberIndex(oldName);
        String newName = "";
        if (flag) {
            int i = oldName.lastIndexOf("\uff08");
            int j = oldName.lastIndexOf("\uff09");
            String index = oldName.substring(i + 1, j);
            int curIndex = Integer.parseInt(index);
            String subName = oldName.substring(0, i);
            if (isExistNameMap.containsKey(subName)) {
                Integer integer = isExistNameMap.get(subName);
                int max = Math.max(curIndex, integer);
                isExistNameMap.put(subName, ++max);
                newName = subName + "\uff08" + max + "\uff09";
            } else {
                isExistNameMap.put(subName, curIndex);
                newName = oldName;
            }
        } else if (isExistNameMap.containsKey(oldName)) {
            int n;
            Integer integer = isExistNameMap.get(oldName);
            if (integer < 0) {
                n = 1;
            } else {
                integer = integer + 1;
                n = integer;
            }
            int index = n;
            isExistNameMap.put(oldName, index);
            newName = oldName + "\uff08" + index + "\uff09";
        } else {
            isExistNameMap.put(oldName, -1);
            newName = oldName;
        }
        isExistNames.add(newName);
        return newName;
    }

    private void addExistNameMap(String name, Map<String, Integer> isExistNameMap, Set<String> isExistNames) {
        boolean flag = this.isNumberIndex(name);
        if (flag) {
            int i = name.lastIndexOf("\uff08");
            int j = name.lastIndexOf("\uff09");
            String index = name.substring(i + 1, j);
            int curIndex = Integer.parseInt(index);
            String subName = name.substring(0, i);
            if (isExistNameMap.containsKey(subName)) {
                Integer integer = isExistNameMap.get(subName);
                int max = Math.max(curIndex, integer);
                isExistNameMap.put(subName, max);
            } else {
                isExistNameMap.put(subName, curIndex);
            }
        } else if (!isExistNameMap.containsKey(name)) {
            isExistNameMap.put(name, -1);
        }
        isExistNames.add(name);
    }

    public boolean isRefActevalObj(Object pkId) {
        QFilter indigroup = new QFilter("indigroup", "=", pkId);
        indigroup.and("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.isExists(indigroup);
    }

    public boolean isProcessOrDistrActevalObj(Object pkId) {
        Long pkIdLong;
        if (pkId == null) {
            return false;
        }
        if (pkId instanceof Long && (pkIdLong = (Long)pkId) == 0L) {
            return false;
        }
        QFilter indigroup = new QFilter("indigroup", "=", pkId);
        indigroup.and("assessstaus", "!=", (Object)AssessStausEnum.Exited.getStatus());
        DynamicObject[] actevalObjs = ACTIVITY_EVALUATION_OBJECT_ENTITY.query(new QFilter[]{indigroup});
        if (actevalObjs.length == 0) {
            return false;
        }
        List actevalObjIds = Arrays.stream(actevalObjs).map(item -> item.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("actevalobj", "in", actevalObjIds);
        qFilter.and("assessnode", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
        qFilter.and("nodestatus", "in", Arrays.asList(AssessNodeStatusEnum.TARGET_FORMULATING.getStatus(), AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()));
        return ACTIVITY_OBJ_RECORD_ENTITY.isExists(qFilter);
    }

    public void addObjIndicatorAreaEntry(Long areaRegId, Long areaId, DynamicObject IndicatorAreaEntry) {
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_GEN_AREAINS_ENTITY.query(this.getObjEntryField(this.areaField(areaRegId) + ",from,ispreinstall,realweight"), new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return;
            }
            this.buildObjIndicatorArea(IndicatorAreaEntry, objIndicatorAreas);
            for (DynamicObject objIndicatorArea : objIndicatorAreas) {
                DynamicObjectCollection entryentity = objIndicatorArea.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryentity) {
                    dynamicObject.set("realweight", dynamicObject.get("weight"));
                }
            }
            OBJ_GEN_AREAINS_ENTITY.save(objIndicatorAreas);
        } else if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_ADDSUB_AREAINS_ENTITY.query(this.getObjEntryField(this.areaField(areaRegId) + ",from,ispreinstall"), new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return;
            }
            this.buildObjIndicatorArea(IndicatorAreaEntry, objIndicatorAreas);
            OBJ_ADDSUB_AREAINS_ENTITY.save(objIndicatorAreas);
        } else if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_ATTACH_AREAINS_ENTITY.query(this.getObjEntryField(this.areaField(areaRegId) + ",from,ispreinstall"), new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return;
            }
            this.buildObjIndicatorArea(IndicatorAreaEntry, objIndicatorAreas);
            OBJ_ATTACH_AREAINS_ENTITY.save(objIndicatorAreas);
        }
    }

    public void deleteAndUpdateSeqObjIndicatorAreaEntry(Long areaRegId, Long areaId, Long areaEntryId) {
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_GEN_AREAINS_ENTITY.query("id,entryentity.seq,entryentity.from", new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return;
            }
            this.removeObjIndicatorArea(areaEntryId, objIndicatorAreas);
            OBJ_GEN_AREAINS_ENTITY.save(objIndicatorAreas);
        } else if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_ADDSUB_AREAINS_ENTITY.query("id,entryentity.seq,entryentity.from", new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return;
            }
            this.removeObjIndicatorArea(areaEntryId, objIndicatorAreas);
            OBJ_ADDSUB_AREAINS_ENTITY.save(objIndicatorAreas);
        } else if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_ATTACH_AREAINS_ENTITY.query("id,entryentity.seq,entryentity.from", new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return;
            }
            this.removeObjIndicatorArea(areaEntryId, objIndicatorAreas);
            OBJ_ATTACH_AREAINS_ENTITY.save(objIndicatorAreas);
        }
    }

    private void removeObjIndicatorArea(Long areaEntryId, DynamicObject[] objIndicatorAreas) {
        int index = 1;
        for (DynamicObject objIndicatorArea : objIndicatorAreas) {
            DynamicObjectCollection entryentity = objIndicatorArea.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
                if (areaEntryId.equals(dynamicObject.getLong("from"))) {
                    entryentity.remove(i);
                    continue;
                }
                dynamicObject.set("seq", (Object)index++);
            }
            index = 1;
        }
    }

    public boolean queryObjIndicatorAreaEntry(Long areaRegId, DynamicObject IndicatorAreaEntry) {
        DynamicObject[] objIndicatorAreaEntrys;
        Object areaEntryId = IndicatorAreaEntry.getPkValue();
        return !(areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK) ? (objIndicatorAreaEntrys = OBJ_GEN_AREA_INDICATOR_ENTITY.query("id", new QFilter[]{new QFilter("from", "=", areaEntryId)})).length == 0 : (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK) ? (objIndicatorAreaEntrys = OBJ_ADDSUB_AREA_INDICATOR_ENTITY.query("id", new QFilter[]{new QFilter("from", "=", areaEntryId)})).length == 0 : areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK) && (objIndicatorAreaEntrys = OBJ_ATTACH_AREA_INDICATOR_ENTITY.query("id", new QFilter[]{new QFilter("from", "=", areaEntryId)})).length == 0));
    }

    public Map<Long, DynamicObject> queryObjIndicatorAreaEntry(List<Long> objGenIndicatorIds, List<Long> objAddsubIndicatorIds) {
        HashMap<Long, DynamicObject> idMaps = new HashMap<Long, DynamicObject>(16);
        DynamicObject[] objGenIndicatorAreaEntrys = OBJ_GEN_AREA_INDICATOR_ENTITY.query(this.areaField(AssessRuleConstants.NORM_INDCTR_AREA_PK), new QFilter[]{new QFilter("id", "in", objGenIndicatorIds)});
        Arrays.stream(objGenIndicatorAreaEntrys).forEach(item -> idMaps.put(item.getLong("id"), (DynamicObject)item));
        DynamicObject[] objAddsubIndicatorAreaEntrys = OBJ_ADDSUB_AREA_INDICATOR_ENTITY.query(this.areaField(AssessRuleConstants.PLUS_MINUS_AREA_PK), new QFilter[]{new QFilter("id", "in", objAddsubIndicatorIds)});
        Arrays.stream(objAddsubIndicatorAreaEntrys).forEach(item -> idMaps.put(item.getLong("id"), (DynamicObject)item));
        return idMaps;
    }

    public void updateObjIndicatorAreaEntry(Long areaRegId, DynamicObject IndicatorAreaEntry) {
        Object areaEntryId = IndicatorAreaEntry.getPkValue();
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            DynamicObject[] objIndicatorAreaEntrys = OBJ_GEN_AREA_INDICATOR_ENTITY.query(this.areaField(areaRegId) + ",realweight", new QFilter[]{new QFilter("from", "=", areaEntryId)});
            if (objIndicatorAreaEntrys.length == 0) {
                return;
            }
            for (DynamicObject objIndicatorAreaEntry : objIndicatorAreaEntrys) {
                HRDynamicObjectUtils.copy((DynamicObject)IndicatorAreaEntry, (DynamicObject)objIndicatorAreaEntry, (Set)Sets.newHashSet((Object[])new String[]{"id"}));
                objIndicatorAreaEntry.set("realweight", objIndicatorAreaEntry.get("weight"));
            }
            OBJ_GEN_AREA_INDICATOR_ENTITY.save(objIndicatorAreaEntrys);
        } else if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            DynamicObject[] objIndicatorAreaEntrys = OBJ_ADDSUB_AREA_INDICATOR_ENTITY.query(this.areaField(areaRegId), new QFilter[]{new QFilter("from", "=", areaEntryId)});
            if (objIndicatorAreaEntrys.length == 0) {
                return;
            }
            for (DynamicObject objIndicatorAreaEntry : objIndicatorAreaEntrys) {
                HRDynamicObjectUtils.copy((DynamicObject)IndicatorAreaEntry, (DynamicObject)objIndicatorAreaEntry, (Set)Sets.newHashSet((Object[])new String[]{"id"}));
            }
            OBJ_ADDSUB_AREA_INDICATOR_ENTITY.save(objIndicatorAreaEntrys);
        } else if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            DynamicObject[] objIndicatorAreaEntrys = OBJ_ATTACH_AREA_INDICATOR_ENTITY.query(this.areaField(areaRegId), new QFilter[]{new QFilter("from", "=", areaEntryId)});
            if (objIndicatorAreaEntrys.length == 0) {
                return;
            }
            for (DynamicObject objIndicatorAreaEntry : objIndicatorAreaEntrys) {
                HRDynamicObjectUtils.copy((DynamicObject)IndicatorAreaEntry, (DynamicObject)objIndicatorAreaEntry, (Set)Sets.newHashSet((Object[])new String[]{"id"}));
            }
            OBJ_ATTACH_AREA_INDICATOR_ENTITY.save(objIndicatorAreaEntrys);
        }
    }

    public void deleteObjIndicatorAreaEntry(Long areaRegId, Long areaEntryId) {
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            OBJ_GEN_AREA_INDICATOR_ENTITY.deleteByFilter(new QFilter[]{new QFilter("from", "=", (Object)areaEntryId)});
        } else if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            OBJ_ADDSUB_AREA_INDICATOR_ENTITY.deleteByFilter(new QFilter[]{new QFilter("from", "=", (Object)areaEntryId)});
        } else if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            OBJ_ATTACH_AREA_INDICATOR_ENTITY.deleteByFilter(new QFilter[]{new QFilter("from", "=", (Object)areaEntryId)});
        }
    }

    public void updateObjIndicatorArea(Long areaRegId, Long areaId, String name, Object value) {
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_GEN_AREAINS_ENTITY.query(name, new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return;
            }
            for (DynamicObject indicatorArea : objIndicatorAreas) {
                indicatorArea.set(name, value);
            }
            OBJ_GEN_AREAINS_ENTITY.save(objIndicatorAreas);
        } else if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_ADDSUB_AREAINS_ENTITY.query(name, new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return;
            }
            for (DynamicObject indicatorArea : objIndicatorAreas) {
                indicatorArea.set(name, value);
            }
            OBJ_ADDSUB_AREAINS_ENTITY.save(objIndicatorAreas);
        } else if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_ATTACH_AREAINS_ENTITY.query(name, new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return;
            }
            for (DynamicObject indicatorArea : objIndicatorAreas) {
                indicatorArea.set(name, value);
            }
            OBJ_ATTACH_AREAINS_ENTITY.save(objIndicatorAreas);
        }
    }

    public boolean checkNameIndicatorAreaEntry(Long areaRegId, Long areaId, String name) {
        QFilter qFilter = new QFilter("ispreinstall", "=", (Object)Boolean.FALSE);
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_GEN_AREAINS_ENTITY.query("id", new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return false;
            }
            List objIndicatorAreaIds = Arrays.stream(objIndicatorAreas).map(item -> item.getLong("id")).collect(Collectors.toList());
            qFilter.and("indctrname", "=", (Object)name);
            qFilter.and("instanceid", "in", objIndicatorAreaIds);
            return OBJ_GEN_AREA_INDICATOR_ENTITY.isExists(qFilter);
        }
        if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_ADDSUB_AREAINS_ENTITY.query("id", new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return false;
            }
            List objIndicatorAreaIds = Arrays.stream(objIndicatorAreas).map(item -> item.getLong("id")).collect(Collectors.toList());
            qFilter.and("indctrname", "=", (Object)name);
            qFilter.and("instanceid", "in", objIndicatorAreaIds);
            return OBJ_ADDSUB_AREA_INDICATOR_ENTITY.isExists(qFilter);
        }
        if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            DynamicObject[] objIndicatorAreas = OBJ_ATTACH_AREAINS_ENTITY.query("id", new QFilter[]{new QFilter("areafrom", "=", (Object)areaId)});
            if (objIndicatorAreas.length == 0) {
                return false;
            }
            List objIndicatorAreaIds = Arrays.stream(objIndicatorAreas).map(item -> item.getLong("id")).collect(Collectors.toList());
            qFilter.and("keyactname", "=", (Object)name);
            qFilter.and("instanceid", "in", objIndicatorAreaIds);
            return OBJ_ATTACH_AREA_INDICATOR_ENTITY.isExists(qFilter);
        }
        return false;
    }

    private void buildObjIndicatorArea(DynamicObject IndicatorAreaEntry, DynamicObject[] objIndicatorAreas) {
        DataEntityPropertyCollection properties = IndicatorAreaEntry.getDataEntityType().getProperties();
        List collect = properties.stream().map(item -> item.getName()).collect(Collectors.toList());
        boolean iseditable = collect.contains("iseditable");
        for (DynamicObject objIndicatorArea : objIndicatorAreas) {
            DynamicObjectCollection entryentity = objIndicatorArea.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryentity.size(); ++i) {
                ((DynamicObject)entryentity.get(i)).set("seq", (Object)(i + 1));
            }
            DynamicObject newEntry = new DynamicObject(entryentity.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)IndicatorAreaEntry, (DynamicObject)newEntry, (Set)Sets.newHashSet((Object[])new String[]{"iseditable"}));
            newEntry.set("from", IndicatorAreaEntry.getPkValue());
            newEntry.set("seq", (Object)(entryentity.size() + 1));
            newEntry.set("ispreinstall", (Object)1);
            if (iseditable) {
                newEntry.set("iseditable", (Object)(IndicatorAreaEntry.getBoolean("iseditable") ? "1" : "0"));
            }
            entryentity.add((Object)newEntry);
        }
    }

    private String areaField(Long areaRegId) {
        String result = "id";
        StringBuilder stringBuilder = new StringBuilder("id");
        List<String> areaListFields = this.areaListField(areaRegId);
        if (CollectionUtils.isNotEmpty(areaListFields)) {
            for (String areaListField : areaListFields) {
                stringBuilder.append(",").append(areaListField.trim());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)stringBuilder.toString())) {
            result = stringBuilder.toString();
        }
        return result;
    }

    private List<String> areaListField(Long areaRegId) {
        ArrayList<String> result = new ArrayList<String>(10);
        if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
            DynamicObject genDynamicObject = GEN_AREA_INSTANCE_ENTITY.generateEmptyDynamicObject();
            DynamicObjectCollection genEntryentity = genDynamicObject.getDynamicObjectCollection("entryentity");
            DataEntityPropertyCollection genProperties = genEntryentity.getDynamicObjectType().getProperties();
            List<String> genFieldList = genProperties.stream().filter(prop -> !"id".equals(prop.getName())).map(item -> item.getName()).collect(Collectors.toList());
            return genFieldList;
        }
        if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
            DynamicObject addSubDynamicObject = ADD_SUB_AREA_INS_ENTITY.generateEmptyDynamicObject();
            DynamicObjectCollection addSubEntryentity = addSubDynamicObject.getDynamicObjectCollection("entryentity");
            DataEntityPropertyCollection addSubProperties = addSubEntryentity.getDynamicObjectType().getProperties();
            List<String> addSubFieldList = addSubProperties.stream().filter(prop -> !"id".equals(prop.getName())).map(item -> item.getName()).collect(Collectors.toList());
            return addSubFieldList;
        }
        if (areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) {
            DynamicObject attachDynamicObject = ATTACH_AREA_INS_ENTITY.generateEmptyDynamicObject();
            DynamicObjectCollection attachEntryentity = attachDynamicObject.getDynamicObjectCollection("entryentity");
            DataEntityPropertyCollection attachProperties = attachEntryentity.getDynamicObjectType().getProperties();
            List<String> attachFieldList = attachProperties.stream().filter(prop -> !"id".equals(prop.getName())).map(item -> item.getName()).collect(Collectors.toList());
            return attachFieldList;
        }
        return result;
    }

    private String getObjEntryField(String fields) {
        String[] splitArr = fields.split(",");
        StringBuilder stringBuilder = new StringBuilder("id");
        for (String spl : splitArr) {
            if ("id".equals(spl)) continue;
            stringBuilder.append(",entryentity.").append(spl);
        }
        return stringBuilder.toString();
    }

    private String getEntryField(List<String> entryFields, String field) {
        String str = StringUtils.isEmpty((CharSequence)field) ? "id" : field;
        StringBuilder stringBuilder = new StringBuilder(str);
        for (String entryField : entryFields) {
            stringBuilder.append(",entryentity.").append(entryField);
        }
        return stringBuilder.toString();
    }

    public void updateEvalObjByIndicGroupId(long indicGroupId) {
        Object[] evalObjs = OBJECT_DOMAIN_SERVICE.queryEvalObjsByIndicGroupId(indicGroupId);
        if (ObjectUtils.isEmpty((Object[])evalObjs)) {
            return;
        }
        this.updateEvalScore((DynamicObject[])evalObjs);
    }

    public void updateEvalScore(DynamicObject[] evalObjs) {
        Map<Long, BigDecimal> sumWeightScoreMap = APP_SERVICE.getSumWeightScoreMap(evalObjs);
        Map<Long, BigDecimal> sumIndctrScoreMap = APP_SERVICE.getSumIndctrScoreMap(evalObjs);
        DynamicObject activityDy = evalObjs[0].getDynamicObject("activity");
        DynamicObject assessFormDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessFormByActId(activityDy.getLong("id"));
        DynamicObject scoreSystemDy = EXECUTE_SCHEME_DOMAIN_SERVICE.queryScoreSystemByScoreSystemId(assessFormDy.getLong("scoresystem.id"));
        String numAccuracy = assessFormDy.getString("numaccuracy");
        String scaleType = assessFormDy.getString("scaletype");
        for (DynamicObject evalObj : evalObjs) {
            long evalObjId = evalObj.getLong("id");
            BigDecimal sumWeightScore = sumWeightScoreMap.get(evalObjId) == null ? new BigDecimal(0) : sumWeightScoreMap.get(evalObjId);
            evalObj.set("assweight", (Object)sumWeightScore.divide(new BigDecimal(100), 2, 1));
            BigDecimal sumIndctrScore = sumIndctrScoreMap.get(evalObjId) == null ? new BigDecimal(0) : sumIndctrScoreMap.get(evalObjId);
            String score = sumIndctrScore.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros().toPlainString();
            String maxScoreOfSystem = scoreSystemDy.getBigDecimal("maxscore").setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get(scaleType).getType()).stripTrailingZeros().toPlainString();
            evalObj.set("assscore", (Object)(score + "/" + maxScoreOfSystem));
        }
        OBJECT_DOMAIN_SERVICE.saveEvaluationObject(evalObjs);
    }

    public DynamicObject queryIndicatorGuide(Long pkId) {
        return INDICATOR_GROUP_ENTITY.queryOne("indicatorguide.indguide, indicatorguide.locale", pkId);
    }
}

