/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activity.service.AssessActivityDomainService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAttachAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.indicator.imp.util.ValidatorUtils;
import kd.opmc.epa.business.utils.NumberValidateUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.AdjustTypeEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;

public class IndicatorImportDomainService {
    private static final String MSG = "msg";
    private static final String DATA = "data";
    private static final String SUCCESS = "success";
    private static final String ERROR_CODE = "errorCode";
    private static final String EVAL_OBJ_ID = "evalobjid";
    private static final String AREA_ENTRY = "areaentry";
    private static final String AREA_INS_ID = "areainsid";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final ActEvalObjManageDomainService ACT_EVAL_OBJ_SERVICE = ActEvalObjManageDomainService.getInstance();
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREA_INS_ENTITY_SERVICE = ObjGenAreaInsEntityService.getInstance();
    private static final ObjAddSubAreaInsEntityService OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE = ObjAddSubAreaInsEntityService.getInstance();
    private static final ObjAttachAreaInsEntityService OBJ_ATTACH_AREA_INS_ENTITY_SERVICE = ObjAttachAreaInsEntityService.getInstance();
    private static final AssessActivityDomainService ACTIVITY_DOMAIN_SERVICE = AssessActivityDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final String[] GEN_AREA_FIELDS = new String[]{"qualitytarget", "qualitydare", "qualitybase", "qualityres"};
    private static final String[] ADD_SUB_AREA_FIELDS = new String[]{"qualitytarget", "qualitydare", "qualitybase", "qualityres"};
    private static final Log LOG = LogFactory.getLog(IndicatorImportDomainService.class);

    public static IndicatorImportDomainService getInstance() {
        return ServiceFactory.getService(IndicatorImportDomainService.class);
    }

    public Map<String, Object> indicatorImportSave(List<Map<String, Object>> params, boolean isAdd) {
        LOG.info("===========================params:{}============================", params);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList data = new ArrayList(16);
        resultMap.put(MSG, "validate request param failed\u3002");
        resultMap.put(DATA, data);
        resultMap.put(SUCCESS, false);
        resultMap.put(ERROR_CODE, "failed");
        if (CollectionUtils.isEmpty(params)) {
            return resultMap;
        }
        try {
            for (Map<String, Object> param2 : params) {
                Object evalObjId = param2.get(EVAL_OBJ_ID);
                if (evalObjId == null || (Long)evalObjId == 0L) {
                    return resultMap;
                }
                Object areaEntryList = param2.get(AREA_ENTRY);
                if (areaEntryList != null) continue;
                return resultMap;
            }
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return resultMap;
        }
        List<Long> evalObjIds = params.stream().map(param -> (Long)param.get(EVAL_OBJ_ID)).collect(Collectors.toList());
        Object[] evalObjs = ACT_EVAL_OBJ_SERVICE.queryActEvalObjByIds(evalObjIds);
        if (HRArrayUtils.isEmpty((Object[])evalObjs)) {
            resultMap.put(MSG, "eactevalobj is empty\u3002");
            resultMap.put(DATA, new ArrayList());
            resultMap.put(SUCCESS, false);
            resultMap.put(ERROR_CODE, "failed");
            return resultMap;
        }
        resultMap.put(MSG, SUCCESS);
        resultMap.put(DATA, data);
        resultMap.put(SUCCESS, true);
        resultMap.put(ERROR_CODE, SUCCESS);
        try {
            this.HandlerParams(params, isAdd, resultMap, (DynamicObject[])evalObjs);
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            resultMap.put(MSG, "save data failed\u3002");
            resultMap.put(DATA, data);
            resultMap.put(SUCCESS, false);
            resultMap.put(ERROR_CODE, "failed");
        }
        LOG.info("===========================resultMap:{}============================", resultMap);
        return resultMap;
    }

    private Tuple<Map<Long, DynamicObject>, Map<Long, DynamicObject>> getDbGenAreaIns(List<Map<String, Object>> params, Map<Long, DynamicObject> evalObjMap) {
        DynamicObject[] dynamicObjects;
        ArrayList<Long> areaInsIds = new ArrayList<Long>(16);
        ArrayList<Long> areaConfIds = new ArrayList<Long>(16);
        Map<Object, Object> areaInsMap = new HashMap(16);
        Map<Object, Object> areaConfMap = new HashMap(16);
        for (Map<String, Object> param : params) {
            DynamicObject evalDynamicObject;
            Long evalObjId = (Long)param.get(EVAL_OBJ_ID);
            List areaEntryList = (List)param.get(AREA_ENTRY);
            if (areaEntryList == null || HRObjectUtils.isEmpty((Object)(evalDynamicObject = evalObjMap.get(evalObjId)))) continue;
            DynamicObjectCollection evalAreaEntry = evalDynamicObject.getDynamicObjectCollection(AREA_ENTRY);
            Map evalAreaEntryMap = evalAreaEntry.stream().collect(Collectors.toMap(area -> area.getLong("areains"), Function.identity()));
            for (Map areaEntryParam : areaEntryList) {
                Long areaRegId;
                Long areaInsId = (Long)areaEntryParam.get(AREA_INS_ID);
                DynamicObject evalAreaEntryObj = (DynamicObject)evalAreaEntryMap.get(areaInsId);
                Long areaConfId = evalAreaEntryObj.getLong("areaconf");
                if (HRObjectUtils.isEmpty((Object)evalAreaEntryObj) || !AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId = Long.valueOf(evalAreaEntryObj.getLong("areareg.id")))) continue;
                areaInsIds.add(areaInsId);
                areaConfIds.add(areaConfId);
            }
        }
        if (!areaInsIds.isEmpty()) {
            dynamicObjects = OBJ_GEN_AREA_INS_ENTITY_SERVICE.loadDynamicObjectArray(areaInsIds.toArray());
            areaInsMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(areaIns -> areaIns.getLong("id"), Function.identity()));
        }
        if (!areaConfIds.isEmpty()) {
            dynamicObjects = ASSESS_FORM_DOMAIN_SERVICE.queryNormalConfigByPk(areaConfIds.toArray());
            areaConfMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(areaIns -> areaIns.getLong("id"), Function.identity()));
        }
        return new Tuple(areaInsMap, areaConfMap);
    }

    private Tuple<Map<Long, DynamicObject>, Map<Long, DynamicObject>> getDbPlusMinusAreaIns(List<Map<String, Object>> params, Map<Long, DynamicObject> evalObjMap) {
        DynamicObject[] dynamicObjects;
        ArrayList<Long> areaInsIds = new ArrayList<Long>(16);
        ArrayList<Long> areaConfIds = new ArrayList<Long>(16);
        Map<Object, Object> areaInsMap = new HashMap(16);
        Map<Object, Object> areaConfMap = new HashMap(16);
        for (Map<String, Object> param : params) {
            DynamicObject evalDynamicObject;
            Long evalObjId = (Long)param.get(EVAL_OBJ_ID);
            List areaEntryList = (List)param.get(AREA_ENTRY);
            if (areaEntryList == null || HRObjectUtils.isEmpty((Object)(evalDynamicObject = evalObjMap.get(evalObjId)))) continue;
            DynamicObjectCollection evalAreaEntry = evalDynamicObject.getDynamicObjectCollection(AREA_ENTRY);
            Map evalAreaEntryMap = evalAreaEntry.stream().collect(Collectors.toMap(area -> area.getLong("areains"), Function.identity()));
            for (Map areaEntryParam : areaEntryList) {
                Long areaRegId;
                Long areaInsId = (Long)areaEntryParam.get(AREA_INS_ID);
                DynamicObject evalAreaEntryObj = (DynamicObject)evalAreaEntryMap.get(areaInsId);
                Long areaConfId = evalAreaEntryObj.getLong("areaconf");
                if (HRObjectUtils.isEmpty((Object)evalAreaEntryObj) || !AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaRegId = Long.valueOf(evalAreaEntryObj.getLong("areareg.id")))) continue;
                areaInsIds.add(areaInsId);
                areaConfIds.add(areaConfId);
            }
        }
        if (!areaInsIds.isEmpty()) {
            dynamicObjects = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.loadDynamicObjectArray(areaInsIds.toArray());
            areaInsMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(areaIns -> areaIns.getLong("id"), Function.identity()));
        }
        if (!areaConfIds.isEmpty()) {
            dynamicObjects = ASSESS_FORM_DOMAIN_SERVICE.queryPlusMinusConfigsByPk(areaConfIds.toArray());
            areaConfMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(areaIns -> areaIns.getLong("id"), Function.identity()));
        }
        return new Tuple(areaInsMap, areaConfMap);
    }

    private Tuple<Map<Long, DynamicObject>, Map<Long, DynamicObject>> getDbAttachAreaIns(List<Map<String, Object>> params, Map<Long, DynamicObject> evalObjMap) {
        DynamicObject[] dynamicObjects;
        ArrayList<Long> areaInsIds = new ArrayList<Long>(16);
        ArrayList<Long> areaConfIds = new ArrayList<Long>(16);
        Map<Object, Object> areaInsMap = new HashMap(16);
        Map<Object, Object> areaConfMap = new HashMap(16);
        for (Map<String, Object> param : params) {
            DynamicObject evalDynamicObject;
            Long evalObjId = (Long)param.get(EVAL_OBJ_ID);
            List areaEntryList = (List)param.get(AREA_ENTRY);
            if (areaEntryList == null || HRObjectUtils.isEmpty((Object)(evalDynamicObject = evalObjMap.get(evalObjId)))) continue;
            DynamicObjectCollection evalAreaEntry = evalDynamicObject.getDynamicObjectCollection(AREA_ENTRY);
            Map evalAreaEntryMap = evalAreaEntry.stream().collect(Collectors.toMap(area -> area.getLong("areains"), Function.identity()));
            for (Map areaEntryParam : areaEntryList) {
                Long areaRegId;
                Long areaInsId = (Long)areaEntryParam.get(AREA_INS_ID);
                DynamicObject evalAreaEntryObj = (DynamicObject)evalAreaEntryMap.get(areaInsId);
                Long areaConfId = evalAreaEntryObj.getLong("areaconf");
                if (HRObjectUtils.isEmpty((Object)evalAreaEntryObj) || !AssessRuleConstants.ATTACH_AREA_PK.equals(areaRegId = Long.valueOf(evalAreaEntryObj.getLong("areareg.id")))) continue;
                areaInsIds.add(areaInsId);
                areaConfIds.add(areaConfId);
            }
        }
        if (!areaInsIds.isEmpty()) {
            dynamicObjects = OBJ_ATTACH_AREA_INS_ENTITY_SERVICE.loadDynamicObjectArray(areaInsIds.toArray());
            areaInsMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(areaIns -> areaIns.getLong("id"), Function.identity()));
        }
        if (!areaConfIds.isEmpty()) {
            dynamicObjects = ASSESS_FORM_DOMAIN_SERVICE.queryAttachConfigByPk(areaConfIds.toArray());
            areaConfMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(areaIns -> areaIns.getLong("id"), Function.identity()));
        }
        return new Tuple(areaInsMap, areaConfMap);
    }

    private void BatchHandlerParams(List<Map<String, Object>> params, boolean isAdd, Map<String, Object> resultMap, DynamicObject[] evalObjs) {
        Map<Long, DynamicObject> evalObjMap = Arrays.stream(evalObjs).collect(Collectors.toMap(eval -> eval.getLong("id"), Function.identity()));
        List<Long> objIds = Arrays.stream(evalObjs).map(eval -> eval.getLong("id")).collect(Collectors.toList());
        ArrayList<DynamicObject> genAreaIns = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> addSubAreaIns = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> attrAreaIns = new ArrayList<DynamicObject>(16);
        Tuple<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dbGenAreaIns = this.getDbGenAreaIns(params, evalObjMap);
        Tuple<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dbPlusMinusAreaIns = this.getDbPlusMinusAreaIns(params, evalObjMap);
        Tuple<Map<Long, DynamicObject>, Map<Long, DynamicObject>> dbAttachAreaIns = this.getDbAttachAreaIns(params, evalObjMap);
        for (Map<String, Object> param : params) {
            Long evalObjId = (Long)param.get(EVAL_OBJ_ID);
            List areaEntryList = (List)param.get(AREA_ENTRY);
            if (areaEntryList == null) {
                resultMap.put(MSG, "areaentry is empty\u3002");
                resultMap.put(SUCCESS, false);
                resultMap.put(ERROR_CODE, "failed");
                return;
            }
            DynamicObject evalDynamicObject = evalObjMap.get(evalObjId);
            if (!HRObjectUtils.isEmpty((Object)evalDynamicObject)) {
                DynamicObjectCollection evalAreaEntry = evalDynamicObject.getDynamicObjectCollection(AREA_ENTRY);
                DynamicObject activityDynamicObject = ACTIVITY_DOMAIN_SERVICE.queryOne(evalDynamicObject.getLong("activity.id"));
                DynamicObject assessForm = OBJECT_DOMAIN_SERVICE.loadAssessForm(activityDynamicObject.getLong("assessform.id"));
                String scoreCalcWay = assessForm.getString("scorecalcway");
                String numAccuracy = assessForm.getString("numaccuracy");
                Map evalAreaEntryMap = evalAreaEntry.stream().collect(Collectors.toMap(area -> area.getLong("areains"), Function.identity()));
                for (Map areaEntryParam : areaEntryList) {
                    Long areaInsId = (Long)areaEntryParam.get(AREA_INS_ID);
                    DynamicObject evalAreaEntryObj = (DynamicObject)evalAreaEntryMap.get(areaInsId);
                    if (!HRObjectUtils.isEmpty((Object)evalAreaEntryObj)) {
                        DynamicObjectCollection indicatorEntryEntity;
                        DynamicObject confDynamicObject;
                        Map item2;
                        Map item1;
                        List entryEntityParam = (List)areaEntryParam.get(ENTRY_ENTITY);
                        Long areaRegId = evalAreaEntryObj.getLong("areareg.id");
                        Long areaConfId = evalAreaEntryObj.getLong("areaconf");
                        DynamicObject areaDynamicObject = null;
                        if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId)) {
                            String tips;
                            item1 = (Map)dbGenAreaIns.item1;
                            item2 = (Map)dbGenAreaIns.item2;
                            areaDynamicObject = (DynamicObject)item1.get(areaInsId);
                            if (HRObjectUtils.isEmpty((Object)areaDynamicObject)) continue;
                            this.checkRepeat(entryEntityParam, "indctrname", resultMap, areaInsId);
                            if (this.checkAreaIsEmpty(areaDynamicObject, resultMap, areaInsId) || HRObjectUtils.isEmpty((Object)(confDynamicObject = (DynamicObject)item2.get(areaConfId)))) continue;
                            int index = 0;
                            DynamicObjectCollection indicatorEntryEntity2 = areaDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
                            if (!isAdd) {
                                indicatorEntryEntity2.clear();
                            } else {
                                index = indicatorEntryEntity2.size();
                            }
                            List<String> mustInputField = this.checkIndicatorMustInput(confDynamicObject);
                            BigDecimal areaNum = this.getIndicatorSum(isAdd, areaDynamicObject, scoreCalcWay);
                            for (Map indicatorParam : entryEntityParam) {
                                this.checkIndicatorMustFiled(evalObjId, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                                this.checkAdjustType(evalObjId, indicatorParam, confDynamicObject, resultMap, areaInsId, numAccuracy);
                                this.checkEvalType(evalObjId, indicatorParam, resultMap, areaInsId, NumberValidateUtils.removeNotValidateField(GEN_AREA_FIELDS));
                                this.makeNormIndicator(index, evalObjId, isAdd, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                                ++index;
                                areaNum = areaNum.add(this.addIndicatorNum(evalObjId, indicatorParam, scoreCalcWay, areaInsId, resultMap, numAccuracy));
                            }
                            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                                if (areaNum.compareTo(areaDynamicObject.getBigDecimal("areaweight")) > 0) {
                                    tips = ResManager.loadKDString((String)"\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700\u2264\u533a\u57df\u6743\u91cd", (String)"IndicatorImportDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]);
                                    this.makeErrorResult(evalObjId, tips, "weight", areaInsId, resultMap);
                                }
                            } else if (areaNum.compareTo(areaDynamicObject.getBigDecimal("areascore")) > 0) {
                                tips = ResManager.loadKDString((String)"\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700\u2264\u533a\u57df\u5206\u503c", (String)"IndicatorImportDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]);
                                this.makeErrorResult(evalObjId, tips, "indctrscore", areaInsId, resultMap);
                            }
                            if (!((Boolean)resultMap.get(SUCCESS)).booleanValue()) continue;
                            genAreaIns.add(areaDynamicObject);
                        }
                        if (AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaRegId)) {
                            item1 = (Map)dbPlusMinusAreaIns.item1;
                            item2 = (Map)dbPlusMinusAreaIns.item2;
                            areaDynamicObject = (DynamicObject)item1.get(areaInsId);
                            if (HRObjectUtils.isEmpty((Object)areaDynamicObject)) continue;
                            this.checkRepeat(entryEntityParam, "indctrname", resultMap, areaInsId);
                            if (this.checkAreaIsEmpty(areaDynamicObject, resultMap, areaInsId) || HRObjectUtils.isEmpty((Object)(confDynamicObject = (DynamicObject)item2.get(areaConfId)))) continue;
                            List<String> mustInputField = this.checkIndicatorMustInput(confDynamicObject);
                            int index = 0;
                            indicatorEntryEntity = areaDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
                            if (!isAdd) {
                                indicatorEntryEntity.clear();
                            } else {
                                index = indicatorEntryEntity.size();
                            }
                            for (Map indicatorParam : entryEntityParam) {
                                this.checkIndicatorMustFiled(evalObjId, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                                this.checkEvalType(evalObjId, indicatorParam, resultMap, areaInsId, ADD_SUB_AREA_FIELDS);
                                this.checkScoreSetting(evalObjId, indicatorParam, resultMap, areaInsId);
                                this.makePlusMinusIndicator(index, isAdd, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                                ++index;
                            }
                            if (!((Boolean)resultMap.get(SUCCESS)).booleanValue()) continue;
                            addSubAreaIns.add(areaDynamicObject);
                        }
                        if (!AssessRuleConstants.ATTACH_AREA_PK.equals(areaRegId)) continue;
                        item1 = (Map)dbAttachAreaIns.item1;
                        item2 = (Map)dbAttachAreaIns.item2;
                        areaDynamicObject = (DynamicObject)item1.get(areaInsId);
                        if (HRObjectUtils.isEmpty((Object)areaDynamicObject)) continue;
                        this.checkRepeat(entryEntityParam, "keyactname", resultMap, areaInsId);
                        if (this.checkAreaIsEmpty(areaDynamicObject, resultMap, areaInsId) || HRObjectUtils.isEmpty((Object)(confDynamicObject = (DynamicObject)item2.get(areaConfId)))) continue;
                        List<String> mustInputField = this.checkIndicatorMustInput(confDynamicObject);
                        int index = 0;
                        indicatorEntryEntity = areaDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
                        if (!isAdd) {
                            indicatorEntryEntity.clear();
                        } else {
                            index = indicatorEntryEntity.size();
                        }
                        for (Map indicatorParam : entryEntityParam) {
                            this.checkIndicatorMustFiled(evalObjId, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                            this.makeAttachAreaIndicator(index, isAdd, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                        }
                        if (!((Boolean)resultMap.get(SUCCESS)).booleanValue()) continue;
                        attrAreaIns.add(areaDynamicObject);
                        continue;
                    }
                    String tips = ResManager.loadKDString((String)"\u533a\u57df\u4e0d\u5b58\u5728\u3002", (String)"IndicatorImportDomainService_2", (String)"opmc-epa-business", (Object[])new Object[0]);
                    this.makeErrorResult(evalObjId, tips, "", areaInsId, resultMap);
                }
                continue;
            }
            String tips = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"IndicatorImportDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]);
            this.makeErrorResult(evalObjId, tips, "", 0L, resultMap);
        }
        if (((Boolean)resultMap.get(SUCCESS)).booleanValue()) {
            if (!genAreaIns.isEmpty()) {
                OBJ_GEN_AREA_INS_ENTITY_SERVICE.save(genAreaIns.toArray(new DynamicObject[0]));
            }
            if (!addSubAreaIns.isEmpty()) {
                OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.save(addSubAreaIns.toArray(new DynamicObject[0]));
            }
            if (!attrAreaIns.isEmpty()) {
                OBJ_ATTACH_AREA_INS_ENTITY_SERVICE.save(attrAreaIns.toArray(new DynamicObject[0]));
            }
            OBJECT_DOMAIN_SERVICE.batchUpdateWeightAndIndctrScore(objIds);
        }
    }

    private void HandlerParams(List<Map<String, Object>> params, boolean isAdd, Map<String, Object> resultMap, DynamicObject[] evalObjs) {
        Map evalObjMap = Arrays.stream(evalObjs).collect(Collectors.toMap(eval -> eval.getLong("id"), Function.identity()));
        List<Long> objIds = Arrays.stream(evalObjs).map(eval -> eval.getLong("id")).collect(Collectors.toList());
        ArrayList<DynamicObject> genAreaIns = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> addSubAreaIns = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> attrAreaIns = new ArrayList<DynamicObject>(16);
        for (Map<String, Object> param : params) {
            Long evalObjId = (Long)param.get(EVAL_OBJ_ID);
            List areaEntryList = (List)param.get(AREA_ENTRY);
            if (areaEntryList == null) {
                resultMap.put(MSG, "areaentry is empty\u3002");
                resultMap.put(SUCCESS, false);
                resultMap.put(ERROR_CODE, "failed");
                return;
            }
            DynamicObject evalDynamicObject = (DynamicObject)evalObjMap.get(evalObjId);
            if (!HRObjectUtils.isEmpty((Object)evalDynamicObject)) {
                DynamicObjectCollection evalAreaEntry = evalDynamicObject.getDynamicObjectCollection(AREA_ENTRY);
                DynamicObject activityDynamicObject = ACTIVITY_DOMAIN_SERVICE.queryOne(evalDynamicObject.getLong("activity.id"));
                DynamicObject assessForm = OBJECT_DOMAIN_SERVICE.loadAssessForm(activityDynamicObject.getLong("assessform.id"));
                String scoreCalcWay = assessForm.getString("scorecalcway");
                String numAccuracy = assessForm.getString("numaccuracy");
                Map evalAreaEntryMap = evalAreaEntry.stream().collect(Collectors.toMap(area -> area.getLong("areains"), Function.identity()));
                for (Map areaEntryParam : areaEntryList) {
                    Long areaInsId = (Long)areaEntryParam.get(AREA_INS_ID);
                    DynamicObject evalAreaEntryObj = (DynamicObject)evalAreaEntryMap.get(areaInsId);
                    if (!HRObjectUtils.isEmpty((Object)evalAreaEntryObj)) {
                        List<String> mustInputField;
                        DynamicObject confDynamicObject;
                        List entryEntityParam = (List)areaEntryParam.get(ENTRY_ENTITY);
                        Long areaRegId = evalAreaEntryObj.getLong("areareg.id");
                        Long areaConfId = evalAreaEntryObj.getLong("areaconf");
                        DynamicObject areaDynamicObject = null;
                        if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaRegId)) {
                            String tips;
                            areaDynamicObject = OBJ_GEN_AREA_INS_ENTITY_SERVICE.loadSingle(areaInsId);
                            this.checkRepeat(entryEntityParam, "indctrname", resultMap, areaInsId);
                            if (this.checkAreaIsEmpty(areaDynamicObject, resultMap, areaInsId)) continue;
                            confDynamicObject = ASSESS_FORM_DOMAIN_SERVICE.queryNormalConfigByPk(areaConfId);
                            mustInputField = this.checkIndicatorMustInput(confDynamicObject);
                            BigDecimal areaNum = this.getIndicatorSum(isAdd, areaDynamicObject, scoreCalcWay);
                            int index = 0;
                            DynamicObjectCollection indicatorEntryEntity = areaDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
                            if (!isAdd) {
                                indicatorEntryEntity.clear();
                            } else {
                                index = indicatorEntryEntity.size();
                            }
                            for (Map indicatorParam : entryEntityParam) {
                                this.checkIndicatorMustFiled(evalObjId, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                                this.checkAdjustType(evalObjId, indicatorParam, confDynamicObject, resultMap, areaInsId, numAccuracy);
                                this.checkEvalType(evalObjId, indicatorParam, resultMap, areaInsId, NumberValidateUtils.removeNotValidateField(GEN_AREA_FIELDS));
                                this.makeNormIndicator(index, evalObjId, isAdd, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                                ++index;
                                areaNum = areaNum.add(this.addIndicatorNum(evalObjId, indicatorParam, scoreCalcWay, areaInsId, resultMap, numAccuracy));
                            }
                            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                                if (areaNum.compareTo(areaDynamicObject.getBigDecimal("areaweight")) > 0) {
                                    tips = ResManager.loadKDString((String)"\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700\u2264\u533a\u57df\u6743\u91cd", (String)"IndicatorImportDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]);
                                    this.makeErrorResult(evalObjId, tips, "weight", areaInsId, resultMap);
                                }
                            } else if (areaNum.compareTo(areaDynamicObject.getBigDecimal("areascore")) > 0) {
                                tips = ResManager.loadKDString((String)"\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700\u2264\u533a\u57df\u5206\u503c", (String)"IndicatorImportDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]);
                                this.makeErrorResult(evalObjId, tips, "indctrscore", areaInsId, resultMap);
                            }
                            if (!((Boolean)resultMap.get(SUCCESS)).booleanValue()) continue;
                            genAreaIns.add(areaDynamicObject);
                        }
                        if (AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaRegId)) {
                            areaDynamicObject = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.loadSingle(areaInsId);
                            this.checkRepeat(entryEntityParam, "indctrname", resultMap, areaInsId);
                            if (this.checkAreaIsEmpty(areaDynamicObject, resultMap, areaInsId)) continue;
                            confDynamicObject = ASSESS_FORM_DOMAIN_SERVICE.queryPlusMinusConfigByPk(areaConfId);
                            mustInputField = this.checkIndicatorMustInput(confDynamicObject);
                            int index = 0;
                            DynamicObjectCollection indicatorEntryEntity = areaDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
                            if (!isAdd) {
                                indicatorEntryEntity.clear();
                            } else {
                                index = indicatorEntryEntity.size();
                            }
                            for (Map indicatorParam : entryEntityParam) {
                                this.checkIndicatorMustFiled(evalObjId, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                                this.checkEvalType(evalObjId, indicatorParam, resultMap, areaInsId, ADD_SUB_AREA_FIELDS);
                                this.checkScoreSetting(evalObjId, indicatorParam, resultMap, areaInsId);
                                this.makePlusMinusIndicator(index, isAdd, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                                ++index;
                            }
                            if (!((Boolean)resultMap.get(SUCCESS)).booleanValue()) continue;
                            addSubAreaIns.add(areaDynamicObject);
                        }
                        if (!AssessRuleConstants.ATTACH_AREA_PK.equals(areaRegId)) continue;
                        areaDynamicObject = OBJ_ATTACH_AREA_INS_ENTITY_SERVICE.loadSingle(areaInsId);
                        this.checkRepeat(entryEntityParam, "keyactname", resultMap, areaInsId);
                        if (this.checkAreaIsEmpty(areaDynamicObject, resultMap, areaInsId)) continue;
                        confDynamicObject = ASSESS_FORM_DOMAIN_SERVICE.queryAttachConfigByPk(areaConfId);
                        mustInputField = this.checkIndicatorMustInput(confDynamicObject);
                        int index = 0;
                        DynamicObjectCollection indicatorEntryEntity = areaDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
                        if (!isAdd) {
                            indicatorEntryEntity.clear();
                        } else {
                            index = indicatorEntryEntity.size();
                        }
                        for (Map indicatorParam : entryEntityParam) {
                            this.checkIndicatorMustFiled(evalObjId, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                            this.makeAttachAreaIndicator(index, isAdd, areaDynamicObject, indicatorParam, resultMap, mustInputField);
                            ++index;
                        }
                        if (!((Boolean)resultMap.get(SUCCESS)).booleanValue()) continue;
                        attrAreaIns.add(areaDynamicObject);
                        continue;
                    }
                    String tips = ResManager.loadKDString((String)"\u533a\u57df\u4e0d\u5b58\u5728\u3002", (String)"IndicatorImportDomainService_2", (String)"opmc-epa-business", (Object[])new Object[0]);
                    this.makeErrorResult(evalObjId, tips, "", areaInsId, resultMap);
                }
                continue;
            }
            String tips = ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"IndicatorImportDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]);
            this.makeErrorResult(evalObjId, tips, "", 0L, resultMap);
        }
        if (((Boolean)resultMap.get(SUCCESS)).booleanValue()) {
            if (!genAreaIns.isEmpty()) {
                OBJ_GEN_AREA_INS_ENTITY_SERVICE.save(genAreaIns.toArray(new DynamicObject[0]));
            }
            if (!addSubAreaIns.isEmpty()) {
                OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.save(addSubAreaIns.toArray(new DynamicObject[0]));
            }
            if (!attrAreaIns.isEmpty()) {
                OBJ_ATTACH_AREA_INS_ENTITY_SERVICE.save(attrAreaIns.toArray(new DynamicObject[0]));
            }
            OBJECT_DOMAIN_SERVICE.batchUpdateWeightAndIndctrScore(objIds);
        }
    }

    private void checkEvalType(Long evalObjId, Map<String, Object> indicatorParam, Map<String, Object> resultMap, Long areaInsId, String[] checkFields) {
        Object evaltype = indicatorParam.get("evaltype");
        if (evaltype != null && HRStringUtils.equals((String)((String)evaltype), (String)"20")) {
            for (String checkField : checkFields) {
                Object value = indicatorParam.get(checkField);
                if (value == null || ValidatorUtils.validateNumber((String)value)) continue;
                String tips = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b", (String)"IndicatorImportDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tips, checkField, areaInsId, resultMap);
            }
        }
    }

    private void checkScoreSetting(Long evalObjId, Map<String, Object> indicatorParam, Map<String, Object> resultMap, Long areaInsId) {
        Object subscoremin = indicatorParam.get("subscoremin");
        Object addscoremax = indicatorParam.get("addscoremax");
        if (subscoremin != null) {
            if (ValidatorUtils.validateNumber((String)subscoremin)) {
                if (BigDecimal.ZERO.compareTo(new BigDecimal((String)subscoremin)) < 0) {
                    String tips = ResManager.loadKDString((String)"\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e0", (String)"IndicatorImportDomainService_5", (String)"opmc-epa-business", (Object[])new Object[0]);
                    this.makeErrorResult(evalObjId, tips, "subscoremin", areaInsId, resultMap);
                }
            } else {
                String tips = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b", (String)"IndicatorImportDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tips, "subscoremin", areaInsId, resultMap);
            }
            return;
        }
        if (addscoremax != null) {
            if (ValidatorUtils.validateNumber((String)addscoremax)) {
                if (BigDecimal.ZERO.compareTo(new BigDecimal((String)addscoremax)) > 0) {
                    String tips = ResManager.loadKDString((String)"\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0", (String)"IndicatorImportDomainService_6", (String)"opmc-epa-business", (Object[])new Object[0]);
                    this.makeErrorResult(evalObjId, tips, "addscoremax", areaInsId, resultMap);
                }
            } else {
                String tips = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b", (String)"IndicatorImportDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tips, "addscoremax", areaInsId, resultMap);
            }
        }
    }

    private void checkAdjustType(Long evalObjId, Map<String, Object> indicatorParam, DynamicObject confDynamicObject, Map<String, Object> resultMap, Long areaInsId, String numAccuracy) {
        boolean isAllowEval = confDynamicObject.getBoolean("reversepoints");
        if (isAllowEval && HRStringUtils.equals((String)confDynamicObject.getString("adjusttype"), (String)AdjustTypeEnum.CUSTOM.getValue())) {
            String tips;
            Object minevalscore = indicatorParam.get("minevalscore");
            Object maxevalscore = indicatorParam.get("maxevalscore");
            if (maxevalscore == null) {
                String tips2 = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"IndicatorImportDomainService_7", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tips2, "maxevalscore", areaInsId, resultMap);
                return;
            }
            if (minevalscore == null) {
                String tips3 = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"IndicatorImportDomainService_8", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tips3, "minevalscore", areaInsId, resultMap);
                return;
            }
            if (ValidatorUtils.validateNumber((String)maxevalscore)) {
                if (ValidatorUtils.validateNumAccuracy((String)maxevalscore) > Integer.parseInt(numAccuracy)) {
                    tips = ResManager.loadKDString((String)"\u201c\u8c03\u6574\u5206\u4e0b\u9650\u201d\u5b57\u6bb5\u5c0f\u6570\u683c\u5f0f\u4e0d\u6b63\u786e:{0}", (String)"IndicatorImportDomainService_9", (String)"opmc-epa-business", (Object[])new Object[]{maxevalscore});
                    this.makeErrorResult(evalObjId, tips, "maxevalscore", areaInsId, resultMap);
                }
            } else {
                tips = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b", (String)"IndicatorImportDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tips, "maxevalscore", areaInsId, resultMap);
            }
            if (ValidatorUtils.validateNumber((String)minevalscore)) {
                if (ValidatorUtils.validateNumAccuracy((String)minevalscore) > Integer.parseInt(numAccuracy)) {
                    tips = ResManager.loadKDString((String)"\u201c\u8c03\u6574\u5206\u4e0b\u9650\u201d\u5b57\u6bb5\u5c0f\u6570\u683c\u5f0f\u4e0d\u6b63\u786e:{0}", (String)"IndicatorImportDomainService_9", (String)"opmc-epa-business", (Object[])new Object[]{minevalscore});
                    this.makeErrorResult(evalObjId, tips, "minevalscore", areaInsId, resultMap);
                }
            } else {
                tips = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b", (String)"IndicatorImportDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tips, "minevalscore", areaInsId, resultMap);
            }
            this.checkMaxMinEvalScore(evalObjId, areaInsId, resultMap, confDynamicObject, maxevalscore, minevalscore);
        }
        if (isAllowEval && HRStringUtils.equals((String)confDynamicObject.getString("adjusttype"), (String)AdjustTypeEnum.NORMAL.getValue())) {
            indicatorParam.put("minevalscore", confDynamicObject.getBigDecimal("lowerscore"));
            indicatorParam.put("maxevalscore", confDynamicObject.getBigDecimal("upperscore"));
        }
    }

    private void checkMaxMinEvalScore(Long evalObjId, Long areaInsId, Map<String, Object> resultMap, DynamicObject confDynamicObject, Object upperScoreObj, Object lowerScoreObj) {
        BigDecimal upperScore = new BigDecimal((String)upperScoreObj);
        BigDecimal lowerScore = new BigDecimal((String)lowerScoreObj);
        DynamicObject scoresystem = confDynamicObject.getDynamicObject("scoresystem");
        BigDecimal maxScore = scoresystem.getBigDecimal("maxscore");
        BigDecimal minScore = scoresystem.getBigDecimal("minscore");
        if (((Boolean)resultMap.get(SUCCESS)).booleanValue()) {
            String tip;
            if (upperScore.compareTo(new BigDecimal(0)) < 0) {
                tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u9700\u22650", (String)"IndicatorImportDomainService_10", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tip, "maxevalscore", areaInsId, resultMap);
            }
            if (upperScore.compareTo(maxScore) > 0) {
                tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u5206\u503c\u9700\u2264\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206", (String)"IndicatorImportDomainService_11", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tip, "maxevalscore", areaInsId, resultMap);
            }
            if (upperScore.compareTo(lowerScore) <= 0) {
                tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0a\u9650\u9700\uff1e\u8c03\u6574\u5206\u4e0b\u9650", (String)"IndicatorImportDomainService_12", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tip, "maxevalscore", areaInsId, resultMap);
            }
            if (maxScore.compareTo(new BigDecimal(0)) >= 0) {
                if (lowerScore.compareTo(maxScore.negate()) < 0) {
                    tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u9700\u2265\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206\u7684\u76f8\u53cd\u6570\u3002", (String)"IndicatorImportDomainService_13", (String)"opmc-epa-business", (Object[])new Object[0]);
                    this.makeErrorResult(evalObjId, tip, "minevalscore", areaInsId, resultMap);
                }
            } else {
                if (lowerScore.compareTo(maxScore) > 0) {
                    tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u9700\u2264\u8bc4\u5206\u5206\u5236\u6700\u9ad8\u5206", (String)"IndicatorImportDomainService_14", (String)"opmc-epa-business", (Object[])new Object[0]);
                    this.makeErrorResult(evalObjId, tip, "minevalscore", areaInsId, resultMap);
                }
                if (lowerScore.compareTo(minScore) < 0) {
                    tip = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u4e0b\u9650\u5206\u503c\u9700\u2265\u8bc4\u5206\u5206\u5236\u6700\u4f4e\u5206", (String)"IndicatorImportDomainService_15", (String)"opmc-epa-business", (Object[])new Object[0]);
                    this.makeErrorResult(evalObjId, tip, "minevalscore", areaInsId, resultMap);
                }
            }
        }
    }

    private List<String> checkIndicatorMustInput(DynamicObject confDynamicObject) {
        ArrayList<String> mustInputField = new ArrayList<String>(16);
        DynamicObjectCollection entryEntity = confDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        for (DynamicObject fieldInfo : entryEntity) {
            DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
            if (!areaField.getBoolean("ismustinput")) continue;
            mustInputField.add(areaField.getString("number"));
        }
        return mustInputField;
    }

    private boolean checkAreaIsEmpty(DynamicObject areaDynamicObject, Map<String, Object> resultMap, Long areaInsId) {
        if (HRObjectUtils.isEmpty((Object)areaDynamicObject)) {
            String tips = ResManager.loadKDString((String)"\u533a\u57df\u4e0d\u5b58\u5728\u3002", (String)"IndicatorImportDomainService_2", (String)"opmc-epa-business", (Object[])new Object[0]);
            List data = (List)resultMap.get(DATA);
            HashMap<Long, String> errorData = new HashMap<Long, String>(16);
            errorData.put(areaInsId, tips);
            data.add(errorData);
            resultMap.put(SUCCESS, false);
            return true;
        }
        return false;
    }

    private void checkRepeat(List<Map<String, Object>> entryEntityParam, String key, Map<String, Object> resultMap, Long areaInsId) {
        List indctrNames = entryEntityParam.stream().map(entry -> (String)entry.get(key)).collect(Collectors.toList());
        List names = indctrNames.stream().distinct().collect(Collectors.toList());
        if (indctrNames.size() != names.size()) {
            String tips = ResManager.loadKDString((String)"\u5b57\u6bb5\u503c\u91cd\u590d\u3002", (String)"IndicatorImportDomainService_16", (String)"opmc-epa-business", (Object[])new Object[0]);
            List data = (List)resultMap.get(DATA);
            HashMap<String, String> msg = new HashMap<String, String>(16);
            HashMap<Long, HashMap<String, String>> errorData = new HashMap<Long, HashMap<String, String>>(16);
            msg.put(key, tips);
            errorData.put(areaInsId, msg);
            data.add(errorData);
            resultMap.put(SUCCESS, false);
        }
    }

    private void makeErrorResult(Long evalObjId, String tips, String key, Long areaInsId, Map<String, Object> resultMap) {
        List data = (List)resultMap.get(DATA);
        HashMap<String, String> msg = new HashMap<String, String>(16);
        HashMap<String, Serializable> errorData = new HashMap<String, Serializable>(16);
        msg.put("field", key);
        msg.put("error", tips);
        errorData.put(AREA_INS_ID, areaInsId);
        errorData.put(EVAL_OBJ_ID, evalObjId);
        errorData.put("failed_msg", msg);
        data.add(errorData);
        resultMap.put(SUCCESS, false);
        resultMap.put(MSG, "failed");
    }

    private void makeNormIndicator(int index, Long evalObjId, boolean isAdd, DynamicObject areaDynamicObject, Map<String, Object> indicatorParam, Map<String, Object> resultMap, List<String> mustInputField) {
        String indctrName;
        DynamicObjectCollection indicatorEntryEntity = areaDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        List indCtrNames = indicatorEntryEntity.stream().map(indicator -> indicator.getString("indctrname")).collect(Collectors.toList());
        if (isAdd && indCtrNames.contains(indctrName = (String)indicatorParam.get("indctrname"))) {
            String tips = ResManager.loadKDString((String)"\u201c{0}\u201d\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\u3002", (String)"IndicatorImportDomainService_21", (String)"opmc-epa-business", (Object[])new Object[]{indctrName});
            this.makeErrorResult(evalObjId, tips, "indctrname", areaDynamicObject.getLong("id"), resultMap);
        }
        DynamicObject indicatorDynamicObject = indicatorEntryEntity.addNew();
        indicatorDynamicObject.set("seq", (Object)index);
        indicatorParam.forEach((key, value) -> {
            if (mustInputField.contains(key) && value == null) {
                String tips = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorImportDomainService_18", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.makeErrorResult(evalObjId, tips, (String)key, areaDynamicObject.getLong("id"), resultMap);
            }
            if (indicatorDynamicObject.getDataEntityType().getProperties().containsKey(key)) {
                indicatorDynamicObject.set(key, value);
            }
        });
        if (indicatorParam.get("weight") != null) {
            indicatorDynamicObject.set("realweight", indicatorParam.get("weight"));
        }
    }

    private BigDecimal getIndicatorSum(boolean isAdd, DynamicObject areaDynamicObject, String scoreCalcWay) {
        BigDecimal areaNum;
        block4: {
            DynamicObjectCollection indicatorEntryEntity = areaDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
            areaNum = BigDecimal.ZERO;
            if (!isAdd) break block4;
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                for (DynamicObject dynamicObject : indicatorEntryEntity) {
                    BigDecimal weight = dynamicObject.getBigDecimal("weight");
                    areaNum = areaNum.add(weight);
                }
            } else {
                for (DynamicObject dynamicObject : indicatorEntryEntity) {
                    BigDecimal indctrscore = dynamicObject.getBigDecimal("indctrscore");
                    areaNum = areaNum.add(indctrscore);
                }
            }
        }
        return areaNum;
    }

    private BigDecimal addIndicatorNum(Long evalObjId, Map<String, Object> indicatorParam, String scoreCalcWay, Long areaInsId, Map<String, Object> resultMap, String numAccuracy) {
        BigDecimal areaNum = BigDecimal.ZERO;
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            Object weight = indicatorParam.get("weight");
            if (weight != null) {
                if (ValidatorUtils.validateNumber((String)weight)) {
                    BigDecimal weightBigDecimal = new BigDecimal((String)weight);
                    if (ValidatorUtils.validateNumAccuracy(weightBigDecimal.toString()) > Integer.parseInt(numAccuracy)) {
                        String tips = ResManager.loadKDString((String)"\u5c0f\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc7{0}", (String)"IndicatorImportDomainService_19", (String)"opmc-epa-business", (Object[])new Object[]{numAccuracy});
                        this.makeErrorResult(evalObjId, tips, "weight", areaInsId, resultMap);
                    }
                    areaNum = areaNum.add(weightBigDecimal);
                } else {
                    String tips = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b", (String)"IndicatorImportDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]);
                    this.makeErrorResult(evalObjId, tips, "weight", areaInsId, resultMap);
                }
            }
        } else {
            Object indctrscore = indicatorParam.get("indctrscore");
            if (indctrscore != null) {
                if (ValidatorUtils.validateNumber((String)indctrscore)) {
                    BigDecimal indctrBigDecimal = new BigDecimal((String)indctrscore);
                    if (ValidatorUtils.validateNumAccuracy(indctrBigDecimal.toString()) > Integer.parseInt(numAccuracy)) {
                        String tips = ResManager.loadKDString((String)"\u5c0f\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc7{0}", (String)"IndicatorImportDomainService_19", (String)"opmc-epa-business", (Object[])new Object[]{numAccuracy});
                        this.makeErrorResult(evalObjId, tips, "indctrscore", areaInsId, resultMap);
                    }
                    areaNum = areaNum.add(indctrBigDecimal);
                } else {
                    String tips = ResManager.loadKDString((String)"\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b", (String)"IndicatorImportDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]);
                    this.makeErrorResult(evalObjId, tips, "indctrscore", areaInsId, resultMap);
                }
            }
        }
        return areaNum;
    }

    private void makePlusMinusIndicator(int index, boolean isAdd, DynamicObject areaDynamicObject, Map<String, Object> indicatorParam, Map<String, Object> resultMap, List<String> mustInputField) {
        DynamicObjectCollection indicatorEntryEntity = areaDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        String indctrName = (String)indicatorParam.get("indctrname");
        List indCtrNames = indicatorEntryEntity.stream().map(indicator -> indicator.getString("indctrname")).collect(Collectors.toList());
        if (isAdd && indCtrNames.contains(indctrName)) {
            String tips = ResManager.loadKDString((String)"\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\u3002", (String)"IndicatorImportDomainService_20", (String)"opmc-epa-business", (Object[])new Object[0]);
            List data = (List)resultMap.get(DATA);
            HashMap<String, String> msg = new HashMap<String, String>(16);
            HashMap<Long, HashMap<String, String>> errorData = new HashMap<Long, HashMap<String, String>>(16);
            msg.put("indctrname", tips);
            errorData.put(areaDynamicObject.getLong("id"), msg);
            data.add(errorData);
            resultMap.put(SUCCESS, false);
        }
        DynamicObject indicatorDynamicObject = indicatorEntryEntity.addNew();
        indicatorDynamicObject.set("seq", (Object)index);
        indicatorParam.forEach((key, value) -> {
            if (mustInputField.contains(key) && value == null) {
                String tips = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorImportDomainService_18", (String)"opmc-epa-business", (Object[])new Object[0]);
                List data = (List)resultMap.get(DATA);
                HashMap<String, String> msg = new HashMap<String, String>(16);
                HashMap<Long, HashMap<String, String>> errorData = new HashMap<Long, HashMap<String, String>>(16);
                msg.put((String)key, tips);
                errorData.put(areaDynamicObject.getLong("id"), msg);
                data.add(errorData);
                resultMap.put(SUCCESS, false);
            }
            if (indicatorDynamicObject.getDataEntityType().getProperties().containsKey(key)) {
                indicatorDynamicObject.set(key, value);
            }
        });
    }

    private void checkIndicatorMustFiled(Long evalObjId, DynamicObject areaDynamicObject, Map<String, Object> indicatorParam, Map<String, Object> resultMap, List<String> mustInputField) {
        Set<String> fieldKey = indicatorParam.keySet();
        for (String field : mustInputField) {
            if (fieldKey.contains(field)) continue;
            String tips = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorImportDomainService_18", (String)"opmc-epa-business", (Object[])new Object[0]);
            this.makeErrorResult(evalObjId, tips, field, areaDynamicObject.getLong("id"), resultMap);
        }
    }

    private void makeAttachAreaIndicator(int index, boolean isAdd, DynamicObject areaDynamicObject, Map<String, Object> indicatorParam, Map<String, Object> resultMap, List<String> mustInputField) {
        DynamicObjectCollection indicatorEntryEntity = areaDynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        String keyActName = (String)indicatorParam.get("keyactname");
        List keyActNames = indicatorEntryEntity.stream().map(indicator -> indicator.getString("keyactname")).collect(Collectors.toList());
        if (isAdd && keyActNames.contains(keyActName)) {
            String tips = ResManager.loadKDString((String)"\u5b57\u6bb5\u503c\u5df2\u5b58\u5728\u3002", (String)"IndicatorImportDomainService_20", (String)"opmc-epa-business", (Object[])new Object[0]);
            List data = (List)resultMap.get(DATA);
            HashMap<String, String> msg = new HashMap<String, String>(16);
            HashMap<Long, HashMap<String, String>> errorData = new HashMap<Long, HashMap<String, String>>(16);
            msg.put("keyactname", tips);
            errorData.put(areaDynamicObject.getLong("id"), msg);
            data.add(errorData);
            resultMap.put(SUCCESS, false);
        }
        DynamicObject indicatorDynamicObject = indicatorEntryEntity.addNew();
        indicatorDynamicObject.set("seq", (Object)index);
        indicatorParam.forEach((key, value) -> {
            if (mustInputField.contains(key) && value == null) {
                String tips = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndicatorImportDomainService_18", (String)"opmc-epa-business", (Object[])new Object[0]);
                List data = (List)resultMap.get(DATA);
                HashMap<String, String> msg = new HashMap<String, String>(16);
                HashMap<Long, HashMap<String, String>> errorData = new HashMap<Long, HashMap<String, String>>(16);
                msg.put((String)key, tips);
                errorData.put(areaDynamicObject.getLong("id"), msg);
                data.add(errorData);
                resultMap.put(SUCCESS, false);
            }
            if (indicatorDynamicObject.getDataEntityType().getProperties().containsKey(key)) {
                indicatorDynamicObject.set(key, value);
            }
        });
    }
}

