/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.indicator.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activity.service.AssessActivityDomainService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAddSubAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjAttachAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.evalback.entity.EvalBackTaskDto;
import kd.opmc.epa.business.domain.evalback.entity.EvalBatchBackDto;
import kd.opmc.epa.business.domain.evalback.entity.EvalBatchBackResult;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjCustomAreaInsEntityService;
import kd.opmc.epa.business.domain.indicator.entityservice.IndicatorGroupEntityService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;

public class IndicatorObjDomainService {
    private static final Log LOG = LogFactory.getLog(IndicatorObjDomainService.class);
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessActivityDomainService ACTIVITY_DOMAIN_SERVICE = AssessActivityDomainService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREA_INS_ENTITY_SERVICE = ObjGenAreaInsEntityService.getInstance();
    private static final ObjAddSubAreaInsEntityService OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE = ObjAddSubAreaInsEntityService.getInstance();
    private static final ObjAttachAreaInsEntityService OBJ_ATTACH_AREA_INS_ENTITY_SERVICE = ObjAttachAreaInsEntityService.getInstance();
    private static final ObjCustomAreaInsEntityService OBJ_CUSTOM_AREA_INS_ENTITY_SERVICE = ObjCustomAreaInsEntityService.getInstance();
    private static final IndicatorGroupEntityService INDICATOR_GROUP_ENTITY_SERVICE = IndicatorGroupEntityService.getInstance();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"IndicatorObjDomainService#&", (int)3, (int)5);
    private static final String NODE_ROLLBACK = "nodeRollback";
    private static final String HANDLER_ROLLBACK = "handlerRollback";

    public static IndicatorObjDomainService getInstance() {
        return ServiceFactory.getService(IndicatorObjDomainService.class);
    }

    public EvalBatchBackResult batchRollBack(List<EvalBatchBackDto> evalBatchBackDtoList) {
        EvalBatchBackResult ret = EvalBatchBackResult.createResultWithTotalCount(evalBatchBackDtoList.size());
        Map<String, List<RollbackParamBo>> requestParam = this.handleRollBackParam(evalBatchBackDtoList, ret);
        List<RollbackParamBo> nodeList = requestParam.get(NODE_ROLLBACK);
        List<RollbackParamBo> handlerList = requestParam.get(HANDLER_ROLLBACK);
        this.invokeRollBackService(nodeList, ret, false);
        this.invokeRollBackService(handlerList, ret, true);
        return ret;
    }

    private void invokeRollBackService(List<RollbackParamBo> nodeList, EvalBatchBackResult ret, boolean isTask) {
        List nodeIds = nodeList.stream().map(RollbackParamBo::getActevalobjId).collect(Collectors.toList());
        FlowValidateResultBo flowValidaRetNode = new FlowValidateResultBo();
        flowValidaRetNode = isTask ? FLOW_RU_SECOND_DOMAIN_SERVICE.rollbackToSpecifiedTask(nodeList) : FLOW_RU_SECOND_DOMAIN_SERVICE.rollbackToSpecifiedNode(nodeList);
        LOG.info("=======invokeRollbackService:{0}======", (Object)flowValidaRetNode);
        Map nodeValidateMap = flowValidaRetNode.getValidateMap();
        Set nodeFailObjs = nodeValidateMap.keySet();
        List<Long> nodeSuccessIds = nodeIds.stream().filter(id -> !nodeFailObjs.contains(id)).collect(Collectors.toList());
        for (Map.Entry entry : nodeValidateMap.entrySet()) {
            ret.addFailureBackInfoList((Long)entry.getKey(), (String)entry.getValue());
        }
        ret.addFailureCount(nodeFailObjs.size());
        ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.dealWithAfterBaskFormulate(nodeSuccessIds);
        ret.addSuccessCount(nodeSuccessIds.size());
        ret.addFailureCount(nodeFailObjs.size());
    }

    public EvalBatchBackResult validateIndicatorRollBack(List<EvalBatchBackDto> evalBatchBackDtoList) {
        int totalSize = evalBatchBackDtoList.size();
        EvalBatchBackResult rollBackRet = EvalBatchBackResult.createResultWithTotalCount(totalSize);
        int failSize = 0;
        for (EvalBatchBackDto batchBackDto : evalBatchBackDtoList) {
            Long ruNodeId = batchBackDto.getRuNodeId();
            if (!HRObjectUtils.isEmpty((Object)ruNodeId) && ruNodeId != 0L) continue;
            String msg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u901a\u8fc7\u201c\u7edf\u4e00\u6d3e\u53d1\u201d\u5f62\u5f0f\u5236\u5b9a\u6307\u6807\uff0c\u65e0\u6cd5\u9000\u56de", (String)"IndicatorObjDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]);
            rollBackRet.addFailureBackInfoList(batchBackDto.getEvalObjId(), msg);
            ++failSize;
        }
        rollBackRet.setFailureCount(failSize);
        rollBackRet.setSuccessCount(totalSize - failSize);
        return rollBackRet;
    }

    private Map<String, List<RollbackParamBo>> handleRollBackParam(List<EvalBatchBackDto> evalBatchBackDtoList, EvalBatchBackResult rollBackRet) {
        HashMap ret = Maps.newHashMap();
        ArrayList nodeList = Lists.newArrayList();
        ArrayList handlerList = Lists.newArrayList();
        for (EvalBatchBackDto batchBackDto : evalBatchBackDtoList) {
            Long ruNodeId = batchBackDto.getRuNodeId();
            if (HRObjectUtils.isEmpty((Object)ruNodeId) || ruNodeId == 0L) {
                String msg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u901a\u8fc7\u201c\u7edf\u4e00\u6d3e\u53d1\u201d\u5f62\u5f0f\u5236\u5b9a\u6307\u6807\uff0c\u65e0\u6cd5\u9000\u56de", (String)"IndicatorObjDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]);
                rollBackRet.addFailureBackInfoList(batchBackDto.getEvalObjId(), msg);
                continue;
            }
            if (HRCollUtil.isNotEmpty(batchBackDto.getTaskList())) {
                List<EvalBackTaskDto> list = batchBackDto.getTaskList();
                for (EvalBackTaskDto dto : list) {
                    RollbackParamBo paramBo = new RollbackParamBo();
                    paramBo.setActevalobjId(batchBackDto.getEvalObjId());
                    paramBo.setActivityId(batchBackDto.getActivityId());
                    paramBo.setReason(batchBackDto.getBackReason());
                    paramBo.setRuProcId(batchBackDto.getRuProcId());
                    paramBo.setRuNodeId(batchBackDto.getRuNodeId());
                    paramBo.setRuTaskId(dto.getTaskId());
                    paramBo.setIndicatorIds((List)(dto.getIndicatorIdList() == null ? Lists.newArrayList() : dto.getIndicatorIdList()));
                    paramBo.setRollbackType("1");
                    handlerList.add(paramBo);
                }
                continue;
            }
            RollbackParamBo paramBo = new RollbackParamBo();
            paramBo.setActevalobjId(batchBackDto.getEvalObjId());
            paramBo.setActivityId(batchBackDto.getActivityId());
            paramBo.setReason(batchBackDto.getBackReason());
            paramBo.setRuNodeId(batchBackDto.getRuNodeId());
            paramBo.setRuProcId(batchBackDto.getRuProcId());
            paramBo.setRollbackType("1");
            nodeList.add(paramBo);
        }
        ret.put(NODE_ROLLBACK, nodeList);
        ret.put(HANDLER_ROLLBACK, handlerList);
        return ret;
    }

    public void upgradeObjAreaConfFormAssForm(List<Long> activitySubDynGroupIds) {
        Map<Long, Map<Long, Long>> areaIdMap = ACTIVITY_DOMAIN_SERVICE.queryAssessFormByActIds(activitySubDynGroupIds);
        this.batchUpdateObjAreaConf(activitySubDynGroupIds, areaIdMap);
    }

    private void batchUpdateObjAreaConf(List<Long> activitySubDynGroupIds, Map<Long, Map<Long, Long>> areaIdMap) {
        LOG.info("==================batchUpdateObjAreaConf start ========================= ");
        THREAD_POOL.execute(() -> this.updateObjAreaInsConf(activitySubDynGroupIds, areaIdMap), RequestContext.get());
        LOG.info("==================batchUpdateObjAreaConf end =========================");
    }

    private void updateObjAreaInsConf(List<Long> activitySubDynGroupIds, Map<Long, Map<Long, Long>> formAreaMap) {
        DynamicObject[] attachIns;
        DynamicObject[] addSubObjIns;
        DynamicObject[] genObjIns;
        DynamicObject[] evalObjMap;
        LinkedList<DynamicObject> saveEvalObj = new LinkedList<DynamicObject>();
        QFilter qFilter = new QFilter("activity", "in", activitySubDynGroupIds);
        for (DynamicObject dynamicObject : evalObjMap = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id, indigroup, activity, areaentry.areaconf", new QFilter[]{qFilter})) {
            DynamicObjectCollection areaentry = dynamicObject.getDynamicObjectCollection("areaentry");
            Map<Long, Long> areaIdMap = formAreaMap.get(dynamicObject.getLong("activity.id"));
            for (DynamicObject area : areaentry) {
                long areaconf = area.getLong("areaconf");
                if (!areaIdMap.containsKey(areaconf)) continue;
                area.set("areaconf", (Object)areaIdMap.get(areaconf));
            }
            saveEvalObj.add(dynamicObject);
        }
        QFilter groupIdsQFilter = new QFilter("activity", "in", activitySubDynGroupIds);
        DynamicObject[] indGroup = INDICATOR_GROUP_ENTITY_SERVICE.query("activity, indareaconfentry.areaconf", new QFilter[]{groupIdsQFilter});
        LinkedList<DynamicObject> groupEvalObj = new LinkedList<DynamicObject>();
        for (DynamicObject dynamicObject : indGroup) {
            DynamicObjectCollection areaentry = dynamicObject.getDynamicObjectCollection("indareaconfentry");
            Map<Long, Long> areaIdMap = formAreaMap.get(dynamicObject.getLong("activity.id"));
            for (DynamicObject area : areaentry) {
                long areaconf = area.getLong("areaconf");
                if (!areaIdMap.containsKey(areaconf)) continue;
                area.set("areaconf", (Object)areaIdMap.get(areaconf));
            }
            groupEvalObj.add(dynamicObject);
        }
        LinkedList<DynamicObject> linkedList = new LinkedList<DynamicObject>();
        QFilter areaConfQFilter = new QFilter("areaactivity", "in", activitySubDynGroupIds);
        for (DynamicObject genIns : genObjIns = OBJ_GEN_AREA_INS_ENTITY_SERVICE.query("id, areaactivity, areaconf", new QFilter[]{areaConfQFilter})) {
            long areaConf;
            Map<Long, Long> areaIdMap = formAreaMap.get(genIns.getLong("areaactivity"));
            if (!areaIdMap.containsKey(areaConf = genIns.getLong("areaconf.id"))) continue;
            genIns.set("areaconf", (Object)areaIdMap.get(areaConf));
            linkedList.add(genIns);
        }
        LinkedList<DynamicObject> linkedList2 = new LinkedList<DynamicObject>();
        for (DynamicObject genIns : addSubObjIns = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.query("id, areaactivity, areaconf", new QFilter[]{areaConfQFilter})) {
            long areaConf;
            Map<Long, Long> areaIdMap = formAreaMap.get(genIns.getLong("areaactivity"));
            if (!areaIdMap.containsKey(areaConf = genIns.getLong("areaconf.id"))) continue;
            genIns.set("areaconf", (Object)areaIdMap.get(areaConf));
            linkedList2.add(genIns);
        }
        LinkedList<DynamicObject> saveObjCustomIns = new LinkedList<DynamicObject>();
        QFilter customAreaConfQFilter = new QFilter("activity", "in", activitySubDynGroupIds);
        for (DynamicObject genIns : attachIns = OBJ_CUSTOM_AREA_INS_ENTITY_SERVICE.query("id, activity, areaconf", new QFilter[]{customAreaConfQFilter})) {
            long areaConf;
            Map<Long, Long> areaIdMap = formAreaMap.get(genIns.getLong("activity"));
            if (!areaIdMap.containsKey(areaConf = genIns.getLong("areaconf"))) continue;
            genIns.set("areaconf", (Object)areaIdMap.get(areaConf));
            saveObjCustomIns.add(genIns);
        }
        INDICATOR_GROUP_ENTITY_SERVICE.save(groupEvalObj.toArray(new DynamicObject[0]));
        OBJ_GEN_AREA_INS_ENTITY_SERVICE.save(linkedList.toArray(new DynamicObject[0]));
        OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.save(linkedList2.toArray(new DynamicObject[0]));
        OBJ_CUSTOM_AREA_INS_ENTITY_SERVICE.save(saveObjCustomIns.toArray(new DynamicObject[0]));
        ACTIVITY_EVALUATION_OBJECT_ENTITY.save(saveEvalObj.toArray(new DynamicObject[0]));
    }

    public Set<Long> checkHaveIndicatorArea(List<Long> objIds) {
        Long insId;
        Long objId;
        DynamicObjectCollection entryEntity;
        DynamicObject[] evalObjs;
        HashSet<Long> resultSet = new HashSet<Long>(16);
        ArrayList<Long> genAreaIns = new ArrayList<Long>(16);
        ArrayList<Long> genAddSubIns = new ArrayList<Long>(16);
        ArrayList<Long> genAttIns = new ArrayList<Long>(16);
        HashMap<Long, Long> genAreaMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> genAddSubMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> genAttMap = new HashMap<Long, Long>(16);
        QFilter qFilter = new QFilter("id", "in", objIds);
        for (DynamicObject evalObj : evalObjs = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id, areaentry.areareg, areaentry.areains, areaentry.areaconf", new QFilter[]{qFilter})) {
            DynamicObjectCollection areaEntry = evalObj.getDynamicObjectCollection("areaentry");
            for (DynamicObject dynamicObject : areaEntry) {
                DynamicObject areaReg = dynamicObject.getDynamicObject("areareg");
                Long areaRegId = areaReg.getLong("id");
                Long areaIns = dynamicObject.getLong("areains");
                if (areaRegId.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
                    genAreaIns.add(areaIns);
                    genAreaMap.put(areaIns, evalObj.getLong("id"));
                    continue;
                }
                if (areaRegId.equals(AssessRuleConstants.PLUS_MINUS_AREA_PK)) {
                    genAddSubIns.add(areaIns);
                    genAddSubMap.put(areaIns, evalObj.getLong("id"));
                    continue;
                }
                if (!areaRegId.equals(AssessRuleConstants.ATTACH_AREA_PK)) continue;
                genAttIns.add(areaIns);
                genAttMap.put(areaIns, evalObj.getLong("id"));
            }
        }
        if (!genAreaIns.isEmpty()) {
            DynamicObject[] genAreaInsObjs;
            for (DynamicObject genAreaInsObj : genAreaInsObjs = OBJ_GEN_AREA_INS_ENTITY_SERVICE.loadDynamicObjectArray(genAreaIns.toArray())) {
                entryEntity = genAreaInsObj.getDynamicObjectCollection("entryentity");
                if (entryEntity.isEmpty() || (objId = (Long)genAreaMap.get(insId = Long.valueOf(genAreaInsObj.getLong("id")))) == null) continue;
                resultSet.add(objId);
            }
        }
        if (!genAddSubIns.isEmpty()) {
            DynamicObject[] genAddSubInsObjs;
            for (DynamicObject genAddSubInsObj : genAddSubInsObjs = OBJ_ADD_SUB_AREA_INS_ENTITY_SERVICE.loadDynamicObjectArray(genAddSubIns.toArray())) {
                entryEntity = genAddSubInsObj.getDynamicObjectCollection("entryentity");
                if (entryEntity.isEmpty() || (objId = (Long)genAddSubMap.get(insId = Long.valueOf(genAddSubInsObj.getLong("id")))) == null) continue;
                resultSet.add(objId);
            }
        }
        if (!genAreaIns.isEmpty()) {
            DynamicObject[] attchAreaInsObjs;
            for (DynamicObject attchAreaInsObj : attchAreaInsObjs = OBJ_ATTACH_AREA_INS_ENTITY_SERVICE.loadDynamicObjectArray(genAttIns.toArray())) {
                entryEntity = attchAreaInsObj.getDynamicObjectCollection("entryentity");
                if (entryEntity.isEmpty() || (objId = (Long)genAttMap.get(insId = Long.valueOf(attchAreaInsObj.getLong("id")))) == null) continue;
                resultSet.add(objId);
            }
        }
        return resultSet;
    }
}

