/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.intactivity.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.interform.entityservice.InterFormEntityService;
import kd.opmc.epa.business.domain.interform.service.InterFormDomainService;
import kd.opmc.epa.business.domain.interview.entityservice.ActInsEntityService;
import kd.opmc.epa.business.domain.interview.entityservice.EmployInsEntityService;
import kd.opmc.epa.business.domain.interview.entityservice.InterInsEntityService;
import kd.opmc.epa.business.domain.interview.entityservice.InterviewActivityConfEntityService;
import kd.opmc.epa.business.domain.interview.entityservice.InterviewObjEntityService;
import kd.opmc.epa.business.domain.interview.entityservice.SignatureInsEntityService;
import kd.opmc.epa.business.domain.interview.enums.InterActStatusEnum;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.constants.PassNodeConstants;
import kd.opmc.epa.common.enums.interview.IntAreaRegEnum;
import kd.opmc.pbs.business.application.impl.mq.StartProcessPublisher;
import kd.opmc.pbs.business.domain.OpmcEntityService;
import kd.opmc.pbs.business.domain.flowscan.entity.BatchFlowTaskResultBo;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;

public class IntActivityDomainService {
    private static final AssessActivityEntityService ACTIVITY_ENTITY = AssessActivityEntityService.getInstance();
    private static final InterviewActivityConfEntityService INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE = InterviewActivityConfEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final InterviewObjEntityService INTER_VIEW_OBJECT_ENTITY_SERVICE = InterviewObjEntityService.getInstance();
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = FlowRuProcBatchDomainService.getInstance();
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();
    private static final InterFormDomainService INTER_FORM_DOMAIN_SERVICE = InterFormDomainService.getInstance();
    private static final InterFormEntityService INTER_FORM_ENTITY_SERVICE = InterFormEntityService.getInstance();
    private static final Map<Long, OpmcEntityService> AREA_INS_ENTITY_MAP = new HashMap<Long, OpmcEntityService>(16);
    private static final EmployInsEntityService EMPLOY_INS_ENTITY_SERVICE = EmployInsEntityService.getInstance();
    private static final ActInsEntityService ACT_INS_ENTITY_SERVICE = ActInsEntityService.getInstance();
    private static final InterInsEntityService INTER_INS_ENTITY_SERVICE = InterInsEntityService.getInstance();
    private static final SignatureInsEntityService SIGNATURE_INS_ENTITY_SERVICE = SignatureInsEntityService.getInstance();
    private static final Log LOGGER = LogFactory.getLog(IntActivityDomainService.class);

    public static IntActivityDomainService getInstance() {
        return ServiceFactory.getService(IntActivityDomainService.class);
    }

    public DynamicObject queryOne(Object pk) {
        return INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.queryOne(pk);
    }

    public DynamicObject[] queryIntObjectArrayById(Long[] intObjIds) {
        return INTER_VIEW_OBJECT_ENTITY_SERVICE.loadDynamicObjectArray(intObjIds);
    }

    public void genInterobjFromActi(Long interActConfId) {
        DynamicObject interActConfDy = INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.loadSingle(interActConfId);
        DynamicObjectCollection activityColl = interActConfDy.getDynamicObjectCollection("activityids");
        ArrayList<Long> activityIdList = new ArrayList<Long>(10);
        Map<Object, Object> defaultWorkFlow = new HashMap(16);
        List<Object> batchFlowTaskResultBoList = new ArrayList(10);
        if (activityColl != null) {
            for (DynamicObject activityDy : activityColl) {
                activityIdList.add(activityDy.getLong("fbasedataid_id"));
            }
        }
        String selectFields = "person,employee,perffilev,perffile,affiliateadminorg,empposrel,perforg";
        if (activityIdList.size() > 0) {
            DynamicObject[] evalObjs = ACTIVITY_EVALUATION_OBJECT_ENTITY_SERVICE.queryByActivityIds(selectFields, activityIdList);
            DynamicObjectCollection flowEntryColl = this.getPerfWorkFlowEntryColl(interActConfDy);
            defaultWorkFlow = this.getDefaultWorkFlowMap(flowEntryColl);
            if (defaultWorkFlow == null) {
                return;
            }
            DynamicObject[] intObjs = this.genIntObjs(evalObjs, selectFields.split(","), interActConfDy, defaultWorkFlow);
            batchFlowTaskResultBoList = this.preCreateEvaluationObjectProcessInstance(intObjs, defaultWorkFlow, interActConfDy);
            for (BatchFlowTaskResultBo batchFlowTaskResultBo : batchFlowTaskResultBoList) {
                StartProcessPublisher.publish((List)batchFlowTaskResultBo.getBatchTaskIdList(), (String)batchFlowTaskResultBo.getTaskType());
            }
        }
    }

    private List<BatchFlowTaskResultBo> preCreateEvaluationObjectProcessInstance(DynamicObject[] evaluationObjectArr, Map<String, Long> defaultWorkFlow, DynamicObject interActConfDy) {
        ArrayList<BatchFlowTaskResultBo> batchFlowTaskResultBoList = new ArrayList<BatchFlowTaskResultBo>(10);
        ArrayList<FlowRuProcBo> formulatFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        for (Map.Entry<String, Long> workFlow : defaultWorkFlow.entrySet()) {
            long workFlowVid = workFlow.getValue();
            String workFlowType = workFlow.getKey();
            for (DynamicObject activityEvaluationObject : evaluationObjectArr) {
                FlowRuProcBo flowRuProcBo = EvalObjUtils.buildIntProcBo(activityEvaluationObject, workFlowVid, workFlowType, interActConfDy);
                if (!"3".equals(workFlowType)) continue;
                formulatFlowRuProcBoList.add(flowRuProcBo);
            }
        }
        BatchFlowTaskResultBo formulateResultBo = BATCH_START_EVAL_ENTITY_SERVICE.generateBatchFlowTaskData(formulatFlowRuProcBoList, TaskTypeEnum.INT_PRE_INSTANTIATION.getValue());
        formulateResultBo.setTaskType(TaskTypeEnum.INT_PRE_INSTANTIATION.getValue());
        batchFlowTaskResultBoList.add(formulateResultBo);
        return batchFlowTaskResultBoList;
    }

    private Map<String, Long> getDefaultWorkFlowMap(DynamicObjectCollection flowEntryColl) {
        if (flowEntryColl == null) {
            return null;
        }
        HashSet<Long> defaultWorkFlowIdSet = new HashSet<Long>(16);
        ArrayList<String> passNodeIdSet = new ArrayList<String>(10);
        for (DynamicObject tempDynObj : flowEntryColl) {
            String passNodeId = tempDynObj.getString("passnode");
            if (!this.checkDefaultEvalAndFormulateFlow(tempDynObj) || passNodeIdSet.contains(passNodeId)) continue;
            defaultWorkFlowIdSet.add(tempDynObj.getLong("flowvid"));
            passNodeIdSet.add(passNodeId);
        }
        DynamicObjectCollection workFlowDynObjColl = WORK_FLOW_ENTITY_SERVICE.queryOriginalCollection("id,workflowtype", new QFilter("id", "in", defaultWorkFlowIdSet).toArray());
        return workFlowDynObjColl.stream().collect(Collectors.toMap(dynObj -> dynObj.getString("workflowtype"), dynObj -> dynObj.getLong("id")));
    }

    private boolean checkDefaultEvalAndFormulateFlow(DynamicObject workFlowDynObjTemp) {
        return workFlowDynObjTemp.getBoolean("isdefaultflow") && workFlowDynObjTemp.getBoolean("isenable") && workFlowDynObjTemp.getLong("passnode") == PassNodeConstants.INTERVIEW_PERFORMANCE.longValue();
    }

    private DynamicObjectCollection getPerfWorkFlowEntryColl(DynamicObject interActConfDy) {
        long perfWorkFlowId = interActConfDy.getLong("perfworkflow.id");
        DynamicObject workFlowDynObj = PERF_WORK_FLOW_DOMAIN_SERVICE.loadSingleWorkFlow(perfWorkFlowId);
        if (workFlowDynObj != null) {
            return workFlowDynObj.getDynamicObjectCollection("flowentry");
        }
        return null;
    }

    private DynamicObject[] genIntObjs(DynamicObject[] evalObjs, String[] selectFields, DynamicObject interActConfDy, Map<String, Long> defaultWorkFlow) {
        DynamicObject userDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        userDy.set("id", (Object)RequestContext.get().getCurrUserId());
        ArrayList<DynamicObject> intObjList = new ArrayList<DynamicObject>(10);
        HashMap<Long, List<DynamicObject>> areaInstanceListOfAreaRegMap = new HashMap<Long, List<DynamicObject>>(16);
        Long evaluatorWorkFlowId = defaultWorkFlow.get("3");
        Long intFormId = interActConfDy.getLong("interform.id");
        DynamicObject intFormDy = INTER_FORM_ENTITY_SERVICE.loadSingle(intFormId);
        for (DynamicObject evalObj : evalObjs) {
            DynamicObject intObjNew = INTER_VIEW_OBJECT_ENTITY_SERVICE.generateEmptyDynamicObject();
            for (String field : selectFields) {
                intObjNew.set(field, evalObj.get(field));
            }
            intObjNew.set("interact", interActConfDy.get("id"));
            intObjNew.set("evalobj", evalObj.get("id"));
            intObjNew.set("interstatus", (Object)InterActStatusEnum.TO_BE.getCode());
            intObjNew.set("creator", (Object)userDy);
            intObjNew.set("interflow", (Object)evaluatorWorkFlowId);
            this.setAreaInstance(intObjNew, intFormDy, areaInstanceListOfAreaRegMap);
            intObjList.add(intObjNew);
        }
        DynamicObject[] intObjs = (DynamicObject[])INTER_VIEW_OBJECT_ENTITY_SERVICE.save(intObjList.toArray(new DynamicObject[0]));
        for (Map.Entry areaInstance : areaInstanceListOfAreaRegMap.entrySet()) {
            long areaRegId = (Long)areaInstance.getKey();
            OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaRegId);
            if (!ObjectUtils.isEmpty((Object)entity)) {
                entity.save(((List)areaInstance.getValue()).toArray(new DynamicObject[0]));
                continue;
            }
            LOGGER.info("Excluded areaReg {}", (Object)areaRegId);
        }
        return intObjs;
    }

    private void setAreaInstance(DynamicObject intObjNew, DynamicObject intFormDy, Map<Long, List<DynamicObject>> areaInstanceListOfAreaRegMap) {
        DynamicObjectCollection areaConfColl = intFormDy.getDynamicObjectCollection("areaconfentry");
        DynamicObjectCollection areaEntry = intObjNew.getDynamicObjectCollection("areaentity");
        for (DynamicObject assTableConf : areaConfColl) {
            DynamicObject areaInstanceEntryRow = new DynamicObject(areaEntry.getDynamicObjectType());
            long areaId = assTableConf.getDynamicObject("area").getLong("id");
            areaInstanceEntryRow.set("area", (Object)areaId);
            DynamicObject areaInstance = this.initAreaInstance(areaId);
            if (areaInstance == null) continue;
            List<DynamicObject> areaInstanceDys = areaInstanceListOfAreaRegMap.get(areaId);
            if (ObjectUtils.isEmpty(areaInstanceDys)) {
                areaInstanceDys = new ArrayList<DynamicObject>(10);
                areaInstanceListOfAreaRegMap.put(areaId, areaInstanceDys);
            }
            areaInstanceDys.add(areaInstance);
            areaInstanceEntryRow.set("areains", areaInstance.getPkValue());
            areaEntry.add((Object)areaInstanceEntryRow);
        }
    }

    private DynamicObject initAreaInstance(long areaId) {
        OpmcEntityService entity = AREA_INS_ENTITY_MAP.get(areaId);
        if (ObjectUtils.isEmpty((Object)entity)) {
            LOGGER.error("Excluded areaReg {0}", (Object)areaId);
            return null;
        }
        DynamicObject areaInstance = entity.generateEmptyDynamicObject();
        areaInstance.set("creator", (Object)RequestContext.get().getCurrUserId());
        ORM.create().setPrimaryKey(areaInstance);
        return areaInstance;
    }

    public void updateIntActivityStatus(Long interActConfId) {
        DynamicObject intActivityDynObj = INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.queryOne(interActConfId);
        intActivityDynObj.set("activitystatus", (Object)"20");
        intActivityDynObj.set("startuptime", (Object)new Date());
        long perfWorkFlowId = intActivityDynObj.getLong("perfworkflow.id");
        DynamicObject workFlowDynObj = PERF_WORK_FLOW_DOMAIN_SERVICE.getSourceDynamicObject(perfWorkFlowId);
        intActivityDynObj.set("perfworkflow", (Object)workFlowDynObj);
        INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.updateOne(intActivityDynObj);
    }

    public int countIntActObjByIntActivityIds(Long intActivityId) {
        return INTER_VIEW_OBJECT_ENTITY_SERVICE.countByIntActivityId(intActivityId);
    }

    static {
        AREA_INS_ENTITY_MAP.put(IntAreaRegEnum.ACTCONF.getAreaPkId(), ACT_INS_ENTITY_SERVICE);
        AREA_INS_ENTITY_MAP.put(IntAreaRegEnum.INTERCONF.getAreaPkId(), INTER_INS_ENTITY_SERVICE);
        AREA_INS_ENTITY_MAP.put(IntAreaRegEnum.SIGCONF.getAreaPkId(), SIGNATURE_INS_ENTITY_SERVICE);
    }
}

