/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.interview.entityservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.interview.enums.InterStatusEnum;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class InterviewObjEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_interobj");

    public static InterviewObjEntityService getInstance() {
        return ServiceFactory.getService(InterviewObjEntityService.class);
    }

    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject[] queryInterviewFlowsMap(Long activityId) {
        QFilter filter = new QFilter("interact", "=", (Object)activityId).and("interstatus", "=", (Object)InterStatusEnum.JOINED.getStatus());
        String selectPro = "id, interflow, perffile, person, empposrel.position, affiliateadminorg, empposrel.company, interflowins";
        return this.query(selectPro, new QFilter[]{filter});
    }

    public DynamicObject[] queryInterviewobjsById(String selectFields, List<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return new DynamicObject[0];
        }
        if (HRStringUtils.isEmpty((String)selectFields)) {
            selectFields = "id";
        }
        return this.query(selectFields, new QFilter[]{new QFilter("id", "in", ids)});
    }

    public DynamicObject queryInterViewObjectById(Long interobjId) {
        return this.loadSingle(interobjId);
    }

    public DynamicObject[] queryIntActObjByIntActivityIds(Long intActivityId) {
        QFilter qFilter = new QFilter("interact.id", "=", (Object)intActivityId);
        return this.queryOriginalArray("interact.id", new QFilter[]{qFilter});
    }

    public int countByIntActivityId(Long intActivityId) {
        QFilter qFilter = new QFilter("interact.id", "=", (Object)intActivityId);
        return HELPER.count("epa_interobj", new QFilter[]{qFilter});
    }

    public DynamicObject[] queryInterViewObjectsByIds(Long[] actevalobjIds) {
        return this.loadDynamicObjectArray(actevalobjIds);
    }

    public DynamicObject[] queryInterObj(Long activityId) {
        QFilter filter = new QFilter("interact", "=", (Object)activityId);
        String selectPro = "evalobj,id, interflow, perffile, person, empposrel.position, affiliateadminorg, empposrel.company, interflowins";
        return this.query(selectPro, new QFilter[]{filter});
    }

    public DynamicObject[] queryInterObjNoTOBe(Long activityId) {
        QFilter filter = new QFilter("interact", "=", (Object)activityId);
        QFilter interstatus = new QFilter("interstatus", "not in", (Object)new String[]{"10", "50"});
        String selectPro = "evalobj,id, interflow, perffile, person, empposrel.position, affiliateadminorg, empposrel.company, interflowins";
        return this.query(selectPro, new QFilter[]{filter, interstatus});
    }

    public DynamicObject[] queryInterviewObjCountByActId(Long activityId) {
        if (activityId == null) {
            return null;
        }
        return this.queryOriginalArray("interstatus", new QFilter[]{new QFilter("interact", "=", (Object)activityId)});
    }

    public DynamicObject[] queryInterObjByIdsAndIntAct(Long activityId, List<Long> ids) {
        if (activityId == null || ids == null || ids.size() < 1) {
            return null;
        }
        QFilter filter = new QFilter("interact", "=", (Object)activityId).and("id", "in", ids);
        String selectPro = "interstatus,interflowins.procstatus,perffile.name,perffile.billno,endtime,modifytime";
        return this.query(selectPro, new QFilter[]{filter});
    }

    public boolean isExistsTobeInterObjByActId(Long activityId) {
        QFilter filter = new QFilter("interact", "=", (Object)activityId).and("interstatus", "=", (Object)InterStatusEnum.JOINED.getStatus());
        return this.isExists(filter);
    }

    public boolean isExistsInProgress(Long intActivityId) {
        ArrayList<String> inProgressStatus = new ArrayList<String>(2);
        inProgressStatus.add(InterStatusEnum.JOINED.getStatus());
        inProgressStatus.add(InterStatusEnum.HAVE_IN_HAND.getStatus());
        QFilter filter = new QFilter("interact.id", "=", (Object)intActivityId).and("interstatus", "in", inProgressStatus);
        return this.isExists(new QFilter[]{filter});
    }

    public boolean isExistsIntObj(Long intActivityId) {
        QFilter filter = new QFilter("interact.id", "=", (Object)intActivityId);
        return this.isExists(new QFilter[]{filter});
    }

    public DynamicObject[] queryByActAndNotEqualInterstatus(String selectFields, Long activityId, String[] interstatus) {
        QFilter activityFilter = new QFilter("interact", "in", (Object)activityId);
        QFilter interflowinsFilter = new QFilter("interstatus", "not in", (Object)interstatus);
        return this.query(selectFields, new QFilter[]{activityFilter, interflowinsFilter});
    }

    public DynamicObject[] queryInterviewObjById(String selectPro, List<Long> objIds) {
        QFilter filter = new QFilter("id", "=", objIds);
        return this.query(selectPro, new QFilter[]{filter});
    }
}

