/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.interview.service;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.interview.entityservice.InterviewActivityConfEntityService;
import kd.opmc.epa.business.domain.interview.entityservice.InterviewObjEntityService;
import kd.opmc.epa.business.domain.interview.enums.InterActStatusEnum;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;

public class InterviewActivityConfDomainService {
    private static final InterviewActivityConfEntityService INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE = InterviewActivityConfEntityService.getInstance();
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final InterviewObjEntityService INTERVIEW_OBJ_ENTITY_SERVICE = InterviewObjEntityService.getInstance();
    private static final AssessActivityEntityService ASSESS_ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();

    public static InterviewActivityConfDomainService getInstance() {
        return ServiceFactory.getService(InterviewActivityConfDomainService.class);
    }

    public DynamicObject queryPerfWorkFlow(Long activityId) {
        DynamicObject activity = INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.queryOne("perfworkflow", new QFilter[]{new QFilter("id", "=", (Object)activityId)});
        if (HRObjectUtils.isEmpty((Object)activity)) {
            return null;
        }
        DynamicObject perfWorkFlow = activity.getDynamicObject("perfworkflow");
        if (HRObjectUtils.isEmpty((Object)perfWorkFlow)) {
            return null;
        }
        return PERF_WORK_FLOW_ENTITY_SERVICE.queryOne(perfWorkFlow.getPkValue());
    }

    public DynamicObject queryInterviewInfoById(Long activityId) {
        if (activityId == null) {
            return null;
        }
        return INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.queryOne("name,number,activitystatus,interform.name,perfworkflow.name,activityids.name", new QFilter[]{new QFilter("id", "=", (Object)activityId)});
    }

    public DynamicObject queryOne(Long intActivityId) {
        return INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.queryOne(intActivityId);
    }

    public DynamicObject[] queryInterviewByPkValue(Object[] objects) {
        return INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.loadDynamicObjectArray(objects);
    }

    public boolean checkEndIntStatus(Long intActivityId) {
        return INTERVIEW_OBJ_ENTITY_SERVICE.isExistsInProgress(intActivityId);
    }

    public boolean isExistsIntObj(Long intActivityId) {
        return INTERVIEW_OBJ_ENTITY_SERVICE.isExistsIntObj(intActivityId);
    }

    public void endActivity(Long intActivityId) {
        DynamicObject intActivityDy = INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.loadSingle(intActivityId);
        intActivityDy.set("activitystatus", (Object)InterActStatusEnum.COMPLETED.getCode());
        intActivityDy.set("endtime", (Object)new Date());
        INTERVIEW_ACTIVITY_CONF_ENTITY_SERVICE.save(new DynamicObject[]{intActivityDy});
    }

    public DynamicObject[] getActivityEntry(DynamicObjectCollection relEvalActivityColl) {
        List<Long> activityIdList = relEvalActivityColl.stream().map(relEvalActivityDy -> (Long)relEvalActivityDy.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        return ASSESS_ACTIVITY_ENTITY_SERVICE.queryActivityByIdList(activityIdList);
    }
}

