/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.interview.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.interview.entity.EndInterResultBo;
import kd.opmc.epa.business.domain.interview.entityservice.InterviewActivityConfEntityService;
import kd.opmc.epa.business.domain.interview.entityservice.InterviewObjEntityService;
import kd.opmc.epa.business.domain.interview.enums.InterStatusEnum;
import kd.opmc.epa.business.domain.interview.service.flow.AbstractFlowPreInstanceService;
import kd.opmc.epa.business.domain.interview.service.flow.FlowPreInstanceServiceFactory;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.workflow.dto.AssignHandlerParamDTO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.business.domain.workflow.vo.AssignHandlerVO;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;

public class InterviewObjDomainService {
    private static final Log LOG = LogFactory.getLog(InterviewObjDomainService.class);
    private static final InterviewObjEntityService INTERVIEW_OBJ_ENTITY_SERVICE = InterviewObjEntityService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final FlowDefProcEntityService FLOW_DEF_PROC_ENTITY_SERVICE = FlowDefProcEntityService.getInstance();
    private static final FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = FlowHandlerDomainService.getInstance();
    private static final PerffileEntityService PERFFILE_ENTITY_SERVICE = PerffileEntityService.getInstance();
    private static final ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = FlowRuProcBatchDomainService.getInstance();
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final InterviewObjEntityService INTER_VIEW_OBJECT_ENTITY_SERVICE = InterviewObjEntityService.getInstance();
    private static final InterviewActivityConfEntityService INTERVIEW_ACTIVITY_CONF_DOMAIN_SERVICE = InterviewActivityConfEntityService.getInstance();
    private static final FlowRuProcDomainService FLOW_RUPROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    private static final FlowRuRoleEntityService ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    private static final FlowHandlerBatchDomainService FLOW_HANDLER_BATCH_DOMAIN_SERVICE = FlowHandlerBatchDomainService.getInstance();
    private static final ActEvalObjManageDomainService ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE = ActEvalObjManageDomainService.getInstance();

    public static InterviewObjDomainService getInstance() {
        return ServiceFactory.getService(InterviewObjDomainService.class);
    }

    public Map<Object, Long> queryInterviewFlowsMap(Long activityId) {
        DynamicObject[] objs = INTERVIEW_OBJ_ENTITY_SERVICE.queryInterviewFlowsMap(activityId);
        return Arrays.stream(objs).filter(obj -> !ObjectUtils.isEmpty((Object)obj.getDynamicObject("interflow"))).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("interflow").getPkValue(), Collectors.counting()));
    }

    public DynamicObject[] queryFlowByPkValue(Set<Object> objects) {
        return WORK_FLOW_ENTITY_SERVICE.getWorkflowById(objects);
    }

    public DynamicObject[] queryInterviewByPkValue(Object[] objects) {
        return INTERVIEW_OBJ_ENTITY_SERVICE.loadDynamicObjectArray(objects);
    }

    public void saveInterview(DynamicObject[] dynamicObjects) {
        INTERVIEW_OBJ_ENTITY_SERVICE.save(dynamicObjects);
    }

    public DynamicObject queryFlowProcPkValue(Long flowProcId) {
        return FLOW_DEF_PROC_ENTITY_SERVICE.getFlowDefProcByPkValue(flowProcId);
    }

    public Map<Long, String> queryHandler(List<Long> roleIds) {
        HashMap<Long, String> evaluatorMap = new HashMap<Long, String>(16);
        Map handerMap = FLOW_HANDLER_DOMAIN_SERVICE.queryHandlerByRuleIds(roleIds);
        for (Map.Entry set : handerMap.entrySet()) {
            List handerList = (List)set.getValue();
            if (ObjectUtils.isEmpty((Object)handerList)) {
                evaluatorMap.put((Long)set.getKey(), "");
                continue;
            }
            StringBuilder builder = new StringBuilder();
            int index = 0;
            for (DynamicObject hander : handerList) {
                if (hander == null) continue;
                if (index != 0) {
                    builder.append(",");
                }
                builder.append(hander.getString("name"));
                String number = String.format("(%s)", hander.getString("number"));
                builder.append(number);
                ++index;
            }
            evaluatorMap.put((Long)set.getKey(), builder.toString());
        }
        return evaluatorMap;
    }

    public DynamicObject[] queryInterObj(Long activityId) {
        DynamicObject[] dynamicObjects = INTERVIEW_OBJ_ENTITY_SERVICE.queryInterObj(activityId);
        return dynamicObjects;
    }

    public boolean updateInterviewObjFlowInstance(Map<Long, Long> interviewInsMap) {
        DynamicObject[] actEvaObjDyns;
        HashSet<Long> actEvaObjIdSet = new HashSet<Long>(16);
        actEvaObjIdSet.addAll(interviewInsMap.keySet());
        QFilter qFilter = new QFilter("id", "in", actEvaObjIdSet);
        for (DynamicObject actEvaObjDyn : actEvaObjDyns = INTERVIEW_OBJ_ENTITY_SERVICE.query("id,interflowins", new QFilter[]{qFilter})) {
            if (null == interviewInsMap.get(actEvaObjDyn.getLong("id"))) continue;
            actEvaObjDyn.set("interflowins", (Object)interviewInsMap.get(actEvaObjDyn.getLong("id")));
        }
        INTERVIEW_OBJ_ENTITY_SERVICE.save(actEvaObjDyns);
        return Boolean.TRUE;
    }

    public DynamicObject[] queryInterViewObjectArrayById(Long[] interobjIds) {
        return INTERVIEW_OBJ_ENTITY_SERVICE.queryInterViewObjectsByIds(interobjIds);
    }

    public DynamicObject queryInterViewObjectById(Long interviewobjId) {
        return INTERVIEW_OBJ_ENTITY_SERVICE.queryInterViewObjectById(interviewobjId);
    }

    public Map<Long, String> getInterViewObjPerffileNamesByObjIds(List<Long> interObjIds) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        DynamicObject[] interObjs = INTERVIEW_OBJ_ENTITY_SERVICE.queryInterviewobjsById("id,perffile.id", interObjIds);
        DynamicObject[] perfFiles = PERFFILE_ENTITY_SERVICE.getPerffileListByIds("id,name", Arrays.stream(interObjs).map(e -> e.getLong("perffile.id")).distinct().collect(Collectors.toList()));
        Map<Long, DynamicObject> perFilesMap = Arrays.stream(perfFiles).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<Long, DynamicObject> interObjMap = Arrays.stream(interObjs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (Long interObjId : interObjIds) {
            resultMap.computeIfAbsent(interObjId, v -> {
                Long perFileId = interObjMap.get(interObjId) == null ? 0L : ((DynamicObject)interObjMap.get(interObjId)).getLong("perffile.id");
                return perFilesMap.get(perFileId) == null ? "" : ((DynamicObject)perFilesMap.get(perFileId)).getString("name");
            });
        }
        return resultMap;
    }

    public Map<Long, Map<String, String>> getInterViewObjPerffilePersonInfoByObjIds(List<Long> interObjIds) {
        HashMap<Long, Map<String, String>> resultMap = new HashMap<Long, Map<String, String>>(16);
        DynamicObject[] interObjs = INTERVIEW_OBJ_ENTITY_SERVICE.queryInterviewobjsById("id,perffile.id", interObjIds);
        DynamicObject[] perfFiles = PERFFILE_ENTITY_SERVICE.getPerffileListByIds("id,name,billno", Arrays.stream(interObjs).map(e -> e.getLong("perffile.id")).distinct().collect(Collectors.toList()));
        Map<Long, DynamicObject> perFilesMap = Arrays.stream(perfFiles).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Map<Long, DynamicObject> interObjMap = Arrays.stream(interObjs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (Long interObjId : interObjIds) {
            resultMap.computeIfAbsent(interObjId, v -> {
                HashMap<String, String> perFilePersonInfo = new HashMap<String, String>(16);
                if (interObjMap.get(interObjId) != null) {
                    Long perFileId = ((DynamicObject)interObjMap.get(interObjId)).getLong("perffile.id");
                    perFilePersonInfo.put("billno", perFilesMap.get(perFileId) == null ? "" : ((DynamicObject)perFilesMap.get(perFileId)).getString("billno"));
                    perFilePersonInfo.put("name", perFilesMap.get(perFileId) == null ? "" : ((DynamicObject)perFilesMap.get(perFileId)).getString("name"));
                    return perFilePersonInfo;
                }
                return null;
            });
        }
        return resultMap;
    }

    public void PreProcessInstance(DynamicObject[] interObjectArr) {
        AbstractFlowPreInstanceService flowPreInstanceService = FlowPreInstanceServiceFactory.getFlowPreInstanceService();
        flowPreInstanceService.preProcessInstance(interObjectArr);
    }

    public Map<String, Integer> queryObjCountGroupByStatus(Long activityId) {
        DynamicObject[] dynamicObjects;
        HashMap<String, Integer> countGroupByStatus = new HashMap<String, Integer>(16);
        for (DynamicObject dynamicObject : dynamicObjects = INTER_VIEW_OBJECT_ENTITY_SERVICE.queryInterviewObjCountByActId(activityId)) {
            String interstatus = dynamicObject.getString("interstatus");
            Integer count = (Integer)countGroupByStatus.get(interstatus);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            countGroupByStatus.put(interstatus, count);
        }
        return countGroupByStatus;
    }

    public DynamicObject[] queryListByInteractIdExceptExit(List<Long> interactIds) {
        String selectFields = "id,interstatus,interact,interact.activitystatus";
        QFilter filter = new QFilter("interact", "in", interactIds);
        return INTERVIEW_OBJ_ENTITY_SERVICE.queryOriginalArray(selectFields, new QFilter[]{filter});
    }

    public Map<Long, Map<String, Integer>> queryCountByInteractId(List<Long> interactIds) {
        HashMap<Long, Map<String, Integer>> resultMap = new HashMap<Long, Map<String, Integer>>(16);
        DynamicObject[] objects = this.queryListByInteractIdExceptExit(interactIds);
        for (Long interactId : interactIds) {
            List collect = Arrays.stream(objects).filter(obj -> HRObjectUtils.equals((Object)obj.getLong("interact"), (Object)interactId)).collect(Collectors.toList());
            HashMap<String, Integer> map = new HashMap<String, Integer>(16);
            int completedCount = 0;
            int haveInHandCount = 0;
            int notStarted = 0;
            map.put("completed", completedCount);
            map.put("have_in_hand", haveInHandCount);
            map.put("not_started", notStarted);
            map.put("all", 0);
            for (DynamicObject object : collect) {
                if (InterStatusEnum.JOINED.getStatus().equals(object.getString("interstatus"))) {
                    ++notStarted;
                    continue;
                }
                if (InterStatusEnum.HAVE_IN_HAND.getStatus().equals(object.getString("interstatus")) || InterStatusEnum.STARTING.getStatus().equals(object.getString("interstatus"))) {
                    ++haveInHandCount;
                    continue;
                }
                if (!InterStatusEnum.COMPLETED.getStatus().equals(object.getString("interstatus")) && !InterStatusEnum.ENDED.getStatus().equals(object.getString("interstatus"))) continue;
                ++completedCount;
            }
            map.put("completed", completedCount);
            map.put("have_in_hand", haveInHandCount);
            map.put("not_started", notStarted);
            map.put("all", notStarted + haveInHandCount + completedCount);
            resultMap.put(interactId, map);
        }
        return resultMap;
    }

    public void finishIntview(List<Long> intObjIds) {
        DynamicObject[] intObjs;
        LOG.info("finishIntview : {}", intObjIds);
        for (DynamicObject intObj : intObjs = INTERVIEW_OBJ_ENTITY_SERVICE.loadDynamicObjectArray(intObjIds.toArray())) {
            Date date = new Date();
            long userId = UserServiceHelper.getCurrentUserId();
            LOG.info("before updateIntObj : {}", (Object)intObj.getLong("id"));
            intObj.set("modifier", (Object)userId);
            intObj.set("modifytime", (Object)date);
            LOG.info("after updateIntObj : {}", (Object)intObj.getLong("id"));
            intObj.set("interstatus", (Object)InterStatusEnum.COMPLETED.getStatus());
            intObj.set("endtime", (Object)date);
        }
        LOG.info("saveEvaluationObject : {}", intObjIds);
        INTERVIEW_OBJ_ENTITY_SERVICE.save(intObjs);
    }

    public Map<Long, DynamicObject> queryEvalObjById(List<Long> objIds) {
        QFilter idFilter = new QFilter("id", "in", objIds);
        DynamicObject[] objDys = INTERVIEW_OBJ_ENTITY_SERVICE.query("person, interflow, interflowins, interstatus,interact, perffile", new QFilter[]{idFilter});
        return Arrays.stream(objDys).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity()));
    }

    public EndInterResultBo endEvaObjInterview(List<Long> intObjIds, Long activityId) {
        EndInterResultBo endInterResultBo = new EndInterResultBo();
        long startTime1 = System.currentTimeMillis();
        DynamicObject[] interObjs = INTERVIEW_OBJ_ENTITY_SERVICE.queryInterObjByIdsAndIntAct(activityId, intObjIds);
        long startTime1_1 = System.currentTimeMillis();
        LOG.info(MessageFormat.format("#1#endEvaObjInterview#queryInterObjByIdsAndIntAct cost:{0} ms", startTime1_1 - startTime1));
        ArrayList<DynamicObject> canEndProcessObjs = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>(10);
        if (interObjs == null || interObjs.length < 1) {
            return endInterResultBo;
        }
        StringBuilder failMessageStb = new StringBuilder();
        String failReasonMessage = "";
        int successCount = 0;
        int taskCount = intObjIds.size();
        Date endTime = new Date();
        ArrayList<Long> procIdList = new ArrayList<Long>(10);
        long startTime2 = System.currentTimeMillis();
        for (DynamicObject dy : interObjs) {
            DynamicObject interflowins = dy.getDynamicObject("interflowins");
            String personNumber = dy.getString("perffile.billno");
            String personName = dy.getString("perffile.name");
            if (interflowins == null || interflowins.getPkValue() == null) {
                failMessageStb.append(ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u9762\u8c08\u4e2d\u201d\uff0c\u4e0d\u80fd\u7ed3\u675f\u9762\u8c08\u3002", (String)"InterviewObjDomainService_0", (String)"opmc-epa-business", (Object[])new Object[]{personName, personNumber})).append("\n");
                continue;
            }
            String procstatus = interflowins.getString("procstatus");
            Long procId = (Long)interflowins.getPkValue();
            if (FlowRuProcStatusEnum.NOTACTIVE.getCode().equals(procstatus) || FlowRuProcStatusEnum.FINISHED.getCode().equals(procstatus)) {
                failMessageStb.append(ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u9762\u8c08\u4e2d\u201d\uff0c\u4e0d\u80fd\u7ed3\u675f\u9762\u8c08\u3002", (String)"InterviewObjDomainService_0", (String)"opmc-epa-business", (Object[])new Object[]{personName, personNumber})).append("\n");
                continue;
            }
            dy.set("interstatus", (Object)InterStatusEnum.ENDED.getStatus());
            dy.set("endtime", (Object)endTime);
            dy.set("modifytime", (Object)endTime);
            canEndProcessObjs.add(dy);
            procIdList.add(procId);
        }
        long startTime2_1 = System.currentTimeMillis();
        LOG.info(MessageFormat.format("#2#endEvaObjInterview#assembleObj cost:{0} ms", startTime2_1 - startTime2));
        HashMap<Long, String> endProcessFailMsgMap = new HashMap<Long, String>(16);
        if (procIdList.size() > 0) {
            long startTime3 = System.currentTimeMillis();
            List flowCommonResultBoList = FLOW_RUPROC_DOMAIN_SERVICE.stopProcess(procIdList, "");
            long startTime3_1 = System.currentTimeMillis();
            LOG.info(MessageFormat.format("#3#endEvaObjInterview#stopProcess cost:{0} ms", startTime3_1 - startTime3));
            for (FlowCommonResultBo flowCommonResultBo : flowCommonResultBoList) {
                if (!"-1".equals(flowCommonResultBo.getCode())) continue;
                endProcessFailMsgMap.put(flowCommonResultBo.getDataId(), flowCommonResultBo.getMessage());
            }
        }
        for (DynamicObject dy : canEndProcessObjs) {
            DynamicObject interflowins = dy.getDynamicObject("interflowins");
            Long procId = (Long)interflowins.getPkValue();
            if (HRStringUtils.isNotEmpty((String)((String)endProcessFailMsgMap.get(procId)))) {
                failMessageStb.append((String)endProcessFailMsgMap.get(procId)).append("\n");
                continue;
            }
            successList.add(dy);
            ++successCount;
        }
        if (successCount > 0) {
            long startTime4 = System.currentTimeMillis();
            this.saveInterview(successList.toArray(new DynamicObject[0]));
            long startTime4_1 = System.currentTimeMillis();
            LOG.info(MessageFormat.format("#4#endEvaObjInterview#saveInterview cost:{0} ms", startTime4_1 - startTime4));
        }
        if (failMessageStb.length() > 0) {
            failReasonMessage = failMessageStb.substring(0, failMessageStb.length() - 1);
        }
        endInterResultBo.setMessage(failReasonMessage);
        endInterResultBo.setObjCount(taskCount);
        endInterResultBo.setTaskCount(taskCount);
        endInterResultBo.setSuccessCount(successCount);
        endInterResultBo.setFailCount(taskCount - successCount);
        return endInterResultBo;
    }

    public FlowValidateResultBo rollbackTask(List<RollbackParamBo> rollbackParamBos) {
        return FLOW_RU_SECOND_DOMAIN_SERVICE.rollbackToSpecifiedTask(rollbackParamBos);
    }

    public boolean isExistsTobeInterObjByActId(Long activityId) {
        return INTERVIEW_OBJ_ENTITY_SERVICE.isExistsTobeInterObjByActId(activityId);
    }

    public void deleteInterObj(DynamicObject[] interObj) {
        Object[] ids = Arrays.stream(interObj).map(DataEntityBase::getPkValue).toArray();
        List interFlow = Arrays.stream(interObj).map(x -> x.getLong("interflowins.id")).collect(Collectors.toList());
        INTERVIEW_OBJ_ENTITY_SERVICE.delete(ids);
        FLOW_RU_SECOND_DOMAIN_SERVICE.deleteRunProc(interFlow);
    }

    public List<Long> queryFormulatorByListDefaultFilter(Long activityId, Object seq, Long flowId) {
        QFilter filter = new QFilter("interact", "=", (Object)activityId).and("interflow", "=", (Object)flowId).and("interstatus", "=", (Object)InterStatusEnum.JOINED.getStatus());
        DynamicObject[] objDys = INTERVIEW_OBJ_ENTITY_SERVICE.queryOriginalArray("id,interflowins.id", new QFilter[]{filter});
        List objIds = Arrays.stream(objDys).map(evalObjDy -> evalObjDy.getLong("interflowins.id")).collect(Collectors.toList());
        return ROLE_ENTITY_SERVICE.queryByRuNodeIndexAndRuProc(seq, objIds);
    }

    public Map<Long, String> getFlowInfoByObjIds(List<Long> objIds) {
        if (objIds == null || objIds.size() == 0) {
            return new HashMap<Long, String>();
        }
        DynamicObject[] objs = INTERVIEW_OBJ_ENTITY_SERVICE.query("interflowins.id", new QFilter[]{new QFilter("id", "in", objIds)});
        Map<Long, Long> objFlowMap = Arrays.stream(objs).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getLong("interflowins.id")));
        List<Long> ruProcIds = Arrays.stream(objs).map(dy -> dy.getLong("interflowins.id")).collect(Collectors.toList());
        Map<Long, String> flowIdInfoMap = ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.getFlowInfo(ruProcIds);
        HashMap<Long, String> objFlowInfoMap = new HashMap<Long, String>(16);
        objFlowMap.forEach((obj, flow) -> objFlowInfoMap.put((Long)obj, (String)flowIdInfoMap.get(flow)));
        return objFlowInfoMap;
    }

    public List<AssignHandlerVO> modifyHandlerAfterStartProcess(List<ExtendedDataEntity> dataEntities, Map<String, List<Long>> handlerInfo) {
        ArrayList<AssignHandlerParamDTO> handlerParamDTOs = new ArrayList<AssignHandlerParamDTO>(10);
        Map<Long, Long> taskObjMap = dataEntities.stream().collect(Collectors.toMap(task -> task.getDataEntity().getLong("id"), task -> task.getDataEntity().getLong("flowruproc.actevalobj")));
        Map<Long, Long> taskRoleMap = dataEntities.stream().collect(Collectors.toMap(task -> task.getDataEntity().getLong("id"), task -> task.getDataEntity().getLong("flowrurole.id")));
        for (ExtendedDataEntity task2 : dataEntities) {
            long taskId = task2.getDataEntity().getLong("id");
            AssignHandlerParamDTO dto = new AssignHandlerParamDTO();
            dto.setRoleId(taskRoleMap.get(taskId));
            dto.setTaskId(Long.valueOf(taskId));
            dto.setHandlerIds(handlerInfo.get("handlers"));
            dto.setActevaObj(taskObjMap.get(taskId));
            dto.setHandType((short)1);
            dto.setWorkFlowType("3");
            handlerParamDTOs.add(dto);
        }
        return FLOW_HANDLER_BATCH_DOMAIN_SERVICE.modifyHandlerAfterStartProcess(handlerParamDTOs);
    }

    public DynamicObject queryActivity(Long activityId) {
        return INTERVIEW_ACTIVITY_CONF_DOMAIN_SERVICE.queryActivity(activityId);
    }

    public DynamicObject[] queryByActAndNotEqualInterflowins(String selectFields, Long activityId, String[] interstatus) {
        return INTERVIEW_OBJ_ENTITY_SERVICE.queryByActAndNotEqualInterstatus(selectFields, activityId, interstatus);
    }

    public DynamicObject[] queryFLowRuRoleById(Long[] roleIdList) {
        return ROLE_ENTITY_SERVICE.queryByPkValue(Arrays.asList(roleIdList));
    }

    public DynamicObject[] queryActInsBy(List<Long> actIns) {
        return new DynamicObject[0];
    }
}

