/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.perfresult.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activity.service.AssessActivityDomainService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjSumAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.RuleGradeEntityService;
import kd.opmc.epa.business.domain.evaladjustment.entity.EvalAdjustmentEntityService;
import kd.opmc.epa.business.domain.hbss.entityservice.CycleTypeEntityService;
import kd.opmc.epa.business.domain.hbss.enums.CycleTypeEnum;
import kd.opmc.epa.business.domain.perfresult.entity.OverAllResultEntityBo;
import kd.opmc.epa.business.domain.perfresult.entity.PerfResultBo;
import kd.opmc.epa.business.domain.perfresult.entityservice.PerfResultEntityService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.DataSourceEnum;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.common.utils.ListUtils;

public class PerfResultDomainService {
    private static final Log log = LogFactory.getLog(PerfResultDomainService.class);
    private static final PerfResultEntityService PERF_RESULT_ENTITY_SERVICE = PerfResultEntityService.getInstance();
    private static final RuleGradeEntityService RULE_GRADE_ENTITY_SERVICE = RuleGradeEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY_SERVICE = PerfLevelEntityService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY = AssessActivityEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final ObjSumAreaInsEntityService OBJ_SUM_AREA_INS_ENTITY_SERVICE = ObjSumAreaInsEntityService.getInstance();
    private static final EvalAdjustmentEntityService EVAL_ADJUSTMENT_ENTITY_SERVICE = EvalAdjustmentEntityService.getInstance();
    private static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    private static final AssessActivityDomainService ASSESS_ACTIVITY_DOMAIN_SERVICE = AssessActivityDomainService.getInstance();
    private static final CycleTypeEntityService CYCLE_TYPE_ENTITY_SERVICE = CycleTypeEntityService.getInstance();
    private static final String SUMPERFLEVEL_ID = "sumperflevel.id";
    private static final String SCORESYSTEM_ID = "scoresystem.id";

    public static PerfResultDomainService getInstance() {
        return ServiceFactory.getService(PerfResultDomainService.class);
    }

    public HisResponse<VersionChangeRespData> savePerfResult(DynamicObject[] evalObjs, Long activityId) {
        if (ObjectUtils.isEmpty((Object[])evalObjs)) {
            log.error("evalObjs is empty");
            return null;
        }
        DynamicObject activity = this.queryActivity(activityId);
        if (ObjectUtils.isEmpty((Object)activity)) {
            log.error("activity is null");
            return null;
        }
        List<DynamicObject> evalObjList = Arrays.stream(evalObjs).filter(evalObj -> !HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.Exited.getStatus())).collect(Collectors.toList());
        String numaccuracy = null;
        String scaletype = null;
        Long scoresystemId = 0L;
        Long sumperflevelId = 0L;
        if (activity.getDynamicObject("assessform") != null) {
            DynamicObject assessForm = activity.getDynamicObject("assessform");
            assessForm = ASSESS_FORM_ENTITY_SERVICE.loadSingle(assessForm.getPkValue());
            numaccuracy = assessForm.getString("numaccuracy");
            scaletype = assessForm.getString("scaletype");
            scoresystemId = assessForm.getLong(SCORESYSTEM_ID);
            sumperflevelId = assessForm.getLong(SUMPERFLEVEL_ID);
        }
        int numAccuracy = 6;
        if (StringUtils.isNotBlank(numaccuracy)) {
            numAccuracy = Integer.parseInt(numaccuracy);
        }
        int roundingMode = StringUtils.equals(scaletype, (CharSequence)"10") ? 0 : (StringUtils.equals(scaletype, (CharSequence)"20") ? 1 : 4);
        ArrayList<PerfResultBo> perfResultBos = new ArrayList<PerfResultBo>(16);
        for (DynamicObject evalObj2 : evalObjList) {
            OverAllResultEntityBo overAllResultBo;
            Object[] objects = OBJ_SUM_AREA_INS_ENTITY_SERVICE.query("eval,flowrutask, flowrurole, modifytime", new QFilter[]{new QFilter("actevalobj", "=", (Object)evalObj2.getLong("id")), new QFilter("activity", "=", (Object)activity.getLong("id"))});
            Object[] adjustRecords = EVAL_ADJUSTMENT_ENTITY_SERVICE.query("ins, flowrutask, flowrurole, modifytime", new QFilter[]{new QFilter("actevalobj", "=", (Object)evalObj2.getLong("id")), new QFilter("activity", "=", (Object)activity.getLong("id"))});
            ArrayList<OverAllResultEntityBo> overAllResultBos = new ArrayList<OverAllResultEntityBo>(10);
            if (!ObjectUtils.isEmpty((Object[])objects)) {
                for (Object object : objects) {
                    overAllResultBo = OverAllResultEntityBo.builder().roleTypeId(object.getLong("flowrurole")).userid(object.getLong("flowrutask.handler.id")).overall(object.getString("eval")).overallTime(object.getDate("modifytime")).build();
                    overAllResultBos.add(overAllResultBo);
                }
            }
            if (!ObjectUtils.isEmpty((Object[])adjustRecords)) {
                for (Object object : adjustRecords) {
                    overAllResultBo = OverAllResultEntityBo.builder().roleTypeId(object.getLong("flowrurole")).userid(object.getLong("flowrutask.handler.id")).overall(object.getString("ins")).overallTime(object.getDate("modifytime")).build();
                    overAllResultBos.add(overAllResultBo);
                }
            }
            PerfResultBo perfResultBo = PerfResultBo.builder().name(evalObj2.getString("perffile.person.name")).personId(evalObj2.getLong("perffile.person.id")).empPosRelId(evalObj2.getLong("perffile.empposrel.id")).employeeId(evalObj2.getLong("employee.id")).affiliateAdminOrgId(evalObj2.getLong("affiliateadminorg.id")).depempId(evalObj2.getLong("perffile.depemp.id")).perfFileId(evalObj2.getLong("perffile.id")).activityId(evalObj2.getLong("activity.id")).schemeId(activity.getLong("scheme.id")).assessLevel(evalObj2.getString("flop")).perfLevelF7(evalObj2.getLong("floplevel.id")).overAllResultEntityBos(overAllResultBos).score(evalObj2.getBigDecimal("fsop").setScale(numAccuracy, roundingMode)).ruleScoreF7(evalObj2.getLong("fsopscoresystem.id")).ruleScoreId(scoresystemId).perfLevelId(sumperflevelId).pmdOrgId(evalObj2.getLong("perffile.pmdorg.id")).build();
            perfResultBos.add(perfResultBo);
        }
        return this.savePerfResult(perfResultBos, activity, evalObjList);
    }

    public HisResponse<VersionChangeRespData> savePerfResult(List<PerfResultBo> perfResultBos, DynamicObject activity, List<DynamicObject> evalObjList) {
        if (ObjectUtils.isEmpty(perfResultBos)) {
            log.error("perfResultBos is null");
            return null;
        }
        boolean isYearSum = activity.getBoolean("isneedmpgenway");
        boolean isGenExtMpSop = activity.getBoolean("isgenextmpsop");
        String mpSopCategory = activity.getString("mpsopcategory");
        String mpGenWay = activity.getString("mpgenway");
        DynamicObject workFlowDy = ASSESS_ACTIVITY_DOMAIN_SERVICE.queryPerfWorkFlow(activity.getLong("id"));
        DynamicObjectCollection nodeEntry = workFlowDy.getDynamicObjectCollection("entryentity");
        boolean isExistSum = nodeEntry.stream().anyMatch(nodeInfo -> nodeInfo.getLong("node.id") == AssessNodeStatusEnum.MPED.getNodeId().longValue() && nodeInfo.getBoolean("isshow"));
        boolean isExistAssess = nodeEntry.stream().anyMatch(nodeInfo -> nodeInfo.getLong("node.id") == AssessNodeStatusEnum.EVALUATED.getNodeId().longValue() && nodeInfo.getBoolean("isshow"));
        Set curPeriodPerfFiles = evalObjList.stream().filter(obj -> obj.getBoolean("iscurperiod")).map(obj -> obj.getLong("perffile.id")).collect(Collectors.toSet());
        Map evalObjMap = evalObjList.stream().collect(Collectors.toMap(obj -> obj.getLong("perffile.id"), Function.identity(), (v1, v2) -> v1));
        ArrayList<DynamicObject> perfResultListOfAssess = new ArrayList<DynamicObject>(16);
        boolean isSop = isYearSum && isGenExtMpSop && isExistSum && isExistAssess && HRStringUtils.equals((String)mpSopCategory, (String)CycleTypeEnum.YEAR.getRef()) && HRStringUtils.equals((String)mpGenWay, (String)"1");
        for (PerfResultBo perfResultBo : perfResultBos) {
            DynamicObject perfResultObject;
            if (curPeriodPerfFiles.contains(perfResultBo.getPerfFileId())) {
                perfResultObject = PERF_RESULT_ENTITY_SERVICE.generateEmptyDynamicObject();
                this.copyProperties(perfResultBo, perfResultObject, activity);
                perfResultObject.set("rulescoref7", (Object)perfResultBo.getRulescoref7());
                perfResultObject.set("score", (Object)((DynamicObject)evalObjMap.get(perfResultBo.getPerfFileId())).getBigDecimal("fsop"));
                perfResultObject.set("perflevelf7", (Object)perfResultBo.getPerflevelf7());
                perfResultObject.set("assesslevel", (Object)((DynamicObject)evalObjMap.get(perfResultBo.getPerfFileId())).getString("flop"));
                if (isSop) {
                    perfResultObject.set("rulescoref7", (Object)perfResultBo.getRuleScoreId());
                    perfResultObject.set("score", (Object)((DynamicObject)evalObjMap.get(perfResultBo.getPerfFileId())).getBigDecimal("sop"));
                    perfResultObject.set("perflevelf7", (Object)perfResultBo.getPerfLevelId());
                    perfResultObject.set("assesslevel", (Object)((DynamicObject)evalObjMap.get(perfResultBo.getPerfFileId())).getString("lop"));
                }
                this.setLevelResultEntity(perfResultObject, perfResultBo);
                this.setOverAllResultEntity(perfResultObject, perfResultBo.getOverAllResultEntityBos());
                perfResultObject.set("resultsource", (Object)"10");
                perfResultListOfAssess.add(perfResultObject);
                continue;
            }
            if (!isExistSum || isYearSum && isGenExtMpSop && HRStringUtils.equals((String)mpSopCategory, (String)CycleTypeEnum.YEAR.getRef())) continue;
            perfResultObject = PERF_RESULT_ENTITY_SERVICE.generateEmptyDynamicObject();
            this.copyProperties(perfResultBo, perfResultObject, activity);
            perfResultObject.set("rulescoref7", (Object)perfResultBo.getRulescoref7());
            perfResultObject.set("score", (Object)((DynamicObject)evalObjMap.get(perfResultBo.getPerfFileId())).getBigDecimal("fsop"));
            perfResultObject.set("perflevelf7", (Object)perfResultBo.getPerflevelf7());
            perfResultObject.set("assesslevel", (Object)((DynamicObject)evalObjMap.get(perfResultBo.getPerfFileId())).getString("flop"));
            this.setLevelResultEntity(perfResultObject, perfResultBo);
            this.setOverAllResultEntity(perfResultObject, perfResultBo.getOverAllResultEntityBos());
            perfResultObject.set("resultsource", (Object)"10");
            perfResultListOfAssess.add(perfResultObject);
        }
        if (isYearSum && isGenExtMpSop && HRStringUtils.equals((String)mpSopCategory, (String)CycleTypeEnum.YEAR.getRef())) {
            Date yearDate = activity.getDate("year");
            int year = HRDateTimeUtils.getYear((Date)yearDate);
            String assessPeriod = year + CycleTypeEnum.YEAR.getRef();
            for (PerfResultBo perfResultBo : perfResultBos) {
                perfResultBo.setScore(((DynamicObject)evalObjMap.get(perfResultBo.getPerfFileId())).getBigDecimal("fsop"));
                perfResultBo.setAssessLevel(((DynamicObject)evalObjMap.get(perfResultBo.getPerfFileId())).getString("flop"));
                DynamicObject perfResultObject = PERF_RESULT_ENTITY_SERVICE.generateEmptyDynamicObject();
                this.copyProperties(perfResultBo, perfResultObject, activity);
                perfResultObject.set("rulescoref7", (Object)perfResultBo.getRulescoref7());
                perfResultObject.set("score", (Object)((DynamicObject)evalObjMap.get(perfResultBo.getPerfFileId())).getBigDecimal("fsop"));
                perfResultObject.set("perflevelf7", (Object)perfResultBo.getPerflevelf7());
                perfResultObject.set("assesslevel", (Object)((DynamicObject)evalObjMap.get(perfResultBo.getPerfFileId())).getString("flop"));
                this.setLevelResultEntity(perfResultObject, perfResultBo);
                perfResultObject.set("cycletype", (Object)1363179570613844992L);
                perfResultObject.set("assessperiod", (Object)assessPeriod);
                perfResultObject.set("period", (Object)CycleTypeEnum.YEAR.getRef());
                perfResultObject.set("resultsource", (Object)"20");
                perfResultListOfAssess.add(perfResultObject);
            }
        }
        if (!HRObjectUtils.isEmpty(perfResultListOfAssess) && perfResultListOfAssess.size() != 0) {
            CodeRuleServiceHelper.injectNumbers((String)"epa_performanceresult", perfResultListOfAssess);
            DynamicObject[] dycs = perfResultListOfAssess.toArray(new DynamicObject[0]);
            HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
            hisVersionParamBo.setEffImmediately(true);
            hisVersionParamBo.setAtomicTrans(true);
            hisVersionParamBo.setEntityNumber("epa_performanceresult");
            hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
            hisVersionParamBo.setHisDyns(dycs);
            HisResponse response = HisModelController.getInstance().noLineTimeHisVersionChange(hisVersionParamBo);
            if (StringUtils.equals((CharSequence)EnumResponseCode.SUCCESS.getCode(), (CharSequence)response.getCode()) && response.getData() != null) {
                DynamicObject[] perfResults = ((VersionChangeRespData)response.getData()).getNewDynamicObjects();
                List<Long> perfResultIds = Arrays.stream(perfResults).map(perfResult -> (Long)perfResult.getPkValue()).collect(Collectors.toList());
                this.synToHrpiAttachTable(perfResultIds);
            }
            return response;
        }
        return null;
    }

    public void synToHrpiAttachTable() {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] dys = PERF_RESULT_ENTITY_SERVICE.query("id", new QFilter[]{filter});
        List<Long> perfResultIds = Arrays.stream(dys).map(perfResult -> (Long)perfResult.getPkValue()).collect(Collectors.toList());
        this.synToHrpiAttachTable(perfResultIds);
    }

    public void synToHrpiAttachTable(List<Long> perfResultIds) {
        ListUtils.excute(perfResultIds, (int)500, this::batchSynHrpiAttachTable);
    }

    private void batchSynHrpiAttachTable(List<Long> perfResultIds) {
        QFilter filter = new QFilter("boid", "in", perfResultIds);
        DynamicObject[] perfResultDys = PERF_RESULT_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{filter});
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(perfResultDys.length);
        for (DynamicObject perfResultDy : perfResultDys) {
            Map<String, Object> param = this.formatParam(perfResultDy);
            paramList.add(param);
        }
        HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPerfResultService", (String)"sysPerfResult", (Object[])new Object[]{paramList});
    }

    private Map<String, Object> formatParam(DynamicObject perfResultDy) {
        HashMap<String, Object> param = new HashMap<String, Object>(64);
        param.put("id", perfResultDy.get("id"));
        param.put("number", perfResultDy.get("number"));
        param.put("name", perfResultDy.get("name"));
        param.put("empposrel", perfResultDy.get("empposrel.id"));
        param.put("person", perfResultDy.get("person.id"));
        param.put("employee", perfResultDy.get("employee.id"));
        param.put("depemp", perfResultDy.get("depemp.id"));
        param.put("affiliateadminorg", perfResultDy.get("affiliateadminorg.id"));
        param.put("perffile", perfResultDy.get("perffilef7.id"));
        param.put("confirmstatus", perfResultDy.get("confirmstatus"));
        param.put("appealstatus", perfResultDy.get("appealstatus"));
        param.put("pmdorg", perfResultDy.get("pmdorg.id"));
        param.put("pmdperson", perfResultDy.get("perffilef7.pmdperson.id"));
        param.put("scheme", perfResultDy.get("schemef7.id"));
        param.put("schemename", perfResultDy.get("schemef7.name"));
        param.put("activity", perfResultDy.get("activity.id"));
        param.put("activityname", perfResultDy.get("activityname"));
        param.put("periodstartdate", perfResultDy.get("activity.periodstartdate"));
        param.put("periodenddate", perfResultDy.get("activity.periodenddate"));
        param.put("assessperiod", perfResultDy.get("assessperiod"));
        param.put("cycletype", perfResultDy.get("cycletype.id"));
        param.put("rulescore", perfResultDy.get("rulescoref7.id"));
        param.put("score", perfResultDy.get("score"));
        param.put("perflevel", perfResultDy.get("perflevelf7.id"));
        param.put("assesslevel", perfResultDy.get("assesslevel"));
        param.put("assessleveltext", perfResultDy.get("assessleveltext"));
        param.put("datasource", perfResultDy.get("datasource"));
        param.put("year", perfResultDy.get("year"));
        param.put("period", perfResultDy.get("period"));
        param.put("adminorgname", perfResultDy.get("adminorgname"));
        param.put("companyname", perfResultDy.get("companyname"));
        param.put("positionname", perfResultDy.get("positionname"));
        param.put("jobname", perfResultDy.get("jobname"));
        param.put("creator", perfResultDy.get("creator.id"));
        param.put("createtime", perfResultDy.get("createtime"));
        param.put("modifier", perfResultDy.get("modifier.id"));
        param.put("modifytime", perfResultDy.get("modifytime"));
        param.put("initdatasource", perfResultDy.get("initdatasource"));
        param.put("initstatus", perfResultDy.get("initstatus"));
        param.put("datastatus", perfResultDy.get("datastatus"));
        param.put("initbatch", perfResultDy.get("initbatch"));
        param.put("boid", perfResultDy.get("boid"));
        param.put("iscurrentversion", perfResultDy.get("iscurrentversion"));
        param.put("hisversion", perfResultDy.get("hisversion"));
        List<Map<String, Object>> levelResultParam = this.getLevelResultParam(perfResultDy);
        param.put("levelresultentity", levelResultParam);
        List<Map<String, Object>> overAllResultParam = this.getOverAllResultParam(perfResultDy);
        param.put("overallresultentity", overAllResultParam);
        return param;
    }

    private List<Map<String, Object>> getOverAllResultParam(DynamicObject perfResultDy) {
        ArrayList<Map<String, Object>> overAllResultParam = new ArrayList<Map<String, Object>>(10);
        DynamicObjectCollection overAllResultEntity = perfResultDy.getDynamicObjectCollection("overallresultentity");
        for (DynamicObject overAllResultDy : overAllResultEntity) {
            HashMap<String, Object> overAllResult = new HashMap<String, Object>(16);
            overAllResult.put("roletype", overAllResultDy.get("roletype.id"));
            overAllResult.put("assessuser", overAllResultDy.get("assessuser.id"));
            overAllResult.put("overall", overAllResultDy.get("overall"));
            overAllResult.put("entryboidall", overAllResultDy.get("entryboidall"));
            overAllResult.put("overalldetail", overAllResultDy.get("overalldetail"));
            overAllResult.put("overalltime", overAllResultDy.get("overalltime"));
            overAllResult.put("oeveralldefshow", overAllResultDy.get("oeveralldefshow"));
            overAllResult.put("seq", overAllResultDy.get("seq"));
            overAllResult.put("id", overAllResultDy.getPkValue());
            overAllResultParam.add(overAllResult);
        }
        return overAllResultParam;
    }

    private List<Map<String, Object>> getLevelResultParam(DynamicObject perfResultDy) {
        ArrayList<Map<String, Object>> levelResults = new ArrayList<Map<String, Object>>(10);
        DynamicObjectCollection levelResultEntity = perfResultDy.getDynamicObjectCollection("levelresultentity");
        for (DynamicObject levelResultDy : levelResultEntity) {
            HashMap<String, Object> levelParam = new HashMap<String, Object>(16);
            levelParam.put("rulelevelnumber", levelResultDy.get("rulelevelnumber"));
            levelParam.put("rulelevelname", levelResultDy.get("rulelevelname"));
            levelParam.put("rulelevel", levelResultDy.get("rulelevel"));
            levelParam.put("entryboidrule", levelResultDy.get("entryboidrule"));
            levelParam.put("leveldetail", levelResultDy.get("leveldetail"));
            levelParam.put("rulegrade", levelResultDy.get("rulegrade.id"));
            levelParam.put("levelrankshow", levelResultDy.get("levelrankshow"));
            levelParam.put("seq", levelResultDy.get("seq"));
            levelParam.put("id", levelResultDy.getPkValue());
            levelResults.add(levelParam);
        }
        return levelResults;
    }

    public DynamicObject queryActivity(long pkId) {
        return ACTIVITY_ENTITY.loadSingle(pkId);
    }

    private void copyProperties(PerfResultBo perfResultBo, DynamicObject perfResultObject, DynamicObject activity) {
        perfResultObject.set("name", (Object)perfResultBo.getName());
        perfResultObject.set("person", (Object)perfResultBo.getPersonId());
        perfResultObject.set("empposrel", (Object)perfResultBo.getEmpPosRelId());
        perfResultObject.set("employee", (Object)perfResultBo.getEmployeeId());
        perfResultObject.set("affiliateadminorg", (Object)perfResultBo.getAffiliateAdminOrgId());
        perfResultObject.set("depemp", (Object)perfResultBo.getDepempId());
        perfResultObject.set("perffilef7", (Object)perfResultBo.getPerfFileId());
        perfResultObject.set("activity", (Object)perfResultBo.getActivityId());
        perfResultObject.set("assessmodelf7", (Object)perfResultBo.getAssessModelId());
        perfResultObject.set("schemef7", (Object)perfResultBo.getSchemeId());
        perfResultObject.set("pmdorg", (Object)perfResultBo.getPmdOrgId());
        perfResultObject.set("datasource", (Object)DataSourceEnum.EXT_INTEGRATION.getCode());
        perfResultObject.set("status", (Object)"C");
        perfResultObject.set("enable", (Object)"1");
        Long perfId = perfResultBo.getPerfFileId();
        Object[] perfList = ASSESS_ACTIVITY_DOMAIN_SERVICE.getPerffileListByIds(Collections.singletonList(perfId));
        if (ObjectUtils.isEmpty((Object[])perfList)) {
            return;
        }
        long cycleTypeId = activity.getDynamicObject("scheme").getDynamicObject("cycletype").getLong("id");
        Object year = activity.get("year");
        String assessPeriod = activity.getString("period");
        String activityName = activity.getString("name");
        String personNumber = perfList[0].getDynamicObject("person").getString("number");
        perfResultObject.set("cycletype", (Object)cycleTypeId);
        perfResultObject.set("year", year);
        perfResultObject.set("assessperiod", (Object)assessPeriod);
        perfResultObject.set("period", (Object)assessPeriod.substring(4));
        perfResultObject.set("activityname", (Object)activityName);
        perfResultObject.set("personNumber", (Object)personNumber);
        DynamicObject empposrelObject = perfList[0].getDynamicObject("empposrel");
        perfResultObject.set("adminorgname", (Object)empposrelObject.getString("adminorg.name"));
        perfResultObject.set("companyname", (Object)empposrelObject.getString("company.name"));
        perfResultObject.set("positionName", (Object)empposrelObject.getString("position.name"));
        perfResultObject.set("jobname", (Object)empposrelObject.getString("job.name"));
    }

    private void setLevelResultEntity(DynamicObject perfResultObject, PerfResultBo perfResultBo) {
        Long perfLevelId = perfResultObject.getLong("perflevelf7");
        if (ObjectUtils.isEmpty((Object)perfLevelId) || perfLevelId == 0L) {
            log.error("\u586b\u5145\u6807\u5c3a\u7b49\u7ea7\u7ed3\u679c\u5206\u5f55\u5931\u8d25, \u8bc4\u4f30\u5bf9\u8c61[{}]\u7684\u7ee9\u6548\u7b49\u7ea7\u540d\u79f0\u4e3a\u7a7a\uff01", perfResultObject.get("name"));
            return;
        }
        String assessLevel = perfResultObject.getString("assesslevel");
        if (HRStringUtils.isEmpty((String)assessLevel)) {
            log.error("\u586b\u5145\u6807\u5c3a\u7b49\u7ea7\u7ed3\u679c\u5206\u5f55\u5931\u8d25, \u8bc4\u4f30\u5bf9\u8c61[{}]\u7684\u7efc\u5408\u7ee9\u6548\u7b49\u7ea7\u4e3a\u7a7a\uff01", perfResultObject.get("name"));
            return;
        }
        int index = Integer.parseInt(assessLevel) - 1;
        DynamicObject perfLevel = PERF_LEVEL_ENTITY_SERVICE.queryOne((Object)perfLevelId);
        DynamicObjectCollection levelConf = perfLevel.getDynamicObjectCollection("entryentity");
        perfResultObject.set("assessleveltext", (Object)new LocaleString(((DynamicObject)levelConf.get(index)).getString("levelname")));
        DynamicObjectCollection ruleMapEntryEntity = perfLevel.getDynamicObjectCollection("rulemapentryentity");
        if (ObjectUtils.isEmpty((Object)ruleMapEntryEntity)) {
            log.error("\u586b\u5145\u6807\u5c3a\u7b49\u7ea7\u7ed3\u679c\u5206\u5f55\u5931\u8d25, \u8bc4\u4f30\u5bf9\u8c61[{}]\u7684\u7b49\u7ea7\u4e0e\u6807\u5c3a\u6620\u5c04\u5173\u8054\u5206\u5f55\u4e3a\u7a7a\uff01", perfResultObject.get("name"));
            return;
        }
        DynamicObjectCollection levelResultEntity = perfResultObject.getDynamicObjectCollection("levelresultentity");
        List ruleMapSorted = ruleMapEntryEntity.stream().sorted(Comparator.comparing(ruleMapDy -> ruleMapDy.getDynamicObject("rulegrade").getString("id"))).collect(Collectors.toList());
        for (int i = 0; i < ruleMapSorted.size(); ++i) {
            DynamicObject ruleGrade = ((DynamicObject)ruleMapSorted.get(i)).getDynamicObject("rulegrade");
            String number = ruleGrade.getString("number");
            String ruleGradeName = ruleGrade.getString("name");
            DynamicObjectCollection rulesubentryentity = ((DynamicObject)ruleMapSorted.get(i)).getDynamicObjectCollection("rulesubentryentity");
            long ruleGradeId = ruleGrade.getLong("id");
            DynamicObject dynamicObject = RULE_GRADE_ENTITY_SERVICE.queryOne(ruleGradeId);
            DynamicObjectCollection gradeConfigEntry = dynamicObject.getDynamicObjectCollection("gradeconfigentry");
            int ruleGradeLevelIndex = ((DynamicObject)rulesubentryentity.get(index)).getInt("rulegradelevel") - 1;
            String rulegrade = ((DynamicObject)gradeConfigEntry.get(ruleGradeLevelIndex)).getString("rulegrade");
            DynamicObject levelResultDy = levelResultEntity.addNew();
            levelResultDy.set("levelrankshow", (Object)(i == 0 ? 1 : 0));
            levelResultDy.set("rulelevelnumber", (Object)number);
            levelResultDy.set("rulelevelname", (Object)ruleGradeName);
            levelResultDy.set("rulelevel", (Object)rulegrade);
            levelResultDy.set("leveldetail", (Object)ResManager.loadKDString((String)"\u6807\u5c3a\u7b49\u7ea7\u8be6\u60c5", (String)"PerfResultDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]));
            levelResultDy.set("rulegrade", (Object)ruleGradeId);
        }
    }

    private void setOverAllResultEntity(DynamicObject perfResultObject, List<OverAllResultEntityBo> overAllResultEntityBos) {
        if (ObjectUtils.isEmpty(overAllResultEntityBos)) {
            return;
        }
        DynamicObjectCollection overallResultEntity = perfResultObject.getDynamicObjectCollection("overallresultentity");
        List sortedCollect = overAllResultEntityBos.stream().sorted(Comparator.comparing(OverAllResultEntityBo::getOverallTime).reversed()).filter(bo -> !HRStringUtils.isEmpty((String)bo.getOverall())).collect(Collectors.toList());
        List roleTypeIdList = sortedCollect.stream().map(OverAllResultEntityBo2 -> OverAllResultEntityBo2.getRoleTypeId()).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = FLOW_RU_ROLE_ENTITY_SERVICE.queryByRuRoleIds(roleTypeIdList);
        Map<Long, Long> roleTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getLong("roletype.id")));
        for (int i = 0; i < sortedCollect.size(); ++i) {
            OverAllResultEntityBo bo2 = (OverAllResultEntityBo)sortedCollect.get(i);
            DynamicObject overAllResultDy = overallResultEntity.addNew();
            overAllResultDy.set("oeveralldefshow", (Object)(i == 0 ? 1 : 0));
            overAllResultDy.set("roletype", (Object)roleTypeMap.get(bo2.getRoleTypeId()));
            overAllResultDy.set("assessuser", (Object)bo2.getUserid());
            overAllResultDy.set("overall", (Object)bo2.getOverall());
            overAllResultDy.set("overalldetail", (Object)ResManager.loadKDString((String)"\u603b\u8bc4\u8be6\u60c5", (String)"PerfResultDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]));
            overAllResultDy.set("overalltime", (Object)bo2.getOverallTime());
        }
    }

    public Object[] update(DynamicObject[] dobjs) {
        return PERF_RESULT_ENTITY_SERVICE.update(dobjs);
    }

    public void synPmdOrg() {
        DynamicObject[] dys;
        QFilter filter = new QFilter("pmdorg", "=", (Object)0L).or("pmdorg", "is null", (Object)"");
        for (DynamicObject dy : dys = PERF_RESULT_ENTITY_SERVICE.query("pmdorg, perffilef7.org", new QFilter[]{filter})) {
            dy.set("pmdorg", (Object)dy.getLong("perffilef7.org.id"));
        }
        PERF_RESULT_ENTITY_SERVICE.save(dys);
    }

    public void savePerfResult(DynamicObject[] dys) {
        PERF_RESULT_ENTITY_SERVICE.save(dys);
    }

    public DynamicObject getCycleTypeId(String period) {
        String number = Arrays.stream(CycleTypeEnum.values()).filter(cycleTypeEnum -> period.contains(cycleTypeEnum.getRef())).map(CycleTypeEnum::getNumber).findFirst().orElse("1010S");
        return CYCLE_TYPE_ENTITY_SERVICE.getIdByNumber(number);
    }

    public void synHisPerfResultField() {
        QFilter filter = new QFilter("datasource", "!=", (Object)DataSourceEnum.HIS_PERRESULT.getCode());
        DynamicObject[] dys = PERF_RESULT_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{filter});
        List<Long> perfIds = Arrays.stream(dys).map(dy -> dy.getLong("perffilef7.id")).collect(Collectors.toList());
        DynamicObject[] perffileList = ASSESS_ACTIVITY_DOMAIN_SERVICE.getPerffileListByIds(perfIds);
        Map perffileMap = Arrays.stream(perffileList).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (k1, k2) -> k1));
        Object[] assessformIds = Arrays.stream(dys).map(dy -> {
            if (dy.getDynamicObject("activity") != null && dy.getDynamicObject("activity").getDynamicObject("assessform") != null) {
                return dy.getDynamicObject("activity").getDynamicObject("assessform").getPkValue();
            }
            return null;
        }).filter(Objects::nonNull).distinct().toArray();
        DynamicObject[] assessForms = ASSESS_FORM_ENTITY_SERVICE.loadDynamicObjectArray(assessformIds);
        Map<Object, Object> assessFormMap = Arrays.stream(assessForms).filter(dy -> dy.getDynamicObject("sumperflevel") != null).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy.getDynamicObject("sumperflevel").getPkValue(), (k1, k2) -> k1));
        DynamicObject[] perfLevels = PERF_LEVEL_ENTITY_SERVICE.loadDynamicObjectArray(assessFormMap.values().stream().distinct().toArray());
        Map perfLevelMap = Arrays.stream(perfLevels).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (k1, k2) -> k1));
        for (DynamicObject dy2 : dys) {
            DynamicObjectCollection ruleMapEntryEntity;
            DynamicObject perfLevel;
            Object assessformId;
            Object sumperflevelId;
            DynamicObject empposrelObject;
            if (dy2.getDynamicObject("schemef7") != null && dy2.getDynamicObject("schemef7").getDynamicObject("cycletype") != null) {
                long cycleTypeId = dy2.getDynamicObject("schemef7").getDynamicObject("cycletype").getLong("id");
                dy2.set("cycletype", (Object)cycleTypeId);
            }
            if (dy2.getDynamicObject("activity") != null) {
                Object year = dy2.getDynamicObject("activity").get("year");
                String assessPeriod = dy2.getDynamicObject("activity").getString("period");
                String activityName = dy2.getDynamicObject("activity").getString("name");
                if (StringUtils.isNotBlank((CharSequence)assessPeriod)) {
                    dy2.set("assessperiod", (Object)assessPeriod);
                    dy2.set("period", (Object)assessPeriod.substring(4));
                }
                dy2.set("year", year);
                dy2.set("activityname", (Object)activityName);
            }
            String personNumber = dy2.getString("person.number");
            dy2.set("personNumber", (Object)personNumber);
            Long perfId = dy2.getLong("perffilef7.id");
            DynamicObject perffile = (DynamicObject)perffileMap.get(perfId);
            if (perffile != null && (empposrelObject = perffile.getDynamicObject("empposrel")) != null) {
                if (empposrelObject.getDynamicObject("adminorg") != null) {
                    dy2.set("adminorgname", (Object)empposrelObject.getString("adminorg.name"));
                }
                if (empposrelObject.getDynamicObject("company") != null) {
                    dy2.set("companyname", (Object)empposrelObject.getString("company.name"));
                }
                if (empposrelObject.getDynamicObject("position") != null) {
                    dy2.set("positionName", (Object)empposrelObject.getString("position.name"));
                }
                if (empposrelObject.getDynamicObject("job") != null) {
                    dy2.set("jobname", (Object)empposrelObject.getString("job.name"));
                }
            }
            if (dy2.getDynamicObject("activity") == null || dy2.getDynamicObject("activity").getDynamicObject("assessform") == null || (sumperflevelId = assessFormMap.get(assessformId = dy2.getDynamicObject("activity").getDynamicObject("assessform").getPkValue())) == null || (perfLevel = (DynamicObject)perfLevelMap.get(sumperflevelId)) == null || ObjectUtils.isEmpty((Object)(ruleMapEntryEntity = perfLevel.getDynamicObjectCollection("rulemapentryentity")))) continue;
            DynamicObjectCollection levelResultEntity = dy2.getDynamicObjectCollection("levelresultentity");
            List ruleMapSorted = ruleMapEntryEntity.stream().sorted(Comparator.comparing(ruleMapDy -> ruleMapDy.getDynamicObject("rulegrade").getString("id"))).collect(Collectors.toList());
            for (int i = 0; i < ruleMapSorted.size(); ++i) {
                if (ruleMapSorted.get(i) == null || ((DynamicObject)ruleMapSorted.get(i)).getDynamicObject("rulegrade") == null) continue;
                long ruleGradeId = ((DynamicObject)ruleMapSorted.get(i)).getDynamicObject("rulegrade").getLong("id");
                if (i >= levelResultEntity.size()) continue;
                ((DynamicObject)levelResultEntity.get(i)).set("rulegrade", (Object)ruleGradeId);
            }
        }
        PERF_RESULT_ENTITY_SERVICE.save(dys);
    }

    public void synPerfResultField() {
        DynamicObject[] dys;
        QFilter filter = new QFilter("datasource", "=", (Object)DataSourceEnum.HIS_PERRESULT.getCode());
        for (DynamicObject dy : dys = PERF_RESULT_ENTITY_SERVICE.query("perffilef7.depemp, perffilef7.employee, period, cycletype, depemp, employee", new QFilter[]{filter})) {
            DynamicObject perffile;
            String period = dy.getString("period");
            if (StringUtils.isNotBlank((CharSequence)period)) {
                DynamicObject cycleType = this.getCycleTypeId(period);
                dy.set("cycletype", (Object)cycleType);
            }
            if ((perffile = dy.getDynamicObject("perffilef7")) == null) continue;
            dy.set("employee", (Object)perffile.getDynamicObject("employee"));
            dy.set("depemp", (Object)perffile.getDynamicObject("depemp"));
        }
        PERF_RESULT_ENTITY_SERVICE.save(dys);
    }

    public DynamicObject[] queryByPerfBoId(long perfFileBoId) {
        return PERF_RESULT_ENTITY_SERVICE.queryByPerfBoId(perfFileBoId);
    }
}

