/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.perfsumcal.service;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.mp.entityservice.MpCalcItemEntityService;
import kd.opmc.epa.business.domain.mp.entityservice.MpRuleEntityService;
import kd.opmc.epa.business.domain.mp.enums.MpLevelSetEnum;
import kd.opmc.epa.business.domain.mp.enums.MpSopGenWayEnum;
import kd.opmc.epa.business.domain.mp.enums.MprSourceEnum;
import kd.opmc.epa.business.domain.perfresult.entityservice.PerfResultEntityService;
import kd.opmc.epa.business.domain.perfsumcal.entity.MpCalcItemInfo;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumCalProcessInfo;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumCalResultBo;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumRuleCalBo;
import kd.opmc.epa.business.domain.perfsumcal.entityservice.PerfSumCalEntryService;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;
import kd.opmc.epa.common.enums.activitymanage.CategoryEnum;
import kd.opmc.epa.common.enums.activitymanage.ErDealRuleEnum;
import kd.opmc.epa.common.enums.activitymanage.MpModeEnum;
import kd.opmc.epa.common.enums.activitymanage.PerfSumDataSourceEnum;
import kd.opmc.epa.common.enums.activitymanage.PerfSumTaskTypeEnum;
import kd.opmc.pbs.business.domain.flowscan.entity.BatchFlowTaskResultBo;
import kd.opmc.pbs.business.domain.flowscan.enums.EntryTaskStatusEnum;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskStatusEnum;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;
import org.apache.commons.collections.MapUtils;

public class PerfSumCalDomainService {
    private static final Log log = LogFactory.getLog(PerfSumCalDomainService.class);
    private static final PerfSumCalEntryService PERF_SUM_CAL_ENTITY_SERVICE = PerfSumCalEntryService.getInstance();
    private static final ActivityEvaluationObjectEntityService EVALUATION_OBJECT_ENTITY_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final MpRuleEntityService MP_RULE_ENTITY_SERVICE = MpRuleEntityService.getInstance();
    private static final MpCalcItemEntityService MP_CALC_ITEM_ENTITY_SERVICE = MpCalcItemEntityService.getInstance();
    private static final PerfResultEntityService PERF_RESULT_ENTITY_SERVICE = PerfResultEntityService.getInstance();
    private static final AssessActivityEntityService ASSESS_ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();
    private static final ActEvalObjManageDomainService EVAL_OBJ_DOMAIN = ActEvalObjManageDomainService.getInstance();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"PerfSumCalDomainService#&", (int)3, (int)6);
    private static final Semaphore SEMAPHORE = new Semaphore(6);
    private static final int BATCH_NUM = 500;

    public static PerfSumCalDomainService getInstance() {
        return ServiceFactory.getService(PerfSumCalDomainService.class);
    }

    public void updateBatchTaskStatus(List<Long> batchTaskIdList, TaskStatusEnum taskStatusEnum) {
        QFilter filter = new QFilter("id", "in", batchTaskIdList);
        DynamicObject[] batchTaskDyns = PERF_SUM_CAL_ENTITY_SERVICE.query("id,taskstatus,modifytime", new QFilter[]{filter});
        Date curDate = new Date();
        for (DynamicObject batchTask : batchTaskDyns) {
            batchTask.set("taskstatus", (Object)taskStatusEnum.getValue());
            batchTask.set("modifytime", (Object)curDate);
        }
        PERF_SUM_CAL_ENTITY_SERVICE.save(batchTaskDyns);
    }

    public PerfSumCalResultBo batchCalPerfSumData(List<Long> evalIdList, PerfSumTaskTypeEnum perfSumTaskTypeEnum) {
        PerfSumCalResultBo perfSumCalResultBo = new PerfSumCalResultBo();
        if (CollectionUtils.isEmpty(evalIdList)) {
            return perfSumCalResultBo;
        }
        perfSumCalResultBo.setTotalCount(evalIdList.size());
        BatchFlowTaskResultBo batchFlowTaskResultBo = this.generateBatchPerfSumData(evalIdList, perfSumTaskTypeEnum);
        perfSumCalResultBo.setOperation("0", "1");
        this.dealBatchSumCalTask(batchFlowTaskResultBo.getBatchTaskIdList(), perfSumCalResultBo);
        return perfSumCalResultBo;
    }

    private void threadSumCalLogic(PerfSumCalResultBo perfSumCalResultBo, BatchFlowTaskResultBo batchFlowTaskResultBo) {
        ConcurrentHashMap<Long, PerfSumCalResultBo> retMap = new ConcurrentHashMap<Long, PerfSumCalResultBo>(16);
        List batchTaskIdList = batchFlowTaskResultBo.getBatchTaskIdList();
        int size = batchTaskIdList.size();
        CountDownLatch atomicInteger = new CountDownLatch(size);
        for (Long batchTaskId : batchTaskIdList) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                log.error((Throwable)e);
            }
            try {
                SEMAPHORE.acquire();
                THREAD_POOL.execute(() -> {
                    try {
                        this.threadSumCalTask(RequestContext.get(), batchTaskId, retMap);
                    }
                    catch (Exception exception) {
                        log.error((Throwable)exception);
                    }
                    finally {
                        SEMAPHORE.release();
                        atomicInteger.countDown();
                    }
                }, RequestContext.get());
            }
            catch (InterruptedException interruptedException) {
                log.error((Throwable)interruptedException);
            }
        }
        try {
            atomicInteger.await();
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
        }
        this.parseResultData(perfSumCalResultBo, retMap);
    }

    private void parseResultData(PerfSumCalResultBo perfSumCalResultBo, Map<Long, PerfSumCalResultBo> retMap) {
        if (MapUtils.isEmpty(retMap)) {
            return;
        }
        for (Map.Entry<Long, PerfSumCalResultBo> entry : retMap.entrySet()) {
            PerfSumCalResultBo val = entry.getValue();
            perfSumCalResultBo.addErrorInfoList(val.getErrorInfoList());
        }
    }

    public void threadSumCalTask(RequestContext requestContext, Long batchTaskId, Map<Long, PerfSumCalResultBo> retMap) {
        QFilter cusFilter = new QFilter("taskstatus", "in", Arrays.asList(TaskStatusEnum.UNPROCESS.getValue(), TaskStatusEnum.PUSHED.getValue()));
        cusFilter.and(new QFilter("id", "=", (Object)batchTaskId));
        DynamicObject[] taskDyArry = PERF_SUM_CAL_ENTITY_SERVICE.queryUnProcessSumCalByCusFilter(cusFilter);
        this.setTaskDyStatus(requestContext, taskDyArry, TaskStatusEnum.PROCESSING);
        PerfSumCalResultBo perfSumCalResultBo = new PerfSumCalResultBo();
        this.processSumCalTask(taskDyArry, perfSumCalResultBo);
        retMap.put(batchTaskId, perfSumCalResultBo);
        this.setTaskDyStatus(requestContext, taskDyArry, TaskStatusEnum.PROCESSED);
    }

    public String ruleCalPerfSumData(PerfSumRuleCalBo perfSumRuleCalBo) {
        if (HRObjectUtils.isEmpty((Object)perfSumRuleCalBo)) {
            return ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PerfSumCalDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        }
        List<MpCalcItemInfo> mpCalcItemList = perfSumRuleCalBo.getMpCalcItemList();
        if (CollectionUtils.isEmpty(mpCalcItemList)) {
            return ResManager.loadKDString((String)"\u53c2\u4e0e\u6c47\u603b\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PerfSumCalDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]);
        }
        PerfSumCalProcessInfo perfSumCalProcessInfo = new PerfSumCalProcessInfo();
        QFilter evalFilter = new QFilter("id", "=", (Object)perfSumRuleCalBo.getEvalObjId());
        DynamicObject evalObjDy = EVALUATION_OBJECT_ENTITY_SERVICE.queryOne("id ,activity.id,sop , lop , mpsop,mplop,mpsopendway,mpsopflag,iscurperiod,mpsopgenway,ismprmodify,mpgroup,mprule,mprealrule,mprsource,ismpcalc,mpcalcerrmsg,mpsopsource,perffile.id ", new QFilter[]{evalFilter});
        DynamicObject acticityDy = this.requireActivityDy(perfSumRuleCalBo.getActicityId());
        perfSumCalProcessInfo.setActicityDy(acticityDy);
        this.buildPerfSumCalProcessData(perfSumCalProcessInfo);
        List<Long> mpCalcItemIdList = mpCalcItemList.stream().map(mpCalcItem -> mpCalcItem.getId()).collect(Collectors.toList());
        Map<Long, DynamicObject> mpCalcItemMap = this.requireMpCalcItemMap(perfSumRuleCalBo.getEvalObjId(), mpCalcItemIdList);
        BigDecimal sumScore = this.calRulePerfSumScore(mpCalcItemList, mpCalcItemMap, perfSumCalProcessInfo, perfSumRuleCalBo);
        String sumLevel = this.proPeriodSumLevel(sumScore, perfSumCalProcessInfo);
        String mpsopFlag = this.requireMpsopFlag(perfSumRuleCalBo);
        this.setCalResult2EvalDy(sumScore, sumLevel, evalObjDy, mpsopFlag);
        EVALUATION_OBJECT_ENTITY_SERVICE.saveOne(evalObjDy);
        return "";
    }

    private String requireMpsopFlag(PerfSumRuleCalBo perfSumRuleCalBo) {
        List<MpCalcItemInfo> mpCalcItemList = perfSumRuleCalBo.getMpCalcItemList();
        StringBuilder mpsopFlagSb = new StringBuilder();
        for (MpCalcItemInfo mpCalcItemInfo : mpCalcItemList) {
            mpsopFlagSb.append(mpCalcItemInfo.getTimeFlag()).append(",");
        }
        return mpsopFlagSb.toString();
    }

    public void batchSumCalTaskExe(RequestContext requestContext, Map<String, Object> map) {
        QFilter cusFilter = new QFilter("taskstatus", "in", Arrays.asList(TaskStatusEnum.UNPROCESS.getValue(), TaskStatusEnum.PUSHED.getValue()));
        DynamicObject[] taskDyArry = PERF_SUM_CAL_ENTITY_SERVICE.queryUnProcessSumCalByCusFilter(cusFilter);
        this.setTaskDyStatus(requestContext, taskDyArry, TaskStatusEnum.PROCESSING);
        PerfSumCalResultBo perfSumCalResultBo = new PerfSumCalResultBo();
        this.processSumCalTask(taskDyArry, perfSumCalResultBo);
        this.setTaskDyStatus(requestContext, taskDyArry, TaskStatusEnum.PROCESSED);
    }

    public void dealBatchSumCalTask(List<Long> batchTaskIdList, PerfSumCalResultBo perfSumCalResultBo) {
        if (CollectionUtils.isEmpty(batchTaskIdList)) {
            return;
        }
        log.info("\u3010OPMC\u3011-dealBatchSumCalTask,batchStartIdList is {}", (Object)batchTaskIdList.toString());
        RequestContext requestContext = RequestContext.get();
        QFilter filter = new QFilter("taskstatus", "in", Arrays.asList(TaskStatusEnum.PUSHED.getValue(), TaskStatusEnum.UNPROCESS.getValue()));
        filter.and(new QFilter("id", "in", batchTaskIdList));
        DynamicObject[] taskDyArry = PERF_SUM_CAL_ENTITY_SERVICE.queryUnProcessSumCalByCusFilter(filter);
        if (null == taskDyArry || taskDyArry.length <= 0) {
            log.info("dealBatchSumCalTask : Haven't Task to execute.");
            return;
        }
        this.setTaskDyStatus(requestContext, taskDyArry, TaskStatusEnum.PROCESSING);
        this.processSumCalTask(taskDyArry, perfSumCalResultBo);
        this.setTaskDyStatus(requestContext, taskDyArry, TaskStatusEnum.PROCESSED);
    }

    public BatchFlowTaskResultBo generateBatchPerfSumData(List<Long> evalIdList, PerfSumTaskTypeEnum perfSumTaskTypeEnum) {
        int batchSize = 0;
        StringBuilder msgSb = new StringBuilder();
        ArrayList<Long> batchTaskIdList = new ArrayList<Long>(10);
        int size = evalIdList.size();
        ArrayList<Long> evalTmpList = new ArrayList<Long>(10);
        for (int i = 0; i < size; ++i) {
            evalTmpList.add(evalIdList.get(i));
            if (i > 0 && (i + 1) % 500 == 0) {
                batchTaskIdList.addAll(this.saveBatchFlowTaskData(evalTmpList, perfSumTaskTypeEnum.getCode()));
                evalTmpList.clear();
                ++batchSize;
                continue;
            }
            if (i != size - 1 || evalTmpList.size() <= 0) continue;
            batchTaskIdList.addAll(this.saveBatchFlowTaskData(evalTmpList, perfSumTaskTypeEnum.getCode()));
            ++batchSize;
        }
        msgSb.append(MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u5206\u4e3a{1}\u6279\u6b21\u5904\u7406\uff0c", (String)"PerfSumCalDomainService_2", (String)"opmc-epa-business", (Object[])new Object[0]), batchTaskIdList.size(), batchSize));
        return this.buildResultInfo("1", msgSb.toString(), batchTaskIdList);
    }

    private BatchFlowTaskResultBo buildResultInfo(String operationType, String resultDetail, List<Long> batchTaskIdList) {
        BatchFlowTaskResultBo batchFlowTaskResultBo = new BatchFlowTaskResultBo();
        batchFlowTaskResultBo.setOperationType(operationType);
        batchFlowTaskResultBo.setResultDetial(resultDetail);
        batchFlowTaskResultBo.setBatchTaskIdList(batchTaskIdList);
        return batchFlowTaskResultBo;
    }

    private List<Long> saveBatchFlowTaskData(List<Long> evalIdList, String tasktype) {
        try {
            if (CollectionUtils.isEmpty(evalIdList)) {
                return new ArrayList<Long>(10);
            }
            Date date = new Date();
            long userId = UserServiceHelper.getCurrentUserId();
            DynamicObject batchPrefSumCalData = PERF_SUM_CAL_ENTITY_SERVICE.generateEmptyDynamicObject();
            batchPrefSumCalData.set("creator", (Object)userId);
            batchPrefSumCalData.set("createtime", (Object)date);
            batchPrefSumCalData.set("modifier", (Object)userId);
            batchPrefSumCalData.set("modifytime", (Object)date);
            batchPrefSumCalData.set("taskstatus", (Object)TaskStatusEnum.UNPROCESS.getValue());
            batchPrefSumCalData.set("tasktype", (Object)tasktype);
            String batchno = this.requireBatchNo(batchPrefSumCalData);
            batchPrefSumCalData.set("batchno", (Object)batchno);
            DynamicObjectCollection dyColl = PERF_SUM_CAL_ENTITY_SERVICE.generateEmptyEntryCollection(batchPrefSumCalData, "entryentity");
            for (Long evalId : evalIdList) {
                DynamicObject entryDy = PERF_SUM_CAL_ENTITY_SERVICE.generateEmptyEntryDynamicObject("entryentity");
                entryDy.set("actevaobj", (Object)evalId);
                entryDy.set("entrytaskstatus", (Object)EntryTaskStatusEnum.UNEXECUTE.getValue());
                entryDy.set("excutecount", (Object)0);
                dyColl.add((Object)entryDy);
            }
            Object pk = PERF_SUM_CAL_ENTITY_SERVICE.saveOne(batchPrefSumCalData);
            ArrayList<Long> batchStartIdList = new ArrayList<Long>(1);
            batchStartIdList.add(((DynamicObject)pk).getLong("id"));
            return batchStartIdList;
        }
        catch (Exception e) {
            log.error(" OPMC_PBS_ERROR : saveBatchFlowTaskData flowRuProcBoList [{}] tasktype [{}] ", (Object)SerializationUtils.toJsonString(evalIdList), (Object)tasktype);
            return new ArrayList<Long>(10);
        }
    }

    private String requireBatchNo(DynamicObject batchFlowTaskData) {
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)batchFlowTaskData.getDataEntityType().getName(), (DynamicObject)batchFlowTaskData, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)batchFlowTaskData);
    }

    public String requireBatchNoByBatchTask(TaskTypeEnum taskTypeEnum) {
        DynamicObject batchFlowTaskData = PERF_SUM_CAL_ENTITY_SERVICE.generateEmptyDynamicObject();
        batchFlowTaskData.set("tasktype", (Object)taskTypeEnum.getValue());
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)batchFlowTaskData.getDataEntityType().getName(), (DynamicObject)batchFlowTaskData, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)batchFlowTaskData);
    }

    private void processSumCalTask(DynamicObject[] taskDyArry, PerfSumCalResultBo perfSumCalResultBo) {
        for (DynamicObject taskDy : taskDyArry) {
            DynamicObjectCollection taskEntryColl = taskDy.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)taskEntryColl)) continue;
            List<Long> evalIdList = taskEntryColl.stream().map(taskEntry -> taskEntry.getLong("actevaobj")).collect(Collectors.toList());
            this.dealProcessSumCalTask(evalIdList, perfSumCalResultBo);
        }
    }

    public void dealProcessSumCalTask(List<Long> evalIdList, PerfSumCalResultBo perfSumCalResultBo) {
        if (CollectionUtils.isEmpty(evalIdList)) {
            return;
        }
        PerfSumCalProcessInfo perfSumCalProcessInfo = new PerfSumCalProcessInfo();
        QFilter evalFilter = new QFilter("id", "in", evalIdList);
        DynamicObject[] evalObjDyArr = EVALUATION_OBJECT_ENTITY_SERVICE.query("id ,activity.id,sop , lop , mpsop,mplop,mpsopendway,mpsopflag,iscurperiod,mpsopgenway,ismprmodify,mpgroup,mprule,mprealrule,mprsource,ismpcalc,mpcalcerrmsg,mpsopsource,perffile.id ", new QFilter[]{evalFilter});
        Long activityId = evalObjDyArr[0].getLong("activity.id");
        this.parseEval2RuleIdAndFileId(evalObjDyArr, perfSumCalProcessInfo);
        DynamicObject acticityDy = this.requireActivityDy(activityId);
        perfSumCalProcessInfo.setActicityDy(acticityDy);
        Long actRuleId = acticityDy.getLong("mprule.id");
        perfSumCalProcessInfo.getRuleIdSet().add(actRuleId);
        this.buildPerfSumCalProcessData(perfSumCalProcessInfo);
        Map<Long, DynamicObject> mpRuleMap = this.requireMpRuleMap(perfSumCalProcessInfo);
        this.addNoExistMpCalcItem(evalIdList, evalObjDyArr, perfSumCalProcessInfo);
        Map<Long, List<DynamicObject>> mpCalcItemMap = this.requireMpCalcItemMap(evalIdList);
        for (DynamicObject evalObjDy : evalObjDyArr) {
            DynamicObject mpRuleDy;
            Long evalId = evalObjDy.getLong("id");
            List<DynamicObject> mpCalcItemList = mpCalcItemMap.get(evalId);
            perfSumCalProcessInfo.addMpCalcItemList(mpCalcItemList, Boolean.FALSE);
            Long mpRuleid = evalObjDy.getLong("mprealrule.id");
            if (HRObjectUtils.isEmpty((Object)mpRuleid) || 0L == mpRuleid) {
                mpRuleid = actRuleId;
                this.setRuleInfoWithEvalObj(evalObjDy, actRuleId);
            }
            if (HRObjectUtils.isEmpty((Object)(mpRuleDy = mpRuleMap.get(mpRuleid)))) {
                this.setErrorMsg2EvalDy(evalObjDy, ResManager.loadKDString((String)"\u6ca1\u627e\u5230\u53ef\u7528\u4e8e\u6c47\u603b\u8ba1\u7b97\u7684\u89c4\u5219\u3002", (String)"PerfSumCalDomainService_3", (String)"opmc-epa-business", (Object[])new Object[0]), perfSumCalResultBo);
                continue;
            }
            DynamicObjectCollection calMpRuleEntryDyColl = mpRuleDy.getDynamicObjectCollection("entryentity");
            String erDealRule = mpRuleDy.getString("erdealrule");
            String mpMode = mpRuleDy.getString("mpmode");
            int calPeriodSize = calMpRuleEntryDyColl.size();
            String errorMsg = this.valTimeFlagIsSame(mpCalcItemList);
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                this.setErrorMsg2EvalDy(evalObjDy, errorMsg, perfSumCalResultBo);
                continue;
            }
            Map<String, DynamicObject> evalMpCalcItemMap = mpCalcItemList.stream().collect(Collectors.toMap(mpCalcItem -> mpCalcItem.getString("timetag"), v -> v, (key1, key2) -> key1));
            BigDecimal pCalPeriodWeight = BigDecimal.ZERO;
            int unCalPeriodCount = 0;
            HashMap flagAndWeightMap = Maps.newHashMapWithExpectedSize((int)16);
            StringBuilder timeFlagStr = new StringBuilder();
            StringBuilder timeFlagLackSb = new StringBuilder();
            for (DynamicObject calMpRuleEntryDy : calMpRuleEntryDyColl) {
                String mpRuleTimeTag = calMpRuleEntryDy.getString("timetag");
                BigDecimal mpRuleWeight = calMpRuleEntryDy.getBigDecimal("weight");
                DynamicObject evalMpCalcItem = evalMpCalcItemMap.get(mpRuleTimeTag);
                if (HRObjectUtils.isEmpty((Object)evalMpCalcItem)) {
                    timeFlagLackSb.append(mpRuleTimeTag).append(",");
                    ++unCalPeriodCount;
                    continue;
                }
                timeFlagStr.append(mpRuleTimeTag).append(",");
                pCalPeriodWeight = pCalPeriodWeight.add(mpRuleWeight);
                flagAndWeightMap.put(mpRuleTimeTag, mpRuleWeight);
                perfSumCalProcessInfo.addMpCalcItem(evalMpCalcItem, Boolean.TRUE);
            }
            int calPeriodCount = calPeriodSize - unCalPeriodCount;
            if (calPeriodCount == 0) {
                this.setErrorMsg2EvalDy(evalObjDy, ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u53ef\u6c47\u603b\u7684\u6570\u636e\u3002", (String)"PerfSumCalDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]), perfSumCalResultBo);
                continue;
            }
            if (ErDealRuleEnum.DEFAULT_NO_SUM_RESULT.getCode().equals(erDealRule) && unCalPeriodCount > 0) {
                String timeFlagLackStr = timeFlagLackSb.toString();
                this.setErrorMsg2EvalDy(evalObjDy, MessageFormat.format(ResManager.loadKDString((String)"{0}\u7ed3\u679c\u83b7\u53d6\u4e3a\u7a7a\u3002", (String)"PerfSumCalDomainService_5", (String)"opmc-epa-business", (Object[])new Object[0]), HRStringUtils.isEmpty((String)timeFlagLackStr) ? timeFlagLackStr : timeFlagLackStr.substring(0, timeFlagLackStr.length() - 1)), perfSumCalResultBo);
                continue;
            }
            this.resetFlagAndWeightMapByMode(flagAndWeightMap, calPeriodSize, pCalPeriodWeight, mpMode, erDealRule);
            BigDecimal sumScore = this.calPeriodSumScore(flagAndWeightMap, evalMpCalcItemMap, perfSumCalProcessInfo);
            String sumLevel = this.proPeriodSumLevel(sumScore, perfSumCalProcessInfo);
            this.setCalResult2EvalDy(sumScore, sumLevel, evalObjDy, timeFlagStr.toString());
        }
        EVALUATION_OBJECT_ENTITY_SERVICE.save(evalObjDyArr);
        DynamicObjectCollection mpCalCalcItemColl = perfSumCalProcessInfo.getMpCalcItemColl();
        if (!CollectionUtils.isEmpty((Collection)mpCalCalcItemColl)) {
            MP_CALC_ITEM_ENTITY_SERVICE.save(mpCalCalcItemColl);
        }
    }

    private void setRuleInfoWithEvalObj(DynamicObject evalObjDy, Long actRuleId) {
        evalObjDy.set("mprealrule", (Object)actRuleId);
        evalObjDy.set("mprsource", (Object)MprSourceEnum.FORM_ACTIVITY.getCode());
    }

    private Map<Long, DynamicObject> requireMpRuleMap(PerfSumCalProcessInfo perfSumCalProcessInfo) {
        Set<Long> ruleIdSet = perfSumCalProcessInfo.getRuleIdSet();
        if (CollectionUtils.isEmpty(ruleIdSet)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        QFilter mpRuleFilter = new QFilter("id", "in", perfSumCalProcessInfo.getRuleIdSet());
        DynamicObject[] mpRuleDyArr = MP_RULE_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{mpRuleFilter});
        Map<Long, DynamicObject> mpRuleMap = Arrays.asList(mpRuleDyArr).stream().collect(Collectors.toMap(mpRuleDy -> mpRuleDy.getLong("id"), v -> v, (key1, key2) -> key1));
        return mpRuleMap;
    }

    private DynamicObject requireActivityDy(Long activityId) {
        QFilter actFilter = new QFilter("id", "=", (Object)activityId);
        return ASSESS_ACTIVITY_ENTITY_SERVICE.queryOne("id , scheme.id ,assessform.id ,perfworkflow.id, mprule.id,timeplanentry,timeplanentry.activity,year", new QFilter[]{actFilter});
    }

    public String proPeriodSumLevel(BigDecimal sumScore, PerfSumCalProcessInfo perfSumCalProcessInfo) {
        String seq = "";
        if (!perfSumCalProcessInfo.isMpLevelExchange() || 0L == perfSumCalProcessInfo.getScoreSystemId() || null == perfSumCalProcessInfo.getScoreSystemId() || HRObjectUtils.isEmpty((Object)perfSumCalProcessInfo.getSumPerfLevelDy())) {
            return seq;
        }
        Long scoreSystemId = perfSumCalProcessInfo.getScoreSystemId();
        DynamicObject sumPerfLevelDy = perfSumCalProcessInfo.getSumPerfLevelDy();
        DynamicObjectCollection scoreMapEntry = sumPerfLevelDy.getDynamicObjectCollection("scoremapentryentity");
        DynamicObject scoreMapDy = scoreMapEntry.stream().filter(scoreMap -> scoreMap.getLong("scoresystem.id") == scoreSystemId.longValue()).findFirst().orElse(null);
        if (scoreMapDy == null) {
            log.error("Unable to find score system mapping for performance level, scoreSystemId[{}], sumPerfLevelId[{}]", (Object)scoreSystemId, (Object)sumPerfLevelDy.getLong("id"));
            return seq;
        }
        String levelScoreMap = scoreMapDy.getString("levelscoremap");
        if (HRStringUtils.equals((String)levelScoreMap, (String)"20")) {
            log.error("Mapping by default is not supported");
            return seq;
        }
        DynamicObjectCollection scoreLevelMapEntry = scoreMapDy.getDynamicObjectCollection("scoresubentryentity");
        for (DynamicObject scoreLevelMap : scoreLevelMapEntry) {
            BigDecimal maxScore = scoreLevelMap.getBigDecimal("maxscore");
            String scoreMaxOperation = scoreLevelMap.getString("scoremaxoperation");
            String scoreMinOperation = scoreLevelMap.getString("scoreminoperation");
            BigDecimal minScore = scoreLevelMap.getBigDecimal("minscore");
            boolean maxCompare = true;
            if (maxScore != null && maxScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMaxOperation, (String)"10")) {
                    maxCompare = maxScore.compareTo(sumScore) > 0;
                } else if (HRStringUtils.equals((String)scoreMaxOperation, (String)"20")) {
                    maxCompare = maxScore.compareTo(sumScore) >= 0;
                }
            }
            boolean minCompare = true;
            if (minScore != null && minScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMinOperation, (String)"10")) {
                    minCompare = sumScore.compareTo(minScore) > 0;
                } else if (HRStringUtils.equals((String)scoreMinOperation, (String)"20")) {
                    boolean bl = minCompare = sumScore.compareTo(minScore) >= 0;
                }
            }
            if (!maxCompare || !minCompare) continue;
            return scoreLevelMap.getString("seq");
        }
        return seq;
    }

    private void resetFlagAndWeightMapByMode(Map<String, BigDecimal> flagAndWeightMap, int calPeriodSize, BigDecimal pCalPeriodWeight, String mpMode, String erDealRule) {
        BigDecimal weight = ErDealRuleEnum.SHARE_WEIGHT.getCode().equals(erDealRule) ? BigDecimal.ONE.divide(BigDecimal.valueOf(flagAndWeightMap.size()), 8, 4) : BigDecimal.ONE.divide(BigDecimal.valueOf(calPeriodSize), 8, 4);
        for (Map.Entry<String, BigDecimal> entry : flagAndWeightMap.entrySet()) {
            if (MpModeEnum.AVG_WEIGHT.getCode().equals(mpMode)) {
                flagAndWeightMap.put(entry.getKey(), weight);
                continue;
            }
            BigDecimal resetWeight = ErDealRuleEnum.SHARE_WEIGHT.getCode().equals(erDealRule) ? (pCalPeriodWeight.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : entry.getValue().divide(pCalPeriodWeight, 8, 4)) : entry.getValue().divide(BigDecimal.valueOf(100L), 8, 4);
            flagAndWeightMap.put(entry.getKey(), resetWeight);
        }
    }

    private void buildPerfSumCalProcessData(PerfSumCalProcessInfo perfSumCalProcessInfo) {
        long perfWorkFlowId = perfSumCalProcessInfo.getActicityDy().getLong("perfworkflow.id");
        DynamicObjectCollection timeplanEntry = perfSumCalProcessInfo.getActicityDy().getDynamicObjectCollection("timeplanentry");
        boolean isAloneSum = EVAL_OBJ_DOMAIN.isDependentSummary(perfWorkFlowId);
        perfSumCalProcessInfo.setAloneSum(isAloneSum);
        DynamicObject perfWorkFlowDy = PERF_WORK_FLOW_ENTITY_SERVICE.queryOne(perfWorkFlowId);
        Boolean isMpSopExchange = perfWorkFlowDy.getBoolean("ismpsopexchange");
        perfSumCalProcessInfo.setMpSopExchange(isMpSopExchange);
        Boolean isMpLevelExchange = perfWorkFlowDy.getBoolean("ismplevelexchange");
        perfSumCalProcessInfo.setMpLevelExchange(isMpLevelExchange);
        String mpLevelSet = perfWorkFlowDy.getString("mplevelset");
        perfSumCalProcessInfo.setMpLevelSet(mpLevelSet);
        Long scoreSystemIdByFlow = perfWorkFlowDy.getLong("scoresystem.id");
        Long sumPerfLevelIdByFlow = perfWorkFlowDy.getLong("sumperflevel.id");
        if (isAloneSum) {
            perfSumCalProcessInfo.setScoreSystemId(scoreSystemIdByFlow);
            perfSumCalProcessInfo.setSumPerfLevelId(sumPerfLevelIdByFlow);
            if (isMpSopExchange.booleanValue()) {
                perfSumCalProcessInfo.setSocreMax(perfWorkFlowDy.getBigDecimal("scoresystem.maxscore"));
            }
            if (isMpLevelExchange.booleanValue() && 0L != sumPerfLevelIdByFlow && null != sumPerfLevelIdByFlow) {
                DynamicObject sumPerfLevelByFlow = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelIdByFlow);
                perfSumCalProcessInfo.setSumPerfLevelDy(sumPerfLevelByFlow);
            }
        }
        if (!isAloneSum) {
            long assessFormId = perfSumCalProcessInfo.getActicityDy().getLong("assessform.id");
            DynamicObject assessFormDy = ASSESS_FORM_ENTITY_SERVICE.queryAssessForm(assessFormId);
            Long scoreSystemIdByForm = assessFormDy.getLong("scoresystem.id");
            perfSumCalProcessInfo.setScoreSystemId(scoreSystemIdByForm);
            perfSumCalProcessInfo.setSocreMax(assessFormDy.getBigDecimal("scoresystem.maxscore"));
            Long sumPerfLevelIdForm = assessFormDy.getLong("sumperflevel.id");
            perfSumCalProcessInfo.setEvalPerfLevelId(sumPerfLevelIdForm);
            if (HRStringUtils.isNotEmpty((String)mpLevelSet) && mpLevelSet.equals(MpLevelSetEnum.SAME_AS_ASSESSFORM.getCode())) {
                perfSumCalProcessInfo.setSumPerfLevelId(sumPerfLevelIdForm);
                if (0L != sumPerfLevelIdForm && null != sumPerfLevelIdForm) {
                    DynamicObject sumPerfLevelByForm = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelIdForm);
                    perfSumCalProcessInfo.setSumPerfLevelDy(sumPerfLevelByForm);
                }
            } else {
                perfSumCalProcessInfo.setSumPerfLevelId(sumPerfLevelIdByFlow);
                if (0L != sumPerfLevelIdByFlow && null != sumPerfLevelIdByFlow) {
                    DynamicObject sumPerfLevelByFlow = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelIdByFlow);
                    perfSumCalProcessInfo.setSumPerfLevelDy(sumPerfLevelByFlow);
                }
            }
        }
    }

    private String valTimeFlagIsSame(List<DynamicObject> mpCalcItemList) {
        if (CollectionUtils.isEmpty(mpCalcItemList)) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u53ef\u6c47\u603b\u7684\u6570\u636e\u3002", (String)"PerfSumCalDomainService_4", (String)"opmc-epa-business", (Object[])new Object[0]);
        }
        HashSet timFlagSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject mpCalCItemDy : mpCalcItemList) {
            String timeTag = mpCalCItemDy.getString("timetag");
            if (timFlagSet.contains(timeTag)) {
                return MessageFormat.format(ResManager.loadKDString((String)"{0}\u5b58\u5728\u591a\u4e2a\u503c\u3002", (String)"PerfSumCalDomainService_6", (String)"opmc-epa-business", (Object[])new Object[0]), timeTag);
            }
            timFlagSet.add(timeTag);
        }
        return "";
    }

    private void parseEval2RuleIdAndFileId(DynamicObject[] evalObjDyArr, PerfSumCalProcessInfo perfSumCalProcessInfo) {
        for (DynamicObject evalObjDy : evalObjDyArr) {
            Long perfFileId = evalObjDy.getLong("perffile.id");
            perfSumCalProcessInfo.getPerfFileIdList().add(perfFileId);
            Long mpRealRuleId = evalObjDy.getLong("mprealrule.id");
            if (HRObjectUtils.isEmpty((Object)mpRealRuleId) || 0L == mpRealRuleId) continue;
            perfSumCalProcessInfo.getRuleIdSet().add(mpRealRuleId);
        }
    }

    private BigDecimal calPeriodSumScore(Map<String, BigDecimal> flagAndWeightMap, Map<String, DynamicObject> evalMpCalcItemMap, PerfSumCalProcessInfo perfSumCalProcessInfo) {
        BigDecimal sumScore = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : flagAndWeightMap.entrySet()) {
            String timeFlag = entry.getKey();
            BigDecimal weight = entry.getValue();
            DynamicObject evalMpCalcItem = evalMpCalcItemMap.get(timeFlag);
            BigDecimal score = evalMpCalcItem.getBigDecimal("sop");
            DynamicObject curScoreSystem = evalMpCalcItem.getDynamicObject("scoresystem");
            if (perfSumCalProcessInfo.isMpSopExchange() && !HRObjectUtils.isEmpty((Object)curScoreSystem)) {
                BigDecimal curScoreSys = evalMpCalcItem.getBigDecimal("scoresystem.maxscore");
                sumScore = curScoreSys.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : sumScore.add(score.multiply(weight).multiply(perfSumCalProcessInfo.getSocreMax()).divide(curScoreSys, 8, 4));
                continue;
            }
            sumScore = sumScore.add(score.multiply(weight));
        }
        return sumScore.setScale(6, 4);
    }

    private BigDecimal calRulePerfSumScore(List<MpCalcItemInfo> mpCalcItemList, Map<Long, DynamicObject> evalMpCalcItemMap, PerfSumCalProcessInfo perfSumCalProcessInfo, PerfSumRuleCalBo perfSumRuleCalBo) {
        BigDecimal sumScore = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(mpCalcItemList)) {
            return sumScore;
        }
        BigDecimal avgWeight = BigDecimal.ONE.divide(BigDecimal.valueOf(mpCalcItemList.size()), 8, 4);
        for (MpCalcItemInfo mpCalcItemInfo : mpCalcItemList) {
            Long mpCalcItemId = mpCalcItemInfo.getId();
            BigDecimal weight = mpCalcItemInfo.getWeight();
            weight = perfSumRuleCalBo.getMpModeEnum().getCode().equals(MpModeEnum.AVG_WEIGHT.getCode()) ? avgWeight : weight.divide(BigDecimal.valueOf(100L), 8, 4);
            DynamicObject evalMpCalcItem = evalMpCalcItemMap.get(mpCalcItemId);
            BigDecimal score = evalMpCalcItem.getBigDecimal("sop");
            DynamicObject curScoreSystem = evalMpCalcItem.getDynamicObject("scoresystem");
            if (perfSumCalProcessInfo.isMpSopExchange() && !HRObjectUtils.isEmpty((Object)curScoreSystem)) {
                BigDecimal curScoreSys = evalMpCalcItem.getBigDecimal("scoresystem.maxscore");
                sumScore = sumScore.add(score.multiply(weight).multiply(perfSumCalProcessInfo.getSocreMax()).divide(curScoreSys, 8, 4));
                continue;
            }
            sumScore = sumScore.add(score.multiply(weight));
        }
        return sumScore.setScale(6, 4);
    }

    private void setCalResult2EvalDy(BigDecimal sumScore, String sumLevel, DynamicObject evalObjDy, String mpsopflag) {
        evalObjDy.set("mpsop", (Object)sumScore);
        evalObjDy.set("mplop", (Object)sumLevel);
        evalObjDy.set("mpsopgenway", (Object)MpSopGenWayEnum.RULE_CALC.getCode());
        evalObjDy.set("ismpcalc", (Object)Boolean.TRUE);
        evalObjDy.set("mpcalcerrmsg", (Object)"");
        if (HRStringUtils.isNotEmpty((String)mpsopflag)) {
            evalObjDy.set("mpsopflag", (Object)mpsopflag.substring(0, mpsopflag.length() - 1));
        }
    }

    private void setErrorMsg2EvalDy(DynamicObject evalObjDy, String errorMsg, PerfSumCalResultBo perfSumCalResultBo) {
        evalObjDy.set("mpsop", null);
        evalObjDy.set("mplop", (Object)"");
        evalObjDy.set("mpsopgenway", (Object)"");
        evalObjDy.set("ismpcalc", (Object)Boolean.FALSE);
        evalObjDy.set("mpcalcerrmsg", (Object)errorMsg);
        evalObjDy.set("mpsopflag", (Object)"");
        perfSumCalResultBo.setErrorInfo(evalObjDy.getLong("id"), errorMsg);
    }

    private Map<Long, List<DynamicObject>> requirePerfResultMap(DynamicObject acticityDy, Set<Long> perfFileIdList) {
        Long schemeId = acticityDy.getLong("scheme.id");
        Date yearDate = acticityDy.getDate("year");
        int year = HRDateTimeUtils.getYear((Date)yearDate);
        String yearStr = Integer.toString(year);
        QFilter perfResultFilter = new QFilter("perffilef7.id", "in", perfFileIdList);
        perfResultFilter.and(new QFilter("activity.scheme.id", "=", (Object)schemeId));
        perfResultFilter.and(new QFilter("assessperiod", "ilike", (Object)(yearStr + "%")));
        perfResultFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject[] perfResultDyArr = PERF_RESULT_ENTITY_SERVICE.query("id , boid ,assessperiod,perffilef7.id,activity.id,activity.peroid , rulescoref7.id , perflevelf7.id , score, assesslevel  ", new QFilter[]{perfResultFilter});
        Map<Long, List<DynamicObject>> perfResultMap = Arrays.asList(perfResultDyArr).stream().collect(Collectors.groupingBy(obj -> obj.getLong("perffilef7.id")));
        return perfResultMap;
    }

    private Map<Long, List<DynamicObject>> requireMpCalcItemMap(List<Long> evalIdList) {
        DynamicObject[] mpCalcItemDyArr = this.requireMpCalcItem(evalIdList);
        Map<Long, List<DynamicObject>> mpCalcItemMap = Arrays.asList(mpCalcItemDyArr).stream().collect(Collectors.groupingBy(obj -> obj.getLong("evaobj.id")));
        return mpCalcItemMap;
    }

    private Map<Long, DynamicObject> requireMpCalcItemMap(Long evalId, List<Long> mpCalcIdList) {
        QFilter mpCalcFilter = new QFilter("evaobj", "=", (Object)evalId);
        mpCalcFilter.and(new QFilter("id", "in", mpCalcIdList));
        DynamicObject[] mpCalcItemDyArr = MP_CALC_ITEM_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{mpCalcFilter});
        Map<Long, DynamicObject> mpCalcItemMap = Arrays.asList(mpCalcItemDyArr).stream().collect(Collectors.toMap(mpCalcItem -> mpCalcItem.getLong("id"), v -> v, (key1, key2) -> key1));
        return mpCalcItemMap;
    }

    private DynamicObject[] requireMpCalcItem(List<Long> evalIdList) {
        QFilter mpCalcFilter = new QFilter("evaobj", "in", evalIdList);
        DynamicObject[] mpCalcItemDyArr = MP_CALC_ITEM_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{mpCalcFilter});
        return mpCalcItemDyArr;
    }

    private void addNoExistMpCalcItem(List<Long> evalIdList, DynamicObject[] evalObjDyArr, PerfSumCalProcessInfo perfSumCalProcessInfo) {
        Map<Long, List<DynamicObject>> mpCalcItemMap = this.requireMpCalcItemMap(evalIdList);
        Map<Long, List<DynamicObject>> perfResultMap = this.requirePerfResultMap(perfSumCalProcessInfo.getActicityDy(), perfSumCalProcessInfo.getPerfFileIdList());
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        for (DynamicObject evalObjDy : evalObjDyArr) {
            Long evalId = evalObjDy.getLong("id");
            Long perfFileId = evalObjDy.getLong("perffile.id");
            List<DynamicObject> perfReusltList = perfResultMap.get(perfFileId);
            List<DynamicObject> evalMpCalcItemList = mpCalcItemMap.get(evalId);
            this.diffCollCalcItemAndPerfRsult(perfReusltList, evalMpCalcItemList, evalObjDy, dyColl, perfSumCalProcessInfo);
        }
        if (dyColl.size() > 0) {
            MP_CALC_ITEM_ENTITY_SERVICE.save(dyColl);
        }
    }

    private void diffCollCalcItemAndPerfRsult(List<DynamicObject> perfReusltList, List<DynamicObject> evalMpCalcItemList, DynamicObject evalObjDy, DynamicObjectCollection dyColl, PerfSumCalProcessInfo perfSumCalProcessInfo) {
        DynamicObject evalMpCalcItemDy;
        Boolean isSaveEval = evalObjDy.getBoolean("iscurperiod") && !perfSumCalProcessInfo.isAloneSum();
        if (CollectionUtils.isEmpty(evalMpCalcItemList)) {
            this.generateMpCalcItemResultList(perfReusltList, evalObjDy, dyColl);
            this.generateMpCalcItemByEval(evalObjDy, isSaveEval, dyColl, perfSumCalProcessInfo);
            return;
        }
        Map<String, DynamicObject> mpCalcItemMap = evalMpCalcItemList.stream().collect(Collectors.toMap(mpCalcItem -> String.valueOf(mpCalcItem.getLong("boid")) + mpCalcItem.getString("period"), v -> v, (key1, key2) -> key1));
        if (CollectionUtils.isNotEmpty(evalMpCalcItemList) && CollectionUtils.isNotEmpty(perfReusltList)) {
            Map<String, DynamicObject> perfResultMap = perfReusltList.stream().collect(Collectors.toMap(perfResult -> String.valueOf(perfResult.getLong("boid")) + perfResult.getString("assessperiod"), v -> v, (key1, key2) -> key1));
            for (Map.Entry<String, DynamicObject> entry : perfResultMap.entrySet()) {
                DynamicObject mpCalcItemDy = mpCalcItemMap.get(entry.getKey());
                if (!HRObjectUtils.isEmpty((Object)mpCalcItemDy)) continue;
                this.generateMpCalcItemByResult(entry.getValue(), evalObjDy, dyColl);
            }
        }
        if (HRObjectUtils.isEmpty((Object)(evalMpCalcItemDy = mpCalcItemMap.get(String.valueOf(evalObjDy.getLong("id") + evalObjDy.getString("activity.period")))))) {
            this.generateMpCalcItemByEval(evalObjDy, isSaveEval, dyColl, perfSumCalProcessInfo);
        }
    }

    private void generateMpCalcItemByEval(DynamicObject evalObjDy, Boolean isSaveEval, DynamicObjectCollection dyColl, PerfSumCalProcessInfo perfSumCalProcessInfo) {
        if (!isSaveEval.booleanValue()) {
            return;
        }
        DynamicObject dy = MP_CALC_ITEM_ENTITY_SERVICE.generateEmptyDynamicObject();
        dy.set("category", (Object)CategoryEnum.COMPREHENSICE_SUM.getCode());
        dy.set("perffile", (Object)evalObjDy.getLong("perffile.id"));
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dy.getDataEntityType().getName(), (DynamicObject)dy, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dy);
        dy.set("number", (Object)number);
        dy.set("evaobj", (Object)evalObjDy.getLong("id"));
        dy.set("activity", (Object)evalObjDy.getLong("activity.id"));
        dy.set("sop", (Object)evalObjDy.getBigDecimal("sop"));
        dy.set("lop", (Object)evalObjDy.getString("lop"));
        dy.set("scoresystem", (Object)perfSumCalProcessInfo.getScoreSystemId());
        dy.set("perfleve", (Object)perfSumCalProcessInfo.getEvalPerfLevelId());
        dy.set("year", (Object)evalObjDy.getDate("activity.year"));
        dy.set("period", (Object)evalObjDy.getString("activity.period"));
        Date yearDate = evalObjDy.getDate("activity.year");
        int year = HRDateTimeUtils.getYear((Date)yearDate);
        String yearStr = Integer.toString(year);
        String timeTag = evalObjDy.getString("activity.period").replace(yearStr, "");
        dy.set("timetag", (Object)timeTag);
        dy.set("datasource", (Object)PerfSumDataSourceEnum.EVAL_OBJ.getCode());
        dy.set("boid", (Object)evalObjDy.getLong("id"));
        dy.set("isused", (Object)Boolean.TRUE);
        dy.set("creator", (Object)RequestContext.get().getCurrUserId());
        dyColl.add((Object)dy);
    }

    private void generateMpCalcItemResultList(List<DynamicObject> perfReusltList, DynamicObject evalObjDy, DynamicObjectCollection dyColl) {
        if (CollectionUtils.isEmpty(perfReusltList)) {
            return;
        }
        for (DynamicObject perfResult : perfReusltList) {
            this.generateMpCalcItemByResult(perfResult, evalObjDy, dyColl);
        }
    }

    private DynamicObject generateMpCalcItemByResult(DynamicObject perfReuslt, DynamicObject evalObjDy, DynamicObjectCollection dyColl) {
        DynamicObject dy = MP_CALC_ITEM_ENTITY_SERVICE.generateEmptyDynamicObject();
        dy.set("category", (Object)CategoryEnum.COMPREHENSICE_SUM.getCode());
        dy.set("perffile", (Object)perfReuslt.getLong("perffilef7.id"));
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dy.getDataEntityType().getName(), (DynamicObject)dy, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)dy);
        dy.set("number", (Object)number);
        dy.set("evaobj", (Object)evalObjDy.getLong("id"));
        dy.set("activity", (Object)perfReuslt.getLong("activity.id"));
        dy.set("sop", (Object)perfReuslt.getBigDecimal("score"));
        dy.set("lop", (Object)perfReuslt.getString("assesslevel"));
        dy.set("scoresystem", (Object)perfReuslt.getLong("rulescoref7.id"));
        dy.set("perfleve", (Object)perfReuslt.getLong("perflevelf7.id"));
        dy.set("year", (Object)evalObjDy.getDate("activity.year"));
        dy.set("period", (Object)perfReuslt.getString("assessperiod"));
        Date yearDate = evalObjDy.getDate("activity.year");
        int year = HRDateTimeUtils.getYear((Date)yearDate);
        String yearStr = Integer.toString(year);
        String timeTag = perfReuslt.getString("assessperiod").replace(yearStr, "");
        dy.set("timetag", (Object)timeTag);
        dy.set("datasource", (Object)PerfSumDataSourceEnum.RESULT_DETAIL.getCode());
        dy.set("boid", (Object)perfReuslt.getLong("boid"));
        dy.set("isused", (Object)Boolean.TRUE);
        dy.set("creator", (Object)RequestContext.get().getCurrUserId());
        dyColl.add((Object)dy);
        return dy;
    }

    private void setTaskDyStatus(RequestContext requestContext, DynamicObject[] taskDyArry, TaskStatusEnum taskStatusEnum) {
        long userId = requestContext.getCurrUserId();
        Date date = new Date();
        for (DynamicObject dy : taskDyArry) {
            dy.set("taskstatus", (Object)taskStatusEnum.getValue());
            dy.set("modifier", (Object)userId);
            dy.set("modifytime", (Object)date);
            if (taskStatusEnum != TaskStatusEnum.PROCESSING) continue;
            dy.set("starttime", (Object)date);
        }
        PERF_SUM_CAL_ENTITY_SERVICE.save(taskDyArry);
    }
}

