/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.perfsumcal.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.mp.entityservice.MpCalcItemEntityService;
import kd.opmc.epa.business.domain.mp.enums.MpLevelSetEnum;
import kd.opmc.epa.business.domain.mp.enums.MpSopEndWayEnum;
import kd.opmc.epa.business.domain.mp.enums.MpSopGenWayEnum;
import kd.opmc.epa.business.domain.mp.enums.MprSourceEnum;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumCalErrorInfo;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumCalResultBo;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumCalDomainService;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.PerfSumDataSourceEnum;
import kd.opmc.epa.common.enums.activitymanage.PerfSumTaskTypeEnum;
import kd.opmc.epa.common.enums.evaluat.ResSyncStatusEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.common.utils.ListUtils;

public class PerfSumDomainService {
    private static final Log log = LogFactory.getLog(PerfSumDomainService.class);
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final ObjsetScoreRecordDomainService OBJSET_SCORERECORD_ENTITY_SERVICE = ObjsetScoreRecordDomainService.getInstance();
    private static final MpCalcItemEntityService MP_CALC_ITEM_ENTITY_SERVICE = MpCalcItemEntityService.getInstance();
    private static final PerfSumCalDomainService PERF_SUM_CAL_ENTITY_SERVICE = PerfSumCalDomainService.getInstance();
    private static final ActEvalObjManageDomainService EVAL_OBJ_DOMAIN = ActEvalObjManageDomainService.getInstance();
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();

    public static PerfSumDomainService getInstance() {
        return ServiceFactory.getService(PerfSumDomainService.class);
    }

    public void upgradeSetScoreRecord() {
        QFilter recordFilter = new QFilter("assessnode", "=", (Object)0L);
        recordFilter.or("assessnode", "is null", (Object)"");
        DynamicObject[] setScoreRecordArr = OBJSET_SCORERECORD_ENTITY_SERVICE.query("id , assessnode ,actevalobj, createtime", new QFilter[]{recordFilter});
        if (null == setScoreRecordArr || setScoreRecordArr.length <= 0) {
            return;
        }
        List<DynamicObject> list = Arrays.asList(setScoreRecordArr);
        ListUtils.excute(list, (int)500, this::batchUpgradeSetScoreRecord);
    }

    private void batchUpgradeSetScoreRecord(List<DynamicObject> setScoreRecordList) {
        if (CollectionUtils.isEmpty(setScoreRecordList)) {
            return;
        }
        List evalIdList = setScoreRecordList.stream().map(setScoreRecord -> setScoreRecord.getLong("actevalobj")).collect(Collectors.toList());
        QFilter actRecordFilter = new QFilter("actevalobj", "in", evalIdList);
        actRecordFilter.and("assessnode", "=", (Object)AssessNodeStatusEnum.TO_BE_CONFIRMED.getNodeId());
        DynamicObject[] actRecordArr = ACTIVITY_RECORD_ENTITY.query("id ,actevalobj, endtime,createtime ", new QFilter[]{actRecordFilter});
        Map<Long, List<DynamicObject>> setScoreRecordMap = setScoreRecordList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("actevalobj")));
        Map<Long, List<DynamicObject>> actRecordMap = Arrays.asList(actRecordArr).stream().collect(Collectors.groupingBy(obj -> obj.getLong("actevalobj")));
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        for (Map.Entry<Long, List<DynamicObject>> entry : setScoreRecordMap.entrySet()) {
            Long entryId = entry.getKey();
            List<DynamicObject> setScoreRecordDyList = entry.getValue();
            List<DynamicObject> actRecordList = actRecordMap.get(entryId);
            for (DynamicObject setScoreRecordDy : setScoreRecordDyList) {
                if (CollectionUtils.isEmpty(actRecordList)) {
                    setScoreRecordDy.set("assessnode", (Object)AssessNodeStatusEnum.EVALUATED.getNodeId());
                    dyColl.add((Object)setScoreRecordDy);
                    continue;
                }
                Date createTime = setScoreRecordDy.getDate("createtime");
                boolean isEvalNode = Boolean.TRUE;
                for (DynamicObject actRecordDy : actRecordList) {
                    Date actRecordCreateTime = actRecordDy.getDate("createtime");
                    if (createTime.before(actRecordCreateTime)) continue;
                    isEvalNode = Boolean.FALSE;
                }
                if (isEvalNode) {
                    setScoreRecordDy.set("assessnode", (Object)AssessNodeStatusEnum.EVALUATED.getNodeId());
                } else {
                    setScoreRecordDy.set("assessnode", (Object)AssessNodeStatusEnum.TO_BE_CONFIRMED.getNodeId());
                }
                dyColl.add((Object)setScoreRecordDy);
            }
        }
        OBJSET_SCORERECORD_ENTITY_SERVICE.save(dyColl);
    }

    public int dealSumCal(StringBuilder message, DynamicObject[] evalDyArr, int nodeIndex, Long activityId) {
        if (HRObjectUtils.isEmpty((Object)message) || HRObjectUtils.isEmpty((Object)evalDyArr)) {
            return 0;
        }
        int failureCount = 0;
        DynamicObjectCollection evalDyColl = new DynamicObjectCollection();
        DynamicObjectCollection activityRecordDyColl = new DynamicObjectCollection();
        for (DynamicObject evalDy2 : evalDyArr) {
            int evalNodeIndex = evalDy2.getInt("nodeindex");
            if (!(1 == nodeIndex && AssessStausEnum.JOINED.getStatus().equals(evalDy2.get("assessstaus")) || NodeTabMapEnum.PERF_SUM.getNodeId().equals(evalDy2.getLong("assessnode.id")) && AssessNodeStatusEnum.MPING.getStatus().equals(evalDy2.getString("nodestatus")) || evalNodeIndex + 1 == nodeIndex && "30".equals(evalDy2.getString("nodestatus")))) {
                message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09:\u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u7ed3\u679c\u6c47\u603b-\u5f85\u6c47\u603b\u5217\u8868\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"PerfSumDomainService_0", (String)"opmc-pbs-business", (Object[])new Object[]{evalDy2.getString("perffile.name"), evalDy2.getString("perffile.billno")})).append("\r\n");
                ++failureCount;
                continue;
            }
            evalDyColl.add((Object)evalDy2);
        }
        if (CollectionUtils.isNotEmpty((Collection)evalDyColl)) {
            List<Long> evalIdList = evalDyColl.stream().map(evalDy -> evalDy.getLong("id")).collect(Collectors.toList());
            PerfSumCalResultBo perfSumCalResultBo = PERF_SUM_CAL_ENTITY_SERVICE.batchCalPerfSumData(evalIdList, PerfSumTaskTypeEnum.ARTIF_EXC);
            Map<Long, DynamicObject> evalDyMap = evalDyColl.stream().collect(Collectors.toMap(evalDy -> evalDy.getLong("id"), v -> v, (key1, key2) -> key1));
            List<PerfSumCalErrorInfo> errorInfoList = perfSumCalResultBo.getErrorInfoList();
            if (errorInfoList.size() > 0) {
                for (PerfSumCalErrorInfo errorInfo : errorInfoList) {
                    DynamicObject evalInfoDy = evalDyMap.get(errorInfo.getEvalObjId());
                    message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09:{2}", (String)"PerfSumDomainService_1", (String)"opmc-pbs-business", (Object[])new Object[]{evalInfoDy.getString("perffile.name"), evalInfoDy.getString("perffile.billno"), errorInfo.getErrorMsg()})).append("\r\n");
                    ++failureCount;
                }
            }
        }
        return failureCount;
    }

    private Map<String, Long> reqPerfSumScoreAndLevel(DynamicObject activityDy) {
        HashMap scoreAndLevelMap = Maps.newHashMapWithExpectedSize((int)16);
        long perfWorkFlowId = activityDy.getLong("perfworkflow.id");
        boolean isAloneSum = EVAL_OBJ_DOMAIN.isDependentSummary(perfWorkFlowId);
        DynamicObject perfWorkFlowDy = PERF_WORK_FLOW_ENTITY_SERVICE.queryOne(perfWorkFlowId);
        Boolean isMpSopExchange = perfWorkFlowDy.getBoolean("ismpsopexchange");
        Boolean isMpLevelExchange = perfWorkFlowDy.getBoolean("ismplevelexchange");
        String mpLevelSet = perfWorkFlowDy.getString("mplevelset");
        Long scoreSystemIdByFlow = perfWorkFlowDy.getLong("scoresystem.id");
        Long sumPerfLevelIdByFlow = perfWorkFlowDy.getLong("sumperflevel.id");
        if (isAloneSum) {
            if (isMpSopExchange.booleanValue()) {
                scoreAndLevelMap.put("scoreSystem", scoreSystemIdByFlow);
            }
            if (isMpLevelExchange.booleanValue()) {
                scoreAndLevelMap.put("scoreSystem", scoreSystemIdByFlow);
                scoreAndLevelMap.put("sumPerfLevel", sumPerfLevelIdByFlow);
            }
            return scoreAndLevelMap;
        }
        long assessFormId = activityDy.getLong("assessform.id");
        DynamicObject assessFormDy = ASSESS_FORM_ENTITY_SERVICE.queryAssessForm(assessFormId);
        Long scoreSystemIdByForm = assessFormDy.getLong("scoresystem.id");
        scoreAndLevelMap.put("scoreSystem", scoreSystemIdByForm);
        if (isMpLevelExchange.booleanValue()) {
            if (HRStringUtils.isNotEmpty((String)mpLevelSet) && mpLevelSet.equals(MpLevelSetEnum.SAME_AS_ASSESSFORM.getCode())) {
                Long sumPerfLevelIdForm = assessFormDy.getLong("sumperflevel.id");
                scoreAndLevelMap.put("sumPerfLevel", sumPerfLevelIdForm);
                return scoreAndLevelMap;
            }
            scoreAndLevelMap.put("sumPerfLevel", sumPerfLevelIdByFlow);
        }
        return scoreAndLevelMap;
    }

    private Map<String, Long> reqFormScoreAndLevel(DynamicObject activityDy, boolean isAloneSum) {
        HashMap scoreAndLevelMap = Maps.newHashMapWithExpectedSize((int)16);
        if (isAloneSum) {
            return scoreAndLevelMap;
        }
        long assessFormId = activityDy.getLong("assessform.id");
        DynamicObject assessFormDy = ASSESS_FORM_ENTITY_SERVICE.queryAssessForm(assessFormId);
        Long scoreSystemIdByForm = assessFormDy.getLong("scoresystem.id");
        scoreAndLevelMap.put("scoreSystem", scoreSystemIdByForm);
        Long sumPerfLevelIdForm = assessFormDy.getLong("sumperflevel.id");
        scoreAndLevelMap.put("sumPerfLevel", sumPerfLevelIdForm);
        return scoreAndLevelMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dealEndEvalSum(StringBuilder message, DynamicObject[] evalDyArr, int nodeIndex, Long activityId) {
        if (HRObjectUtils.isEmpty((Object)message) || HRObjectUtils.isEmpty((Object)evalDyArr)) {
            return 0;
        }
        int failureCount = 0;
        DynamicObjectCollection evalDyColl = new DynamicObjectCollection();
        DynamicObjectCollection activityRecordDyColl = new DynamicObjectCollection();
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        Map<String, Long> scoreAndLevelMap = this.reqPerfSumScoreAndLevel(activityDy);
        DynamicObjectCollection timeplanEntry = activityDy.getDynamicObjectCollection("timeplanentry");
        boolean isLastNode = timeplanEntry.size() == nodeIndex;
        long userId = UserServiceHelper.getCurrentUserId();
        Date date = new Date();
        for (DynamicObject evalDy : evalDyArr) {
            int evalNodeIndex = evalDy.getInt("nodeindex");
            Boolean isMpCalc = evalDy.getBoolean("ismpcalc");
            String mpsopgenway = evalDy.getString("mpsopgenway");
            if (!(isMpCalc.booleanValue() || mpsopgenway.equals(MpSopGenWayEnum.RESULT_MODIFY.getCode()) || mpsopgenway.equals(MpSopGenWayEnum.RESULT_IMPORT.getCode()))) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message.append("\r\n");
                }
                message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09:\u8bc4\u4f30\u5bf9\u8c61\u65e0\u6c47\u603b\u7ed3\u679c\uff0c\u4e0d\u53ef\u7ed3\u675f\u6c47\u603b\u3002", (String)"PerfSumDomainService_2", (String)"opmc-pbs-business", (Object[])new Object[]{evalDy.getString("perffile.name"), evalDy.getString("perffile.billno")}));
                ++failureCount;
                continue;
            }
            if (!(1 == nodeIndex && AssessStausEnum.JOINED.getStatus().equals(evalDy.get("assessstaus")) || NodeTabMapEnum.PERF_SUM.getNodeId().equals(evalDy.getLong("assessnode.id")) && AssessNodeStatusEnum.MPING.getStatus().equals(evalDy.getString("nodestatus")) || evalNodeIndex + 1 == nodeIndex && "30".equals(evalDy.getString("nodestatus")))) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message.append("\r\n");
                }
                message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09:\u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u7ed3\u679c\u6c47\u603b-\u5f85\u6c47\u603b\u5217\u8868\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"PerfSumDomainService_0", (String)"opmc-pbs-business", (Object[])new Object[]{evalDy.getString("perffile.name"), evalDy.getString("perffile.billno")}));
                ++failureCount;
                continue;
            }
            activityRecordDyColl.add((Object)this.addActivityRecord(nodeIndex, evalDy, date, userId));
            evalDy.set("modifier", (Object)userId);
            evalDy.set("modifytime", (Object)date);
            evalDy.set("fsop", evalDy.get("mpsop"));
            evalDy.set("flop", evalDy.get("mplop"));
            evalDy.set("fsopsource", (Object)"mpsop");
            evalDy.set("fsopscoresystem", (Object)scoreAndLevelMap.get("scoreSystem"));
            evalDy.set("floplevel", (Object)scoreAndLevelMap.get("sumPerfLevel"));
            evalDy.set("mpsopendway", (Object)MpSopEndWayEnum.END_SUMMARY.getCode());
            evalDy.set("perffilev", evalDy.get("perffile.sourcevid"));
            if (isLastNode) {
                evalDy.set("assessstaus", (Object)AssessStausEnum.COMPLETED.getStatus());
                evalDy.set("assessnode", null);
                evalDy.set("nodeindex", null);
                evalDy.set("nodestatus", null);
                evalDy.set("completetime", (Object)date);
            } else {
                evalDy.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
                evalDy.set("nodeindex", (Object)nodeIndex);
                evalDy.set("assessnode", (Object)NodeTabMapEnum.PERF_SUM.getNodeId());
                evalDy.set("nodestatus", (Object)AssessNodeStatusEnum.MPED.getStatus());
            }
            evalDyColl.add((Object)evalDy);
        }
        if (evalDyColl.size() > 0) {
            try (TXHandle txhandle = TX.required();){
                ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evalDyColl);
                ACTIVITY_RECORD_ENTITY.save(activityRecordDyColl);
            }
        }
        return failureCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dealResetEvalSumByInter(List<Long> evalId, Long activityId) {
        if (CollectionUtils.isEmpty(evalId) || null == activityId || 0L == activityId) {
            return Boolean.FALSE;
        }
        QFilter evalFilter = new QFilter("activity", "=", (Object)activityId);
        evalFilter.and("id", "in", evalId);
        DynamicObject[] evalDyArr = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id,nodeindex,assessstaus,nodestatus,assessnode,creator, createtime, modifier,modifytime, completetime , sop, lop , fsop,flop ,fsopsource,fsopscoresystem,floplevel,mpsop,mplop,mpsopendway,mpsopflag,iscurperiod,mpsopgenway,ismprmodify,mpgroup,mprule,mprealrule,mprsource,ismpcalc,mpcalcerrmsg,mpsopsource", new QFilter[]{evalFilter});
        DynamicObjectCollection evalDyColl = new DynamicObjectCollection();
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        long perfWorkFlowId = activityDy.getLong("perfworkflow.id");
        boolean isAloneSum = EVAL_OBJ_DOMAIN.isDependentSummary(perfWorkFlowId);
        Map<String, Long> scoreAndLevelMap = this.reqFormScoreAndLevel(activityDy, isAloneSum);
        DynamicObjectCollection timeplanEntry = activityDy.getDynamicObjectCollection("timeplanentry");
        Long assessnode = NodeTabMapEnum.PERF_SUM.getNodeId();
        boolean isFirstNode = Boolean.FALSE;
        int size = timeplanEntry.size();
        int nodeIndex = 0;
        for (int index = 0; index < size; ++index) {
            DynamicObject timePlanDy = (DynamicObject)timeplanEntry.get(index);
            Long assessNodeId = timePlanDy.getLong("activity.id");
            if (assessNodeId.longValue() != NodeTabMapEnum.PERF_SUM.getNodeId().longValue()) continue;
            if (index == 0) {
                isFirstNode = Boolean.TRUE;
                nodeIndex = index + 1;
                break;
            }
            nodeIndex = index + 1;
            assessnode = ((DynamicObject)timeplanEntry.get(index - 1)).getLong("activity.id");
            break;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        Date date = new Date();
        ArrayList evalIdList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject evalDy : evalDyArr) {
            Boolean isCurPeriod = evalDy.getBoolean("iscurperiod");
            evalDy.set("mpsop", (Object)BigDecimal.ZERO);
            evalDy.set("mplop", (Object)"");
            evalDy.set("fsop", evalDy.get("sop"));
            evalDy.set("flop", evalDy.get("lop"));
            if (isAloneSum) {
                evalDy.set("fsopsource", null);
            } else {
                evalDy.set("fsopsource", (Object)"sop");
            }
            evalDy.set("ismpcalc", (Object)Boolean.FALSE);
            evalDy.set("modifier", (Object)userId);
            evalDy.set("modifytime", (Object)date);
            evalDy.set("mpsopendway", null);
            evalDy.set("mpsopgenway", null);
            evalDy.set("mpsopflag", null);
            evalDy.set("completetime", null);
            evalDy.set("mpcalcerrmsg", null);
            evalDy.set("ismprmodify", (Object)Boolean.FALSE);
            evalDy.set("mpgroup", null);
            evalDy.set("mprsource", null);
            evalDy.set("mprule", null);
            evalDy.set("mprealrule", null);
            if (isFirstNode) {
                evalDy.set("assessstaus", (Object)AssessStausEnum.JOINED.getStatus());
            } else {
                evalDy.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
            }
            if (!isCurPeriod.booleanValue()) {
                evalDy.set("assessnode", (Object)NodeTabMapEnum.PERF_SUM.getNodeId());
                evalDy.set("nodeindex", (Object)nodeIndex);
                evalDy.set("nodestatus", (Object)AssessNodeStatusEnum.MPING.getStatus());
                evalDy.set("fsopscoresystem", null);
                evalDy.set("floplevel", null);
            }
            if (isCurPeriod.booleanValue()) {
                evalDy.set("fsopscoresystem", (Object)scoreAndLevelMap.get("scoreSystem"));
                evalDy.set("floplevel", (Object)scoreAndLevelMap.get("sumPerfLevel"));
                if (isFirstNode) {
                    evalDy.set("assessnode", null);
                    evalDy.set("nodeindex", null);
                    evalDy.set("nodestatus", null);
                } else {
                    evalDy.set("assessnode", (Object)assessnode);
                    evalDy.set("nodeindex", (Object)(nodeIndex - 1));
                    evalDy.set("nodestatus", (Object)"30");
                }
            }
            evalIdList.add(evalDy.getLong("id"));
            evalDyColl.add((Object)evalDy);
        }
        if (evalIdList.size() > 0) {
            try (TXHandle txhandle = TX.required();){
                ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evalDyColl);
                QFilter recordFilter = new QFilter("actevalobj", "in", (Object)evalIdList);
                recordFilter.and("activity", "=", (Object)activityId);
                recordFilter.and("assessnode", "=", (Object)AssessNodeStatusEnum.MPED.getNodeId());
                ACTIVITY_RECORD_ENTITY.deleteByFilter(new QFilter[]{recordFilter});
                OBJSET_SCORERECORD_ENTITY_SERVICE.deleteByFilter(new QFilter[]{recordFilter});
                QFilter mpCalcItemFilter = new QFilter("evaobj", "in", (Object)evalIdList);
                mpCalcItemFilter.and("datasource", "=", (Object)PerfSumDataSourceEnum.EVAL_OBJ.getCode());
                MP_CALC_ITEM_ENTITY_SERVICE.deleteByFilter(new QFilter[]{mpCalcItemFilter});
            }
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dealResetEvalSum(StringBuilder message, DynamicObject[] evalDyArr, int nodeIndex, Long activityId) {
        if (HRObjectUtils.isEmpty((Object)message) || HRObjectUtils.isEmpty((Object)evalDyArr)) {
            return 0;
        }
        int failureCount = 0;
        DynamicObjectCollection evalDyColl = new DynamicObjectCollection();
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        long perfWorkFlowId = activityDy.getLong("perfworkflow.id");
        boolean isAloneSum = EVAL_OBJ_DOMAIN.isDependentSummary(perfWorkFlowId);
        Map<String, Long> scoreAndLevelMap = this.reqFormScoreAndLevel(activityDy, isAloneSum);
        DynamicObjectCollection timeplanEntry = activityDy.getDynamicObjectCollection("timeplanentry");
        boolean isFirstNode = nodeIndex == 1;
        Long assessnode = this.requireBeforeAssessNode(NodeTabMapEnum.PERF_SUM.getNodeId(), timeplanEntry);
        boolean isLastNode = timeplanEntry.size() == nodeIndex;
        long userId = UserServiceHelper.getCurrentUserId();
        Date date = new Date();
        ArrayList evalIdList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject evalDy : evalDyArr) {
            Boolean isCurPeriod = evalDy.getBoolean("iscurperiod");
            if (isLastNode && StringUtils.equals((CharSequence)evalDy.getString("ressyncstatus"), (CharSequence)ResSyncStatusEnum.ARCHIVED.getCode())) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message.append("\r\n");
                }
                message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09:\u7ee9\u6548\u7ed3\u679c\u5df2\u5f52\u6863\uff0c\u4e0d\u53ef\u91cd\u7f6e\u3002", (String)"PerfSumDomainService_3", (String)"opmc-pbs-business", (Object[])new Object[]{evalDy.getString("perffile.name"), evalDy.getString("perffile.billno")}));
                ++failureCount;
                continue;
            }
            if (!(isLastNode || NodeTabMapEnum.PERF_SUM.getNodeId().equals(evalDy.get("assessnode.id")) && AssessNodeStatusEnum.MPED.getStatus().equals(evalDy.get("nodestatus")))) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message.append("\r\n");
                }
                message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09:\u5df2\u4e0d\u5728\u7ed3\u679c\u6c47\u603b-\u5df2\u5b8c\u6210\uff0c\u4e0d\u53ef\u91cd\u7f6e\u3002", (String)"PerfSumDomainService_4", (String)"opmc-pbs-business", (Object[])new Object[]{evalDy.getString("perffile.name"), evalDy.getString("perffile.billno")}));
                ++failureCount;
                continue;
            }
            evalDy.set("mpsop", (Object)BigDecimal.ZERO);
            evalDy.set("mplop", (Object)"");
            evalDy.set("fsop", evalDy.get("sop"));
            evalDy.set("flop", evalDy.get("lop"));
            if (isAloneSum) {
                evalDy.set("fsopsource", null);
            } else {
                evalDy.set("fsopsource", (Object)"sop");
            }
            evalDy.set("ismpcalc", (Object)Boolean.FALSE);
            evalDy.set("modifier", (Object)userId);
            evalDy.set("modifytime", (Object)date);
            evalDy.set("mpsopendway", null);
            evalDy.set("mpsopgenway", null);
            evalDy.set("mpsopflag", null);
            evalDy.set("completetime", null);
            evalDy.set("mpcalcerrmsg", null);
            evalDy.set("ismprmodify", (Object)Boolean.FALSE);
            evalDy.set("mpgroup", null);
            evalDy.set("mprsource", null);
            evalDy.set("mprule", null);
            evalDy.set("mprealrule", null);
            if (isFirstNode) {
                evalDy.set("assessstaus", (Object)AssessStausEnum.JOINED.getStatus());
            } else {
                evalDy.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
            }
            if (!isCurPeriod.booleanValue()) {
                evalDy.set("assessnode", (Object)NodeTabMapEnum.PERF_SUM.getNodeId());
                evalDy.set("nodeindex", (Object)nodeIndex);
                evalDy.set("nodestatus", (Object)AssessNodeStatusEnum.MPING.getStatus());
                evalDy.set("fsopscoresystem", null);
                evalDy.set("floplevel", null);
            }
            if (isCurPeriod.booleanValue()) {
                evalDy.set("fsopscoresystem", (Object)scoreAndLevelMap.get("scoreSystem"));
                evalDy.set("floplevel", (Object)scoreAndLevelMap.get("sumPerfLevel"));
                if (isFirstNode) {
                    evalDy.set("assessnode", null);
                    evalDy.set("nodeindex", null);
                    evalDy.set("nodestatus", null);
                } else {
                    evalDy.set("assessnode", (Object)assessnode);
                    evalDy.set("nodeindex", (Object)(nodeIndex - 1));
                    evalDy.set("nodestatus", (Object)"30");
                }
            }
            evalIdList.add(evalDy.getLong("id"));
            evalDyColl.add((Object)evalDy);
        }
        if (evalIdList.size() > 0) {
            try (TXHandle txhandle = TX.required();){
                ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evalDyColl);
                QFilter recordFilter = new QFilter("actevalobj", "in", (Object)evalIdList);
                recordFilter.and("activity", "=", (Object)activityId);
                recordFilter.and("assessnode", "=", (Object)AssessNodeStatusEnum.MPED.getNodeId());
                ACTIVITY_RECORD_ENTITY.deleteByFilter(new QFilter[]{recordFilter});
                OBJSET_SCORERECORD_ENTITY_SERVICE.deleteByFilter(new QFilter[]{recordFilter});
                QFilter mpCalcItemFilter = new QFilter("evaobj", "in", (Object)evalIdList);
                mpCalcItemFilter.and("datasource", "=", (Object)PerfSumDataSourceEnum.EVAL_OBJ.getCode());
                MP_CALC_ITEM_ENTITY_SERVICE.deleteByFilter(new QFilter[]{mpCalcItemFilter});
            }
        }
        return failureCount;
    }

    public boolean clearPerfSumData(Long activityId) {
        DynamicObject[] evalDyArr;
        QFilter evalFilter = new QFilter("activity", "=", (Object)activityId);
        for (DynamicObject evalDy : evalDyArr = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id  , mpsop,mplop,mpsopendway,mpsopflag,iscurperiod,mpsopgenway,ismprmodify,mpgroup,mprule,mprealrule,mprsource,ismpcalc,mpcalcerrmsg,mpsopsource", new QFilter[]{evalFilter})) {
            evalDy.set("mpsop", null);
            evalDy.set("mplop", null);
            evalDy.set("mpcalcerrmsg", null);
            evalDy.set("ismpcalc", (Object)Boolean.FALSE);
            evalDy.set("mpsopgenway", null);
            evalDy.set("mpsopflag", null);
        }
        if (evalDyArr.length > 0) {
            ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evalDyArr);
        }
        return Boolean.TRUE;
    }

    public boolean clearPerfSumDataSyncScheme(Long activityId) {
        DynamicObject[] evalDyArr;
        QFilter evalFilter = new QFilter("activity", "=", (Object)activityId);
        evalFilter.and("mprsource", "=", (Object)MprSourceEnum.FORM_ACTIVITY.getCode());
        for (DynamicObject evalDy : evalDyArr = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("id  , mpsop,mplop,mpsopendway,mpsopflag,iscurperiod,mpsopgenway,ismprmodify,mpgroup,mprule,mprealrule,mprsource,ismpcalc,mpcalcerrmsg,mpsopsource", new QFilter[]{evalFilter})) {
            evalDy.set("mpsop", null);
            evalDy.set("mplop", null);
            evalDy.set("mpcalcerrmsg", null);
            evalDy.set("mpsopflag", null);
            evalDy.set("ismpcalc", (Object)Boolean.FALSE);
            evalDy.set("mpsopgenway", null);
            evalDy.set("mprealrule", null);
            evalDy.set("mprsource", null);
        }
        if (evalDyArr.length > 0) {
            ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evalDyArr);
        }
        return Boolean.TRUE;
    }

    public Long requireBeforeAssessNode(Long curAssessNode, DynamicObjectCollection timeplanEntry) {
        if (CollectionUtils.isEmpty((Collection)timeplanEntry)) {
            return curAssessNode;
        }
        for (int index = 0; index < timeplanEntry.size(); ++index) {
            DynamicObject timePlanDy = (DynamicObject)timeplanEntry.get(index);
            Long assessNodeId = timePlanDy.getLong("activity.id");
            if (assessNodeId.longValue() != curAssessNode.longValue()) continue;
            return index == 0 ? curAssessNode.longValue() : ((DynamicObject)timeplanEntry.get(index - 1)).getLong("activity.id");
        }
        return curAssessNode;
    }

    private DynamicObject addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.MPED.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.MPED.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
        return activityRecord;
    }
}

