/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.perfsumcal.service;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalfinishtypeEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.mp.entityservice.MpCalcItemEntityService;
import kd.opmc.epa.business.domain.mp.enums.MpLevelSetEnum;
import kd.opmc.epa.business.domain.mp.enums.MpSopEndWayEnum;
import kd.opmc.epa.business.domain.mp.enums.MpSopGenWayEnum;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumResultSetBo;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.constants.PerformSummaryConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.activitymanage.PerfSumDataSourceEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;

public class PerfSumResultDomainService {
    private static final Log log = LogFactory.getLog(PerfSumResultDomainService.class);
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();
    private static final ObjsetScoreRecordDomainService OBJSET_SCORE_RECORD_DOMAIN_SERVICE = ObjsetScoreRecordDomainService.getInstance();
    private static final MpCalcItemEntityService MP_CALC_ITEM_ENTITY_SERVICE = MpCalcItemEntityService.getInstance();
    private static final ActEvalObjManageDomainService ACT_EVALOBJ_MANAGE_DOMAIN_SERVICE = ActEvalObjManageDomainService.getInstance();

    public static PerfSumResultDomainService getInstance() {
        return ServiceFactory.getService(PerfSumResultDomainService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> notSummary(IFormView view, DynamicObject[] evaluationObjects) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long activityId = (Long)formShowParameter.getCustomParam("activity");
        Integer nodeIndex = (Integer)formShowParameter.getCustomParam("nodeindex");
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        Date date = new Date();
        DynamicObjectCollection recodeDyColl = new DynamicObjectCollection();
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<String> failMessage = new ArrayList<String>(10);
        ArrayList<Long> evalIdList = new ArrayList<Long>(10);
        for (int index = 0; index < evaluationObjects.length; ++index) {
            boolean isLastNode;
            DynamicObject evalObj = evaluationObjects[index];
            if (this.checkEvaObjNotInToBeMP(nodeIndex, evalObj)) {
                failMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0} {1}: \u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u7ed3\u679c\u6c47\u603b-\u5f85\u6c47\u603b\u5217\u8868\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"PerfSumResultDomainService_0", (String)"opmc-epa-business", (Object[])new Object[0]), evalObj.getString("person.name"), evalObj.getString("person.number")));
                continue;
            }
            Object iscurperiod = evalObj.get("iscurperiod");
            if (iscurperiod != null && !((Boolean)iscurperiod).booleanValue()) {
                failMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0} {1}: \u975e\u672c\u5468\u671f\u8003\u6838\u7684\u8bc4\u4f30\u5bf9\u8c61\u4e0d\u53ef\u201c\u4e0d\u6c47\u603b\u201d", (String)"PerfSumResultDomainService_1", (String)"opmc-epa-business", (Object[])new Object[0]), evalObj.getString("person.name"), evalObj.getString("person.number")));
                continue;
            }
            evalObj.set("nodestatus", (Object)AssessNodeStatusEnum.MPED.getStatus());
            evalObj.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
            evalObj.set("assessnode", (Object)NodeTabMapEnum.PERF_SUM.getNodeId());
            evalObj.set("nodeindex", (Object)nodeIndex);
            DynamicObject recodeDy = this.addActivityRecord(evalObj.getInt("nodeindex"), evalObj, date, userId);
            recodeDyColl.add((Object)recodeDy);
            evalObj.set(AssessScoreAbbrEnum.MPLOP.getCode(), null);
            evalObj.set(AssessScoreAbbrEnum.MPSOP.getCode(), null);
            evalObj.set("mpsopgenway", null);
            evalObj.set("ismprmodify", (Object)false);
            evalObj.set("ismpcalc", (Object)Boolean.FALSE);
            evalObj.set("mpsopflag", null);
            evalObj.set("mpcalcerrmsg", null);
            evalObj.set("mpgroup", null);
            evalObj.set("mprsource", null);
            evalObj.set("mprealrule", null);
            evalObj.set("mpsopendway", (Object)MpSopEndWayEnum.NOT_SUMMARY.getCode());
            evalObj.set("modifier", (Object)userId);
            evalObj.set("modifytime", (Object)date);
            evalObj.set("perffilev", evalObj.get("perffile.sourcevid"));
            DynamicObjectCollection timeplanEntry = activityDy.getDynamicObjectCollection("timeplanentry");
            boolean bl = isLastNode = ((DynamicObject)timeplanEntry.get(timeplanEntry.size() - 1)).getLong("activity.index") == AssessNodeStatusEnum.MPED.getNodeId().longValue();
            if (isLastNode) {
                evalObj.set("assessstaus", (Object)AssessStausEnum.COMPLETED.getStatus());
                evalObj.set("assessnode", null);
                evalObj.set("nodeindex", null);
                evalObj.set("nodestatus", null);
                evalObj.set("completetime", (Object)date);
            }
            evalIdList.add(evalObj.getLong("id"));
        }
        if (recodeDyColl.size() > 0) {
            try (TXHandle txhandle = TX.required();){
                EvalObjUtils.saveRecordEntityColl(recodeDyColl);
                ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evaluationObjects);
                QFilter mpCalcItemFilter = new QFilter("evaobj", "in", evalIdList);
                mpCalcItemFilter.and("datasource", "=", (Object)PerfSumDataSourceEnum.EVAL_OBJ.getCode());
                MP_CALC_ITEM_ENTITY_SERVICE.deleteByFilter(new QFilter[]{mpCalcItemFilter});
            }
        }
        return failMessage;
    }

    public DynamicObject addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.TO_BE_MP.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.MPED.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        Long activityId = evaluationObj.getLong("activity.id");
        if (activityId == null || activityId == 0L) {
            activityId = evaluationObj.getLong("activity");
        }
        activityRecord.set("activity", (Object)activityId);
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        return activityRecord;
    }

    public boolean checkEvaObjNotInToBeMP(Integer nodeIndex, DynamicObject evalObj) {
        if (evalObj == null) {
            return true;
        }
        int evaNodeIndex = evalObj.getInt("nodeindex");
        String evaNodeStatus = evalObj.getString("nodestatus");
        if (nodeIndex == null) {
            nodeIndex = 1;
        }
        if (nodeIndex <= 1) {
            boolean isJoined = HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.JOINED.getStatus());
            if (isJoined) {
                return false;
            }
        } else {
            boolean isAssessProcessing = HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.HAVE_IN_HAND.getStatus());
            if (!isAssessProcessing) {
                return true;
            }
            if (evaNodeIndex != nodeIndex) {
                boolean isPreNodeCompleted = HRStringUtils.equals((String)evaNodeStatus, (String)AssessNodeStatusEnum.EVALUATED.getStatus());
                return !isPreNodeCompleted;
            }
        }
        return HRStringUtils.equals((String)evaNodeStatus, (String)AssessNodeStatusEnum.MPED.getStatus());
    }

    public DynamicObject[] queryEvalObjWithMpResultById(List<Long> evalObjectIdList) {
        QFilter idFilter = new QFilter("id", "in", evalObjectIdList);
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query(" perffile.name,perffile.billno,perffile.sourcevid,perffilev.id, person.name,person.number, assessnode, nodestatus,nodeindex, assessstaus, perforg.id, assessperiod,assessyear,activity.id, creator, createtime, modifier,modifytime,  mpsop,mplop,mpsopendway,mpsopgenway,completetime,iscurperiod,ismprmodify,mpsopflag,mprsource,ismpcalc,mpcalcerrmsg,mprsource,mprealrule,mpgroup", new QFilter[]{idFilter}, "modifytime desc");
    }

    public boolean isScoreMappingLeval(Long scoreSystemId, Long sumPerfLevelId) {
        if (scoreSystemId == null || sumPerfLevelId == null) {
            return false;
        }
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelId);
        DynamicObjectCollection scoreMapEntry = sumPerfLevel.getDynamicObjectCollection("scoremapentryentity");
        DynamicObject scoreMapDy = scoreMapEntry.stream().filter(scoreMap -> scoreMap.getLong("scoresystem.id") == scoreSystemId.longValue()).findFirst().orElse(null);
        if (scoreMapDy == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public DynamicObject queryAssessFormByActivity(Long id) {
        String selectFields = "id, assessform.id, perfworkflow.id";
        QFilter filter = new QFilter("id", "=", (Object)id);
        return ACTIVITY_ENTITY_SERVICE.queryOne(selectFields, new QFilter[]{filter});
    }

    public DynamicObject queryWorkFlowById(Long id) {
        String selectFields = "id, mplevelset, mpnumaccuracy, mpscaletype, scoresystem.id,scoresystem.maxscore,scoresystem.minscore, sumperflevel.id,ismpsopexchange,ismplevelexchange";
        QFilter filter = new QFilter("id", "=", (Object)id);
        return PERF_WORK_FLOW_ENTITY_SERVICE.queryOne(selectFields, new QFilter[]{filter});
    }

    public String calcLevelByScore(Long sumPerfLevelId, Long scoreSystemId, BigDecimal score) {
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelId);
        DynamicObjectCollection scoreMapEntry = sumPerfLevel.getDynamicObjectCollection("scoremapentryentity");
        DynamicObject scoreMapDy = scoreMapEntry.stream().filter(scoreMap -> scoreMap.getLong("scoresystem.id") == scoreSystemId.longValue()).findFirst().orElse(null);
        if (scoreMapDy == null) {
            return "";
        }
        String levelScoreMap = scoreMapDy.getString("levelscoremap");
        if (HRStringUtils.equals((String)levelScoreMap, (String)"20")) {
            return null;
        }
        DynamicObjectCollection scoreLevelMapEntry = scoreMapDy.getDynamicObjectCollection("scoresubentryentity");
        for (DynamicObject scoreLevelMap : scoreLevelMapEntry) {
            BigDecimal maxScore = scoreLevelMap.getBigDecimal("maxscore");
            String scoreMaxOperation = scoreLevelMap.getString("scoremaxoperation");
            String scoreMinOperation = scoreLevelMap.getString("scoreminoperation");
            BigDecimal minScore = scoreLevelMap.getBigDecimal("minscore");
            boolean maxCompare = true;
            if (maxScore != null && maxScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMaxOperation, (String)"10")) {
                    maxCompare = maxScore.compareTo(score) > 0;
                } else if (HRStringUtils.equals((String)scoreMaxOperation, (String)"20")) {
                    maxCompare = maxScore.compareTo(score) >= 0;
                }
            }
            boolean minCompare = true;
            if (minScore != null && minScore.compareTo(BigDecimal.ZERO) != 0) {
                if (HRStringUtils.equals((String)scoreMinOperation, (String)"10")) {
                    minCompare = score.compareTo(minScore) > 0;
                } else if (HRStringUtils.equals((String)scoreMinOperation, (String)"20")) {
                    boolean bl = minCompare = score.compareTo(minScore) >= 0;
                }
            }
            if (!maxCompare || !minCompare) continue;
            DynamicObjectCollection perfLevelEntry = sumPerfLevel.getDynamicObjectCollection("entryentity");
            return String.valueOf(((DynamicObject)perfLevelEntry.get(scoreLevelMap.getInt("seq") - 1)).getPkValue());
        }
        return "";
    }

    public PerfSumResultSetBo getPerfSumDataDealSetByActivityId(Long activityId, Boolean isQueryMaxMinScore) {
        PerfSumResultSetBo perfSumResultSetBo = new PerfSumResultSetBo();
        if (activityId == null || activityId == 0L) {
            return perfSumResultSetBo;
        }
        DynamicObject activityDy = this.queryAssessFormByActivity(activityId);
        if (Objects.isNull(activityDy)) {
            return perfSumResultSetBo;
        }
        if (isQueryMaxMinScore == null) {
            isQueryMaxMinScore = Boolean.FALSE;
        }
        DynamicObject perfworkflowObj = activityDy.getDynamicObject("perfworkflow");
        String numaccuracy = "2";
        String scaletype = ScalaTypeEnum.ROUND_HALF_UP.getValue();
        HashMap<String, String> levelNameMap = new HashMap<String, String>(16);
        if (perfworkflowObj != null) {
            DynamicObject sumperflevelDy;
            long perfworkFlowId = perfworkflowObj.getLong("id");
            boolean isDependentSummary = ACT_EVALOBJ_MANAGE_DOMAIN_SERVICE.isDependentSummary(perfworkFlowId);
            DynamicObject perfWorkFlowDy = this.queryWorkFlowById(perfworkFlowId);
            String mplevelset = perfWorkFlowDy.getString("mplevelset");
            boolean ismplevelexchange = perfWorkFlowDy.getBoolean("ismplevelexchange");
            if (isDependentSummary) {
                DynamicObject scoreSystemDy;
                boolean ismpsopexchange = perfWorkFlowDy.getBoolean("ismpsopexchange");
                if (ismpsopexchange && (scoreSystemDy = perfWorkFlowDy.getDynamicObject("scoresystem")) != null) {
                    perfSumResultSetBo.setScoreSystemId(scoreSystemDy.getLong("id"));
                    if (isQueryMaxMinScore.booleanValue()) {
                        String maxscore = scoreSystemDy.getString("maxscore");
                        String minscore = scoreSystemDy.getString("minscore");
                        perfSumResultSetBo.setMaxScore(maxscore);
                        perfSumResultSetBo.setMinScore(minscore);
                    }
                }
                numaccuracy = perfWorkFlowDy.getString("mpnumaccuracy");
                scaletype = perfWorkFlowDy.getString("mpscaletype");
            } else {
                long assessFormId = activityDy.getLong("assessform.id");
                DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(assessFormId);
                if (!Objects.isNull(assessForm)) {
                    DynamicObject sumperflevelDy2;
                    numaccuracy = assessForm.getString("numaccuracy");
                    scaletype = assessForm.getString("scaletype");
                    DynamicObject scoresystemDy = assessForm.getDynamicObject("scoresystem");
                    if (scoresystemDy != null) {
                        perfSumResultSetBo.setScoreSystemId(scoresystemDy.getLong("id"));
                    }
                    if (isQueryMaxMinScore.booleanValue()) {
                        Map<String, String> dataSetByAssessForm = this.getDataSetByAssessForm(assessForm);
                        perfSumResultSetBo.setMinScore(dataSetByAssessForm.get("minscore"));
                        perfSumResultSetBo.setMaxScore(dataSetByAssessForm.get("maxscore"));
                    }
                    if (ismplevelexchange && !HRStringUtils.equals((String)MpLevelSetEnum.CUSTOM.getCode(), (String)mplevelset) && (sumperflevelDy2 = assessForm.getDynamicObject("sumperflevel")) != null) {
                        long sumPerfLevelId = sumperflevelDy2.getLong("id");
                        perfSumResultSetBo.setPerfLevelId(sumPerfLevelId);
                        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelId);
                        DynamicObjectCollection entryentity = sumPerfLevel.getDynamicObjectCollection("entryentity");
                        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
                            for (DynamicObject entry : entryentity) {
                                levelNameMap.put(entry.getString("seq"), entry.getString("levelname"));
                            }
                        }
                    }
                }
            }
            if ((isDependentSummary || HRStringUtils.equals((String)MpLevelSetEnum.CUSTOM.getCode(), (String)mplevelset)) && ismplevelexchange && (sumperflevelDy = perfWorkFlowDy.getDynamicObject("sumperflevel")) != null) {
                long sumPerfLevelId = sumperflevelDy.getLong("id");
                perfSumResultSetBo.setPerfLevelId(sumPerfLevelId);
                DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumPerfLevelId);
                DynamicObjectCollection entryentity = sumPerfLevel.getDynamicObjectCollection("entryentity");
                if (!CollectionUtils.isEmpty((Collection)entryentity)) {
                    for (DynamicObject entry : entryentity) {
                        levelNameMap.put(entry.getString("seq"), entry.getString("levelname"));
                    }
                }
            }
            perfSumResultSetBo.setNumAccuracy(numaccuracy);
            perfSumResultSetBo.setScaleType(scaletype);
            perfSumResultSetBo.setLevelNameMap(levelNameMap);
        }
        if (HRStringUtils.isEmpty((String)perfSumResultSetBo.getNumAccuracy())) {
            perfSumResultSetBo.setNumAccuracy("2");
        }
        if (HRStringUtils.isEmpty((String)perfSumResultSetBo.getScaleType())) {
            perfSumResultSetBo.setScaleType(ScalaTypeEnum.ROUND_HALF_UP.getValue());
        }
        return perfSumResultSetBo;
    }

    private Map<String, String> getDataSetByAssessForm(DynamicObject assessForm) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        String numaccuracy = assessForm.getString("numaccuracy");
        String scaletype = assessForm.getString("scaletype");
        result.put("numaccuracy", numaccuracy);
        result.put("scaletype", scaletype);
        result.put("maxscore", "0");
        result.put("minscore", "0");
        DynamicObject scoresystem = assessForm.getDynamicObject("scoresystem");
        String evaSumLimit = assessForm.getString("evasumlimit");
        if (HRStringUtils.isEmpty((String)evaSumLimit) && Objects.isNull(scoresystem)) {
            return result;
        }
        String limitmaxscore = assessForm.getString("limitmaxscore");
        String limitminscore = assessForm.getString("limitminscore");
        if (HRStringUtils.isEmpty((String)evaSumLimit) || HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.SUM_LIMIT.getValue())) {
            result.put("maxscore", scoresystem.getString("maxscore"));
            result.put("minscore", scoresystem.getString("minscore"));
            return result;
        }
        if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.APPOINT_SUM_LIMIT.getValue())) {
            result.put("maxscore", limitmaxscore);
            result.put("minscore", limitminscore);
            return result;
        }
        if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.NOT_LIMIT.getValue())) {
            DynamicObjectCollection areaEntry = assessForm.getDynamicObjectCollection("areaconfentry");
            List plusMinusList = areaEntry.stream().filter(entry -> AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(entry.getDynamicObject("areareg").getPkValue())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(plusMinusList)) {
                Long areaConf = ((DynamicObject)plusMinusList.get(0)).getLong("areaconf");
                DynamicObject plusMinusConfigDy = ASSESS_RULE_APP_SERVICE.queryPlusMinusConfigByPk(areaConf);
                BigDecimal maxScore = scoresystem.getBigDecimal("maxscore").add(plusMinusConfigDy.getBigDecimal("pluslimit"));
                BigDecimal minScore = scoresystem.getBigDecimal("minscore").add(plusMinusConfigDy.getBigDecimal("minuslimit"));
                result.put("maxscore", maxScore.toString());
                result.put("minscore", minScore.toString());
            } else {
                result.put("maxscore", scoresystem.getString("maxscore"));
                result.put("minscore", scoresystem.getString("minscore"));
            }
        }
        return result;
    }

    public void assembleMpResultExport(BeforeWriteDataEventArgs args, List<Map<Integer, Map<String, Object>>> tplDataRows) {
        String extParams = args.getExtParams();
        if (HRStringUtils.isEmpty((String)extParams)) {
            return;
        }
        Map customParams = (Map)SerializationUtils.fromJsonString((String)extParams, Map.class);
        Object activityId = customParams.get("activityId");
        Object exportSource = customParams.get("exportSource");
        if ((activityId != null || exportSource != null) && HRStringUtils.equals((String)"epa_tobeperfsum_export_from_impttpl_hr", (String)String.valueOf(exportSource))) {
            Long activityL = Long.valueOf((String)activityId);
            PerfSumResultSetBo perfSumResultSetBo = this.getPerfSumDataDealSetByActivityId(activityL, false);
            Map<String, String> levelNameMap = perfSumResultSetBo.getLevelNameMap();
            for (Map<Integer, Map<String, Object>> tplDataRow : tplDataRows) {
                for (Map.Entry<Integer, Map<String, Object>> integerMapEntry : tplDataRow.entrySet()) {
                    String mplop;
                    String levelName;
                    Map<String, Object> map = integerMapEntry.getValue();
                    String key = (String)map.get("key");
                    Object val = map.get("val");
                    if (val == null || HRStringUtils.isEmpty((String)val.toString())) continue;
                    if (HRStringUtils.equals((String)key, (String)"mpsop")) {
                        BigDecimal mpsop = new BigDecimal(val.toString());
                        mpsop = mpsop.setScale(Integer.parseInt(perfSumResultSetBo.getNumAccuracy()), ScalaTypeEnum.get(perfSumResultSetBo.getScaleType()).getType());
                        map.put("val", mpsop.toString());
                        map.remove("isNumber");
                        continue;
                    }
                    if (!HRStringUtils.equals((String)key, (String)"mplop") || !HRStringUtils.isNotEmpty((String)(levelName = levelNameMap.get(mplop = val.toString())))) continue;
                    map.put("val", levelName);
                }
            }
        }
    }

    public DynamicObject[] queryToBePerfSumObj(Long activityId, Integer nodeIndex, List<Long> evaObjIdList) {
        QFilter toBePerfSumCommonFilter = this.getToBePerfSumCommonFilter(nodeIndex);
        QFilter filter = new QFilter("activity", "=", (Object)activityId);
        String selectProperties = "perffile.billno,perffile.name,perffile.number,perffile.sourcevid,perffilev.id, mpsop,mplop,mpsopendway,mpsopgenway,creator,createtime, modifier,modifytime,activity.number,activity.name,affiliateadminorg.name";
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.query(selectProperties, new QFilter[]{filter.and(toBePerfSumCommonFilter)});
    }

    public QFilter getToBePerfSumCommonFilter(Integer nodeIndex) {
        QFilter filter2 = new QFilter("nodeindex", "=", (Object)nodeIndex).and("nodestatus", "!=", (Object)AssessNodeStatusEnum.MPED.getStatus());
        QFilter filter1 = null;
        filter1 = nodeIndex <= 1 ? new QFilter("assessstaus", "=", (Object)AssessStausEnum.JOINED.getStatus()) : new QFilter("nodeindex", "=", (Object)(nodeIndex - 1)).and("nodestatus", "=", (Object)AssessNodeStatusEnum.EVALUATED.getStatus());
        return filter1.or(filter2);
    }

    public Object[] updateEvaObjMpResultStatus(List<Long> evaObjIdList, MpSopGenWayEnum mpSopGenWayEnum) {
        DynamicObject[] evaObjArr = ACTIVITY_EVALUATION_OBJECT_ENTITY.query("mpsopgenway,modifier,modifytime", new QFilter[]{new QFilter("id", "in", evaObjIdList)});
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        for (DynamicObject evaObjDy : evaObjArr) {
            evaObjDy.set("mpsopgenway", (Object)mpSopGenWayEnum.getCode());
            dynamicObjects.add((Object)evaObjDy);
        }
        return ACTIVITY_EVALUATION_OBJECT_ENTITY.save(dynamicObjects);
    }

    public Object[] addMpResultModifyLog(DynamicObjectCollection evals, Map<Long, Object> reasonMap, MpSopGenWayEnum mpSopGenWayEnum) {
        if (CollectionUtils.isEmpty((Collection)evals)) {
            return new Object[0];
        }
        if (mpSopGenWayEnum == null) {
            mpSopGenWayEnum = MpSopGenWayEnum.RESULT_MODIFY;
        }
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        long userId = UserServiceHelper.getCurrentUserId();
        Date date = new Date();
        Long assessNodeId = AssessNodeStatusEnum.MPED.getNodeId();
        for (DynamicObject eval : evals) {
            Object reason;
            DynamicObject dy = OBJSET_SCORE_RECORD_DOMAIN_SERVICE.generateEmptyDynamicObject();
            dy.set("actevalobj", (Object)eval.getLong("id"));
            dy.set("activity", eval.get("activity.id"));
            dy.set("perforg", eval.get("perforg.id"));
            dy.set("assessyear", (Object)eval.getLong("assessyear"));
            dy.set("assessperiod", (Object)eval.getString("assessperiod"));
            dy.set("assessnode", (Object)assessNodeId);
            dy.set("score", (Object)(null == eval.getBigDecimal(AssessScoreAbbrEnum.MPSOP.getCode()) ? BigDecimal.ZERO : eval.getBigDecimal(AssessScoreAbbrEnum.MPSOP.getCode())));
            dy.set("level", (Object)(HRStringUtils.isEmpty((String)eval.getString(AssessScoreAbbrEnum.MPLOP.getCode())) ? "" : eval.getString(AssessScoreAbbrEnum.MPLOP.getCode())));
            dy.set("changetype", (Object)EvalfinishtypeEnum.HANDWORK_INPUT.getType());
            dy.set("generateway", (Object)mpSopGenWayEnum.getCode());
            if (reasonMap != null && null != (reason = reasonMap.get(eval.getLong("id")))) {
                dy.set("reason", reason);
            }
            dy.set("modifier", (Object)userId);
            dy.set("modifytime", (Object)date);
            dy.set("creator", (Object)userId);
            dy.set("createtime", (Object)date);
            dyColl.add((Object)dy);
        }
        return OBJSET_SCORE_RECORD_DOMAIN_SERVICE.save(dyColl);
    }

    public boolean validMpSop(BigDecimal sop) {
        if (sop == null) {
            return false;
        }
        return sop.compareTo(PerformSummaryConstants.MIN_SCORE_BIG) >= 0 && sop.compareTo(PerformSummaryConstants.MAX_SCORE_BIG) <= 0;
    }

    public Map<String, String> getLevelSeq2NameMapByEvaObjId(Long evaObj) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (evaObj == null || evaObj == 0L) {
            return result;
        }
        QFilter activityFilter = new QFilter("evaobj.id", "=", (Object)evaObj);
        return this.getLevelSeq2NameMapByFilter(result, activityFilter);
    }

    private Map<String, String> getLevelSeq2NameMapByFilter(Map<String, String> result, QFilter activityFilter) {
        DynamicObject[] calcItemColl = MP_CALC_ITEM_ENTITY_SERVICE.query("perfleve.id", new QFilter[]{activityFilter});
        HashSet<Long> perfLevelIdSet = new HashSet<Long>(16);
        for (DynamicObject calcItemDy : calcItemColl) {
            DynamicObject perfLevelDy = calcItemDy.getDynamicObject("perfleve");
            if (perfLevelDy == null) continue;
            perfLevelIdSet.add(perfLevelDy.getLong("id"));
        }
        if (CollectionUtils.isNotEmpty(perfLevelIdSet)) {
            result = this.getLevelSeq2NameMap(perfLevelIdSet);
        }
        return result;
    }

    public Map<String, String> getLevelSeq2NameMapByActivityId(Long activityId) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (activityId == null || activityId == 0L) {
            return result;
        }
        QFilter activityFilter = new QFilter("evaobj.activity.id", "=", (Object)activityId);
        return this.getLevelSeq2NameMapByFilter(result, activityFilter);
    }

    public Map<String, String> getLevelSeq2NameMap(Set<Long> perfLevelIdList) {
        DynamicObject[] query;
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (CollectionUtils.isEmpty(perfLevelIdList)) {
            return result;
        }
        QFilter qFilter = new QFilter("id", "in", perfLevelIdList);
        for (DynamicObject dynamicObject : query = PERF_LEVEL_ENTITY.query("id,entryentity.seq,entryentity.levelname", new QFilter[]{qFilter})) {
            long id = dynamicObject.getLong("id");
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDy : entryentity) {
                result.put(id + "_" + entryDy.getInt("seq"), entryDy.getString("levelname"));
            }
        }
        return result;
    }
}

