/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.perfworkflow.service;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;

public class PerfWorkFlowDomainService {
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();

    public static PerfWorkFlowDomainService getInstance() {
        return ServiceFactory.getService(PerfWorkFlowDomainService.class);
    }

    public DynamicObjectCollection queryAssFlowById(long perfWorkFlowId, String workFlowType) {
        DynamicObject perfWorkFlow = PERF_WORK_FLOW_ENTITY_SERVICE.queryOne(perfWorkFlowId);
        if (perfWorkFlow == null) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection flowEntry = perfWorkFlow.getDynamicObjectCollection("flowentry");
        List flowVid = flowEntry.stream().filter(entry -> entry.getBoolean("isenable")).map(flow -> flow.getLong("flowvid")).collect(Collectors.toList());
        QFilter flowFilter = new QFilter("id", "in", flowVid).and("publishstatus", "=", (Object)"20").and("workflowtype", "=", (Object)workFlowType);
        DynamicObject[] workFlow = WORK_FLOW_ENTITY_SERVICE.query("id", new QFilter[]{flowFilter});
        Set flowIds = Arrays.stream(workFlow).map(flow -> flow.getLong("id")).collect(Collectors.toSet());
        return flowEntry.stream().filter(flow -> flowIds.contains(flow.getLong("flowvid"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    public List<Long> queryFlowById(long perfWorkFlowId, String workFlowType) {
        DynamicObject perfWorkFlow = PERF_WORK_FLOW_ENTITY_SERVICE.queryOne(perfWorkFlowId);
        if (perfWorkFlow == null) {
            return null;
        }
        DynamicObjectCollection flowEntry = perfWorkFlow.getDynamicObjectCollection("flowentry");
        List flowVid = flowEntry.stream().filter(entry -> entry.getBoolean("isenable")).map(flow -> flow.getLong("flowvid")).collect(Collectors.toList());
        QFilter flowFilter = new QFilter("id", "in", flowVid).and("publishstatus", "=", (Object)"20").and("workflowtype", "=", (Object)workFlowType);
        DynamicObject[] workFlow = WORK_FLOW_ENTITY_SERVICE.query("id,boid", new QFilter[]{flowFilter});
        List<Long> flowIds = Arrays.stream(workFlow).map(flow -> flow.getLong("boid")).collect(Collectors.toList());
        return flowIds;
    }

    public DynamicObject loadSingleWorkFlow(long workFlowId) {
        return PERF_WORK_FLOW_ENTITY_SERVICE.loadSingle(workFlowId);
    }

    public DynamicObject getSourceDynamicObject(Long boId) {
        return PERF_WORK_FLOW_ENTITY_SERVICE.getSourceDynamicObject(boId);
    }
}

