/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.permission.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.epa.business.domain.permission.utils.AbstractPermissionMap;
import kd.opmc.epa.common.enums.per.AreaEnum;
import kd.opmc.epa.common.enums.per.FieldDisplayEnum;
import kd.opmc.epa.common.enums.per.FieldRequiredEnum;
import kd.opmc.epa.common.enums.per.FieldUpdateEnum;

public class PermissionFieldMap
extends AbstractPermissionMap {
    private static final Map<String, String> FIELD_DISPlAY_MAP = new HashMap<String, String>();
    private static final Map<String, String> FIELD_UPDATE_MAP = new HashMap<String, String>();
    private static final Map<String, String> FIELD_REQUIRED_MAP = new HashMap<String, String>();

    private static void initializeFieldMaps(Long areaValue) {
        DynamicObject[] dynamicObjects = null;
        if (AreaEnum.EMPINFO.getValue().equals(areaValue)) {
            dynamicObjects = PERFORMACE_SETTINGS_ENTITYSERVICE.queryEmpFieldPermission();
        } else if (AreaEnum.NORMINDCTR.getValue().equals(areaValue)) {
            dynamicObjects = PERFORMACE_SETTINGS_ENTITYSERVICE.queryNormalFieldPermission();
        } else if (AreaEnum.PLUSMINUS.getValue().equals(areaValue)) {
            dynamicObjects = PERFORMACE_SETTINGS_ENTITYSERVICE.queryPlusFieldPermission();
        } else if (AreaEnum.CUSTOM.getValue().equals(areaValue)) {
            dynamicObjects = PERFORMACE_SETTINGS_ENTITYSERVICE.queryCustomFieldPermission();
        } else if (AreaEnum.ATTACH.getValue().equals(areaValue)) {
            dynamicObjects = PERFORMACE_SETTINGS_ENTITYSERVICE.queryAttachFieldPermission();
        } else if (AreaEnum.SUM.getValue().equals(areaValue)) {
            dynamicObjects = PERFORMACE_SETTINGS_ENTITYSERVICE.querySumFieldPermission();
        }
        if (dynamicObjects != null && !HRObjectUtils.isEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                StringBuilder stringBuilder = new StringBuilder(dynamicObject.getString("activity")).append("-").append(dynamicObject.getLong("pbsnodetypeid.id")).append("-").append(dynamicObject.getString("nodeparameter")).append("-");
                for (DynamicObject entry : dynamicObject.getDynamicObjectCollection("fieldentry")) {
                    StringBuilder fieldBuilder = new StringBuilder(stringBuilder);
                    String combinedKey = fieldBuilder.append(entry.getLong("areafieldregid.id")).toString();
                    FIELD_DISPlAY_MAP.putIfAbsent(combinedKey, entry.getString("fielddisplay"));
                    FIELD_UPDATE_MAP.putIfAbsent(combinedKey, entry.getString("fieldupdate"));
                    FIELD_REQUIRED_MAP.putIfAbsent(combinedKey, entry.getString("fieldrequired"));
                }
            }
        }
    }

    public static String getAreaDisplayMapValue(String key) {
        return FIELD_DISPlAY_MAP.get(key);
    }

    public static String getAreaUpdateMapValue(String key) {
        return FIELD_UPDATE_MAP.get(key);
    }

    public static String getAreaRequiredMapValue(String key) {
        return FIELD_REQUIRED_MAP.get(key);
    }

    public static Boolean getAreaDisplay(String key) {
        String value = FIELD_DISPlAY_MAP.get(key);
        if (FieldDisplayEnum.OPEN_AND_DISABLED.getValue().equals(value)) {
            return Boolean.TRUE;
        }
        if (FieldDisplayEnum.OPEN_CAN_CLOSE.getValue().equals(value)) {
            return Boolean.TRUE;
        }
        if (FieldDisplayEnum.AREA_ABOUT.getValue().equals(value)) {
            return Boolean.TRUE;
        }
        if (FieldDisplayEnum.OPEN_AND_DISABLED_AREA.getValue().equals(value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean getAreaUpdate(String key) {
        String value = FIELD_UPDATE_MAP.get(key);
        if (FieldUpdateEnum.OPEN_AND_DISABLED.getValue().equals(value)) {
            return Boolean.TRUE;
        }
        if (FieldUpdateEnum.OPEN_CAN_CLOSE.getValue().equals(value)) {
            return Boolean.TRUE;
        }
        if (FieldUpdateEnum.AREA_ABOUT.getValue().equals(value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean getAreaRequired(String key) {
        String value = FIELD_REQUIRED_MAP.get(key);
        if (FieldRequiredEnum.OPEN_AND_DISABLED.getValue().equals(value)) {
            return Boolean.TRUE;
        }
        if (FieldRequiredEnum.OPEN_CAN_CLOSE.getValue().equals(value)) {
            return Boolean.TRUE;
        }
        if (FieldRequiredEnum.AREA_ABOUT.getValue().equals(value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static {
        PermissionFieldMap.initializeFieldMaps(AreaEnum.EMPINFO.getValue());
        PermissionFieldMap.initializeFieldMaps(AreaEnum.NORMINDCTR.getValue());
        PermissionFieldMap.initializeFieldMaps(AreaEnum.PLUSMINUS.getValue());
        PermissionFieldMap.initializeFieldMaps(AreaEnum.ATTACH.getValue());
        PermissionFieldMap.initializeFieldMaps(AreaEnum.CUSTOM.getValue());
        PermissionFieldMap.initializeFieldMaps(AreaEnum.SUM.getValue());
    }
}

