/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.scheme.entity;

import java.io.Serializable;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetEntryVO;

public class MpRuleSetVO
implements Serializable {
    private static final long serialVersionUID = 7553342980749374856L;
    private int mpmode;
    private String mpformula;
    private int erdealrule;
    private List<MpRuleSetEntryVO> entryentities;

    public int getMpmode() {
        return this.mpmode;
    }

    public void setMpmode(int mpmode) {
        this.mpmode = mpmode;
    }

    public String getMpformula() {
        if (HRStringUtils.isEmpty((String)this.mpformula)) {
            this.getMpformulaForSave();
        }
        return this.mpformula;
    }

    public String getMpformulaForSave() {
        List<MpRuleSetEntryVO> mpRuleSetEntryVOs = this.getEntryentities();
        StringBuilder sb = new StringBuilder(16);
        for (MpRuleSetEntryVO vo : mpRuleSetEntryVOs) {
            if (this.getMpmode() == 1) {
                sb.append(vo.getTimetag()).append("+");
                continue;
            }
            if (this.getMpmode() != 2) continue;
            sb.append(vo.getTimetag()).append(" * ").append(vo.getWeight() == null ? "0" : vo.getWeight().setScale(2, RoundingMode.HALF_UP)).append("%").append("+");
        }
        if (sb.length() > 0) {
            if (this.getMpmode() == 1) {
                this.setMpformula("(" + sb.substring(0, sb.length() - 1) + " ) / " + mpRuleSetEntryVOs.size());
            } else {
                this.setMpformula(sb.substring(0, sb.length() - 1));
            }
        }
        return this.mpformula;
    }

    public void setMpformula(String mpformula) {
        this.mpformula = mpformula;
    }

    public int getErdealrule() {
        return this.erdealrule;
    }

    public void setErdealrule(int erdealrule) {
        this.erdealrule = erdealrule;
    }

    public List<MpRuleSetEntryVO> getEntryentities() {
        Optional<List<MpRuleSetEntryVO>> optionalList = Optional.ofNullable(this.entryentities);
        this.entryentities = optionalList.orElseGet(ArrayList::new);
        return this.entryentities;
    }

    public void setEntryentities(List<MpRuleSetEntryVO> entryentities) {
        this.entryentities = entryentities;
    }
}

