/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.scheme.entityservice;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.common.constants.ObjectScopeConstants;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class AssessGroupEntityService
extends OpmcEntityService
implements ObjectScopeConstants {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_assessgroup");

    public static AssessGroupEntityService getInstance() {
        return ServiceFactory.getService(AssessGroupEntityService.class);
    }

    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject generateEmpty() {
        return HELPER.generateEmptyDynamicObject();
    }

    public Object saveOne(DynamicObject dynamicObject) {
        return HELPER.saveOne(dynamicObject);
    }

    public DynamicObject[] queryListByScopeId(boolean ref, Long scopeId) {
        if (ObjectUtils.isEmpty((Object)scopeId)) {
            return new DynamicObject[0];
        }
        String selectFields = "id, status, enable";
        if (ref) {
            selectFields = "id, name, number, description, isdefault, objectscope";
        }
        return HELPER.query(selectFields, new QFilter[]{new QFilter("objectscope", "=", (Object)scopeId)}, "number");
    }

    public DynamicObject[] queryListByScopeIdList(List<Long> scopeIdList) {
        if (scopeIdList == null || scopeIdList.isEmpty()) {
            return new DynamicObject[0];
        }
        String selectFields = "id, objectscope, status, enable";
        return HELPER.query(selectFields, new QFilter[]{new QFilter("objectscope", "in", scopeIdList)}, "number");
    }

    public DynamicObject queryDefaultGroup(Long schemeId) {
        String selectFields = "isdefault,objectscope";
        QFilter idFilter = new QFilter("scheme", "=", (Object)schemeId);
        QFilter defaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        return HELPER.queryOne(selectFields, new QFilter[]{idFilter, defaultFilter});
    }

    public DynamicObject queryById(String fields, Long pkId) {
        return this.queryOne(fields, pkId);
    }

    public void deleteByScopeId(Long scopeId) {
        HELPER.deleteByFilter(new QFilter[]{new QFilter("objectscope", "=", (Object)scopeId)});
    }

    public DynamicObject[] queryListBySchemeId(Long schemeId) {
        String selectFields = "id";
        QFilter filter = new QFilter("scheme", "=", (Object)schemeId);
        return HELPER.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryGroupListBySchemeId(String selectFields, Long schemeId) {
        if (ObjectUtils.isEmpty((Object)schemeId)) {
            return new DynamicObject[0];
        }
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = "id";
        }
        return HELPER.query(selectFields, new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)});
    }

    public int count(QFilter[] filters) {
        return HELPER.count("epa_assessgroup", filters);
    }

    public DynamicObject[] queryAssessGroupArr(long schemeId, long objectScopeId) {
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)schemeId);
        schemeFilter.and("objectscope", "=", (Object)objectScopeId);
        return HELPER.query("objectscope,isdefault", schemeFilter.toArray(), "number");
    }
}

