/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.scheme.entityservice;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class AssessObjectEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_assessobject");

    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public static AssessObjectEntityService getInstance() {
        return ServiceFactory.getService(AssessObjectEntityService.class);
    }

    public DynamicObject generateEmpty() {
        return HELPER.generateEmptyDynamicObject();
    }

    public DynamicObject[] queryListBySchemeId(String selectFields, Long schemeId) {
        if (ObjectUtils.isEmpty((Object)schemeId)) {
            return new DynamicObject[0];
        }
        if (HRStringUtils.isEmpty((String)selectFields)) {
            selectFields = "id";
        }
        return HELPER.query(selectFields, new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)});
    }

    public DynamicObject[] queryListByIds(List<Long> ids) {
        String selectFields = "id, perfile, assgroup, resperson";
        return HELPER.query(selectFields, new QFilter[]{new QFilter("id", "in", ids)});
    }

    public DynamicObject[] queryListBySchemeIdNOrg(long schemeId, List<Long> orgIds) {
        return HELPER.query("id", new QFilter[]{new QFilter("scheme", "=", (Object)schemeId).and("perfile.affiliateadminorg", "in", orgIds)});
    }

    public DynamicObject[] queryListNotContainOrg(long schemeId, List<Long> orgIds) {
        return HELPER.query("id", new QFilter[]{new QFilter("scheme", "=", (Object)schemeId).and("perfile.affiliateadminorg", "not in", orgIds)});
    }

    public DynamicObject[] queryAllObjByIds(List<Long> ids) {
        String selectFields = "id, perfile, assgroup, scheme, startcycle, endcycle, lastjoindate, datasource, datasourcetype, person ,empposorgrel, employee, resperson";
        return this.query(selectFields, new QFilter[]{new QFilter("id", "in", ids)});
    }

    public DynamicObject[] queryListBySchemeIdAndPerfiles(long schemeId, List<Long> perfiles) {
        String selectFields = "id, perfile, resperson, startcycle,endcycle";
        return HELPER.query(selectFields, new QFilter[]{new QFilter("scheme", "=", (Object)schemeId).and("perfile.id", "in", perfiles)});
    }

    public DynamicObject[] queryListByAssessGroupIdList(String selectProperties, List<Long> assessGroupIdList) {
        return HELPER.query(selectProperties, new QFilter("assgroup", "in", assessGroupIdList).toArray());
    }
}

