/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.scheme.entityservice;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.pbs.business.domain.OpmcEntityService;

public class ExecuteSchemeEntityService
extends OpmcEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_executescheme");

    public static ExecuteSchemeEntityService getInstance() {
        return ServiceFactory.getService(ExecuteSchemeEntityService.class);
    }

    protected HRBaseServiceHelper getServiceHelper() {
        return HELPER;
    }

    public DynamicObject[] queryListBySchemeId(Long schemeId, String searchText) {
        String selectFields = "timetag, assessscope, assessform, perfworkflow";
        QFilter filter = new QFilter("scheme", "=", (Object)schemeId);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            String text = "%" + searchText + "%";
            QFilter numfilter = new QFilter("number", "like", (Object)text);
            QFilter namefilter = new QFilter("name", "like", (Object)text);
            QFilter searchFilter = numfilter.or(namefilter);
            return HELPER.query(selectFields, new QFilter[]{filter, searchFilter});
        }
        return HELPER.query(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryListBySchemeId(Long schemeId) {
        String selectFields = "timetag, assessscope, assessform, perfworkflow";
        QFilter filter = new QFilter("scheme", "=", (Object)schemeId);
        String orderBy = "timetag asc, number asc";
        return HELPER.query(selectFields, new QFilter[]{filter}, orderBy);
    }

    public void deleteById(Long id) {
        HELPER.deleteOne((Object)id);
    }

    public DynamicObject generateEmpty() {
        return HELPER.generateEmptyDynamicObject();
    }

    public void batchSave(DynamicObjectCollection cols) {
        HELPER.save(cols);
    }

    public DynamicObject queryExecuteSchemeById(Long executeSchemeId) {
        return HELPER.queryOne("perfworkflow", new QFilter("id", "=", (Object)executeSchemeId));
    }

    public int count(QFilter[] filters) {
        return HELPER.count("epa_executescheme", filters);
    }

    public DynamicObject[] queryAssessSchemeArr(List<Long> executeSchemeIdList) {
        return HELPER.query("id,scheme.id,scheme.startyear,scheme.endyear", new QFilter("id", "not in", executeSchemeIdList).toArray());
    }

    public DynamicObject queryExecuteSchemeCycleType(long executeSchemeId) {
        return HELPER.queryOne("timetag.cycletype", new QFilter("id", "=", (Object)executeSchemeId).toArray());
    }

    public DynamicObject[] queryListByIds(List<Long> executeSchemeIds) {
        String selectFields = "assessform";
        QFilter filter = new QFilter("id", "in", executeSchemeIds);
        return HELPER.query(selectFields, new QFilter[]{filter});
    }
}

