/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.scheme.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessGroupEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessObjectEntityService;
import kd.opmc.epa.business.domain.scheme.service.SchemeBaseInfoDomainService;
import kd.opmc.pbs.business.external.haos.IHAOSBatchAdminOrgInfoQueryService;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;
import kd.opmc.pmd.business.domain.perffile.service.PerffileDomainService;

public class AssessObjectDomainService {
    private static final AssessObjectEntityService ASSESS_OBJECT_ENTITY_SERVICE = AssessObjectEntityService.getInstance();
    private static final PerffileDomainService PERFFILE_DOMAIN_SERVICE = PerffileDomainService.getInstance();
    private static final IHAOSBatchAdminOrgInfoQueryService HAOS_BATCH_ADMIN_ORG_INFO_QUERY_SERVICE = IHAOSBatchAdminOrgInfoQueryService.getInstance();
    private static final SchemeBaseInfoDomainService SCHEME_BASE_INFO_DOMAIN_SERVICE = SchemeBaseInfoDomainService.getInstance();
    private static final PerffileEntityService PERF_FILE_ENTITY = PerffileEntityService.getInstance();
    private static final AssessGroupEntityService ASSESS_GROUP_ENTITY_SERVICE = AssessGroupEntityService.getInstance();
    private static final String ACTIVITY_SELECT_FIELDS = "id,perfile,perfile.empposrel,perfile.sourcevid,assgroup,startcycle,endcycle,creator,createtime,modifier,modifytime,scheme,lastjoindate,datasource,datasourcetype,person,empposorgrel,employee";

    public static AssessObjectDomainService getInstance() {
        return ServiceFactory.getService(AssessObjectDomainService.class);
    }

    public void save(DynamicObject[] dataEntities) {
        ASSESS_OBJECT_ENTITY_SERVICE.save(dataEntities);
    }

    public DynamicObject[] getPerffileListByIds(List<Long> ids) {
        String selectFields = "id,person,empposorgrel,employee, affiliateadminorg";
        return PERFFILE_DOMAIN_SERVICE.getPerffileListByIds(selectFields, ids);
    }

    public DynamicObject generateEmpty() {
        return ASSESS_OBJECT_ENTITY_SERVICE.generateEmptyDynamicObject();
    }

    public void update(DynamicObject[] dataEntities) {
        ASSESS_OBJECT_ENTITY_SERVICE.updateDatas(dataEntities);
    }

    public DynamicObject[] loadDynamicObjectArrayByIds(Object[] ids) {
        return ASSESS_OBJECT_ENTITY_SERVICE.loadDynamicObjectArray("epa_assessobject", ids);
    }

    public DynamicObject[] queryListBySchemeId(Long schemeId) {
        return ASSESS_OBJECT_ENTITY_SERVICE.queryListBySchemeId(ACTIVITY_SELECT_FIELDS, schemeId);
    }

    public DynamicObject[] queryListByAssessGroupIdList(List<Long> assessGroupIdList) {
        return ASSESS_OBJECT_ENTITY_SERVICE.queryListByAssessGroupIdList(ACTIVITY_SELECT_FIELDS, assessGroupIdList);
    }

    public List<Map<String, Object>> batchGetAllSubOrg(List<Long> orgIdList, Date date) {
        return HAOS_BATCH_ADMIN_ORG_INFO_QUERY_SERVICE.batchGetAllSubOrg(orgIdList, date);
    }

    public DynamicObject[] queryPerffileBySchemeId(Long schemeId) {
        return ASSESS_OBJECT_ENTITY_SERVICE.queryListBySchemeId("id,perfile,startcycle", schemeId);
    }

    public DynamicObject[] saveAssessObject(Long schemeId, DynamicObjectCollection assessObjectColl, DynamicObject activity) {
        return this.saveAssessObjectDetail(schemeId, assessObjectColl, activity, "");
    }

    public DynamicObject[] saveAssessObjectWithInput(Long schemeId, DynamicObjectCollection assessObjectColl, DynamicObject activity) {
        return this.saveAssessObjectDetail(schemeId, assessObjectColl, activity, "1");
    }

    private DynamicObject[] saveAssessObjectDetail(Long schemeId, DynamicObjectCollection assessObjectColl, DynamicObject activity, String updateFlag) {
        DynamicObject scheme = SCHEME_BASE_INFO_DOMAIN_SERVICE.queryCycleInfoById(schemeId);
        if (HRObjectUtils.isEmpty((Object)scheme)) {
            return null;
        }
        DynamicObject[] savedAssessObject = this.queryPerffileBySchemeId(schemeId);
        Map<Long, DynamicObject> assessObjectIdDynObjMap = Arrays.stream(savedAssessObject).collect(Collectors.toMap(pf -> pf.getLong("perfile.id"), pf -> pf));
        ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updatateCycleList = new ArrayList<DynamicObject>(10);
        ArrayList<Long> savedAssessObjectIdList = new ArrayList<Long>(10);
        String startCycle = activity == null ? HRDateTimeUtils.format((Date)scheme.getDate("startyear"), (String)"yyyy") + scheme.getDynamicObject("starttimetag").getString("name") : this.getStartYearByActivity(scheme, activity);
        for (DynamicObject assessDynObj : assessObjectColl) {
            DynamicObject savedAssessObjectDynObj = assessObjectIdDynObjMap.get(assessDynObj.getLong("perffile.id"));
            if (savedAssessObjectDynObj != null) {
                savedAssessObjectIdList.add(savedAssessObjectDynObj.getLong("id"));
                if (!HRStringUtils.isEmpty((String)savedAssessObjectDynObj.getString("startcycle"))) continue;
                savedAssessObjectDynObj.set("startcycle", (Object)startCycle);
                updatateCycleList.add(savedAssessObjectDynObj);
                continue;
            }
            DynamicObject tmpAssessObject = this.generateEmpty();
            tmpAssessObject.set("scheme", (Object)schemeId);
            tmpAssessObject.set("perfile", assessDynObj.get("perffile"));
            tmpAssessObject.set("assgroup", assessDynObj.get("group"));
            if (!HRStringUtils.equals((String)updateFlag, (String)"1")) {
                tmpAssessObject.set("startcycle", (Object)startCycle);
                String endCycle = "";
                if (scheme.getDate("endyear") != null) {
                    endCycle = activity == null ? HRDateTimeUtils.format((Date)scheme.getDate("endyear"), (String)"yyyy") + scheme.getDynamicObject("endtimetag").getString("name") : this.getEndYearByActivity(scheme, activity);
                }
                tmpAssessObject.set("endcycle", (Object)endCycle);
            }
            tmpAssessObject.set("lastjoindate", (Object)new Date());
            tmpAssessObject.set("person", assessDynObj.get("person"));
            tmpAssessObject.set("empposorgrel", assessDynObj.get("empposorgrel"));
            tmpAssessObject.set("employee", assessDynObj.get("employee"));
            String source = activity == null ? "10" : "20";
            tmpAssessObject.set("datasource", (Object)source);
            tmpAssessObject.set("datasourcetype", (Object)"10");
            tempList.add(tmpAssessObject);
        }
        ArrayList<DynamicObject> returnDataList = new ArrayList<DynamicObject>(10);
        if (!savedAssessObjectIdList.isEmpty()) {
            DynamicObject[] savedAssessObjectArr = ASSESS_OBJECT_ENTITY_SERVICE.loadDynamicObjectArray(savedAssessObjectIdList.toArray());
            returnDataList.addAll(Arrays.asList(savedAssessObjectArr));
        }
        DynamicObject[] saveData = tempList.toArray(new DynamicObject[0]);
        DynamicObject[] save = (DynamicObject[])ASSESS_OBJECT_ENTITY_SERVICE.save(saveData);
        ASSESS_OBJECT_ENTITY_SERVICE.save(updatateCycleList.toArray(new DynamicObject[0]));
        returnDataList.addAll(Arrays.asList(save));
        return returnDataList.toArray(new DynamicObject[0]);
    }

    public DynamicObject[] saveJoinSchemeAssessObject(List<Long> perFileIds, Long schemeId) {
        DynamicObject scheme = SCHEME_BASE_INFO_DOMAIN_SERVICE.queryCycleInfoById(schemeId);
        if (HRObjectUtils.isEmpty((Object)scheme)) {
            return null;
        }
        DynamicObject defaultAssessGroup = ASSESS_GROUP_ENTITY_SERVICE.queryDefaultGroup(schemeId);
        DynamicObject[] savedAssessObject = this.queryPerffileBySchemeId(schemeId);
        Map<Long, DynamicObject> assessObjectIdDynObjMap = Arrays.stream(savedAssessObject).collect(Collectors.toMap(pf -> pf.getLong("perfile.id"), pf -> pf));
        ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updatateCycleList = new ArrayList<DynamicObject>(10);
        ArrayList<Long> savedAssessObjectIdList = new ArrayList<Long>(10);
        String startCycle = HRDateTimeUtils.format((Date)scheme.getDate("startyear"), (String)"yyyy") + scheme.getDynamicObject("starttimetag").getString("name");
        String selectors = "person,empposrel,empentryentity.empposorgrel,employee,affiliateadminorg,startdate,enddate,pmdorg";
        DynamicObject[] assessObjectJoinInCol = PERFFILE_DOMAIN_SERVICE.getPerffileListByIds(selectors, perFileIds);
        DynamicObjectCollection assessObjectColl = new DynamicObjectCollection();
        assessObjectColl.addAll(Arrays.asList(assessObjectJoinInCol));
        for (DynamicObject assessDynObj : assessObjectColl) {
            DynamicObject savedAssessObjectDynObj = assessObjectIdDynObjMap.get(assessDynObj.getLong("id"));
            if (savedAssessObjectDynObj != null) {
                savedAssessObjectIdList.add(savedAssessObjectDynObj.getLong("id"));
                if (!HRStringUtils.isEmpty((String)savedAssessObjectDynObj.getString("startcycle"))) continue;
                savedAssessObjectDynObj.set("startcycle", (Object)startCycle);
                updatateCycleList.add(savedAssessObjectDynObj);
                continue;
            }
            DynamicObject tmpAssessObject = this.generateEmpty();
            tmpAssessObject.set("scheme", (Object)schemeId);
            tmpAssessObject.set("perfile", (Object)assessDynObj.getLong("id"));
            tmpAssessObject.set("assgroup", (Object)defaultAssessGroup);
            tmpAssessObject.set("startcycle", (Object)startCycle);
            String endCycle = "";
            if (scheme.getDate("endyear") != null) {
                endCycle = HRDateTimeUtils.format((Date)scheme.getDate("endyear"), (String)"yyyy") + scheme.getDynamicObject("endtimetag").getString("name");
            }
            tmpAssessObject.set("endcycle", (Object)endCycle);
            tmpAssessObject.set("lastjoindate", (Object)new Date());
            tmpAssessObject.set("person", assessDynObj.get("person"));
            tmpAssessObject.set("employee", assessDynObj.get("employee"));
            tmpAssessObject.set("datasource", (Object)"10");
            tmpAssessObject.set("datasourcetype", (Object)"10");
            DynamicObjectCollection empEntryEntity = assessDynObj.getDynamicObjectCollection("empentryentity");
            if (CollectionUtils.isNotEmpty((Collection)empEntryEntity)) {
                tmpAssessObject.set("empposorgrel", (Object)((DynamicObject)empEntryEntity.get(0)).getDynamicObject("empposorgrel"));
            }
            tempList.add(tmpAssessObject);
        }
        ArrayList<DynamicObject> returnDataList = new ArrayList<DynamicObject>(10);
        if (!savedAssessObjectIdList.isEmpty()) {
            DynamicObject[] savedAssessObjectArr = ASSESS_OBJECT_ENTITY_SERVICE.loadDynamicObjectArray(savedAssessObjectIdList.toArray());
            returnDataList.addAll(Arrays.asList(savedAssessObjectArr));
        }
        DynamicObject[] saveData = tempList.toArray(new DynamicObject[0]);
        DynamicObject[] save = (DynamicObject[])ASSESS_OBJECT_ENTITY_SERVICE.save(saveData);
        ASSESS_OBJECT_ENTITY_SERVICE.save(updatateCycleList.toArray(new DynamicObject[0]));
        returnDataList.addAll(Arrays.asList(save));
        return returnDataList.toArray(new DynamicObject[0]);
    }

    private String getEndYearByActivity(DynamicObject schemeDynObj, DynamicObject activityDynObj) {
        DynamicObject cycleTypeDynObj;
        String executeSchemeTimeTagName = activityDynObj.getString("executescheme.timetag.name");
        if (schemeDynObj.getBoolean("isperiodassess")) {
            DynamicObjectCollection periodConfEntry = schemeDynObj.getDynamicObjectCollection("periodconfentity");
            cycleTypeDynObj = ((DynamicObject)periodConfEntry.get(0)).getDynamicObject("pcycletype");
        } else {
            cycleTypeDynObj = schemeDynObj.getDynamicObject("cycletype");
        }
        if (executeSchemeTimeTagName.startsWith("M")) {
            long cycleTypeId = cycleTypeDynObj.getLong("id");
            if (1363179570613844992L == cycleTypeId) {
                return this.formatEndPeriodYear(schemeDynObj, "Y");
            }
            if (1363179723043240960L == cycleTypeId) {
                return this.formatEndPeriodYear(schemeDynObj, "H2");
            }
            if (1363180109330260992L == cycleTypeId) {
                return this.formatEndPeriodYear(schemeDynObj, "Q4");
            }
            return this.formatEndPeriodYear(schemeDynObj, "M12");
        }
        if (executeSchemeTimeTagName.startsWith("Q")) {
            long cycleTypeId = cycleTypeDynObj.getLong("id");
            if (1363179570613844992L == cycleTypeId) {
                return this.formatEndPeriodYear(schemeDynObj, "Y");
            }
            if (1363179723043240960L == cycleTypeId) {
                return this.formatEndPeriodYear(schemeDynObj, "H2");
            }
            return this.formatEndPeriodYear(schemeDynObj, "Q4");
        }
        if (executeSchemeTimeTagName.startsWith("H")) {
            long cycleTypeId = cycleTypeDynObj.getLong("id");
            if (cycleTypeId == 1363179723043240960L) {
                return this.formatEndPeriodYear(schemeDynObj, "H2");
            }
            return this.formatEndPeriodYear(schemeDynObj, "Y");
        }
        return this.formatEndPeriodYear(schemeDynObj, "Y");
    }

    private String getStartYearByActivity(DynamicObject schemeDynObj, DynamicObject activityDynObj) {
        DynamicObject cycleTypeDynObj;
        String executeSchemeTimeTagName = activityDynObj.getString("executescheme.timetag.name");
        if (schemeDynObj.getBoolean("isperiodassess")) {
            DynamicObjectCollection periodConfEntry = schemeDynObj.getDynamicObjectCollection("periodconfentity");
            cycleTypeDynObj = ((DynamicObject)periodConfEntry.get(0)).getDynamicObject("pcycletype");
        } else {
            cycleTypeDynObj = schemeDynObj.getDynamicObject("cycletype");
        }
        if (executeSchemeTimeTagName.startsWith("M")) {
            int month = Integer.parseInt(executeSchemeTimeTagName.substring(1));
            long cycleTypeId = cycleTypeDynObj.getLong("id");
            if (1363179570613844992L == cycleTypeId) {
                return this.formatStartPeriodYear(activityDynObj, "Y");
            }
            if (1363179723043240960L == cycleTypeId) {
                if (month > 6) {
                    return this.formatStartPeriodYear(activityDynObj, "H2");
                }
                return this.formatStartPeriodYear(activityDynObj, "H1");
            }
            if (1363180109330260992L == cycleTypeId) {
                if (month <= 3) {
                    return this.formatStartPeriodYear(activityDynObj, "Q1");
                }
                if (month <= 6) {
                    return this.formatStartPeriodYear(activityDynObj, "Q2");
                }
                if (month <= 9) {
                    return this.formatStartPeriodYear(activityDynObj, "Q3");
                }
                return this.formatStartPeriodYear(activityDynObj, "Q4");
            }
            return this.formatStartPeriodYear(activityDynObj, executeSchemeTimeTagName);
        }
        if (executeSchemeTimeTagName.startsWith("Q")) {
            int quarter = Integer.parseInt(executeSchemeTimeTagName.substring(1));
            long cycleTypeId = cycleTypeDynObj.getLong("id");
            if (1363179570613844992L == cycleTypeId) {
                return this.formatStartPeriodYear(activityDynObj, "Y");
            }
            if (1363179723043240960L == cycleTypeId) {
                if (quarter > 2) {
                    return this.formatStartPeriodYear(activityDynObj, "H2");
                }
                return this.formatStartPeriodYear(activityDynObj, "H1");
            }
            return this.formatStartPeriodYear(activityDynObj, executeSchemeTimeTagName);
        }
        if (executeSchemeTimeTagName.startsWith("H")) {
            long cycleTypeId = cycleTypeDynObj.getLong("id");
            if (cycleTypeId == 1363179723043240960L) {
                return this.formatStartPeriodYear(activityDynObj, executeSchemeTimeTagName);
            }
            return this.formatStartPeriodYear(activityDynObj, "Y");
        }
        return this.formatStartPeriodYear(activityDynObj, "Y");
    }

    private String formatEndPeriodYear(DynamicObject schemeDynObj, String period) {
        return HRDateTimeUtils.format((Date)schemeDynObj.getDate("endyear"), (String)"yyyy") + period;
    }

    private String formatStartPeriodYear(DynamicObject activityDynObj, String period) {
        return HRDateTimeUtils.format((Date)activityDynObj.getDate("year"), (String)"yyyy") + period;
    }

    public DynamicObject[] queryListByIds(List<Long> ids) {
        return ASSESS_OBJECT_ENTITY_SERVICE.queryListByIds(ids);
    }

    public void deleteAssObjByOrgNSchemeId(long schemeId, Map<Long, Boolean> delOrg) {
        ArrayList<Long> delOrgIds = new ArrayList<Long>(delOrg.size());
        ArrayList<Long> containLowerOrgIds = new ArrayList<Long>(delOrg.size());
        for (Map.Entry<Long, Boolean> org : delOrg.entrySet()) {
            if (org.getValue().booleanValue()) {
                containLowerOrgIds.add(org.getKey());
                continue;
            }
            delOrgIds.add(org.getKey());
        }
        List resultList = HAOS_BATCH_ADMIN_ORG_INFO_QUERY_SERVICE.batchGetAllSubOrg(containLowerOrgIds, new Date());
        delOrgIds.addAll(resultList.stream().map(map -> (Long)map.get("orgId")).collect(Collectors.toList()));
        DynamicObject[] assObj = ASSESS_OBJECT_ENTITY_SERVICE.queryListBySchemeIdNOrg(schemeId, delOrgIds);
        ASSESS_OBJECT_ENTITY_SERVICE.delete(Arrays.stream(assObj).map(DataEntityBase::getPkValue).toArray());
    }

    public DynamicObject[] queryAllObjByIds(List<Long> ids) {
        return ASSESS_OBJECT_ENTITY_SERVICE.queryAllObjByIds(ids);
    }

    public void deleteOrgLowerAssObjByOrgNSchemeId(Long schemeId, Map<Long, Boolean> orgMap) {
        ArrayList<Long> notContainLowerOrgIds = new ArrayList<Long>(orgMap.size());
        ArrayList<Long> containLowerOrgIds = new ArrayList<Long>(orgMap.size());
        for (Map.Entry<Long, Boolean> org : orgMap.entrySet()) {
            if (org.getValue().booleanValue()) {
                containLowerOrgIds.add(org.getKey());
                continue;
            }
            notContainLowerOrgIds.add(org.getKey());
        }
        List resultList = HAOS_BATCH_ADMIN_ORG_INFO_QUERY_SERVICE.batchGetAllSubOrg(containLowerOrgIds, new Date());
        notContainLowerOrgIds.addAll(resultList.stream().map(map -> (Long)map.get("orgId")).collect(Collectors.toList()));
        DynamicObject[] assObj = ASSESS_OBJECT_ENTITY_SERVICE.queryListNotContainOrg(schemeId, notContainLowerOrgIds);
        ASSESS_OBJECT_ENTITY_SERVICE.delete(Arrays.stream(assObj).map(DataEntityBase::getPkValue).toArray());
    }

    public int countNoJoinObj(List<QFilter> dataFilters) {
        return PERF_FILE_ENTITY.count("pmd_perffile", dataFilters.toArray(new QFilter[0]));
    }

    public int countJoinObj(List<QFilter> dataFilters) {
        return ASSESS_OBJECT_ENTITY_SERVICE.count("epa_assessobject", dataFilters.toArray(new QFilter[0]));
    }

    public void deleteAssessObjectByPerfFileIdList(long schemeId, List<Long> perfFileIdList) {
        QFilter qFilter = new QFilter("perfile", "in", perfFileIdList);
        qFilter.and("scheme", "=", (Object)schemeId);
        ASSESS_OBJECT_ENTITY_SERVICE.deleteByFilter(qFilter.toArray());
    }

    public DynamicObject[] queryByFilters(QFilter[] qFilters) {
        String selectProperties = "perfile,perfile.bsed,perfile.bsled,perfile.archivesstatus,perfile.affiliateadminorg,perfile.startdate,perfile.enddate,pmdorg,person,resperson,assgroup,employee,startcycle,endcycle";
        return ASSESS_OBJECT_ENTITY_SERVICE.query(selectProperties, qFilters);
    }
}

