/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.scheme.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.ScoreSystemEntityService;
import kd.opmc.pbs.business.external.hrcs.IHRCSTipService;

public class ExecuteSchemeDomainService {
    private static final ExecuteSchemeEntityService ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final IHRCSTipService IHRCS_TIP_SERVICE = IHRCSTipService.getInstance();
    private static final ScoreSystemEntityService SCORE_SYSTEM_ENTITY = ScoreSystemEntityService.getInstance();

    public static ExecuteSchemeDomainService getInstance() {
        return ServiceFactory.getService(ExecuteSchemeDomainService.class);
    }

    public DynamicObject[] queryListByFilters(String selectFields, QFilter[] qFilters) {
        return ENTITY_SERVICE.query(selectFields, qFilters);
    }

    public DynamicObject[] queryListBySchemeId(Long schemeId, String searchText) {
        return ENTITY_SERVICE.queryListBySchemeId(schemeId, searchText);
    }

    public DynamicObject[] queryListBySchemeId(Long schemeId) {
        return ENTITY_SERVICE.queryListBySchemeId(schemeId);
    }

    public void deleteById(Long id) {
        ENTITY_SERVICE.deleteById(id);
    }

    public DynamicObject generateEmpty() {
        return ENTITY_SERVICE.generateEmpty();
    }

    public void batchSave(DynamicObjectCollection cols) {
        ENTITY_SERVICE.batchSave(cols);
    }

    public DynamicObject[] queryAssRuleInfoBySchemeId(Long schemeId) {
        String selectFields = "assessrule";
        return ENTITY_SERVICE.query(selectFields, new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)});
    }

    public DynamicObject queryBySchemeId(Long schemeId) {
        String selectFields = "assessform,perfworkflow,perfworkflow.flowentry";
        return ENTITY_SERVICE.queryOne(selectFields, new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
    }

    public void deleteByFilter(QFilter[] qFilters) {
        ENTITY_SERVICE.deleteByFilter(qFilters);
    }

    public DynamicObject queryScoreSystemBySchemeId(Long schemeId) {
        DynamicObject scheme = ENTITY_SERVICE.queryOne(schemeId);
        DynamicObject assessFormDy = scheme.getDynamicObject("assessform");
        return SCORE_SYSTEM_ENTITY.queryOne((Object)assessFormDy.getLong("scoresystem.id"));
    }

    public DynamicObject[] query(String selectors, QFilter[] queryFilters, String order) {
        return ENTITY_SERVICE.query(selectors, queryFilters, order);
    }

    public DynamicObject queryOne(String selectors, Long schemeId) {
        return ENTITY_SERVICE.queryOne(selectors, schemeId);
    }

    public int count(QFilter[] qFilters) {
        return ENTITY_SERVICE.count(qFilters);
    }

    public DynamicObject queryAssessFormBySchemeId(Long schemeId) {
        DynamicObject scheme = ENTITY_SERVICE.queryOne(schemeId);
        return scheme.getDynamicObject("assessform");
    }

    public DynamicObject queryScoreSystemByScoreSystemId(Long scoreSystemId) {
        return SCORE_SYSTEM_ENTITY.queryOne((Object)scoreSystemId);
    }

    public DynamicObject queryExecuteSchemeCycleType(long executeSchemeId) {
        return ENTITY_SERVICE.queryExecuteSchemeCycleType(executeSchemeId);
    }
}

