/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.scheme.service;

import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessGroupEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.ObjectScopeEntityService;

public class ObjectScopeDomainService {
    private static final ObjectScopeEntityService OBJECT_SCOPE_ENTITY_SERVICE = ObjectScopeEntityService.getInstance();
    private static final AssessGroupEntityService ASSESS_GROUP_ENTITY_SERVICE = AssessGroupEntityService.getInstance();

    public static ObjectScopeDomainService getInstance() {
        return ServiceFactory.getService(ObjectScopeDomainService.class);
    }

    public DynamicObject[] queryListBySchemeId(Long schemeId) {
        return OBJECT_SCOPE_ENTITY_SERVICE.queryListBySchemeId(schemeId);
    }

    public int queryCountBySchemeId(Long schemeId) {
        return OBJECT_SCOPE_ENTITY_SERVICE.queryCountBySchemeId(schemeId);
    }

    public void generateDefaultData(Long schemeId) {
        String scopeName = ResManager.loadKDString((String)"\u9ed8\u8ba4\u8bc4\u4f30\u5bf9\u8c61\u8303\u56f4", (String)"ObjectScopeDomainService_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        String groupName = ResManager.loadKDString((String)"\u9ed8\u8ba4\u8003\u6838\u7ec4", (String)"ObjectScopeDomainService_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        String scopeDesc = ResManager.loadKDString((String)"\u9ed8\u8ba4\u751f\u6210\u7684\u8bc4\u4f30\u5bf9\u8c61\u8303\u56f4", (String)"ObjectScopeDomainService_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        String groupDesc = ResManager.loadKDString((String)"\u9ed8\u8ba4\u751f\u6210\u7684\u8003\u6838\u7ec4", (String)"ObjectScopeDomainService_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject scope = OBJECT_SCOPE_ENTITY_SERVICE.generateEmpty();
        scope.set("scheme", (Object)schemeId);
        scope.set("number", (Object)"1010_S");
        scope.set("name", (Object)scopeName);
        scope.set("description", (Object)scopeDesc);
        scope.set("status", (Object)"C");
        scope.set("enable", (Object)"1");
        scope.set("creator", (Object)userId);
        DynamicObject defaultScope = (DynamicObject)OBJECT_SCOPE_ENTITY_SERVICE.saveOne(scope);
        DynamicObject group = ASSESS_GROUP_ENTITY_SERVICE.generateEmpty();
        group.set("scheme", (Object)schemeId);
        group.set("objectscope", (Object)defaultScope.getLong("id"));
        group.set("isdefault", (Object)"1");
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"epa_assessgroup", (DynamicObject)group, (String)"");
        group.set("number", (Object)("1010_S" + CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)group)));
        group.set("name", (Object)groupName);
        group.set("description", (Object)groupDesc);
        group.set("status", (Object)"C");
        group.set("enable", (Object)"1");
        group.set("creator", (Object)userId);
        ASSESS_GROUP_ENTITY_SERVICE.saveOne(group);
    }

    public void deleteById(Long scopeId) {
        OBJECT_SCOPE_ENTITY_SERVICE.deleteById(scopeId);
    }

    public DynamicObject generateEmpty() {
        return OBJECT_SCOPE_ENTITY_SERVICE.generateEmptyDynamicObject();
    }

    public DynamicObject queryOne(Long scopeId) {
        return OBJECT_SCOPE_ENTITY_SERVICE.queryOne(scopeId);
    }

    public DynamicObject[] query(QFilter[] qfilter) {
        return OBJECT_SCOPE_ENTITY_SERVICE.query(qfilter);
    }
}

