/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.scheme.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activity.service.AssessActivityDomainService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessGroupEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessObjectEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.AssignManagerEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.ObjectScopeEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.SchemeBaseInfoEntityService;
import kd.opmc.pbs.business.external.haos.IHAOSBatchAdminOrgInfoQueryService;
import kd.opmc.pbs.business.external.hrcs.IHRCSTipService;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;

public class SchemeBaseInfoDomainService {
    private static final SchemeBaseInfoEntityService SCHEME_BASE_INFO_ENTITY_SERVICE = SchemeBaseInfoEntityService.getInstance();
    private static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();
    private static final IHRCSTipService IHRCS_TIP_SERVICE = IHRCSTipService.getInstance();
    private static final IHAOSBatchAdminOrgInfoQueryService HAOS_BATCH_ADMIN_ORG_INFO_QUERY_SERVICE = IHAOSBatchAdminOrgInfoQueryService.getInstance();
    private static final ActivityEvaluationObjectEntityService EVALUATION_OBJECT_ENTITY_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final ObjectScopeEntityService OBJECT_SCOPE_ENTITY = ObjectScopeEntityService.getInstance();
    private static final AssessGroupEntityService ASSESS_GROUP_ENTITY = AssessGroupEntityService.getInstance();
    private static final AssignManagerEntityService ASSIGN_MANAGER_ENTITY = AssignManagerEntityService.getInstance();
    private static final AssessObjectEntityService ASSESS_OBJECT_ENTITY = AssessObjectEntityService.getInstance();

    public static SchemeBaseInfoDomainService getInstance() {
        return ServiceFactory.getService(SchemeBaseInfoDomainService.class);
    }

    public DynamicObject[] queryListBySchemeId(String selectFields, Long schemeId) {
        return SCHEME_BASE_INFO_ENTITY_SERVICE.queryListBySchemeId(selectFields, schemeId);
    }

    public void save(DynamicObject[] dataEntities) {
        SCHEME_BASE_INFO_ENTITY_SERVICE.save(dataEntities);
    }

    public DynamicObject[] queryListBySchemeId(Long schemeId) {
        return SCHEME_BASE_INFO_ENTITY_SERVICE.queryListBySchemeId(schemeId);
    }

    public Long getUserIdByPersonInfo(Long personId) {
        ArrayList<Long> personIds = new ArrayList<Long>(10);
        HashMap<String, ArrayList<Long>> idMaps = new HashMap<String, ArrayList<Long>>(16);
        personIds.add(personId);
        idMaps.put("person", personIds);
        Map userIdByPersonInfo = PERSON_SERVICE.getUserIdByPersonInfo(idMaps);
        Map data = (Map)userIdByPersonInfo.get("data");
        long userId = 0L;
        if (data != null) {
            Map userInfo = (Map)data.get(personId);
            userId = userInfo == null ? 0L : (Long)userInfo.get("user");
        }
        return userId;
    }

    public DynamicObject queryOneById(Long schemeId) {
        String selectField = "id, createorg, adminorg,schstatus";
        return SCHEME_BASE_INFO_ENTITY_SERVICE.queryOneById(selectField, schemeId);
    }

    public String getTips(String key, DynamicObject dynamicObject) {
        List tips = IHRCS_TIP_SERVICE.getTips("epa_scheme", key, dynamicObject);
        if (!ObjectUtils.isEmpty((Object)tips)) {
            return (String)tips.get(0);
        }
        return "";
    }

    public List<Long> getAllOrgIds(long id) {
        List<Long> list = Collections.singletonList(id);
        List resultList = HAOS_BATCH_ADMIN_ORG_INFO_QUERY_SERVICE.batchGetAllSubOrg(list, new Date());
        return resultList.stream().map(map -> (Long)map.get("orgId")).collect(Collectors.toList());
    }

    public DynamicObject queryOrgEntryById(Long schemeId) {
        return SCHEME_BASE_INFO_ENTITY_SERVICE.queryOneById("id,orgbasedata,iscontainlower", schemeId);
    }

    public DynamicObject queryCycleInfoById(Long schemeId) {
        return SCHEME_BASE_INFO_ENTITY_SERVICE.queryOneById("id,cycletype,cyclescheme,startyear,endyear,starttimetag,endtimetag,isperiodassess,periodconfentity.pcycletype", schemeId);
    }

    public boolean queryOrgIsExistEvalObjInAct(Long pkValue, Long orgId, boolean isContainCur, boolean isContainLower) {
        DynamicObject[] activities = new AssessActivityDomainService().queryActivityBySchemeId(pkValue);
        Set<Long> actIds = Arrays.stream(activities).map(act -> act.getLong("id")).collect(Collectors.toSet());
        if (isContainLower) {
            List<Long> orgIds = Collections.singletonList(orgId);
            List resultList = HAOS_BATCH_ADMIN_ORG_INFO_QUERY_SERVICE.batchGetAllSubOrg(orgIds, new Date());
            Set<Long> lowerOrgIdSet = resultList.stream().map(map -> (Long)map.get("orgId")).collect(Collectors.toSet());
            if (!isContainCur) {
                lowerOrgIdSet.remove(orgId);
            }
            return EVALUATION_OBJECT_ENTITY_SERVICE.queryExistsByActAndOrg(actIds, lowerOrgIdSet);
        }
        return EVALUATION_OBJECT_ENTITY_SERVICE.queryExistsByActAndOrg(actIds, Sets.newHashSet((Object[])new Long[]{orgId}));
    }

    public DynamicObject[] querySchemePeriodCycle(List<Long> idList) {
        QFilter idFilter = new QFilter("id", "in", idList);
        return SCHEME_BASE_INFO_ENTITY_SERVICE.query("pcycletype", new QFilter[]{idFilter});
    }

    public void deleteSchemeInfoById(List<Long> deleteIdList) {
        QFilter filter = new QFilter("scheme", "in", deleteIdList);
        OBJECT_SCOPE_ENTITY.deleteByFilter(new QFilter[]{filter});
        ASSESS_GROUP_ENTITY.deleteByFilter(new QFilter[]{filter});
        ASSIGN_MANAGER_ENTITY.deleteByFilter(new QFilter[]{filter});
        ASSESS_OBJECT_ENTITY.deleteByFilter(new QFilter[]{filter});
    }

    public DynamicObject[] query(String selectors, QFilter[] queryFilters, String order) {
        return SCHEME_BASE_INFO_ENTITY_SERVICE.query(selectors, queryFilters, order);
    }

    public DynamicObject queryOne(String selector, Long schemeId) {
        return SCHEME_BASE_INFO_ENTITY_SERVICE.queryOne(selector, schemeId);
    }

    public DynamicObject generateEmptyEntryDynamicObject(String periodconfentity) {
        return SCHEME_BASE_INFO_ENTITY_SERVICE.generateEmptyEntryDynamicObject(periodconfentity);
    }

    public DynamicObject[] getSchemeArrBySchemeIdList(List<Long> schemeIdList) {
        return SCHEME_BASE_INFO_ENTITY_SERVICE.query("id,name,schstatus,cyclescheme,isperiodassess,periodconfentity.pcyclescheme", new QFilter("id", "in", schemeIdList).toArray());
    }
}

