/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.domain.todomessage.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.opmc.epa.business.ServiceFactory;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.pbs.business.domain.msg.service.MsgSendDomainService;

public class ToDoMessageDomainService {
    private static final Long EPA_DEVINDICATOR_SIN = 1631189203540856832L;
    private static final Long EPA_DEVINDICATOR_MUL = 1631189203540856832L;
    private static final String FORMID = "formId";
    private static final String EPA_ASSINDWORKBENCH = "epa_assindworkbench";
    private static final String ACTIVITY_ID = "activityId";
    private static final MsgSendDomainService MSG_SEND_DOMAIN_SERVICE = MsgSendDomainService.getInstance();

    public static ToDoMessageDomainService getInstance() {
        return ServiceFactory.getService(ToDoMessageDomainService.class);
    }

    public void sendToDoMessage(List<DynamicObject> joinActivityEvaluation, DynamicObject assessActivity) {
        Map<Long, List<DynamicObject>> collect = joinActivityEvaluation.stream().collect(Collectors.groupingBy(this::getAssignUser));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(FORMID, EPA_ASSINDWORKBENCH);
        params.put(ACTIVITY_ID, assessActivity.getString("id"));
        collect.forEach((key, value) -> {
            if (value.size() > 1) {
                this.sendMultipleMessage((List<DynamicObject>)value, (Map<String, String>)params);
            } else {
                this.sendSingleMessage((List<DynamicObject>)value, (Map<String, String>)params);
            }
        });
    }

    private Long getAssignUser(DynamicObject dynamicObject) {
        if (dynamicObject.get("assignuser") instanceof Long) {
            return dynamicObject.getLong("assignuser");
        }
        return dynamicObject.getLong("assignuser.id");
    }

    private void sendMultipleMessage(List<DynamicObject> joinActivityEvaluation, Map<String, String> params) {
        StringBuilder multipleName = new StringBuilder();
        ArrayList<String> PersonNames = new ArrayList<String>(16);
        for (int index = 0; index < joinActivityEvaluation.size(); ++index) {
            PersonNames.add(joinActivityEvaluation.get(index).getString("person.name"));
            if (index >= 2) break;
        }
        multipleName.append(String.join((CharSequence)",", PersonNames));
        ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = new ActivityEvaluationObjectDomainService();
        DynamicObject dynamicObject = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.generateEmptyDynamicObject();
        dynamicObject.set("person", (Object)new DynamicObject(joinActivityEvaluation.get(0).getDynamicObject("person").getDynamicObjectType()));
        dynamicObject.set("person.name", (Object)multipleName.toString());
        List personIds = joinActivityEvaluation.stream().map(this::getAssignUser).collect(Collectors.toList());
        String loadKDString = ResManager.loadKDString((String)"\u6307\u6807\u5236\u5b9a", (String)"ToDoMessageDomainService_5", (String)"opmc-epa-business", (Object[])new Object[0]);
        MSG_SEND_DOMAIN_SERVICE.sendMessageWithUrl(EPA_DEVINDICATOR_MUL, personIds, dynamicObject, params, loadKDString);
    }

    private void sendSingleMessage(List<DynamicObject> joinActivityEvaluation, Map<String, String> params) {
        DynamicObject dynamicObject = joinActivityEvaluation.get(0);
        ArrayList<Long> personIds = new ArrayList<Long>();
        personIds.add(this.getAssignUser(dynamicObject));
        String loadKDString = ResManager.loadKDString((String)"\u6307\u6807\u5236\u5b9a", (String)"ToDoMessageDomainService_5", (String)"opmc-epa-business", (Object[])new Object[0]);
        MSG_SEND_DOMAIN_SERVICE.sendMessageWithUrl(EPA_DEVINDICATOR_SIN, personIds, dynamicObject, params, loadKDString);
    }
}

