/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.print;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.session.SessionManager;
import kd.bos.svc.util.FileServerUtil;
import kd.bos.url.UrlService;
import kd.opmc.epa.business.print.PrintContext;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class PrintFileOutputStream
extends OutputStream {
    private long length;
    private ByteArrayOutputStream byteOs;
    private FileOutputStream fileOs;
    private OutputStream currentOs;
    private static final long MAX_MEM_SIZE = 0x6400000L;
    private String filePath;
    private PrintContext printContext;
    private static final Log LOG = LogFactory.getLog(PrintFileOutputStream.class);

    public PrintFileOutputStream(PrintContext printContext) {
        this.printContext = printContext;
        this.filePath = this.genFilePath();
        this.byteOs = new ByteArrayOutputStream();
        this.currentOs = this.byteOs;
    }

    @Override
    public void write(int b) throws IOException {
        this.currentOs.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.beforeWrite(b);
        this.currentOs.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.beforeWrite(b);
        this.currentOs.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.currentOs.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.byteOs != null) {
            this.byteOs.close();
        }
        if (this.fileOs != null) {
            this.fileOs.close();
        }
        if (this.currentOs != null) {
            this.currentOs.close();
        }
    }

    public PrintContext getPrintContext() {
        return this.printContext;
    }

    public void setPrintContext(PrintContext printContext) {
        this.printContext = printContext;
    }

    private void beforeWrite(byte[] b) throws IOException {
        this.length += (long)b.length;
        if (this.currentOs instanceof ByteArrayOutputStream && this.length > 0x6400000L) {
            LOG.info("\u6587\u4ef6\u8d85\u8fc7{} byte,\u6539\u7528\u78c1\u76d8\u6d41", (Object)0x6400000L);
            this.fileOs = new FileOutputStream(this.filePath);
            this.fileOs.write(this.byteOs.toByteArray());
            this.currentOs = this.fileOs;
            if (this.byteOs != null) {
                this.byteOs.close();
                this.byteOs = null;
            }
        }
    }

    public String uploadFileAndGetPreviewUrl(String saveFileName) {
        try {
            String filePath = this.saveInputStream2FileServer(saveFileName, new ByteArrayInputStream(((ByteArrayOutputStream)this.currentOs).toByteArray()));
            String attachmentPreviewUrl = this.getPreviewUrl(filePath);
            String csrfTokenValue = SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
            LOG.info("file upload path :{}, file preview url:{}", (Object)filePath, (Object)attachmentPreviewUrl);
            return String.format(attachmentPreviewUrl + "&kd_cs_ticket=%s", csrfTokenValue);
        }
        catch (Exception exception) {
            LOG.error("upload file or get preview url fail ! msg: {}", (Object)exception.getMessage());
            return null;
        }
    }

    private String getPreviewUrl(String filePath) {
        String retPath = UrlService.getAttachmentPreviewUrl((String)filePath);
        try {
            HttpResponse response = this.sendGetRequest(retPath);
            if (response == null) {
                LOG.error("send request err");
                return retPath;
            }
            String contentType = response.getFirstHeader("Content-Type").getValue();
            if (contentType.startsWith("application/pdf")) {
                return retPath;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            retPath = JSONObject.fromObject((Object)result).getString("url");
            LOG.info("get file real preview url. url:{}", (Object)retPath);
            return retPath;
        }
        catch (IOException exception) {
            LOG.error("get file preview url err . file path:{}, e:{}", (Object)retPath, (Object)exception);
            return retPath;
        }
    }

    private HttpResponse sendGetRequest(String url) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String sessionUrl = EncreptSessionUtils.encryptHttpUrlSession((String)url);
        HttpGet httpGet = new HttpGet(sessionUrl);
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            LOG.error("send preview request err. url:{}, e:{}", (Object)url, (Object)e);
        }
        return response;
    }

    private String saveInputStream2FileServer(String fileFullName, ByteArrayInputStream inputStream) {
        StringBuilder sb = new StringBuilder(this.genFilePath());
        sb.append(this.printContext.getAppFormPkIdStr()).append("attachments/").append(UUID.randomUUID()).append("/");
        FileItemExt fileItem = FileServerUtil.createFileItem((String)fileFullName, (String)sb.append(fileFullName).toString(), (InputStream)inputStream, (FileSource)FileSource.PRINT_TPL);
        fileItem.setAppId("epa");
        fileItem.setCreateNewFileWhenExists(true);
        return FileServiceFactory.getAttachmentFileService().upload((FileItem)fileItem);
    }

    public String genFilePath() {
        Calendar cale = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
        String dateStr = simpleDateFormat.format(cale.getTime());
        RequestContext rc = RequestContext.getOrCreate();
        String baseDir = "/%s/%s/%s/";
        baseDir = String.format(baseDir, rc.getTenantId(), rc.getAccountId(), dateStr);
        return baseDir;
    }
}

