/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.print.font;

import com.google.common.collect.Maps;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.service.PrtFont;
import kd.bos.print.service.provider.FontServiceProvider;

public class PrintFont {
    private static final Log LOG = LogFactory.getLog(PrintFont.class);
    private static Map<String, BaseFont> cacheFont = Maps.newHashMap();
    private static final FontServiceProvider FONT_SERVICE_PROVIDER = new FontServiceProvider();

    public static Font createDefaultFont(int style, int size) {
        PrtFont defaultFont = FONT_SERVICE_PROVIDER.getDefaultFont();
        BaseFont font = PrintFont.loadFont(defaultFont);
        return new Font(font, (float)size, style);
    }

    private static BaseFont loadFont(PrtFont prtFont) {
        BaseFont baseFont;
        String name;
        block7: {
            PrtFont defaultFont = FONT_SERVICE_PROVIDER.getDefaultFont();
            name = prtFont.getFontName();
            baseFont = null;
            if (cacheFont.containsKey(name)) {
                LOG.info("\u4ece\u7f13\u5b58\u4e2d\u53d6\u4e86\u5b57\u4f53\uff1a{}", (Object)cacheFont.get(name).getPostscriptFontName());
                return cacheFont.get(name);
            }
            if (StringUtils.equals((CharSequence)defaultFont.getFontName(), (CharSequence)name)) {
                return PrintFont.loadDefaultFont();
            }
            String fileName = prtFont.getFontFileName();
            LOG.info("\u5b57\u4f53\u540d\u79f0\uff1a{}", (Object)fileName);
            fileName = "simsun.ttc";
            String fileFullName = FONT_SERVICE_PROVIDER.getFontFilesDir() + File.separator + fileName;
            LOG.info("\u5b57\u4f53\u5168\u8def\u5f84fullFontPath\uff1a{}", (Object)fileFullName);
            File fontFile = new File(fileFullName);
            boolean fontExist = fontFile.exists();
            if (!fontExist) {
                fontFile = FONT_SERVICE_PROVIDER.downloadFont(prtFont);
                fontExist = fontFile.exists();
            }
            if (fontExist) {
                try {
                    baseFont = BaseFont.createFont((String)(fileFullName + ",0"), (String)"Identity-H", (boolean)true);
                    cacheFont.put(name, baseFont);
                    LOG.info("\u6362\u7f13\u5b58\u4e2d\u53d6\u7684\u5b57\u4f53\uff1a{}", (Object)cacheFont.toString());
                }
                catch (DocumentException | IOException e) {
                    LOG.error("\u521b\u5efa\u5b57\u4f53\u5931\u8d25: {}", (Object)e.getMessage());
                    if (!(e instanceof IOException) || !fontFile.exists() || fontFile.delete()) break block7;
                    LOG.info("\u5f02\u5e38\u5b57\u4f53\u5220\u9664\u5931\u8d25\uff1a{}", (Object)fontFile.getAbsolutePath());
                }
            }
        }
        if (baseFont != null) {
            return baseFont;
        }
        BaseFont font = PrintFont.loadDefaultFont();
        cacheFont.put(name, font);
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BaseFont loadDefaultFont() {
        BaseFont font;
        block25: {
            font = null;
            PrtFont defaultFont = FONT_SERVICE_PROVIDER.getDefaultFont();
            String name = defaultFont.getFontName();
            if (cacheFont.containsKey(name)) {
                LOG.info("\u4ece\u7f13\u5b58\u4e2d\u53d6\u4e86\u5b57\u4f53\uff1a{}", (Object)cacheFont.get(name).getPostscriptFontName());
                return cacheFont.get(name);
            }
            String fileName = defaultFont.getFontFileName();
            LOG.info("\u5b57\u4f53\u540d\u79f0\uff1a{}", (Object)fileName);
            fileName = "simsun.ttc";
            String fullFontPath = FONT_SERVICE_PROVIDER.getFontFilesDir() + File.separator + fileName;
            LOG.info("\u5b57\u4f53\u5168\u8def\u5f84fullFontPath\uff1a{}", (Object)fullFontPath);
            File fontFile = new File(fullFontPath);
            try {
                block24: {
                    if (!fontFile.exists()) {
                        InputStream ios = null;
                        try {
                            ios = PrintFont.class.getClassLoader().getResourceAsStream(fileName);
                            boolean createSus = fontFile.createNewFile();
                            if (createSus && ios != null) {
                                try (FileOutputStream fos = new FileOutputStream(fontFile);){
                                    byte[] bytes = new byte[1024];
                                    int index = 0;
                                    while ((index = ios.read(bytes)) != -1) {
                                        fos.write(bytes, 0, index);
                                        fos.flush();
                                    }
                                    break block24;
                                }
                            }
                            LOG.error("\u6253\u5370\uff1a\u4ece\u78c1\u76d8\u52a0\u8f7d\u5b57\u4f53\u52a0\u8f7d\u5931\u8d25\uff0c\u78c1\u76d8\u76ee\u5f55: {}", (Object)fontFile.getPath());
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                        finally {
                            if (ios != null) {
                                PrintFont.safeClose(ios);
                            }
                        }
                    }
                }
                font = BaseFont.createFont((String)(fullFontPath + ",0"), (String)"Identity-H", (boolean)true);
                cacheFont.put(name, font);
                cacheFont.put(defaultFont.getFontCode(), font);
                LOG.info("\u5df2\u653e\u5165\u5b57\u4f53\u7f13\u5b58\uff0c\u7f13\u5b58\uff1a{}", cacheFont);
            }
            catch (DocumentException | IOException e) {
                LOG.error("\u6253\u5370\uff1a\u4ece\u78c1\u76d8\u52a0\u8f7d\u5b57\u4f53\u52a0\u8f7d\u5931\u8d25\uff0c\u78c1\u76d8\u76ee\u5f55: {}", (Object)e.getMessage());
                LOG.error(e);
                if (!(e instanceof IOException) || !fontFile.exists() || fontFile.delete()) break block25;
                LOG.info("\u5f02\u5e38\u5b57\u4f53\u5220\u9664\u5931\u8d25\uff1a{}", (Object)fontFile.getAbsolutePath());
            }
        }
        return font;
    }

    private static void safeClose(InputStream ios) {
        if (ios != null) {
            try {
                ios.close();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

