/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjCrossIndicatorEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjImportScoreIndEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalModeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.assessrule.entityservice.NormalConfigEntityService;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;

public class ActEvalObjIndUpgradeTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ActEvalObjIndUpgradeTask.class);
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final NormalConfigEntityService NORMAL_CONFIG_ENTITY_SERVICE = NormalConfigEntityService.getInstance();
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final ObjCrossIndicatorEntityService OBJ_CROSS_INDICATOR_ENTITY_SERVICE = ObjCrossIndicatorEntityService.getInstance();
    private static final ObjImportScoreIndEntityService IMPORT_SCORE_IND_ENTITY_SERVICE = ObjImportScoreIndEntityService.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info(MessageFormat.format("=================start Update {0}=================", Thread.currentThread().getName()));
        long startTime = System.currentTimeMillis();
        Object[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.getUnifiedDistEvalObj();
        if (ObjectUtils.isEmpty((Object[])evalObjs)) {
            LOG.info(MessageFormat.format("getUnifiedDistEvalObj is empty !!! cost:{0} ms", System.currentTimeMillis() - startTime));
            return;
        }
        startTime = System.currentTimeMillis();
        this.updateObjCrossIndicator((DynamicObject[])evalObjs);
        LOG.info(MessageFormat.format("saveObjCrossIndicator excute cost:{0} ms", System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        this.updateImportScoreInd((DynamicObject[])evalObjs);
        LOG.info(MessageFormat.format("saveImportScoreInd excute cost:{0} ms", System.currentTimeMillis() - startTime));
        LOG.info(MessageFormat.format("=================end Update {0}=================", Thread.currentThread().getName()));
    }

    public void updateObjCrossIndicator(DynamicObject[] evalObjs) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<DynamicObject> indicatorDyList = new ArrayList<DynamicObject>(10);
        for (DynamicObject evalObj : evalObjs) {
            List areaList;
            DynamicObjectCollection areaEntry = evalObj.getDynamicObjectCollection("areaentry");
            if (ObjectUtils.isEmpty((Object)areaEntry) || ObjectUtils.isEmpty(areaList = areaEntry.stream().filter(areaInfo -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaInfo.getLong("areareg.id"))).collect(Collectors.toList()))) continue;
            List<Long> normalConfIds = areaList.stream().map(ins -> ins.getLong("areaconf")).collect(Collectors.toList());
            DynamicObject[] normalConfs = NORMAL_CONFIG_ENTITY_SERVICE.queryConfNameByPks(normalConfIds);
            Map<Long, String> confNameMap = Arrays.stream(normalConfs).collect(Collectors.toMap(conf -> conf.getLong("id"), conf -> conf.getString("areacustname")));
            for (DynamicObject areaInfo2 : areaList) {
                long areaConfId = areaInfo2.getLong("areaconf");
                long areaInstId = areaInfo2.getLong("areains");
                Object[] indicatorDys = APP_SERVICE.queryIndicator(areaInstId, AreaRegEnum.NORM_INDCTR_AREA);
                if (ObjectUtils.isEmpty((Object[])indicatorDys)) continue;
                for (Object indicatorDy : indicatorDys) {
                    DynamicObject objCrossIndicator;
                    if (HRStringUtils.equals((String)EvalModeEnum.SYS_INPUT.getCode(), (String)indicatorDy.getString("evalmode")) || ObjectUtils.isEmpty((Object)(objCrossIndicator = OBJ_CROSS_INDICATOR_ENTITY_SERVICE.queryOneByAreaInstId(areaInstId))) || ObjectUtils.isEmpty(confNameMap) || !HRStringUtils.isEmpty((String)objCrossIndicator.getString("areaname"))) continue;
                    objCrossIndicator.set("modifytime", (Object)date);
                    objCrossIndicator.set("modifier", (Object)currUserId);
                    objCrossIndicator.set("areaname", (Object)confNameMap.get(areaConfId));
                    indicatorDyList.add(objCrossIndicator);
                }
            }
        }
        if (!ObjectUtils.isEmpty(indicatorDyList)) {
            OBJ_CROSS_INDICATOR_ENTITY_SERVICE.save(indicatorDyList.toArray(new DynamicObject[0]));
        }
    }

    public void updateImportScoreInd(DynamicObject[] evalObjs) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        ArrayList<DynamicObject> indicatorDyList = new ArrayList<DynamicObject>(10);
        for (DynamicObject evalObj : evalObjs) {
            List areaList;
            DynamicObjectCollection areaEntry = evalObj.getDynamicObjectCollection("areaentry");
            if (ObjectUtils.isEmpty((Object)areaEntry) || ObjectUtils.isEmpty(areaList = areaEntry.stream().filter(areaInfo -> AreaRegEnum.NORM_INDCTR_AREA.getAreaPkId().equals(areaInfo.getLong("areareg.id"))).collect(Collectors.toList()))) continue;
            List<Long> normalConfIds = areaList.stream().map(ins -> ins.getLong("areaconf")).collect(Collectors.toList());
            DynamicObject[] normalConfs = NORMAL_CONFIG_ENTITY_SERVICE.queryConfNameByPks(normalConfIds);
            Map<Long, String> confNameMap = Arrays.stream(normalConfs).collect(Collectors.toMap(conf -> conf.getLong("id"), conf -> conf.getString("areacustname")));
            for (DynamicObject areaInfo2 : areaList) {
                long areaConfId = areaInfo2.getLong("areaconf");
                long areaInstId = areaInfo2.getLong("areains");
                Object[] indicatorDys = APP_SERVICE.queryIndicator(areaInstId, AreaRegEnum.NORM_INDCTR_AREA);
                if (ObjectUtils.isEmpty((Object[])indicatorDys)) continue;
                for (Object indicatorDy : indicatorDys) {
                    DynamicObject importScoreInd;
                    if (!HRStringUtils.equals((String)EvalModeEnum.SYS_INPUT.getCode(), (String)indicatorDy.getString("evalmode")) || ObjectUtils.isEmpty((Object)(importScoreInd = IMPORT_SCORE_IND_ENTITY_SERVICE.queryOneByAreaInstId(areaInstId))) || ObjectUtils.isEmpty(confNameMap) || !HRStringUtils.isEmpty((String)importScoreInd.getString("areaname"))) continue;
                    importScoreInd.set("modifytime", (Object)date);
                    importScoreInd.set("modifier", (Object)currUserId);
                    importScoreInd.set("areaname", (Object)confNameMap.get(areaConfId));
                    indicatorDyList.add(importScoreInd);
                }
            }
        }
        if (!ObjectUtils.isEmpty(indicatorDyList)) {
            IMPORT_SCORE_IND_ENTITY_SERVICE.save(indicatorDyList.toArray(new DynamicObject[0]));
        }
    }
}

