/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.pmd.business.application.service.PerffileApplicationService;

public class ActivityAddActObjTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ActivityAddActObjTask.class);
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();
    private static final PerffileApplicationService PERF_FILE_APPLICATION_SERVICE = PerffileApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"ActivityAddActObjTask#&", (int)3, (int)5);
    private static final Semaphore SEMAPHORE = new Semaphore(5);
    private static final String ACTIVITY_START_UP_LOCK = "opmc/datalock/activity/startup/";
    private static final String SUCCESS_LIST = "success_list";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String PMDORG = "pmdorg";

    public void feedbackProgress(int progress, String desc) {
        super.feedbackProgress(progress, desc, null);
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map.containsKey("activity_id")) {
            try (DLock lock = DLock.create((String)(ACTIVITY_START_UP_LOCK + map.get("activity_id")));){
                lock.lock();
                String desc = ResManager.loadKDString((String)"\u6b63\u5728\u4e3a\u60a8\u81ea\u52a8\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61...", (String)"ActivityAddActObjTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
                long assessActivityPkId = Long.parseLong(String.valueOf(map.get("activity_id")));
                DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(assessActivityPkId);
                this.feedbackProgress(20, desc, null);
                List perfileIds = Lists.partition((List)((List)map.get(SUCCESS_LIST)), (int)200);
                int count = perfileIds.size();
                CountDownLatch atomicInteger = new CountDownLatch(count);
                for (int i = 0; i < count; ++i) {
                    List perfileIdsubList = (List)perfileIds.get(i);
                    int pecent = (i + 1) / count * 90;
                    this.batchsaveEvaluationObject(perfileIdsubList, activityDynObj, desc, pecent, atomicInteger);
                }
                this.feedbackProgress(100, desc, null);
            }
        }
    }

    private void batchsaveEvaluationObject(List<Long> perfileIds, DynamicObject activityDynObj, String desc, int pecent, CountDownLatch atomicInteger) {
        this.saveEvaluationObject(perfileIds, activityDynObj, desc);
        if (pecent > 0) {
            this.feedbackProgress(pecent - 1, desc, null);
        }
    }

    private void saveEvaluationObject(List<Long> perfileIds, DynamicObject activityDynObj, String desc) {
        String selectors = "person,empposrel,employee,affiliateadminorg,startdate,enddate,pmdorg,bsed,bsled";
        DynamicObject[] assessObjectJoinInCol = PERF_FILE_APPLICATION_SERVICE.getPerffileListByIds(selectors, perfileIds);
        DynamicObjectCollection assessObjectJoinInList = new DynamicObjectCollection();
        Arrays.stream(assessObjectJoinInCol).forEach(data -> assessObjectJoinInList.add(data));
        this.feedbackProgress(40, desc, null);
        this.saveAssessObjectAndEvaluationObject(activityDynObj, assessObjectJoinInList, desc);
    }

    private void saveAssessObjectAndEvaluationObject(DynamicObject curActivityDynObj, DynamicObjectCollection assessObjectJoinInList, String desc) {
        long schemeId = curActivityDynObj.getLong("scheme.id");
        long executeSchemeAssessScopeId = curActivityDynObj.getLong("executescheme.assessscope.id");
        DynamicObjectCollection assessObjectEntryEntity = this.genAssessObjectEntryEntity(assessObjectJoinInList, schemeId, executeSchemeAssessScopeId);
        DynamicObject[] assessObjectArr = ASSESS_OBJECT_APPLICATION_SERVICE.saveAssessObject(schemeId, assessObjectEntryEntity, curActivityDynObj);
        ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.saveAssessObject(curActivityDynObj, assessObjectArr);
    }

    private DynamicObjectCollection genAssessObjectEntryEntity(DynamicObjectCollection assessObjectJoinInList, long schemeId, long executeSchemeAssessScopeId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"epa_assessobject_joinin");
        DynamicObject emptyJonInDynObj = new DynamicObject((DynamicObjectType)dataEntityType);
        Object[] assessGroupArr = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessGroupArr(schemeId, executeSchemeAssessScopeId);
        Object assessGroup = null;
        for (DynamicObject dynamicObject : assessGroupArr) {
            if (!dynamicObject.getBoolean("isdefault")) continue;
            assessGroup = dynamicObject;
            break;
        }
        if (assessGroup == null && !HRArrayUtils.isEmpty((Object[])assessGroupArr) && assessGroupArr.length > 0) {
            assessGroup = assessGroupArr[0];
        }
        DynamicObjectCollection assessObjectEntryEntity = emptyJonInDynObj.getDynamicObjectCollection("assessobjectentryentity");
        for (DynamicObject perfFileDynObj : assessObjectJoinInList) {
            DynamicObject dynamicObject = assessObjectEntryEntity.addNew();
            dynamicObject.set("perffile", (Object)perfFileDynObj);
            dynamicObject.set("group", (Object)(assessGroup == null ? 0L : assessGroup.getLong("id")));
            dynamicObject.set("assessscope", (Object)(assessGroup == null ? 0L : assessGroup.getLong("objectscope.id")));
            dynamicObject.set("person", (Object)perfFileDynObj.getDynamicObject("person"));
            dynamicObject.set("empposorgrel", (Object)perfFileDynObj.getDynamicObject("empposrel"));
            dynamicObject.set("employee", (Object)perfFileDynObj.getDynamicObject("employee"));
        }
        return assessObjectEntryEntity;
    }
}

