/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;

public class ActivityAddNotJoinTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ActivityAddNotJoinTask.class);
    private static final AssessObjectApplicationService ASSESS_OBJECT = AssessObjectApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final String ACTIVITY_START_UP_LOCK = "opmc/datalock/activity/startup/";
    private static final String NOT_JOIN_ACTOBJ = "notJoinIds";
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"ActivityAddNotJoinTask#&", (int)3, (int)5);
    private static final Semaphore SEMAPHORE = new Semaphore(5);

    public void feedbackProgress(int progress, String desc) {
        super.feedbackProgress(progress, desc, null);
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map.containsKey("activity_id")) {
            try (DLock lock = DLock.create((String)(ACTIVITY_START_UP_LOCK + map.get("activity_id")));){
                lock.lock();
                String desc = ResManager.loadKDString((String)"\u6b63\u5728\u4e3a\u60a8\u81ea\u52a8\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61...", (String)"ActivityAddNotJoinTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
                long assessActivityPkId = Long.parseLong(String.valueOf(map.get("activity_id")));
                DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(assessActivityPkId);
                this.feedbackProgress(20, desc, null);
                DynamicObject[] assessObjects = ASSESS_OBJECT.queryAllObjByIds((List)map.get(NOT_JOIN_ACTOBJ));
                this.feedbackProgress(40, desc, null);
                List activityDynObjs = Lists.partition(Arrays.stream(assessObjects).collect(Collectors.toList()), (int)100);
                int count = activityDynObjs.size();
                CountDownLatch atomicInteger = new CountDownLatch(count);
                for (int i = 0; i < count; ++i) {
                    List assessObjectColls = (List)activityDynObjs.get(i);
                    int pecent = (i + 1) / count * 90;
                    this.batchsaveEvaluationObject(assessObjectColls, activityDynObj, desc, pecent, atomicInteger);
                }
                try {
                    atomicInteger.await();
                    this.feedbackProgress(100, desc, null);
                }
                catch (InterruptedException e) {
                    LOG.error("==================ActivityAddNotJoinTask==================", (Throwable)e);
                }
            }
        }
    }

    private void batchsaveEvaluationObject(List<DynamicObject> assessObjectColls, DynamicObject activityDynObj, String desc, int pecent, CountDownLatch atomicInteger) {
        try {
            LOG.info("==================start ActivityAddNotJoinTask==================");
            SEMAPHORE.acquire();
            LOG.info("==================acquire semaphore ActivityAddNotJoinTask==================");
            THREAD_POOL.execute(() -> {
                try {
                    ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.addEvaluationObjects(assessObjectColls.toArray(new DynamicObject[0]), activityDynObj);
                    if (pecent > 0) {
                        this.feedbackProgress(pecent - 1, desc, null);
                    }
                }
                catch (Exception exception) {
                    LOG.error("==================ActivityAddNotJoinTask==================", (Throwable)exception);
                }
                finally {
                    SEMAPHORE.release();
                    atomicInteger.countDown();
                    LOG.info("==================release semaphore ActivityAddNotJoinTask==================");
                }
            }, RequestContext.get());
        }
        catch (InterruptedException interruptedException) {
            LOG.error("==================ActivityAddNotJoinTask InterruptedException==================", (Throwable)interruptedException);
        }
    }
}

