/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.interview.InterviewActivityConfApplication;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.interview.service.InterviewObjDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.domain.scheme.service.ExecuteSchemeDomainService;
import kd.opmc.epa.common.constants.PassNodeConstants;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.flowscan.service.BatchFlowTaskService;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;

public class AddInterObjTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(AddInterObjTask.class);
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final ExecuteSchemeDomainService EXECUTE_SCHEME_DOMAIN_SERVICE = ExecuteSchemeDomainService.getInstance();
    private static final ExecuteSchemeEntityService ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final BatchFlowTaskService BATCH_FLOW_TASK_SERVICE = BatchFlowTaskService.getInstance();
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();
    private static final String ISSUCCESS = "issuccess";
    private final InterviewObjDomainService interviewObjDomainService = InterviewObjDomainService.getInstance();
    private static final InterviewActivityConfApplication INTERVIEW_ACTIVITY_CONF_APPLICATION = InterviewActivityConfApplication.getInstance();
    private final String[] NAMES = new String[]{"epa_actins", "epa_interins", "epa_signatureins"};
    private final Long[] IDS = new Long[]{12L, 13L, 14L};

    private Object getDefaultFlow(Long activityId) {
        Object flowId = 0L;
        DynamicObject perfWorkFlow = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryPerfWorkFlow(activityId);
        DynamicObjectCollection flowEntry = perfWorkFlow.getDynamicObjectCollection("flowentry");
        for (DynamicObject dynamicObject : flowEntry) {
            if (!dynamicObject.getBoolean("isdefaultflow") || !PassNodeConstants.INTERVIEW_PERFORMANCE.equals(dynamicObject.get("passnode"))) continue;
            flowId = dynamicObject.get("flowvid");
            break;
        }
        return flowId;
    }

    public void feedbackProgress(int progress, String desc, Map<String, Object> customData) {
        super.feedbackProgress(progress, desc, customData);
    }

    private void saveInterObj(Long[] ids, Long activityId, List<Long> fevalobjid, List<Map<String, Object>> exportDataList, HashMap<String, Object> taskInfoMap, int checkedCount, List<String> failMessage) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("epa_interobj");
        HRBaseServiceHelper evalObjServiceHelper = new HRBaseServiceHelper("epa_actevalobj");
        DynamicObject[] evalObjArr = evalObjServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)ids)});
        ArrayList<DynamicObject> interObjs = new ArrayList<DynamicObject>(10);
        Object flowId = this.getDefaultFlow(activityId);
        for (int i = 0; i < evalObjArr.length; ++i) {
            DynamicObject evalObj = evalObjArr[i];
            if (fevalobjid.contains(evalObj.get("id"))) {
                String personDesc = evalObj.getString("person.name") + " " + evalObj.getString("person.number");
                String failReson = ResManager.loadKDString((String)"{0}\uff1a \u5df2\u53c2\u4e0e\u5f53\u524d\u9762\u8c08\u6d3b\u52a8\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u6dfb\u52a0", (String)"AddInterObjTask_14", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                failMessage.add(failReson);
                String reason = ResManager.loadKDString((String)"\u5df2\u53c2\u4e0e\u5f53\u524d\u9762\u8c08\u6d3b\u52a8\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u6dfb\u52a0", (String)"AddInterObjTask_1", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.genData2Excel(exportDataList, evalObj, reason);
                taskInfoMap.put("valDealNum", checkedCount);
                double process = (double)(i + 1) / ((double)ids.length * 0.01);
                taskInfoMap.put("startDealNum", i + 1);
                taskInfoMap.put("valDealNum", checkedCount++);
                String desc = ResManager.loadKDString((String)"\u9762\u8c08\u5bf9\u8c61\u6dfb\u52a0\u4e2d...", (String)"AddInterObjTask_2", (String)"opmc-pbs-business", (Object[])new Object[0]);
                this.feedbackProgress((int)process, desc, taskInfoMap);
                continue;
            }
            DynamicObject interObj = serviceHelper.generateEmptyDynamicObject();
            interObj.set("evalobj", evalObj.getPkValue());
            interObj.set("person", evalObj.get("person"));
            interObj.set("perffile", evalObj.get("perffile"));
            interObj.set("affiliateadminorg", evalObj.get("affiliateadminorg"));
            interObj.set("empposrel", evalObj.get("empposrel"));
            interObj.set("employee", evalObj.get("employee"));
            interObj.set("perforg", evalObj.get("perforg"));
            interObj.set("interact", (Object)activityId);
            interObj.set("interflow", flowId);
            interObj.set("interstatus", (Object)"10");
            DynamicObjectCollection areaentity = interObj.getDynamicObjectCollection("areaentity");
            this.genAreaIns(areaentity);
            interObjs.add(interObj);
            double process = (double)(i + 1) / ((double)ids.length * 0.01);
            taskInfoMap.put("startDealNum", i + 1);
            taskInfoMap.put("valDealNum", ++checkedCount);
            String desc = ResManager.loadKDString((String)"\u9762\u8c08\u5bf9\u8c61\u6dfb\u52a0\u4e2d...", (String)"AddInterObjTask_2", (String)"opmc-pbs-business", (Object[])new Object[0]);
            this.feedbackProgress((int)process, desc, taskInfoMap);
        }
        if (interObjs.size() == 0) {
            return;
        }
        DynamicObject[] saveInterObjs = interObjs.toArray(new DynamicObject[0]);
        serviceHelper.save(saveInterObjs);
        this.interviewObjDomainService.PreProcessInstance(saveInterObjs);
    }

    private void genAreaIns(DynamicObjectCollection areaentity) {
        for (int j = 0; j < 3; ++j) {
            DynamicObject dynamicObject = areaentity.addNew();
            dynamicObject.set("area", (Object)this.IDS[j]);
            dynamicObject.set("areains", this.genDynamicObjectWithPkid(this.NAMES[j], "t_" + this.NAMES[j]).getPkValue());
        }
    }

    private DynamicObject genDynamicObjectWithPkid(String entityName, String tableName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        long[] pkid = DBServiceHelper.genLongIds((String)tableName, (int)1);
        DynamicObject instance = serviceHelper.generateEmptyDynamicObject();
        instance.set("id", (Object)pkid[0]);
        serviceHelper.save(new DynamicObject[]{instance});
        return instance;
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) {
        List evalObjectIds = (List)params.get("evalobjlist");
        Long[] ids = evalObjectIds.toArray(new Long[0]);
        Long activity = (Long)params.get("activity");
        HashMap<String, Object> taskInfoMap = new HashMap<String, Object>(16);
        taskInfoMap.put("valTotalNum", ids.length);
        taskInfoMap.put("valDealNum", 0);
        taskInfoMap.put("startTotalNum", ids.length);
        taskInfoMap.put("startDealNum", 0);
        int checkedCount = 0;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("epa_actevalobj");
        QFilter filter = new QFilter("id", "in", (Object)ids);
        QFilter statusFilter = new QFilter("assessstaus", "=", (Object)"40");
        DynamicObject[] evalObj = serviceHelper.query("id,person.name,perffile.number,person.number,activity.name,", new QFilter[]{filter, statusFilter});
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(10);
        ArrayList<String> failMessage = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : evalObj) {
            String desc = ResManager.loadKDString((String)"\u542f\u52a8\u6307\u6807\u5236\u5b9a\u6821\u9a8c\u4e2d...", (String)"AddInterObjTask_3", (String)"opmc-pbs-business", (Object[])new Object[0]);
            taskInfoMap.put("valDealNum", checkedCount++);
            double process = (double)checkedCount / ((double)ids.length * 0.01);
            this.feedbackProgress((int)process, desc, taskInfoMap);
            String personDesc = dynamicObject.getString("person.name") + " " + dynamicObject.getString("person.number");
            Object activityName = dynamicObject.get("activity.name");
            String failReson = ResManager.loadKDString((String)"{0}\uff1a \u5df2\u9000\u51fa\u5173\u8054\u8003\u6838\u6d3b\u52a8-{1}", (String)"AddInterObjTask_15", (String)"opmc-epa-business", (Object[])new Object[]{personDesc, activityName});
            failMessage.add(failReson);
            String reason = ResManager.loadKDString((String)"\u5df2\u9000\u51fa\u5173\u8054\u8003\u6838\u6d3b\u52a8\uff0c\u65e0\u6cd5\u4f5c\u4e3a\u9762\u8c08\u5bf9\u8c61\u53c2\u4e0e\u5f53\u524d\u9762\u8c08\u6d3b\u52a8", (String)"AddInterObjTask_5", (String)"opmc-epa-business", (Object[])new Object[0]);
            this.genData2Excel(exportDataList, dynamicObject, reason);
        }
        List quiteEvalObj = Arrays.stream(evalObj).map(obj -> (Long)obj.get("id")).collect(Collectors.toList());
        List<Long> passEval = Arrays.stream(ids).filter(id -> !quiteEvalObj.contains(id)).collect(Collectors.toList());
        HRBaseServiceHelper interObjServiceHelper = new HRBaseServiceHelper("epa_interobj");
        QFilter evalfilter = new QFilter("evalobj", "in", (Object)passEval.toArray(new Long[0]));
        QFilter activityfilter = new QFilter("interact", "=", (Object)activity);
        DynamicObject[] evalObjIdsExist = interObjServiceHelper.query("evalobj", new QFilter[]{evalfilter, activityfilter});
        List<Long> existedInterObjs = Arrays.stream(evalObjIdsExist).map(evalObjEx -> (Long)evalObjEx.get("evalobj.id")).collect(Collectors.toList());
        this.saveInterObj(passEval.toArray(new Long[0]), activity, existedInterObjs, exportDataList, taskInfoMap, checkedCount, failMessage);
        this.feedbackCustomdata(this.getResultMap(taskInfoMap, evalObjectIds, exportDataList, failMessage, passEval, existedInterObjs));
    }

    private HashMap<String, Object> getResultMap(HashMap<String, Object> taskInfoMap, List<Long> evalObjectIds, List<Map<String, Object>> exportDataList, List<String> failMessage, List<Long> passEval, List<Long> existedInterObjs) {
        int toltal = evalObjectIds.size();
        int successCount = passEval.size() - existedInterObjs.size();
        int failCount = toltal - successCount;
        if (toltal == successCount) {
            taskInfoMap.put(ISSUCCESS, "0");
        } else if (toltal == failCount) {
            taskInfoMap.put(ISSUCCESS, "2");
            String exportUrl = null;
            try {
                String excelName = ResManager.loadKDString((String)"\u6dfb\u52a0\u9762\u8c08\u5bf9\u8c61\u6821\u9a8c_\u9519\u8bef\u62a5\u544a_{0}", (String)"AddInterObjTask_13", (String)"opmc-epa-business", (Object[])new Object[]{HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss")});
                List<HRExportHeadObject> headDataList = this.getExportHead();
                exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, exportDataList, headDataList);
                taskInfoMap.put("downloadurl", exportUrl);
            }
            catch (IOException e) {
                log.error("StartFormulateTask exportUrl failure: ", (Throwable)e);
            }
        } else {
            taskInfoMap.put(ISSUCCESS, "1");
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6dfb\u52a0\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"AddInterObjTask_7", (String)"opmc-epa-business", (Object[])new Object[0]), toltal, successCount, failCount);
            Tuple message = Tuple.create((Object)title, (Object)String.join((CharSequence)"\n", failMessage));
            taskInfoMap.put("title", title);
            taskInfoMap.put("errinfo", String.join((CharSequence)"\n", failMessage));
        }
        return taskInfoMap;
    }

    private void genData2Excel(List<Map<String, Object>> exportDataList, DynamicObject evalObj, String reason) {
        HashMap<String, Object> exportData = new HashMap<String, Object>(16);
        exportData.put("perffilenumber", evalObj.get("perffile.number"));
        exportData.put("name", evalObj.get("person.name"));
        exportData.put("number", evalObj.get("person.number"));
        exportData.put("activity", evalObj.get("activity.name"));
        exportData.put("reason", reason);
        exportDataList.add(exportData);
    }

    private List<HRExportHeadObject> getExportHead() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("perffilenumber", ResManager.loadKDString((String)"\u7ee9\u6548\u6863\u6848\u7f16\u7801", (String)"AddInterObjTask_8", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"AddInterObjTask_9", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AddInterObjTask_10", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("activity", ResManager.loadKDString((String)"\u5173\u8054\u8003\u6838\u6d3b\u52a8", (String)"AddInterObjTask_11", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"AddInterObjTask_12", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        return headDataList;
    }
}

