/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.DynPermUpdateRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.indicator.service.IndicatorObjDomainService;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;
import kd.opmc.epa.business.domain.upgradeparam.entity.UpgradeParamEntityService;
import kd.opmc.epa.business.utils.ActivityPermissionUtils;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.workflow.service.FlowAssistDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;

public class AtivityPermUpdateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(AtivityPermUpdateTask.class);
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY = AssessActivityEntityService.getInstance();
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = FlowRuProcBatchDomainService.getInstance();
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();
    private static final FlowAssistDomainService FLOW_ASSIST_DOMAIN_SERVICE = FlowAssistDomainService.getInstance();
    private static final IndicatorObjDomainService INDICATOR_OBJ_DOMAIN_SERVICE = IndicatorObjDomainService.getInstance();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"AtivityPermUpdateTask#&", (int)2, (int)3);
    private static final Semaphore SEMAPHORE = new Semaphore(2);
    private static final DynPermUpdateRecordEntityService DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE = DynPermUpdateRecordEntityService.getInstance();
    private static final UpgradeParamEntityService UPGRADE_PARAM_ENTITY_SERVICE = UpgradeParamEntityService.getInstance();
    private static final long UPGRADE_PARAM_PK_ID = 1972597508609672192L;
    private static final String ACTIVITY_START_UP_LOCK = "opmc/datalock/activity/update/";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String lockKey = ACTIVITY_START_UP_LOCK + requestContext.getTenantId();
        try (DLock lock = DLock.create((String)lockKey);){
            Long activityId = (Long)map.get("activity_id");
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
            String key = "isUpdateActivity" + requestContext.getTenantId();
            cache.put(key, (Object)"1", 86400);
            DynamicObject[] activityDyns = activityId == null || activityId == 0L ? ACTIVITY_ENTITY.query("dynamicpermission,perfworkflow,processpermsetting.id,executescheme.assessform.id,executescheme.perfworkflow.id", new QFilter[]{new QFilter("dynamicpermission", "is null", null).or(new QFilter("dynamicpermission", "=", (Object)0L))}) : ACTIVITY_ENTITY.query("dynamicpermission,perfworkflow,processpermsetting.id,executescheme.assessform.id,executescheme.perfworkflow.id", new QFilter[]{new QFilter("id", "=", (Object)activityId)});
            List activityDynIds = Arrays.stream(activityDyns).map(data -> data.getLong("id")).collect(Collectors.toList());
            List activityDynGroupIds = Lists.partition(activityDynIds, (int)1);
            int count = activityDynGroupIds.size();
            CountDownLatch atomicInteger = new CountDownLatch(count);
            for (int i = 0; i < count; ++i) {
                List activitySubDynGroupIds = (List)activityDynGroupIds.get(i);
                int pecent = (i + 1) / count * 90;
                this.batchGroupUpdate(activitySubDynGroupIds, atomicInteger, pecent);
            }
            try {
                atomicInteger.await();
                this.feedbackProgress(100, null, null);
            }
            catch (InterruptedException e) {
                LOG.error("==================ActivityAddNotJoinTask==================", (Throwable)e);
            }
            QFilter activityQFilter = new QFilter("dynamicpermission", "=", (Object)0L);
            if (!ACTIVITY_ENTITY.isExists(activityQFilter)) {
                DynamicObject updateParam = UPGRADE_PARAM_ENTITY_SERVICE.queryOne(1972597508609672192L);
                updateParam.set("isupgrade", (Object)Character.valueOf('0'));
                UPGRADE_PARAM_ENTITY_SERVICE.saveOne(updateParam);
            }
            cache.put(key, (Object)"");
            LOG.info(MessageFormat.format("=================AtivityPermUpdateTask end Update {0}=================", Thread.currentThread().getName()));
        }
    }

    private void batchGroupUpdate(List<Long> activityDynIds, CountDownLatch atomicInteger, int pecent) {
        try {
            LOG.info("==================start AtivityPermUpdateTask==================");
            SEMAPHORE.acquire();
            LOG.info("==================acquire semaphore AtivityPermUpdateTask==================");
            THREAD_POOL.execute(() -> {
                try {
                    this.batchUpdateActivitiesPerm(activityDynIds);
                    if (pecent > 0) {
                        this.feedbackProgress(pecent - 1, null, null);
                    }
                }
                catch (Exception exception) {
                    LOG.error("==================AtivityPermUpdateTask==================", (Throwable)exception);
                    DynamicObject activityDyns = ACTIVITY_ENTITY.queryOne(activityDynIds.get(0));
                    DynamicObject recoedDyn = DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE.queryByBusiness((Long)activityDynIds.get(0), "2");
                    if (recoedDyn == null) {
                        recoedDyn = DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE.generateEmptyDynamicObject();
                    }
                    recoedDyn.set("activity", activityDynIds.get(0));
                    recoedDyn.set("name", (Object)activityDyns.getString("name"));
                    recoedDyn.set("number", (Object)activityDyns.getString("number"));
                    recoedDyn.set("status", (Object)"-1");
                    recoedDyn.set("traceid", (Object)RequestContext.get().getTraceId());
                    recoedDyn.set("exceptiondesc", (Object)(CommonUtil.getStackTrace((Exception)exception).length() > 2000 ? CommonUtil.getStackTrace((Exception)exception).substring(0, 1999) : CommonUtil.getStackTrace((Exception)exception)));
                    DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE.saveOne(recoedDyn);
                }
                finally {
                    SEMAPHORE.release();
                    atomicInteger.countDown();
                    LOG.info("==================release semaphore AtivityPermUpdateTask==================");
                }
            }, RequestContext.get());
        }
        catch (InterruptedException interruptedException) {
            LOG.error("==================AtivityPermUpdateTask InterruptedException==================", (Throwable)interruptedException);
        }
    }

    private void batchUpdateActivitiesPerm(List<Long> activityDynIds) {
        Long activityId = activityDynIds.get(0);
        try (TXHandle txHandle = TX.requiresNew();){
            DynamicObject[] activityDyns = ACTIVITY_ENTITY.query("dynamicpermission,perfworkflow,processpermsetting.id,assessform,executescheme.assessform.id,executescheme.perfworkflow.id", new QFilter[]{new QFilter("id", "=", (Object)activityId)});
            LOG.info(MessageFormat.format("=================AtivityPermUpdateTask start Update flow and form {0}=================", Thread.currentThread().getName()));
            ActivityPermissionUtils.setActivityAndCopyFlowForUpdate(activityDyns);
            LOG.info(MessageFormat.format("=================AtivityPermUpdateTask end Update flow and form {0}=================", Thread.currentThread().getName()));
            List<Long> perfworkids = Arrays.stream(activityDyns).map(activityDyn -> activityDyn.getLong("perfworkflow")).collect(Collectors.toList());
            DynamicObject[] perfWorkFlowDyns = PERF_WORK_FLOW_ENTITY_SERVICE.getPerfWorkflows(perfworkids);
            Map<Long, DynamicObject> perfWorkMap = Arrays.stream(perfWorkFlowDyns).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            HashMap<Long, DynamicObject> activityWorkFlowMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject activity : activityDyns) {
                activityWorkFlowMap.put(activity.getLong("id"), perfWorkMap.get(activity.getLong("perfworkflow")));
            }
            ASSESS_ACTIVITY_APPLICATION_SERVICE.saveActivity(activityDyns);
            for (DynamicObject activity : activityDyns) {
                DynamicObject[] evaluationObjectSavedArr = this.getEvaluationObjectByIdList(activity.getLong("id"));
                List evalflowInsIdList = Arrays.stream(evaluationObjectSavedArr).filter(data -> data.getLong("evalflowins.id") != 0L).map(data -> data.getLong("evalflowins.id")).collect(Collectors.toList());
                List fomulateInsIdList = Arrays.stream(evaluationObjectSavedArr).filter(data -> data.getLong("formulateflowins.id") != 0L).map(data -> data.getLong("formulateflowins.id")).collect(Collectors.toList());
                LOG.info(MessageFormat.format("=================AtivityPermUpdateTask start Update flowproc {0}=================", Thread.currentThread().getName()));
                FLOW_ASSIST_DOMAIN_SERVICE.batchRefreshRunproc(fomulateInsIdList, evalflowInsIdList, Long.valueOf(activity.getLong("perfworkflow")));
                LOG.info(MessageFormat.format("=================AtivityPermUpdateTask end Update flowproc {0}=================", Thread.currentThread().getName()));
                DynamicObject perfworkDyn = (DynamicObject)activityWorkFlowMap.get(activity.getLong("id"));
                DynamicObjectCollection perfworkEntryDyns = perfworkDyn.getDynamicObjectCollection("flowentry");
                Map<Long, Long> entryEntities = perfworkEntryDyns.stream().collect(Collectors.toMap(k -> k.getLong("sourceentryid"), v -> v.getLong("flowvid")));
                for (DynamicObject entry : evaluationObjectSavedArr) {
                    Long evaflowVid = entryEntities.get(entry.getLong("evalflow.id"));
                    Long formulateflowVid = entryEntities.get(entry.getLong("formulateflow.id"));
                    if (evaflowVid != null && evaflowVid != 0L) {
                        entry.set("evalflow", (Object)evaflowVid);
                    }
                    if (formulateflowVid == null || formulateflowVid == 0L) continue;
                    entry.set("formulateflow", (Object)formulateflowVid);
                }
                ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evaluationObjectSavedArr);
                LOG.info(MessageFormat.format("=================AtivityPermUpdateTask start Update areaconf {0}=================", Thread.currentThread().getName()));
                INDICATOR_OBJ_DOMAIN_SERVICE.upgradeObjAreaConfFormAssForm(activityDynIds);
                LOG.info(MessageFormat.format("=================AtivityPermUpdateTask end Update areaconf {0}=================", Thread.currentThread().getName()));
            }
            DynamicObject recoedDyn = DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE.queryByBusiness(activityId, "2");
            if (recoedDyn == null) {
                recoedDyn = DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE.generateEmptyDynamicObject();
                recoedDyn.set("activity", (Object)activityId);
            }
            recoedDyn.set("status", (Object)"1");
            recoedDyn.set("name", (Object)activityDyns[0].getString("name"));
            recoedDyn.set("number", (Object)activityDyns[0].getString("number"));
            DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE.saveOne(recoedDyn);
        }
    }

    private DynamicObject[] getEvaluationObjectByIdList(Long activityId) {
        DynamicObject[] evaluationObjList = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryActivityEvaluationObjectActivityId("id,assessstaus", activityId);
        List<Long> evaluationObjIdList = Arrays.stream(evaluationObjList).map(evaobj -> evaobj.getLong("id")).collect(Collectors.toList());
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(evaluationObjIdList);
    }
}

