/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entity.CopyHisIndicatorTaskBo;
import kd.opmc.epa.business.domain.activitymanage.entity.CopyHisIndicatorTaskVo;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.indicator.entity.AreaNameMappingBo;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;

public class CopyHisIndicatorTask
extends AbstractTask {
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<Object> msgList = new ArrayList<Object>(16);
        List<Long> successObjList = new ArrayList<Long>(16);
        Object[] evalObjectIds = (Object[])SerializationUtils.deSerializeFromBase64((String)map.get("evalObjectIds").toString());
        Object copyActId = SerializationUtils.deSerializeFromBase64((String)map.get("copyActId").toString());
        Object fromActId = SerializationUtils.deSerializeFromBase64((String)map.get("fromActId").toString());
        if (HRArrayUtils.isEmpty((Object[])evalObjectIds) || HRObjectUtils.isEmpty((Object)copyActId) || HRObjectUtils.isEmpty((Object)fromActId)) {
            return;
        }
        Long[] evalObjectIdList = (Long[])Arrays.stream(evalObjectIds).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        Object[] allCopyToDynamicObjects = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(Arrays.asList(evalObjectIdList));
        if (HRArrayUtils.isEmpty((Object[])allCopyToDynamicObjects)) {
            return;
        }
        List<Long> copyToActIds = Arrays.stream(allCopyToDynamicObjects).map(dyc -> dyc.getLong("activity.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> toActivityAssessFromMaps = ASSESS_ACTIVITY_APPLICATION_SERVICE.getAssessFromByActivityIds(copyToActIds);
        int allSize = allCopyToDynamicObjects.length;
        String desc = ResManager.loadKDString((String)"\u63d0\u4ea4\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762\uff0c\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c", (String)"CopyHisIndicatorTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>(16);
        resultMap.put("valTotalNum", Integer.valueOf(allSize));
        resultMap.put("valDealNum", Integer.valueOf(0));
        resultMap.put("startTotalNum", Integer.valueOf(allSize));
        resultMap.put("startDealNum", Integer.valueOf(0));
        resultMap.put("success", Integer.valueOf(0));
        resultMap.put("fail", Integer.valueOf(allSize));
        resultMap.put("total", Integer.valueOf(allSize));
        resultMap.put("msgList", (Serializable)((Object)msgList));
        this.feedbackProgress(10, desc, resultMap);
        ArrayList<Object> copyToDynamicObjectList = new ArrayList<Object>(16);
        for (Object allCopyToDynamicObject : allCopyToDynamicObjects) {
            if (HRObjectUtils.equals((Object)allCopyToDynamicObject.getLong("activity.id"), (Object)((Long)fromActId)) && HRObjectUtils.equals((Object)allCopyToDynamicObject.getString("assessstaus"), (Object)AssessStausEnum.JOINED.getStatus())) {
                copyToDynamicObjectList.add(allCopyToDynamicObject);
                continue;
            }
            DynamicObject[] msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u5df2\u4e0d\u5728\u5f85\u5236\u5b9a\u73af\u8282\uff0c\u4e0d\u53ef\u590d\u5236\u5386\u53f2\u6307\u6807\u3002", (String)"CopyHisIndicatorTask_1", (String)"opmc-epa-business", (Object[])new Object[]{allCopyToDynamicObject.getString("person.name"), allCopyToDynamicObject.getString("person.number")});
            msgList.add(msg);
        }
        if (copyToDynamicObjectList.isEmpty()) {
            resultMap.put("valDealNum", Integer.valueOf(allSize));
            this.feedbackProgress(80, desc, resultMap);
            this.feedbackCustomdata(resultMap);
            return;
        }
        DynamicObject[] copyToDynamicObjects = copyToDynamicObjectList.toArray(new DynamicObject[0]);
        List perfFileIds = Arrays.stream(copyToDynamicObjects).map(dyc -> dyc.getLong("perffile.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("activity", "=", copyActId);
        qFilter.and("perffile", "in", perfFileIds);
        Object[] copyFromDynamicObjects = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectByFilter(qFilter);
        if (HRArrayUtils.isEmpty((Object[])copyFromDynamicObjects)) {
            for (DynamicObject copyToDynamicObject : copyToDynamicObjects) {
                String msg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5f53\u524d\u5236\u5b9a\u5bf9\u8c61\u4e0d\u5728\u6240\u9009\u5386\u53f2\u8003\u6838\u6d3b\u52a8\u4e2d\uff0c\u65e0\u6cd5\u590d\u5236\u5386\u53f2\u6307\u6807\u3002", (String)"CopyHisIndicatorTask_2", (String)"opmc-epa-business", (Object[])new Object[]{copyToDynamicObject.getString("person.name"), copyToDynamicObject.getString("person.number")});
                msgList.add(msg);
            }
            resultMap.put("valDealNum", Integer.valueOf(allSize));
            this.feedbackProgress(80, desc, resultMap);
            this.feedbackCustomdata(resultMap);
            return;
        }
        List<Long> copyFromActIds = Arrays.stream(copyFromDynamicObjects).map(dyc -> dyc.getLong("activity.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> fromActivityAssessFromMaps = ASSESS_ACTIVITY_APPLICATION_SERVICE.getAssessFromByActivityIds(copyFromActIds);
        resultMap.put("valDealNum", Integer.valueOf(allSize));
        this.feedbackProgress(20, desc, resultMap);
        Map<Long, DynamicObject> copyFromDycMaps = Arrays.stream(copyFromDynamicObjects).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("perffile.id"), Function.identity()));
        HashMap<Long, Map<String, AreaNameMappingBo>> copyFromObjAreaMap = new HashMap<Long, Map<String, AreaNameMappingBo>>(16);
        for (Object copyFromDynamicObject : copyFromDynamicObjects) {
            HashMap<String, AreaNameMappingBo> copyFromAreaMap = new HashMap<String, AreaNameMappingBo>(16);
            DynamicObjectCollection copyFromAreaEntry = copyFromDynamicObject.getDynamicObjectCollection("areaentry");
            for (DynamicObject dynamicObject2 : copyFromAreaEntry) {
                String formId;
                Object areaRegId = dynamicObject2.getLong("areareg.id");
                Long confId = dynamicObject2.getLong("areaconf");
                switch (formId = AreaRegEnum.get((Long)areaRegId).getEvalObjAreaPageIdOfAssign()) {
                    case "epa_genareains_assign": {
                        DynamicObject normalConfig = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryNormalConfigByPk(confId);
                        copyFromAreaMap.put(normalConfig.getString("areacustname"), new AreaNameMappingBo(normalConfig, dynamicObject2));
                        break;
                    }
                    case "epa_addsubareains_assign": {
                        DynamicObject plusMinusConfig = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryPlusMinusConfigByPk(confId);
                        copyFromAreaMap.put(plusMinusConfig.getString("areacustname"), new AreaNameMappingBo(plusMinusConfig, dynamicObject2));
                        break;
                    }
                    case "epa_attachareains_assign": {
                        DynamicObject attachConfig = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAttachConfigByPk(confId);
                        copyFromAreaMap.put(attachConfig.getString("areacustname"), new AreaNameMappingBo(attachConfig, dynamicObject2));
                        break;
                    }
                }
            }
            copyFromObjAreaMap.put(copyFromDynamicObject.getLong("perffile.id"), copyFromAreaMap);
        }
        this.feedbackProgress(30, desc, resultMap);
        DynamicObjectCollection copyToAreaEntry = copyToDynamicObjects[0].getDynamicObjectCollection("areaentry");
        HashMap<String, AreaNameMappingBo> copyToAreaMap = new HashMap<String, AreaNameMappingBo>(16);
        HashMap<Long, String> copyToAreaRegIdMap = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject3 : copyToAreaEntry) {
            Long areaRegId = dynamicObject3.getLong("areareg.id");
            Long confId = dynamicObject3.getLong("areaconf");
            String formId = AreaRegEnum.get((Long)areaRegId).getEvalObjAreaPageIdOfAssign();
            switch (formId) {
                case "epa_genareains_assign": {
                    DynamicObject normalConfig = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryNormalConfigByPk(confId);
                    copyToAreaMap.put(normalConfig.getString("areacustname"), new AreaNameMappingBo(normalConfig, dynamicObject3));
                    copyToAreaRegIdMap.put(confId, normalConfig.getString("areacustname"));
                    break;
                }
                case "epa_addsubareains_assign": {
                    DynamicObject plusMinusConfig = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryPlusMinusConfigByPk(confId);
                    copyToAreaMap.put(plusMinusConfig.getString("areacustname"), new AreaNameMappingBo(plusMinusConfig, dynamicObject3));
                    copyToAreaRegIdMap.put(confId, plusMinusConfig.getString("areacustname"));
                    break;
                }
                case "epa_attachareains_assign": {
                    DynamicObject attachConfig = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAttachConfigByPk(confId);
                    copyToAreaMap.put(attachConfig.getString("areacustname"), new AreaNameMappingBo(attachConfig, dynamicObject3));
                    copyToAreaRegIdMap.put(confId, attachConfig.getString("areacustname"));
                    break;
                }
            }
        }
        this.feedbackProgress(40, desc, resultMap);
        DynamicObject fromActObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(copyActId);
        DynamicObject toActObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(fromActId);
        DynamicObject copyFromAssessFormDy = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.loadAssessForm(fromActObj.getLong("assessform.id"));
        DynamicObject copyToAssessFormDy = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.loadAssessForm(toActObj.getLong("assessform.id"));
        CopyHisIndicatorTaskBo copyHisIndicatorTaskBo = new CopyHisIndicatorTaskBo();
        copyHisIndicatorTaskBo.setCopyToDynamicObjects(copyToDynamicObjects);
        copyHisIndicatorTaskBo.setCopyFromDycMaps(copyFromDycMaps);
        copyHisIndicatorTaskBo.setCopyFromObjAreaMap(copyFromObjAreaMap);
        copyHisIndicatorTaskBo.setCopyToAreaMap(copyToAreaMap);
        copyHisIndicatorTaskBo.setCopyToAreaRegIdMap(copyToAreaRegIdMap);
        copyHisIndicatorTaskBo.setFromActivityAssessFromMaps(fromActivityAssessFromMaps);
        copyHisIndicatorTaskBo.setToActivityAssessFromMaps(toActivityAssessFromMaps);
        copyHisIndicatorTaskBo.setSuccessObjList(successObjList);
        copyHisIndicatorTaskBo.setCopyFromAssessFormDy(copyFromAssessFormDy);
        copyHisIndicatorTaskBo.setCopyToAssessFormDy(copyToAssessFormDy);
        this.feedbackProgress(50, desc, resultMap);
        CopyHisIndicatorTaskVo copyHisIndicatorTaskVo = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.copyIndicatorArea(copyHisIndicatorTaskBo);
        List<String> msgs = copyHisIndicatorTaskVo.getMsgList();
        List<Long> objList = copyHisIndicatorTaskVo.getSuccessObjList();
        List<Long> haIfSuccessObjList = copyHisIndicatorTaskVo.getHaIfSuccessObjList();
        msgList.addAll(msgs);
        successObjList.addAll(objList);
        successObjList.addAll(haIfSuccessObjList);
        msgList = msgList.stream().distinct().collect(Collectors.toList());
        successObjList = successObjList.stream().distinct().collect(Collectors.toList());
        resultMap.put("msgList", (Serializable)((Object)msgList));
        resultMap.put("fail", Integer.valueOf(allSize - objList.size() - haIfSuccessObjList.size()));
        resultMap.put("success", Integer.valueOf(objList.size()));
        resultMap.put("halfsuccess", Integer.valueOf(haIfSuccessObjList.size()));
        resultMap.put("startDealNum", Integer.valueOf(allSize));
        this.feedbackProgress(80, desc, resultMap);
        if (!successObjList.isEmpty()) {
            ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.batchUpdateWeightAndIndctrScore(successObjList);
        }
        this.feedbackCustomdata(resultMap);
    }
}

