/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.opmc.epa.business.application.service.scheme.ExecuteSchemeApplicationService;

public class ExecuteSchemeUpdateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ExecuteSchemeUpdateTask.class);
    private static final ExecuteSchemeApplicationService EXECUTE_SCHEME_APPLICATION_SERVICE = ExecuteSchemeApplicationService.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info(MessageFormat.format("=================start Update {0}=================", Thread.currentThread().getName()));
        long startTime = System.currentTimeMillis();
        DynamicObject[] dynamicObjects = EXECUTE_SCHEME_APPLICATION_SERVICE.query("org.id,adminorg.id,scheme.id,scheme.org.id,scheme.adminorg.id", new QFilter[0], "");
        LOG.info(MessageFormat.format("queryDepemp cost:{0} ms", System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        List executeSchemeDyns = Arrays.stream(dynamicObjects).map(data -> {
            data.set("org", (Object)data.getLong("scheme.org.id"));
            data.set("adminorg", (Object)data.getLong("scheme.adminorg.id"));
            return data;
        }).collect(Collectors.toList());
        DynamicObjectCollection cols = new DynamicObjectCollection();
        cols.addAll(executeSchemeDyns);
        EXECUTE_SCHEME_APPLICATION_SERVICE.batchSave(cols);
        LOG.info(MessageFormat.format("excute cost:{0} ms", System.currentTimeMillis() - startTime));
        LOG.info(MessageFormat.format("=================end Update {0}=================", Thread.currentThread().getName()));
    }
}

