/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.task.extpoint.IndicatorBatchRollbackCheckService;
import kd.opmc.epa.business.task.extpoint.impl.IndicatorBatchRollbackCheckServiceImpl;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.vo.NodeIdAndTaskIdMapVO;

public class RollbackBatchIndicatorTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(RollbackBatchIndicatorTask.class);
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List objIds = (List)SerializationUtils.deSerializeFromBase64((String)map.get("evaluationObjectIds").toString());
        Map taskMap = (Map)SerializationUtils.deSerializeFromBase64((String)map.get("taskMap").toString());
        Map objMap = (Map)SerializationUtils.deSerializeFromBase64((String)map.get("objMap").toString());
        String reason = map.get("reason") == null ? "" : (String)map.get("reason");
        ArrayList tasklist = new ArrayList(taskMap.values());
        String desc = ResManager.loadKDString((String)"\u56de\u9000\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762", (String)"RollbackBatchIndicatorTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>(16);
        resultMap.put("valTotalNum", Integer.valueOf(objIds.size()));
        resultMap.put("valDealNum", Integer.valueOf(0));
        resultMap.put("startTotalNum", Integer.valueOf(objIds.size()));
        resultMap.put("startDealNum", Integer.valueOf(0));
        this.feedbackProgress(0, desc, resultMap);
        if (ObjectUtils.isEmpty((Object)objIds)) {
            return;
        }
        ArrayList msgList = new ArrayList(16);
        DynamicObject[] taskDys = FLOW_RU_PROC_APPLICATION_SERVICE.queryNoOperateTasksById(tasklist);
        NodeIdAndTaskIdMapVO nodeIdAndTaskIdMapVO = FLOW_RU_PROC_APPLICATION_SERVICE.getNodeIdAndTaskIdMapVO(tasklist);
        List nodeIds = nodeIdAndTaskIdMapVO.getNodeId();
        Map taskNodeIdMap = nodeIdAndTaskIdMapVO.getTaskNodeIdMap();
        HashMap<Long, DynamicObject> nodeIdUserDyMap = new HashMap<Long, DynamicObject>(16);
        HashMap taskIdUserDyMap = new HashMap(16);
        List<Long> lockedNodeList = this.getLockedNode(nodeIds, nodeIdUserDyMap);
        ArrayList lockedTaskList = new ArrayList(10);
        for (Long lockedNodeId : lockedNodeList) {
            taskNodeIdMap.forEach((taskId, nodeId) -> {
                if (lockedNodeId.equals(nodeId)) {
                    lockedTaskList.add(taskId);
                    taskIdUserDyMap.put(taskId, nodeIdUserDyMap.get(nodeId));
                }
            });
        }
        this.feedbackProgress(10, desc, resultMap);
        Map<Long, String> personNameAndNumberMap = APP_SERVICE.getPersonNameAndNumberByIds(objIds);
        LinkedList canOpTaskList = new LinkedList();
        LinkedList<Long> canOpObjList = new LinkedList<Long>();
        this.feedbackProgress(20, desc, resultMap);
        for (Long objId : objIds) {
            IndicatorBatchRollbackCheckServiceImpl indicatorBatchRollbackCheckService = new IndicatorBatchRollbackCheckServiceImpl();
            HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)indicatorBatchRollbackCheckService, IndicatorBatchRollbackCheckService.class, (String)"kd.opmc.epa.business.task.extpoint.IndicatorBatchRollbackCheckService#getNoInOperateTaskMsg", (PluginFilter)null);
            List noInOperateTaskMsgList = proxy.callReplaceIfPresent(validate -> validate.getNoInOperateTaskMsg((Long)taskMap.get(objId), taskDys, (String)personNameAndNumberMap.get(objId)));
            if (noInOperateTaskMsgList != null && noInOperateTaskMsgList.size() > 0 && !HRStringUtils.isEmpty((String)((String)noInOperateTaskMsgList.get(0)))) {
                msgList.add(noInOperateTaskMsgList.get(0));
                continue;
            }
            if (taskMap.get(objId) != null && lockedTaskList.contains(taskMap.get(objId))) {
                String lockedMsgTxt = ResManager.loadKDString((String)"{0}\uff1a\u8be5\u4eba\u5458\u7684\u4efb\u52a1\u6b63\u5728\u88ab\u5236\u5b9a\u4eba\u3010{1} {2} \u3011\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u9000\u56de\u3002", (String)"RollbackBatchIndicatorTask_1", (String)"opmc-epa-business", (Object[])new Object[]{personNameAndNumberMap.get(objId), ((DynamicObject)taskIdUserDyMap.get(taskMap.get(objId))).getString("name"), ((DynamicObject)taskIdUserDyMap.get(taskMap.get(objId))).getString("number")});
                String lockedMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(lockedMsgTxt);
                msgList.add(lockedMsg);
                continue;
            }
            canOpTaskList.add(taskMap.get(objId));
            canOpObjList.add(objId);
        }
        resultMap.put("valDealNum", Integer.valueOf(objIds.size()));
        this.feedbackProgress(60, desc, resultMap);
        LinkedList<Long> submitTaskSuccessList = new LinkedList<Long>();
        FlowValidateResultBo resultBo = FLOW_RU_PROC_APPLICATION_SERVICE.batchRollbackTasks(canOpTaskList, reason);
        if (resultBo != null) {
            String msg;
            Map validateMap;
            String resultBoCode = resultBo.getCode();
            if ("-1".equals(resultBoCode)) {
                validateMap = resultBo.getValidateMap();
                if (validateMap != null && !validateMap.isEmpty()) {
                    for (Long taskId2 : canOpTaskList) {
                        if (!validateMap.containsKey(taskId2)) {
                            submitTaskSuccessList.add((Long)objMap.get(taskId2));
                            continue;
                        }
                        msg = (String)validateMap.get(taskId2);
                        msgList.add(personNameAndNumberMap.get(objMap.get(taskId2)) + "\uff1a" + msg);
                    }
                } else {
                    submitTaskSuccessList.addAll(canOpObjList);
                }
                APP_SERVICE.batchUpdateWeightAndIndctrScore(submitTaskSuccessList);
            } else if ("1".equals(resultBoCode)) {
                validateMap = resultBo.getValidateMap();
                if (validateMap != null && !validateMap.isEmpty()) {
                    for (Long taskId2 : canOpTaskList) {
                        msg = (String)validateMap.get(taskId2);
                        if (HRStringUtils.isEmpty((String)msg)) {
                            submitTaskSuccessList.add((Long)objMap.get(taskId2));
                            continue;
                        }
                        msgList.add(personNameAndNumberMap.get(objMap.get(taskId2)) + "\uff1a" + msg);
                    }
                } else {
                    submitTaskSuccessList.addAll(canOpObjList);
                }
                APP_SERVICE.batchUpdateWeightAndIndctrScore(submitTaskSuccessList);
            }
        }
        resultMap.put("startDealNum", Integer.valueOf(objIds.size()));
        this.feedbackProgress(80, desc, resultMap);
        resultMap.put("msgList", msgList);
        resultMap.put("success", Integer.valueOf(submitTaskSuccessList.size()));
        resultMap.put("fail", Integer.valueOf(objIds.size() - submitTaskSuccessList.size()));
        resultMap.put("total", Integer.valueOf(objIds.size()));
        this.feedbackCustomdata(resultMap);
    }

    private List<Long> getLockedNode(List<Long> nodeIds, Map<Long, DynamicObject> nodeIdUserDyMap) {
        ArrayList<Long> lockedNodeList = new ArrayList<Long>(10);
        HashMap<Long, Long> nodeIdUserIdMap = new HashMap<Long, Long>(16);
        ArrayList<Long> lockUserList = new ArrayList<Long>(10);
        for (Long nodeId2 : nodeIds) {
            Long userId2;
            DataMutex dataMutex = DataMutex.create();
            Map lockInfoMap = dataMutex.getLockInfo(nodeId2.toString(), "default_netctrl", "epa_actevalobj");
            if (lockInfoMap == null) continue;
            Long currentUserId = UserServiceHelper.getCurrentUserId();
            if (lockInfoMap.get("userid") == null || (userId2 = Long.valueOf((String)lockInfoMap.get("userid"))) != 0L && currentUserId.equals(userId2)) continue;
            lockedNodeList.add(nodeId2);
            lockUserList.add(userId2);
            nodeIdUserIdMap.put(nodeId2, userId2);
        }
        Map idUserMap = BusinessDataServiceHelper.loadFromCache((Object[])lockUserList.toArray(), (String)"bos_user");
        nodeIdUserIdMap.forEach((nodeId, userId) -> nodeIdUserDyMap.put((Long)nodeId, (DynamicObject)idUserMap.get(userId)));
        return lockedNodeList;
    }
}

