/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.pbs.business.task.PotMemberInsTask;

public class StartActivitySelfFillingTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(PotMemberInsTask.class);
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();

    public void feedbackProgress(int progress, String desc) {
        super.feedbackProgress(progress, desc, null);
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("StartActivitySelfFillingTask start!");
        String desc = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762\uff0c\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c", (String)"StartActivitySelfFillingTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        this.feedbackProgress(10, desc);
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        boolean result = false;
        try {
            if (map.containsKey("activity_id")) {
                long adminOrgId = Long.parseLong(String.valueOf(map.get("activity_id")));
                DynamicObject assessActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(adminOrgId);
                List<DynamicObject> joinActivityEvaluation = ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE.getJoinActivityObjects(adminOrgId);
                this.feedbackProgress(20, desc);
                result = ASSESS_ACTIVITY_APPLICATION_SERVICE.startActivitySelfFilling(assessActivity, joinActivityEvaluation, this);
            } else if (map.containsKey("evaluation_object_ids")) {
                List<Object> longList = new ArrayList(16);
                if (map.get("evaluation_object_ids") instanceof Long[]) {
                    LOG.info("StartActivitySelfFillingTask Long[]");
                    Long[] longs = (Long[])map.get("evaluation_object_ids");
                    longList = Arrays.stream(longs).collect(Collectors.toList());
                } else if (map.get("evaluation_object_ids") instanceof ArrayList) {
                    LOG.info("StartActivitySelfFillingTask ArrayList");
                    longList = (ArrayList)map.get("evaluation_object_ids");
                } else if (map.get("evaluation_object_ids") instanceof JSONArray) {
                    LOG.info("StartActivitySelfFillingTask JSONArray");
                    JSONArray array = (JSONArray)map.get("evaluation_object_ids");
                    longList = array.toJavaList(Long.class);
                }
                List<DynamicObject> joinActivityEvaluation = ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE.getJoinActivityObjects(longList);
                if (!ObjectUtils.isEmpty(joinActivityEvaluation)) {
                    LOG.info("startActivitySelfFilling start");
                    long activityId = joinActivityEvaluation.get(0).getLong("activity.id");
                    DynamicObject assessActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(activityId);
                    result = ASSESS_ACTIVITY_APPLICATION_SERVICE.startActivitySelfFilling(assessActivity, joinActivityEvaluation, this);
                    LOG.info("startActivitySelfFilling end");
                }
                this.feedbackProgress(20, desc);
                LOG.info("StartActivitySelfFillingTask result!", (Object)result);
            }
        }
        catch (NumberFormatException exception) {
            LOG.error("StartActivitySelfFillingTask", (Throwable)exception);
        }
        resultMap.put("result", result);
        this.feedbackCustomdata(resultMap);
        LOG.info("StartActivitySelfFillingTask end!");
    }
}

