/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;

public class StartActivityUnifiedReleaseTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(StartActivityUnifiedReleaseTask.class);
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();

    public void feedbackProgress(int progress, String desc) {
        super.feedbackProgress(progress, desc, null);
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("StartActivityUnifiedReleaseTask start!");
        String desc = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762\uff0c\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c", (String)"StartActivityUnifiedReleaseTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        this.feedbackProgress(10, desc);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean result = false;
        try {
            if (map.containsKey("activity_id")) {
                long activityId = Long.parseLong(String.valueOf(map.get("activity_id")));
                this.feedbackProgress(20, desc);
                List<DynamicObject> joinActivityEvaluation = ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE.getJoinActivityObjects(activityId);
                Tuple<String, String> message = ASSESS_ACTIVITY_APPLICATION_SERVICE.startActivityUnifiedRelease(activityId, joinActivityEvaluation, this);
                result = true;
                resultMap.put("data", message);
            } else if (map.containsKey("evaluation_object_ids")) {
                LOG.info("startActivityUnifiedRelease start!");
                List<Object> longList = new ArrayList(16);
                if (map.get("evaluation_object_ids") instanceof Long[]) {
                    LOG.info("startActivityUnifiedRelease Long[]");
                    Long[] longs = (Long[])map.get("evaluation_object_ids");
                    longList = Arrays.stream(longs).collect(Collectors.toList());
                } else if (map.get("evaluation_object_ids") instanceof ArrayList) {
                    LOG.info("startActivityUnifiedRelease ArrayList");
                    longList = (ArrayList)map.get("evaluation_object_ids");
                } else if (map.get("evaluation_object_ids") instanceof JSONArray) {
                    LOG.info("startActivityUnifiedRelease JSONArray");
                    JSONArray array = (JSONArray)map.get("evaluation_object_ids");
                    longList = array.toJavaList(Long.class);
                }
                List<DynamicObject> joinActivityEvaluation = ActivityEvaluationObjectApplicationService.getInstance().getJoinActivityObjects(longList);
                if (!ObjectUtils.isEmpty(joinActivityEvaluation)) {
                    long activityId = joinActivityEvaluation.get(0).getLong("activity.id");
                    Tuple<String, String> message = ASSESS_ACTIVITY_APPLICATION_SERVICE.startActivityUnifiedRelease(activityId, joinActivityEvaluation, this);
                    result = true;
                    resultMap.put("data", message);
                }
                LOG.info("startActivityUnifiedRelease end!");
            }
        }
        catch (NumberFormatException exception) {
            LOG.error("StartActivityUnifiedReleaseTask", (Throwable)exception);
        }
        resultMap.put("result", result);
        this.feedbackCustomdata(resultMap);
        LOG.info("StartActivityUnifiedReleaseTask end!");
    }
}

