/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import org.apache.commons.collections.MapUtils;

public class StartEvaluatedCheckTask
extends AbstractTask {
    private static final FlowRuProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        int allSize;
        Object[] evalObjs = (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)params.get("evaluationObjects").toString());
        if (ObjectUtils.isEmpty((Object[])evalObjs)) {
            return;
        }
        String desc = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762\uff0c\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c", (String)"StartEvaluatedCheckTask_0", (String)"opmc-pbs-business", (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        int successSize = allSize = evalObjs.length;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList failList = Lists.newArrayListWithCapacity((int)10);
        ArrayList ids = Lists.newArrayListWithCapacity((int)10);
        for (int i = 0; i < allSize; ++i) {
            Object evalObj = evalObjs[i];
            ids.add(evalObj.getLong("evalflowins.id"));
            FlowCommonResultBo flowCommonResultBo = FLOW_DEF_PROC_DOMAIN_SERVICE.verifyHandlerBeforeStartProcess((List)ids);
            if (Objects.isNull(flowCommonResultBo) || HRStringUtils.equals((String)flowCommonResultBo.getCode(), (String)"-1")) {
                this.buiderFailResult((DynamicObject)evalObj, failList, flowCommonResultBo);
                --successSize;
            }
            Double process = (double)(i + 1) / ((double)evalObjs.length * 0.01);
            this.feedbackProgress(process.intValue(), desc, null);
            ids.clear();
        }
        this.buiderResult(allSize, successSize, failList, resultMap);
        this.feedbackCustomdata(resultMap);
    }

    private void buiderResult(int allSize, int successSize, List<Map<String, String>> failList, HashMap<String, Object> resultMap) {
        HashMap message = Maps.newHashMapWithExpectedSize((int)16);
        message.put("totalcount", allSize);
        message.put("sucesscount", successSize);
        message.put("failcount", allSize - successSize);
        message.put("failList", failList);
        resultMap.put("data", message);
    }

    private void buiderFailResult(DynamicObject evalObj, List<Map<String, String>> failList, FlowCommonResultBo flowCommonResultBo) {
        HashMap failMessage;
        if (Objects.isNull(flowCommonResultBo)) {
            return;
        }
        Map msgMap = flowCommonResultBo.getMsgMap();
        Map corssNodemsgMap = flowCommonResultBo.getCorssNodemsgMap();
        if (MapUtils.isEmpty((Map)msgMap) && MapUtils.isEmpty((Map)corssNodemsgMap)) {
            return;
        }
        List detail = (List)msgMap.get(evalObj.getLong("id"));
        List crossedDetail = (List)corssNodemsgMap.get(evalObj.getLong("id"));
        if (CollectionUtils.isEmpty((Collection)detail) && CollectionUtils.isEmpty((Collection)crossedDetail)) {
            return;
        }
        for (Map detailInfo : detail) {
            for (Map.Entry entry : detailInfo.entrySet()) {
                failMessage = Maps.newHashMapWithExpectedSize((int)16);
                failMessage.put("dealername", evalObj.getString("person.name"));
                failMessage.put("dealernum", evalObj.getString("person.number"));
                failMessage.put("preffileno", evalObj.getString("perffile.number"));
                failMessage.put("detail", entry.getValue());
                failList.add(failMessage);
            }
        }
        for (Map crossedDetailInfo : crossedDetail) {
            for (Map.Entry entry : crossedDetailInfo.entrySet()) {
                failMessage = Maps.newHashMapWithExpectedSize((int)16);
                failMessage.put("dealername", evalObj.getString("person.name"));
                failMessage.put("dealernum", evalObj.getString("person.number"));
                failMessage.put("preffileno", evalObj.getString("perffile.number"));
                failMessage.put("detail", entry.getValue());
                failList.add(failMessage);
            }
        }
    }
}

