/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.application.impl.mq.StartProcessPublisher;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.flowscan.entity.BatchFlowTaskResultBo;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import kd.opmc.pbs.business.domain.flowscan.service.BatchFlowTaskService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuResultBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import org.apache.commons.collections.MapUtils;

public class StartEvaluatedTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(StartEvaluatedTask.class);
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final BatchFlowTaskService BATCH_FLOW_TASK_SERVICE = BatchFlowTaskService.getInstance();
    private static final FlowHandlerBatchDomainService FLOW_HANDLER_BATCH_DOMAIN_SERVICE = FlowHandlerBatchDomainService.getInstance();
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();

    public void feedbackProgress(int progress, String desc, Map<String, Object> customData) {
        super.feedbackProgress(progress, desc, customData);
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) {
        List evalObjectIds = (List)params.get("evalObjectIds");
        Object[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(evalObjectIds);
        if (ObjectUtils.isEmpty((Object[])evalObjs)) {
            return;
        }
        int allSize = evalObjs.length;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        String desc = ResManager.loadKDString((String)"\u542f\u52a8\u7ee9\u6548\u8bc4\u4f30\u6821\u9a8c\u4e2d...", (String)"StartEvaluatedTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        this.builerProgressResult(resultMap, allSize, "0");
        this.feedbackProgress(0, desc, resultMap);
        if (this.excuteValEval((DynamicObject[])evalObjs, allSize)) {
            return;
        }
        int nodeIndex = (Integer)params.get("nodeindex");
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList failList = Lists.newArrayListWithCapacity((int)10);
        DynamicObjectCollection dyColl = this.updateEvalStatus2Starting((DynamicObject[])evalObjs, failList);
        desc = ResManager.loadKDString((String)"\u542f\u52a8\u7ee9\u6548\u8bc4\u4f30\u4e2d...", (String)"StartEvaluatedTask_1", (String)"opmc-epa-business", (Object[])new Object[0]);
        Double processVal = (double)allSize / ((double)(allSize * 2) * 0.01);
        this.builerProgressResult(resultMap, allSize, "1");
        this.feedbackProgress(processVal.intValue(), desc, resultMap);
        int successSize = dyColl.size();
        int suspendcount = 0;
        String batchNo = BATCH_FLOW_TASK_SERVICE.requireBatchNoByBatchTask(TaskTypeEnum.EVAL_START);
        ArrayList<FlowRuProcBo> evalFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        List cannotStartEvaObjList = BatchStartEvalEntityService.getInstance().getActevaobjUnCompletedTask(evalObjectIds, TaskTypeEnum.EVAL_START.getValue());
        for (int i = 0; i < dyColl.size(); ++i) {
            DynamicObject evalObj = (DynamicObject)dyColl.get(i);
            if (evalObj.getLong("assessnode.id") != NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId().longValue() || !HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()) || evalObj.getLong("nodeindex") != AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId().longValue()) {
                this.buiderFailResult(failList, evalObj, ResManager.loadKDString((String)"\u5c1a\u672a\u8fdb\u5165\u7ee9\u6548\u8bc4\u4f30\u6d41\u7a0b\u6216\u7ee9\u6548\u8bc4\u4f30\u6d41\u7a0b\u5df2\u5b8c\u6210 ", (String)"StartEvaluatedTask_2", (String)"opmc-epa-business", (Object[])new Object[0]));
                --successSize;
                continue;
            }
            if (cannotStartEvaObjList.contains(evalObj.getLong("id"))) {
                --successSize;
                this.buiderFailResult(failList, evalObj, ResManager.loadKDString((String)"\u7ee9\u6548\u8bc4\u4f30\u6d41\u7a0b\u6b63\u5728\u542f\u52a8\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5 ", (String)"StartEvaluatedTask_3", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            FlowRuProcBo flowRuProcBo = this.buildEvaluationProcBo(evalObj, batchNo);
            evalFlowRuProcBoList.add(flowRuProcBo);
            Double process = (double)(i + 1 + allSize) / ((double)(allSize * 2) * 0.01);
            this.builerProgressResult(resultMap, 1, "2");
            this.updateEvalObj(nodeIndex, date, userId, evalObj);
            this.addActivityRecord(nodeIndex, evalObj, date, userId);
            this.feedbackProgress(process.intValue(), desc, resultMap);
        }
        List evaFlowRuProcBoPartList = Lists.partition(evalFlowRuProcBoList, (int)200);
        for (List ruProBoList : evaFlowRuProcBoPartList) {
            BatchFlowTaskResultBo startEvaResultBo = BATCH_START_EVAL_ENTITY_SERVICE.generateBatchFlowTaskData(ruProBoList, TaskTypeEnum.EVAL_START.getValue());
            StartProcessPublisher.publish((List)startEvaResultBo.getBatchTaskIdList(), (String)startEvaResultBo.getTaskType());
        }
        List<Long> ids = Arrays.stream(evalObjs).map(coll -> coll.getLong("id")).collect(Collectors.toList());
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject((DynamicObject[])evalObjs);
        this.updateEvalObjStartStatus(ids, "10");
        this.buiderResult(allSize, successSize, suspendcount, failList, resultMap);
        this.feedbackCustomdata(resultMap);
    }

    protected void updateEvalObjStartStatus(List<Long> evalObjectIds, String status) {
        DynamicObject[] startingObj = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjStatusById(evalObjectIds);
        Arrays.stream(startingObj).forEach(evalObj -> evalObj.set("startstatus", (Object)status));
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(startingObj);
    }

    private boolean excuteValEval(DynamicObject[] evalObjs, int allSize) {
        HashMap<String, Object> validateDataMap = EvalObjUtils.startCheckTask(evalObjs);
        this.builerProgressResult(validateDataMap, allSize, "0");
        this.builerProgressResult(validateDataMap, allSize, "1");
        String data = JSONObject.toJSONString(validateDataMap);
        Boolean isStartTask = this.validateIsStartTask(data);
        if (!isStartTask.booleanValue()) {
            this.feedbackCustomdata(validateDataMap);
            return true;
        }
        return false;
    }

    private Boolean validateIsStartTask(String data) {
        JSONObject resultDate = JSONObject.parseObject((String)data);
        if (Objects.isNull(resultDate)) {
            return Boolean.FALSE;
        }
        Map dataMap = MapUtils.getMap((Map)resultDate, (Object)"data");
        if (HRObjectUtils.isEmpty((Object)dataMap)) {
            return Boolean.FALSE;
        }
        Integer failcount = MapUtils.getInteger((Map)dataMap, (Object)"failcount");
        if (!Objects.isNull(failcount) && failcount > 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void updateEvalObjStatus2Started(DynamicObject evalObj) {
        evalObj.set("startstatus", (Object)"10");
    }

    private DynamicObjectCollection updateEvalStatus2Starting(DynamicObject[] evalObjs, List<Map<String, String>> failList) {
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        for (DynamicObject evalObj : evalObjs) {
            if (evalObj.getLong("assessnode.id") != NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId().longValue() || !HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()) || evalObj.getLong("nodeindex") != AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId().longValue()) {
                this.buiderFailResult(failList, evalObj, ResManager.loadKDString((String)"\u5c1a\u672a\u8fdb\u5165\u7ee9\u6548\u8bc4\u4f30\u6d41\u7a0b\u6216\u7ee9\u6548\u8bc4\u4f30\u6d41\u7a0b\u5df2\u5b8c\u6210 ", (String)"StartEvaluatedTask_2", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            String startStatus = evalObj.getString("startstatus");
            if (HRStringUtils.equals((String)startStatus, (String)"20")) {
                this.buiderFailResult(failList, evalObj, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u8bc4\u4f30\u4efb\u52a1\u5df2\u542f\u52a8\u6216\u5df2\u5b8c\u6210", (String)"StartEvaluatedTask_4", (String)"opmc-epa-business", (Object[])new Object[0]));
                continue;
            }
            evalObj.set("startstatus", (Object)"20");
            dyColl.add((Object)evalObj);
        }
        List<Long> ids = dyColl.stream().map(coll -> coll.getLong("id")).collect(Collectors.toList());
        this.updateEvalObjStartStatus(ids, "10");
        return dyColl;
    }

    private void builerProgressResult(HashMap<String, Object> resultMap, int val, String type) {
        if (HRStringUtils.equals((String)type, (String)"0")) {
            resultMap.put("valTotalNum", val);
            resultMap.put("startTotalNum", val);
        } else if (HRStringUtils.equals((String)type, (String)"1")) {
            resultMap.put("valDealNum", this.setDealNum(resultMap.get("valDealNum"), val));
        } else {
            resultMap.put("startDealNum", this.setDealNum(resultMap.get("startDealNum"), val));
        }
    }

    private int setDealNum(Object obj, int val) {
        if (Objects.isNull(obj)) {
            return val;
        }
        if (obj instanceof Integer) {
            return (Integer)obj + val;
        }
        return val;
    }

    private void buiderResult(int allSize, int successSize, int suspendcount, List<Map<String, String>> failList, HashMap<String, Object> resultMap) {
        HashMap message = Maps.newHashMapWithExpectedSize((int)16);
        message.put("totalcount", allSize);
        message.put("sucesscount", successSize);
        message.put("failcount", allSize - successSize);
        message.put("suspendcount", suspendcount);
        message.put("failList", failList);
        resultMap.put("data", message);
    }

    private void buiderFailResult(List<Map<String, String>> failList, DynamicObject evalObj, String detail) {
        HashMap failMessage = Maps.newHashMapWithExpectedSize((int)16);
        failMessage.put("dealername", evalObj.getString("person.name"));
        failMessage.put("dealernum", evalObj.getString("person.number"));
        failMessage.put("preffileno", evalObj.getString("perffile.number"));
        failMessage.put("detail", detail);
        failList.add(failMessage);
    }

    private FlowRuResultBo startProcess(DynamicObject evaluationObj, String batchNo) {
        log.info(" ----------\u3010\u542f\u52a8\u8bc4\u4f30\u6d41\u7a0b\u3011\u5f00\u59cb\u6267\u884c----------");
        FlowRuProcBo flowRuProcBo = this.buildEvaluationProcBo(evaluationObj, batchNo);
        if (flowRuProcBo.getActEvalObjId() == 0L || flowRuProcBo.getActivityId() == 0L || flowRuProcBo.getAdminOrgId() == 0L || flowRuProcBo.getFlowVid() == 0L || flowRuProcBo.getPerfOrgId() == 0L || HRStringUtils.isEmpty((String)flowRuProcBo.getAssessPeriod()) || flowRuProcBo.getAssessYear() == 0 || ObjectUtils.isEmpty((Object)flowRuProcBo.getPerson())) {
            log.error("\u542f\u52a8\u8bc4\u4f30\u6d41\u7a0b\u65f6\u6570\u636e\u6709\u8bef\uff0c\u65e0\u6cd5\u542f\u52a8\u6d41\u7a0b\uff0cFlowRuProcBo:[{}]", (Object)flowRuProcBo.toString());
            return null;
        }
        FlowRuResultBo resultBo = FLOW_RU_PROC_DOMAIN_SERVICE.startProcess(flowRuProcBo);
        log.info(" ----------\u3010\u542f\u52a8\u8bc4\u4f30\u6d41\u7a0b\u3011\u6267\u884c\u6210\u529f----------");
        return resultBo;
    }

    private boolean updateEvalFlowEntry(DynamicObject evaluationObj, List<Long> processInstIds) {
        DynamicObjectCollection evalFlowEntry = evaluationObj.getDynamicObjectCollection("evalflowentry");
        if (ObjectUtils.isEmpty((Object)evalFlowEntry)) {
            log.error("\u66f4\u65b0\u8bc4\u4f30\u6d41\u7a0b\u5355\u636e\u4f53\u7684\u8bc4\u4f30\u6d41\u7a0b\u5b9e\u4f8b\u5931\u8d25\uff0c\u8bc4\u4f30\u6d41\u7a0b\u5355\u636e\u4f53\u4e3a\u7a7a");
            return false;
        }
        for (int proIndex = 0; proIndex < processInstIds.size(); ++proIndex) {
            DynamicObject evalFlow = (DynamicObject)evalFlowEntry.get(proIndex);
            evalFlow.set("evalflowru", (Object)processInstIds.get(proIndex));
        }
        return true;
    }

    private void updateEvalObj(int nodeIndex, Date date, long userId, DynamicObject evaluationObj) {
        log.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011ASSESSNODE:{},NODEINDEX:{},NODESTATUS:{}----------", new Object[]{AssessNodeStatusEnum.EVALUATING.getNodeId(), nodeIndex, AssessNodeStatusEnum.EVALUATING.getStatus()});
        evaluationObj.set("modifier", (Object)userId);
        evaluationObj.set("modifytime", (Object)date);
        evaluationObj.set("assessnode", (Object)AssessNodeStatusEnum.EVALUATING.getNodeId());
        evaluationObj.set("nodeindex", (Object)nodeIndex);
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.EVALUATING.getStatus());
    }

    private void addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.EVALUATING.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.EVALUATING.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        ACTIVITY_RECORD_ENTITY.saveOne(activityRecord);
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
    }

    private FlowRuProcBo buildEvaluationProcBo(DynamicObject evaluationObj, String batchNo) {
        long flowVid = evaluationObj.getLong("evalflow.id");
        DynamicObject person = evaluationObj.getDynamicObject("person");
        Integer assessYear = evaluationObj.getInt("assessyear");
        String assessPeriod = evaluationObj.getString("assessperiod");
        long actEvalObjId = evaluationObj.getLong("id");
        DynamicObject activityDy = evaluationObj.getDynamicObject("activity");
        DynamicObject schemeDy = ASSESS_SCHEME_APPLICATION_SERVICE.queryOneById(activityDy.getLong("scheme.id"));
        long perfOrgId = schemeDy.getLong("createorg.id");
        long adminOrgId = schemeDy.getLong("adminorg.id");
        long activityId = evaluationObj.getLong("activity.id");
        long empPosRelId = evaluationObj.getLong("empposrel.id");
        DynamicObject executeScheme = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        String settingmode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(executeScheme.getLong("perfworkflow.id")), "4");
        FlowRuProcBo flowRuProcBo = FlowRuProcBo.builder().flowVid(Long.valueOf(flowVid)).person(person).perfOrgId(Long.valueOf(perfOrgId)).adminOrgId(Long.valueOf(adminOrgId)).assessYear(assessYear).assessPeriod(assessPeriod).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).settingMode(StringUtils.isEmpty((String)settingmode) ? "" : settingmode).workflowType("2").batchNo(batchNo).build();
        return flowRuProcBo;
    }
}

