/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.domain.scheme.service.ExecuteSchemeDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssFormatEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.pbs.business.application.impl.mq.StartProcessPublisher;
import kd.opmc.pbs.business.domain.flowscan.entity.BatchFlowTaskResultBo;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import kd.opmc.pbs.business.domain.flowscan.service.BatchFlowTaskService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowDefNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class StartFormulateTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(StartFormulateTask.class);
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final ExecuteSchemeDomainService EXECUTE_SCHEME_DOMAIN_SERVICE = ExecuteSchemeDomainService.getInstance();
    private static final BatchFlowTaskService BATCH_FLOW_TASK_SERVICE = BatchFlowTaskService.getInstance();
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final String ISSUCCESS = "issuccess";

    public void feedbackProgress(int progress, String desc, Map<String, Object> customData) {
        super.feedbackProgress(progress, desc, customData);
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) {
        List evalObjectIds = (List)params.get("evalObjectIds");
        Object[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(evalObjectIds);
        if (ObjectUtils.isEmpty((Object[])evalObjs)) {
            return;
        }
        int allSize = evalObjs.length;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("valTotalNum", allSize);
        resultMap.put("valDealNum", 0);
        resultMap.put("startTotalNum", allSize);
        resultMap.put("startDealNum", 0);
        DynamicObject activityDy = evalObjs[0].getDynamicObject("activity");
        String settingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(activityDy.getLong("perfworkflow.id")), "1");
        ArrayList<String> failMessage = new ArrayList<String>(16);
        long validateTime = System.currentTimeMillis();
        log.info("StartFormulateTask validate start: {}", (Object)validateTime);
        Tuple<List<DynamicObject>, String> checkResult = this.validateBeforeStart((DynamicObject[])evalObjs, failMessage, resultMap);
        List evalObjPassList = (List)checkResult.item1;
        String exporturl = (String)checkResult.item2;
        log.info("StartFormulateTask validate end: {} s", (Object)((System.currentTimeMillis() - validateTime) / 1000L));
        if (HRObjectUtils.isEmpty((Object)evalObjPassList)) {
            return;
        }
        this.updateEvalObjStartStatus(evalObjectIds, "20");
        int successSize = evalObjPassList.size();
        int nodeIndex = (Integer)params.get("nodeindex");
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        String batchNo = BATCH_FLOW_TASK_SERVICE.requireBatchNoByBatchTask(TaskTypeEnum.INDICATOR_START);
        ArrayList<DynamicObject> activityRecordList = new ArrayList<DynamicObject>(10);
        ArrayList<FlowRuProcBo> formulatFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        String desc = ResManager.loadKDString((String)"\u6307\u6807\u5236\u5b9a\u542f\u52a8\u4e2d...", (String)"StartFormulateTask_0", (String)"opmc-pbs-business", (Object[])new Object[0]);
        long startTime = System.currentTimeMillis();
        log.info("StartFormulateTask start: {}", (Object)startTime);
        for (int i = 0; i < evalObjPassList.size(); ++i) {
            DynamicObject evalObj = (DynamicObject)evalObjPassList.get(i);
            FlowRuProcBo flowRuProcBo = this.buildEvaluationProcBo(evalObj, settingMode, batchNo);
            formulatFlowRuProcBoList.add(flowRuProcBo);
            this.updateEvalObj(nodeIndex, date, userId, evalObj);
            activityRecordList.add(this.addActivityRecord(nodeIndex, evalObj, date, userId));
            double process = (double)(i + 1) / ((double)evalObjs.length * 0.01);
            resultMap.put("startDealNum", i + 1);
            this.feedbackProgress((int)process, desc, resultMap);
        }
        log.info("StartFormulateTask end: {} s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        List formulateFlowRuProcBoPartList = Lists.partition(formulatFlowRuProcBoList, (int)200);
        for (List formulateRuProcBoList : formulateFlowRuProcBoPartList) {
            BatchFlowTaskResultBo startFormulateResultBo = BATCH_START_EVAL_ENTITY_SERVICE.generateBatchFlowTaskData(formulateRuProcBoList, TaskTypeEnum.INDICATOR_START.getValue());
            StartProcessPublisher.publish((List)startFormulateResultBo.getBatchTaskIdList(), (String)startFormulateResultBo.getTaskType());
        }
        log.info("StartFormulateTask end: {} s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject((DynamicObject[])evalObjs);
        this.updateEvalObjStartStatus(evalObjectIds, "10");
        if (successSize > 0) {
            ACTIVITY_RECORD_ENTITY.save(activityRecordList.toArray(new DynamicObject[0]));
        }
        String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u542f\u52a8\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"StartFormulateTask_1", (String)"opmc-epa-business", (Object[])new Object[0]), allSize, successSize, allSize - successSize);
        Tuple message = Tuple.create((Object)title, (Object)String.join((CharSequence)"\n", failMessage));
        resultMap.put("data", message);
        resultMap.put(ISSUCCESS, "0");
        if (successSize == 0) {
            resultMap.put("downloadurl", exporturl);
            resultMap.put(ISSUCCESS, "2");
        } else if (successSize != allSize) {
            resultMap.put(ISSUCCESS, "1");
        }
        resultMap.put("opKey", "startprocess");
        this.feedbackCustomdata(resultMap);
    }

    protected void updateEvalObjStartStatus(List<Long> evalObjectIds, String status) {
        DynamicObject[] startingObj = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjStatusById(evalObjectIds);
        Arrays.stream(startingObj).forEach(evalObj -> evalObj.set("startstatus", (Object)status));
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(startingObj);
    }

    private boolean hasFormulateNode(DynamicObject executeScheme, DynamicObject evalObj) {
        HashMap<Long, Long> flowIdMap = new HashMap<Long, Long>(16);
        long flowVid = evalObj.getLong("formulateflow.id");
        flowIdMap.put(flowVid, executeScheme.getLong("perfworkflow.id"));
        List workflowBoList = FLOW_DEF_PROC_DOMAIN_SERVICE.getWorkflowDefByID(flowIdMap);
        if (ObjectUtils.isEmpty((Object)workflowBoList)) {
            return false;
        }
        List flowdefNodeBoList = ((WorkflowBo)workflowBoList.get(0)).getFlowdefNodeBoList();
        if (ObjectUtils.isEmpty((Object)flowdefNodeBoList)) {
            return false;
        }
        DynamicObject flowdefNodeDyn = ((FlowDefNodeBo)flowdefNodeBoList.get(0)).getFlowdefNodeDyn();
        return flowdefNodeDyn.getLong("nodetype.id") == NodeTypeConstants.INDICATOR_FORMULATE.longValue();
    }

    private void updateEvalObj(int nodeIndex, Date date, long userId, DynamicObject evaluationObj) {
        log.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011ASSESSNODE:{},NODEINDEX:{},NODESTATUS:{}----------", new Object[]{AssessNodeStatusEnum.TO_BE_FORMULATED.getNodeId(), nodeIndex, AssessNodeStatusEnum.TO_BE_FORMULATED.getStatus()});
        evaluationObj.set("modifier", (Object)userId);
        evaluationObj.set("modifytime", (Object)date);
        evaluationObj.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
        evaluationObj.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
        evaluationObj.set("nodeindex", (Object)nodeIndex);
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus());
    }

    private DynamicObject addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
        return activityRecord;
    }

    private FlowRuProcBo buildEvaluationProcBo(DynamicObject evaluationObj, String settingMode, String batchNo) {
        long flowVid = evaluationObj.getLong("formulateflow.id");
        DynamicObject person = evaluationObj.getDynamicObject("person");
        Integer assessYear = evaluationObj.getInt("assessyear");
        String assessPeriod = evaluationObj.getString("assessperiod");
        long actEvalObjId = evaluationObj.getLong("id");
        DynamicObject activityDy = evaluationObj.getDynamicObject("activity");
        DynamicObject schemeDy = ASSESS_SCHEME_APPLICATION_SERVICE.queryOneById(activityDy.getLong("scheme.id"));
        long perfOrgId = schemeDy.getLong("createorg.id");
        long adminOrgId = schemeDy.getLong("adminorg.id");
        long activityId = evaluationObj.getLong("activity.id");
        long empPosRelId = evaluationObj.getLong("empposrel.id");
        return FlowRuProcBo.builder().flowVid(Long.valueOf(flowVid)).person(person).perfOrgId(Long.valueOf(perfOrgId)).adminOrgId(Long.valueOf(adminOrgId)).assessYear(assessYear).assessPeriod(assessPeriod).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).settingMode(settingMode).workflowType("1").batchNo(batchNo).build();
    }

    private BigDecimal getBigLimitMaxSore(DynamicObject activityDy, BigDecimal maxScoreOfSystem) {
        DynamicObject assessFormDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessFormByActId(activityDy.getLong("id"));
        return assessFormDy.getBoolean("allowexceedupper") ? assessFormDy.getBigDecimal("limitmaxscore") : maxScoreOfSystem;
    }

    private Tuple<List<DynamicObject>, String> validateBeforeStart(DynamicObject[] evalObjs, List<String> failMessage, HashMap<String, Object> resultMap) {
        DynamicObject activityDy = evalObjs[0].getDynamicObject("activity");
        DynamicObject executeScheme = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        String assFormat = "";
        DynamicObject assessDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessFormByActivityId(activityDy.getLong("id"));
        if (assessDy != null && assessDy.getString("scorecalcway") != null) {
            assFormat = assessDy.getString("scorecalcway");
        }
        String settingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(activityDy.getLong("perfworkflow.id")), "1");
        DynamicObject scoreSystemDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryScoreSystemByActId(activityDy.getLong("id"));
        BigDecimal maxScoreOfSystem = scoreSystemDy.getBigDecimal("maxscore");
        BigDecimal limitMaxScore = this.getBigLimitMaxSore(activityDy, maxScoreOfSystem);
        Map<Long, DynamicObject> areaInstanceMap = APP_SERVICE.queryEvaluationGenAreaInstance(Arrays.asList(evalObjs));
        String target = HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? "weight" : "indctrscore";
        Map<Long, BigDecimal> normalAreaSumMap = APP_SERVICE.getNormalAreaSumMap(evalObjs, areaInstanceMap, target);
        Map<Long, Long> areaSumScoreMap = APP_SERVICE.getNormalAreaSumGtMap(evalObjs, areaInstanceMap, assFormat);
        BigDecimal compareVal = HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? new BigDecimal(100) : maxScoreOfSystem;
        Map<Long, BigDecimal> areaScoreNotEqMap = APP_SERVICE.getAreaScoreNotEqMap(evalObjs, compareVal, areaInstanceMap, assFormat);
        Map<Long, Boolean> checkForcedControlZeroMap = APP_SERVICE.checkForcedControlZeroMap(evalObjs, HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? "areaweight" : "areascore", HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? new BigDecimal(100) : limitMaxScore);
        List flowIds = Arrays.stream(evalObjs).map(evalObject -> evalObject.getLong("formulateflowins.id")).collect(Collectors.toList());
        FlowCommonResultBo flowCommonResultBo = FLOW_RU_PROC_DOMAIN_SERVICE.verifyHandlerBeforeStartProcess(flowIds);
        String desc = ResManager.loadKDString((String)"\u542f\u52a8\u6307\u6807\u5236\u5b9a\u6821\u9a8c\u4e2d...", (String)"StartFormulateTask_2", (String)"opmc-pbs-business", (Object[])new Object[0]);
        ArrayList<DynamicObject> evalObjPassList = new ArrayList<DynamicObject>(10);
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(10);
        for (int i = 0; i < evalObjs.length; ++i) {
            String reason;
            String reason2;
            double process = (double)(i + 1) / ((double)evalObjs.length * 0.01);
            resultMap.put("valDealNum", i + 1);
            this.feedbackProgress((int)process, desc, resultMap);
            DynamicObject evalObj = evalObjs[i];
            String personDesc = evalObj.getString("person.name") + " " + evalObj.getString("person.number") + ": ";
            if (!HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.JOINED.getStatus())) {
                reason2 = ResManager.loadKDString((String)"{0}\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5f85\u5236\u5b9a\u201d\uff0c\u4e0d\u80fd\u542f\u52a8\u5236\u5b9a\u6d41\u7a0b\u3002", (String)"StartFormulateTask_3", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                failMessage.add(reason2);
                this.genData2Excel(exportDataList, evalObj, reason2);
                continue;
            }
            if (evalObj.getLong("formulateflowins.id") == 0L) {
                reason2 = ResManager.loadKDString((String)"{0}\u6b63\u5728\u9884\u5b9e\u4f8b\u5316\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"StartFormulateTask_4", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                failMessage.add(reason2);
                this.genData2Excel(exportDataList, evalObj, reason2);
                continue;
            }
            String startStatus = evalObj.getString("startstatus");
            if (HRStringUtils.equals((String)startStatus, (String)"20")) {
                String reason3 = ResManager.loadKDString((String)"{0}\u5236\u5b9a\u5bf9\u8c61\u7684\u6307\u6807\u5236\u5b9a\u4efb\u52a1\u5df2\u542f\u52a8\u6216\u5df2\u5b8c\u6210\u3002", (String)"StartFormulateTask_5", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                failMessage.add(reason3);
                this.genData2Excel(exportDataList, evalObj, reason3);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)evalObj.getDynamicObject("formulateflow"))) {
                String reason4 = ResManager.loadKDString((String)"{0}\u672a\u914d\u7f6e\u6d41\u7a0b\u3002", (String)"StartFormulateTask_6", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                failMessage.add(reason4);
                this.genData2Excel(exportDataList, evalObj, reason4);
                continue;
            }
            long evalObjId = evalObj.getLong("id");
            if (HRStringUtils.equals((String)settingMode, (String)"20")) {
                List roleCheckList = (List)flowCommonResultBo.getMsgMap().get(evalObjId);
                if (HRStringUtils.equals((String)flowCommonResultBo.getCode(), (String)"-1") && !ObjectUtils.isEmpty((Object)roleCheckList)) {
                    String reason5 = personDesc + String.join((CharSequence)"", ((Map)roleCheckList.get(0)).values());
                    failMessage.add(reason5);
                    this.genData2Excel(exportDataList, evalObj, reason5);
                    continue;
                }
            }
            boolean hasFormulateNode = this.hasFormulateNode(executeScheme, evalObj);
            String evaSumLimit = assessDy.getString("evasumlimit");
            if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) && !EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
                BigDecimal sumWeightScore;
                BigDecimal bigDecimal = sumWeightScore = normalAreaSumMap.get(evalObjId) == null ? new BigDecimal(0) : normalAreaSumMap.get(evalObjId);
                if (checkForcedControlZeroMap.get(evalObjId) != null && checkForcedControlZeroMap.get(evalObjId).booleanValue()) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u5408\u8ba1\u6743\u91cd\u9700=100%\u3002", (String)"StartFormulateTask_8", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
                if (sumWeightScore.compareTo(new BigDecimal(100)) > 0) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u5408\u8ba1\u6743\u91cd\u9700=100%\u3002", (String)"StartFormulateTask_8", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
                if (!hasFormulateNode && sumWeightScore.compareTo(new BigDecimal(100)) < 0) {
                    reason = ResManager.loadKDString((String)"{0}\u5df2\u5236\u5b9a\u6307\u6807\u6743\u91cd\u672a\u8fbe\u5230100%\uff0c\u4f46\u6240\u9009\u62e9\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u672a\u6709\u201c\u5236\u5b9a\u201d\u8282\u70b9\u3002", (String)"StartFormulateTask_9", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaSumScoreMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700\u2264\u533a\u57df\u6743\u91cd\u3002", (String)"StartFormulateTask_10", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaScoreNotEqMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u6743\u91cd\u5168\u90e8\u5927\u4e8e0\u65f6\uff0c\u533a\u57df\u5408\u8ba1\u6743\u91cd\u9700=100%\u3002", (String)"StartFormulateTask_11", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
            } else if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) && EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
                String reason6;
                BigDecimal limitMaxRatioBD = new BigDecimal(100);
                BigDecimal HundredRatioBD = new BigDecimal(100);
                if (assessDy.getBigDecimal("limitmaxratio") != null) {
                    limitMaxRatioBD = assessDy.getBigDecimal("limitmaxratio");
                }
                int numaccuracy = 0;
                try {
                    numaccuracy = Integer.parseInt(assessDy.getString("numaccuracy"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                limitMaxRatioBD = limitMaxRatioBD.setScale(numaccuracy);
                BigDecimal sumWeightScore = normalAreaSumMap.get(evalObjId) == null ? new BigDecimal(0) : normalAreaSumMap.get(evalObjId);
                Map<Long, Boolean> checkOutWeightForcedControlZeroMap = APP_SERVICE.checkOutWeightForcedControlZeroMap(evalObjs, "areaweight", limitMaxRatioBD);
                if (checkOutWeightForcedControlZeroMap.get(evalObjId) != null && checkOutWeightForcedControlZeroMap.get(evalObjId).booleanValue()) {
                    reason6 = ResManager.loadKDString((String)"{0}\u5f53\u5b58\u5728\u5f3a\u63a7\u7684\u533a\u57df\u6743\u91cd\u4e3a0\u7684\u533a\u57df\u65f6\uff0c\u201c\u533a\u57df\u7d2f\u8ba1\u6743\u91cd\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u8868\u5355\u6307\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d\uff1a{1}%\uff0c\u5927\u4e8e\u7b49\u4e8e100%\u3002", (String)"StartFormulateTask_22", (String)"opmc-epa-business", (Object[])new Object[]{personDesc, limitMaxRatioBD});
                    failMessage.add(reason6);
                    this.genData2Excel(exportDataList, evalObj, reason6);
                    continue;
                }
                if (sumWeightScore.compareTo(limitMaxRatioBD) > 0) {
                    reason6 = ResManager.loadKDString((String)"{0}\u201c\u533a\u57df\u7d2f\u8ba1\u6743\u91cd\u9700\u201d\u5c0f\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u8868\u5355\u5236\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d\uff1a{1}", (String)"StartFormulateTask_23", (String)"opmc-epa-business", (Object[])new Object[]{personDesc, limitMaxRatioBD});
                    failMessage.add(reason6);
                    this.genData2Excel(exportDataList, evalObj, reason6);
                    continue;
                }
                if (!hasFormulateNode && sumWeightScore.compareTo(new BigDecimal(100)) < 0) {
                    reason6 = ResManager.loadKDString((String)"{0}\u5df2\u5236\u5b9a\u6307\u6807\u6743\u91cd\u672a\u8fbe\u5230100%\uff0c\u4f46\u6240\u9009\u62e9\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u672a\u6709\u201c\u5236\u5b9a\u201d\u8282\u70b9\u3002", (String)"StartFormulateTask_9", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason6);
                    this.genData2Excel(exportDataList, evalObj, reason6);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaSumScoreMap.get(evalObjId))) {
                    reason6 = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700\u2264\u533a\u57df\u6743\u91cd\u3002", (String)"StartFormulateTask_10", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason6);
                    this.genData2Excel(exportDataList, evalObj, reason6);
                    continue;
                }
                Map<Long, BigDecimal> areaValLargeMap = APP_SERVICE.getAreaValLargeMap(evalObjs, "areaweight", limitMaxRatioBD, areaInstanceMap);
                if (!ObjectUtils.isEmpty((Object)areaValLargeMap.get(evalObjId))) {
                    String reason7 = ResManager.loadKDString((String)"{0}\u533a\u57df\u6743\u91cd\u5168\u90e8\u5927\u4e8e0\u65f6\uff0c\u201c\u533a\u57df\u7d2f\u8ba1\u6743\u91cd\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u8868\u5355\u6307\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d\uff1a{0}%\uff0c\u5927\u4e8e\u7b49\u4e8e100%\u3002", (String)"StartFormulateTask_24", (String)"opmc-epa-business", (Object[])new Object[]{personDesc, limitMaxRatioBD});
                    failMessage.add(reason7);
                    this.genData2Excel(exportDataList, evalObj, reason7);
                    continue;
                }
            } else {
                BigDecimal sumIndctrScore;
                BigDecimal bigDecimal = sumIndctrScore = normalAreaSumMap.get(evalObjId) == null ? new BigDecimal(0) : normalAreaSumMap.get(evalObjId);
                if (checkForcedControlZeroMap.get(evalObjId) != null && checkForcedControlZeroMap.get(evalObjId).booleanValue()) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u5408\u8ba1\u5206\u503c\u9700=\u57fa\u51c6\u6700\u9ad8\u5206\u3002", (String)"StartFormulateTask_12", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
                if (sumIndctrScore.compareTo(limitMaxScore) > 0) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700\u2264\u533a\u57df\u5206\u503c\u3002", (String)"StartFormulateTask_13", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
                if (!hasFormulateNode && sumIndctrScore.compareTo(maxScoreOfSystem) < 0) {
                    reason = ResManager.loadKDString((String)"{0}\u5df2\u5236\u5b9a\u6307\u6807\u5206\u503c\u7d2f\u8ba1\u672a=\u57fa\u51c6\u6700\u9ad8\u5206\uff0c\u4f46\u6240\u9009\u62e9\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u672a\u6709\u201c\u5236\u5b9a\u201d\u8282\u70b9\u3002", (String)"StartFormulateTask_14", (String)"opmc-epa-business", (Object[])new Object[0]);
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaSumScoreMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700=\u533a\u57df\u5206\u503c\u3002", (String)"StartFormulateTask_15", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaScoreNotEqMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u5408\u8ba1\u5206\u503c\u9700=\u57fa\u51c6\u6700\u9ad8\u5206\u3002", (String)"StartFormulateTask_12", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
            }
            evalObjPassList.add(evalObj);
        }
        String exportUrl = null;
        if (exportDataList.size() > 0) {
            String excelName = ResManager.loadKDString((String)"\u542f\u52a8\u5236\u5b9a\u6d41\u7a0b\u6821\u9a8c_\u9519\u8bef\u62a5\u544a_{0}", (String)"StartFormulateTask_21", (String)"opmc-epa-business", (Object[])new Object[]{HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss")});
            List<HRExportHeadObject> headDataList = this.getExportHead();
            try {
                exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, exportDataList, headDataList);
            }
            catch (IOException e) {
                log.error("StartFormulateTask exportUrl failure: ", (Throwable)e);
            }
        }
        return Tuple.create(evalObjPassList, exportUrl);
    }

    private void genData2Excel(List<Map<String, Object>> exportDataList, DynamicObject evalObj, String reason) {
        HashMap<String, Object> exportData = new HashMap<String, Object>(16);
        exportData.put("perffilenumber", evalObj.get("perffile.number"));
        exportData.put("name", evalObj.get("person.name"));
        exportData.put("number", evalObj.get("person.number"));
        exportData.put("reason", reason);
        exportDataList.add(exportData);
    }

    private List<HRExportHeadObject> getExportHead() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("perffilenumber", ResManager.loadKDString((String)"\u7ee9\u6548\u6863\u6848\u7f16\u7801", (String)"StartFormulateTask_17", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"StartFormulateTask_18", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"StartFormulateTask_19", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"StartFormulateTask_20", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        return headDataList;
    }
}

