/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.interview.entityservice.ActInsEntityService;
import kd.opmc.epa.business.domain.interview.enums.InterStatusEnum;
import kd.opmc.epa.business.domain.interview.service.InterviewObjDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.pbs.business.application.impl.mq.StartProcessPublisher;
import kd.opmc.pbs.business.domain.flowscan.entity.BatchFlowTaskResultBo;
import kd.opmc.pbs.business.domain.flowscan.entityservice.BatchStartEvalEntityService;
import kd.opmc.pbs.business.domain.flowscan.enums.TaskTypeEnum;
import kd.opmc.pbs.business.domain.flowscan.service.BatchFlowTaskService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;

public class StartInterviewTask
extends AbstractTask {
    private static final InterviewObjDomainService INTERVIEW_OBJ_DOMAIN_SERVICE = InterviewObjDomainService.getInstance();
    private static final BatchFlowTaskService BATCH_FLOW_TASK_SERVICE = BatchFlowTaskService.getInstance();
    private static final BatchStartEvalEntityService BATCH_START_EVAL_ENTITY_SERVICE = BatchStartEvalEntityService.getInstance();
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActInsEntityService ACT_INS_ENTITY_SERVICE = ActInsEntityService.getInstance();
    private static final Log LOG = LogFactory.getLog(StartInterviewTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        ArrayList<String> msgList = new ArrayList<String>(16);
        Object[] inteObjs = (Object[])SerializationUtils.deSerializeFromBase64((String)map.get("inteObjs").toString());
        Object[] dynamicObjects = INTERVIEW_OBJ_DOMAIN_SERVICE.queryInterviewByPkValue(inteObjs);
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        int allSize = dynamicObjects.length;
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>(16);
        resultMap.put("valTotalNum", Integer.valueOf(allSize));
        resultMap.put("valDealNum", Integer.valueOf(0));
        resultMap.put("startTotalNum", Integer.valueOf(allSize));
        resultMap.put("startDealNum", Integer.valueOf(0));
        String desc = ResManager.loadKDString((String)"\u63d0\u4ea4\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762\uff0c\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c", (String)"StartInterviewTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        this.feedbackProgress(10, desc, resultMap);
        ArrayList<DynamicObject> successObjList = new ArrayList<DynamicObject>(16);
        for (Object object : dynamicObjects) {
            String errorMsg;
            if (!HRStringUtils.equals((String)object.getString("interstatus"), (String)InterStatusEnum.JOINED.getStatus())) {
                errorMsg = ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u72b6\u6001\u672a\u5728\u201c\u5f85\u9762\u8c08\u201d\u4e2d\uff0c\u4e0d\u80fd\u542f\u52a8", (String)"StartInterviewTask_1", (String)"opmc-epa-business", (Object[])new Object[]{object.getString("person.name"), object.getString("person.number")});
                msgList.add(errorMsg);
                continue;
            }
            if (HRObjectUtils.isEmpty((Object)object.getDynamicObject("interflow"))) {
                errorMsg = ResManager.loadKDString((String)"{0} {1}\uff1a\u9762\u8c08\u6d41\u7a0b\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u542f\u52a8", (String)"StartInterviewTask_2", (String)"opmc-epa-business", (Object[])new Object[]{object.getString("person.name"), object.getString("person.number")});
                msgList.add(errorMsg);
                continue;
            }
            successObjList.add((DynamicObject)object);
        }
        resultMap.put("valDealNum", Integer.valueOf(allSize));
        resultMap.put("success", Integer.valueOf(successObjList.size()));
        resultMap.put("fail", Integer.valueOf(allSize - successObjList.size()));
        resultMap.put("total", Integer.valueOf(allSize));
        this.feedbackProgress(20, desc, resultMap);
        if (!successObjList.isEmpty()) {
            ArrayList<FlowRuProcBo> inteFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
            try {
                String batchNo = BATCH_FLOW_TASK_SERVICE.requireBatchNoByBatchTask(TaskTypeEnum.EVAL_START);
                for (DynamicObject dynamicObject : successObjList) {
                    dynamicObject.set("interstatus", (Object)InterStatusEnum.HAVE_IN_HAND.getStatus());
                    dynamicObject.set("starttime", (Object)new Date());
                    FlowRuProcBo flowRuProcBo = this.buildInterviewProcBo(dynamicObject, batchNo);
                    inteFlowRuProcBoList.add(flowRuProcBo);
                }
                resultMap.put("valTotalNum", Integer.valueOf(allSize));
                resultMap.put("valDealNum", Integer.valueOf(inteFlowRuProcBoList.size()));
                resultMap.put("startTotalNum", Integer.valueOf(allSize));
                resultMap.put("startDealNum", Integer.valueOf(inteFlowRuProcBoList.size()));
                this.feedbackProgress(60, desc, resultMap);
                BatchFlowTaskResultBo startEvaResultBo = BATCH_START_EVAL_ENTITY_SERVICE.generateBatchFlowTaskData(inteFlowRuProcBoList, TaskTypeEnum.INTERVIEW_START.getValue());
                StartProcessPublisher.publish((List)startEvaResultBo.getBatchTaskIdList(), (String)startEvaResultBo.getTaskType());
                List<Long> list = successObjList.stream().map(x -> x.getLong("evalobj.id")).collect(Collectors.toList());
                DynamicObject[] evalObjFsop = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjFsopById(list);
                this.setInterviewFsop(successObjList, evalObjFsop);
                INTERVIEW_OBJ_DOMAIN_SERVICE.saveInterview((DynamicObject[])dynamicObjects);
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception);
                String msg = ResManager.loadKDString((String)"\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\u3002", (String)"StartInterviewTask_3", (String)"opmc-epa-business", (Object[])new Object[0]);
                msgList.add(msg);
            }
            resultMap.put("success", Integer.valueOf(inteFlowRuProcBoList.size()));
            resultMap.put("fail", Integer.valueOf(allSize - inteFlowRuProcBoList.size()));
            resultMap.put("total", Integer.valueOf(allSize));
        }
        resultMap.put("msgList", (Serializable)((Object)(!ObjectUtils.isEmpty(msgList) && msgList.size() > 1 ? msgList.stream().distinct().collect(Collectors.toList()) : msgList)));
        this.feedbackProgress(80, desc, resultMap);
        this.feedbackCustomdata(resultMap);
    }

    private void setInterviewFsop(List<DynamicObject> successObjList, DynamicObject[] evalObjFsop) {
        Map<Long, Tuple> evalFsopMap = Arrays.stream(evalObjFsop).collect(Collectors.toMap(task -> task.getLong("id"), task2 -> new Tuple((Object)task2.getBigDecimal(AssessScoreAbbrEnum.FSOP.getCode()), (Object)task2.getString(AssessScoreAbbrEnum.FLOP.getCode())), (task, task2) -> task2));
        Map<Long, Long> interNEvalIdMap = successObjList.stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getLong("evalobj.id"), (task, task2) -> task2));
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        for (DynamicObject interObj : successObjList) {
            Tuple bigDecimalStringTuple = evalFsopMap.get(interNEvalIdMap.get(interObj.getLong("id")));
            interObj.set("fsop", bigDecimalStringTuple.item1);
            interObj.set("flop", bigDecimalStringTuple.item2);
            interObj.set("modifier", (Object)userId);
            interObj.set("modifytime", (Object)date);
        }
    }

    private FlowRuProcBo buildInterviewProcBo(DynamicObject interviewObj, String batchNo) {
        DynamicObject interActConf;
        long flowVid = interviewObj.getLong("interflow.id");
        DynamicObject person = interviewObj.getDynamicObject("person");
        long actEvalObjId = interviewObj.getLong("id");
        long activityId = interviewObj.getLong("interact.id");
        long empPosRelId = interviewObj.getLong("empposrel.id");
        String settingMode = "";
        if (!HRObjectUtils.isEmpty((Object)interviewObj) && !HRObjectUtils.isEmpty((Object)(interActConf = interviewObj.getDynamicObject("interact")))) {
            long perfWorkFlowId = interActConf.getLong("perfworkflow.id");
            settingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(perfWorkFlowId), "7");
        }
        return FlowRuProcBo.builder().flowVid(Long.valueOf(flowVid)).person(person).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).workflowType("3").settingMode(settingMode).batchNo(batchNo).build();
    }
}

