/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessGroupApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entity.ActObjStatBo;
import kd.opmc.epa.business.domain.timetag.enums.TimeStampEnums;
import kd.opmc.epa.business.task.StartUpActivityTask;
import kd.opmc.epa.common.utils.activity.EvalObjectUtils;

public class StartUpActivityAddActObjectTask
extends StartUpActivityTask {
    private static final Log LOG = LogFactory.getLog(StartUpActivityAddActObjectTask.class);
    private static final AssessObjectApplicationService ASSESS_OBJECT = AssessObjectApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final AssessGroupApplicationService ASSESS_GROUP_APPLICATION_SERVICE = AssessGroupApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"StartUpActivityAddActObjectTask#&", (int)3, (int)5);
    private static final Semaphore SEMAPHORE = new Semaphore(5);
    private static final String ACTIVITY_START_UP_LOCK = "opmc/datalock/activity/startup/";

    @Override
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map.containsKey("activity_id")) {
            try (DLock lock = DLock.create((String)(ACTIVITY_START_UP_LOCK + map.get("activity_id")));){
                lock.lock();
                long assessActivityPkId = Long.parseLong(String.valueOf(map.get("activity_id")));
                DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
                cache.put(String.valueOf(map.get("activity_id")), (Object)String.valueOf(map.get("activity_id")));
                DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(assessActivityPkId);
                DynamicObject[] joinInAssessObjectArr = ASSESS_OBJECT.queryByFilters(new QFilter[]{this.getFilter(assessActivityPkId)});
                DynamicObject[] joinInAssess = ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE.filterPerffileAssess(joinInAssessObjectArr, activityDynObj);
                String desc = ResManager.loadKDString((String)"\u6b63\u5728\u4e3a\u60a8\u81ea\u52a8\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61...", (String)"StartUpActivityAddActObjectTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.feedbackProgress(20, desc, null);
                ArrayList<DynamicObject> sucessDyns = new ArrayList<DynamicObject>();
                this.valid(sucessDyns, joinInAssess, activityDynObj);
                List activityDynObjs = Lists.partition(sucessDyns, (int)100);
                int count = activityDynObjs.size();
                CountDownLatch atomicInteger = new CountDownLatch(count);
                for (int i = 0; i < count; ++i) {
                    List assessObjectColls = (List)activityDynObjs.get(i);
                    int pecent = (i + 1) / count * 90;
                    this.batchsaveEvaluationObject(assessObjectColls, activityDynObj, desc, pecent, atomicInteger);
                }
                try {
                    atomicInteger.await();
                    cache.put(String.valueOf(map.get("activity_id")), (Object)"");
                    ArrayList<Long> longList = new ArrayList<Long>(10);
                    longList.add(assessActivityPkId);
                    Map<Long, ActObjStatBo> mapresult = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.countActObjStatusByActivityIds(longList);
                    HashMap<String, Integer> taskInfoMap = new HashMap<String, Integer>(16);
                    if (mapresult.isEmpty()) {
                        taskInfoMap.put("sucess", 0);
                    } else {
                        taskInfoMap.put("sucess", mapresult.get(assessActivityPkId).getJoined());
                    }
                    this.feedbackCustomdata(taskInfoMap);
                }
                catch (InterruptedException e) {
                    LOG.error("==================StartUpActivityAddActObjectTask==================", (Throwable)e);
                }
            }
        }
    }

    private void batchsaveEvaluationObject(List<DynamicObject> assessObjectColls, DynamicObject activityDynObj, String desc, int pecent, CountDownLatch atomicInteger) {
        try {
            LOG.info("==================start StartUpActivityAddActObjectTask==================");
            SEMAPHORE.acquire();
            LOG.info("==================acquire semaphore StartUpActivityAddActObjectTask==================");
            THREAD_POOL.execute(() -> {
                try {
                    ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE.addEvaluationObjects(assessObjectColls.toArray(new DynamicObject[0]), activityDynObj, this);
                    if (pecent > 0) {
                        this.feedbackProgress(pecent - 1, desc, null);
                    }
                }
                catch (Exception exception) {
                    LOG.error("==================StartUpActivityAddActObjectTask==================", (Throwable)exception);
                }
                finally {
                    SEMAPHORE.release();
                    atomicInteger.countDown();
                    LOG.info("==================release semaphore StartUpActivityAddActObjectTask==================");
                }
            }, RequestContext.get());
        }
        catch (InterruptedException interruptedException) {
            LOG.error("==================StartUpActivityAddActObjectTask InterruptedException==================", (Throwable)interruptedException);
        }
    }

    @Override
    public void feedbackStartUpProgress(int progress, String desc, Map<String, Object> customData) {
        this.feedbackProgress(progress, desc, customData);
    }

    private long getSchemeId(long assessActivityId) {
        DynamicObject executeSchemeDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.getExecuteSchemeById(assessActivityId);
        return executeSchemeDynObj.getLong("scheme.id");
    }

    private QFilter getFilter(Long activityId) {
        DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(activityId);
        long schemeId = activity.getDynamicObject("scheme").getLong("id");
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        Set<Long> groupIds = this.getScopeGroupsByAct(activity);
        QFilter groupFilter = new QFilter("assgroup", "in", groupIds);
        qFilter.and(groupFilter);
        Set<Long> objIds = this.getJoinedObjIdsByAct(activity);
        qFilter.and(new QFilter("perfile", "not in", objIds));
        qFilter.and(new QFilter("perfile.archivesstatus", "=", (Object)"1"));
        return qFilter;
    }

    private Set<Long> getScopeGroupsByAct(DynamicObject activity) {
        DynamicObject executeScheme = activity.getDynamicObject("executescheme");
        Long assessScopeId = executeScheme.getDynamicObject("assessscope").getLong("id");
        DynamicObject[] assessGroups = ASSESS_GROUP_APPLICATION_SERVICE.queryListByScopeId(true, assessScopeId);
        return Arrays.stream(assessGroups).map(group -> group.getLong("id")).collect(Collectors.toSet());
    }

    private String getPeriod(String period, DynamicObject scheme) {
        Long cycleTypeId = scheme.getLong("cycletype.id");
        if (cycleTypeId.equals(TimeStampEnums.M1.getTypeId())) {
            return period;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(period, 0, 4);
        if (cycleTypeId.equals(TimeStampEnums.Y.getTypeId())) {
            stringBuilder.append(TimeStampEnums.Y.getTag());
        } else if (cycleTypeId.equals(TimeStampEnums.H1.getTypeId())) {
            stringBuilder.append(this.calculateHalfTag(period));
        } else if (cycleTypeId.equals(TimeStampEnums.Q1.getTypeId())) {
            stringBuilder.append(this.calculateQuarterTag(period));
        }
        return stringBuilder.toString();
    }

    private String calculateHalfTag(String period) {
        int value;
        if (period.charAt(4) == 'Q') {
            value = this.getValueFromPeriod(period);
            if (value > 2 && value <= 4) {
                return TimeStampEnums.H2.getTag();
            }
            if (value > 0 && value <= 2) {
                return TimeStampEnums.H1.getTag();
            }
        }
        if (period.charAt(4) == 'M') {
            value = this.getValueFromPeriod(period);
            if (value > 6 && value <= 12) {
                return TimeStampEnums.H2.getTag();
            }
            if (value > 0 && value <= 6) {
                return TimeStampEnums.H1.getTag();
            }
        }
        return period.substring(4);
    }

    private String calculateQuarterTag(String period) {
        if (period.charAt(4) == 'M') {
            int value = this.getValueFromPeriod(period);
            if (value > 9 && value <= 12) {
                return TimeStampEnums.Q4.getTag();
            }
            if (value > 6 && value <= 9) {
                return "Q3";
            }
            if (value > 3 && value <= 6) {
                return "Q2";
            }
            if (value > 0 && value <= 3) {
                return TimeStampEnums.Q1.getTag();
            }
        }
        return period.substring(4);
    }

    private int getValueFromPeriod(String period) {
        String lastTwoDigits = period.substring(5);
        return Integer.parseInt(lastTwoDigits);
    }

    private Set<Long> getJoinedObjIdsByAct(DynamicObject activity) {
        DynamicObject[] evaluationObject = EVALUATION_OBJECT_APPLICATION_SERVICE.queryEvaluationObjectByActId((Long)activity.getPkValue());
        return Arrays.stream(evaluationObject).map(obj -> obj.getLong("perffile.id")).collect(Collectors.toSet());
    }

    private void valid(List<DynamicObject> sucessList, DynamicObject[] assessObj, DynamicObject curActivity) {
        List<Long> perffileIds = Arrays.stream(assessObj).map(obj -> obj.getDynamicObject("perfile").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection assGroupsEntry = curActivity.getDynamicObjectCollection("assgroupentry");
        Set actGroupIdSet = assGroupsEntry.stream().map(group -> group.getDynamicObject("assgroup").getLong("id")).collect(Collectors.toSet());
        Set<Long> scopeGroupsIds = this.getScopeGroupsByAct(curActivity);
        Set<Long> joinedObjIds = this.getJoinedObjIdsByAct(curActivity);
        Map<Long, DynamicObject> existedEvaMap = EVALUATION_OBJECT_APPLICATION_SERVICE.queryExistEvalObjectByPerfIds(curActivity.getString("period"), perffileIds);
        String period = curActivity.getString("period");
        long schemeId = curActivity.getDynamicObject("scheme").getLong("id");
        HashSet leftTag = new HashSet(16);
        HashSet rightTag = new HashSet(16);
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryCycleInfoById(schemeId);
        String startTagYear = scheme.getDynamicObject("starttimetag").getString("name");
        String tag = startTagYear.substring(0, 1);
        if ("M".equals(tag)) {
            EvalObjectUtils.getSchemeMonthPeriodStr((DynamicObject)scheme, (String)period, leftTag, rightTag);
        }
        String topTimeTag = this.getTimeTag(scheme, period);
        Date actStart = curActivity.getDate("periodstartdate");
        Date actEnd = curActivity.getDate("periodenddate");
        for (DynamicObject dataEntity : assessObj) {
            Set<Long> joinobjIds;
            long groupId = dataEntity.getDynamicObject("assgroup").getLong("id");
            long perffileId = dataEntity.getLong("perfile.id");
            Long id = dataEntity.getLong("id");
            if (!actGroupIdSet.contains(groupId)) continue;
            Date perfStartDate = dataEntity.getDate("perfile.startdate");
            Date perfEndDate = dataEntity.getDate("perfile.enddate");
            if (perfStartDate != null && perfEndDate != null && (perfEndDate.compareTo(actStart) < 0 || perfStartDate.compareTo(actEnd) > 0)) continue;
            String startCycle = dataEntity.getString("startcycle");
            String endCycle = dataEntity.getString("endcycle");
            boolean notContainsMonthPeriod = false;
            boolean notContainsOtherPeriod = false;
            if (StringUtils.isEmpty((CharSequence)startCycle)) continue;
            if (StringUtils.isEmpty((CharSequence)endCycle)) {
                notContainsMonthPeriod = tag.charAt(0) == 'M' && !leftTag.contains(startCycle);
                notContainsOtherPeriod = tag.charAt(0) != 'M' && topTimeTag.compareTo(startCycle) < 0;
            } else {
                notContainsMonthPeriod = rightTag.isEmpty() ? tag.charAt(0) == 'M' && !leftTag.contains(startCycle) : tag.charAt(0) == 'M' && (!leftTag.contains(startCycle) || !rightTag.contains(endCycle));
                boolean bl = notContainsOtherPeriod = tag.charAt(0) != 'M' && (topTimeTag.compareTo(startCycle) < 0 || topTimeTag.compareTo(endCycle) > 0);
            }
            if (notContainsMonthPeriod || notContainsOtherPeriod) continue;
            boolean notContainsScopeGroup = !scopeGroupsIds.contains(groupId);
            boolean joinedObj = joinedObjIds.contains(perffileId);
            if (notContainsScopeGroup || joinedObj || (joinobjIds = this.getJoinedObjIdsByAct(curActivity)).contains(perffileId) || HRStringUtils.equals((String)dataEntity.getString("perfile.archivesstatus"), (String)"2")) continue;
            sucessList.add(dataEntity);
        }
    }

    private String getTimeTag(DynamicObject scheme, String period) {
        String timeTag = null;
        String startTagYear = scheme.getDynamicObject("starttimetag").getString("name");
        String tag = startTagYear.substring(0, 1);
        int periodYear = Integer.parseInt(period.substring(0, 4));
        String periodTag = period.substring(4, 5);
        int periodNumber = 0;
        timeTag = periodYear + startTagYear;
        switch (tag) {
            case "Y": {
                timeTag = periodYear + tag;
                break;
            }
            case "H": {
                periodNumber = Integer.parseInt(period.substring(5));
                if ("H".equals(periodTag)) {
                    timeTag = periodYear + tag + periodNumber;
                    break;
                }
                if ("Q".equals(periodTag)) {
                    timeTag = periodYear + tag + (periodNumber / 3 + 1);
                    break;
                }
                timeTag = periodYear + tag + (periodNumber / 7 + 1);
                break;
            }
            case "Q": {
                periodNumber = Integer.parseInt(period.substring(5));
                if ("Q".equals(periodTag)) {
                    timeTag = periodYear + tag + periodNumber;
                    break;
                }
                timeTag = periodYear + tag + ((periodNumber - 1) / 3 + 1);
                break;
            }
        }
        return timeTag;
    }
}

