/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;

public class StartUpActivityTask
extends AbstractTask {
    private static final AssessObjectApplicationService ASSESS_OBJECT = AssessObjectApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final String ACTIVITY_START_UP_LOCK = "opmc/datalock/activity/startup/";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (map.containsKey("activity_id")) {
            try (DLock lock = DLock.create((String)(ACTIVITY_START_UP_LOCK + map.get("activity_id")));){
                lock.lock();
                long assessActivityPkId = Long.parseLong(String.valueOf(map.get("activity_id")));
                DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(assessActivityPkId);
                Object[] joinInAssessObjectArr = ASSESS_OBJECT.queryListByActivity(activityDynObj);
                if (HRArrayUtils.isEmpty((Object[])joinInAssessObjectArr)) {
                    return;
                }
                String desc = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762\uff0c\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c", (String)"StartUpActivityTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
                this.feedbackProgress(20, desc, null);
                Object[] joinInAssess = ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE.filterJoinAssess((DynamicObject[])joinInAssessObjectArr, activityDynObj);
                if (HRArrayUtils.isEmpty((Object[])joinInAssess)) {
                    return;
                }
                this.feedbackProgress(40, desc, null);
                ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE.addEvaluationObjects((DynamicObject[])joinInAssess, activityDynObj, this);
                this.feedbackProgress(100, desc, null);
            }
        }
    }

    public void feedbackStartUpProgress(int progress, String desc, Map<String, Object> customData) {
        this.feedbackProgress(progress, desc, customData);
    }

    private long getSchemeId(long assessActivityId) {
        DynamicObject executeSchemeDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.getExecuteSchemeById(assessActivityId);
        return executeSchemeDynObj.getLong("scheme.id");
    }
}

