/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjGenAreaInsEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ObjSumAreaInsEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.CustomConfigEntityService;
import kd.opmc.epa.business.domain.assessrule.entityservice.NormalConfigEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAddSubEvalRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjAttachEvalRecordEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjCustomAreaInsEntityService;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenEvalRecordEntityService;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;

public class SubmitBatchEvalObjTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(SubmitBatchEvalObjTask.class);
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final ObjGenEvalRecordEntityService GEN_EVAL_RECORD_ENTITY = ObjGenEvalRecordEntityService.getInstance();
    private static final ObjAddSubEvalRecordEntityService ADD_SUB_EVAL_RECORD_ENTITY = ObjAddSubEvalRecordEntityService.getInstance();
    private static final ObjAttachEvalRecordEntityService ATTACH_EVAL_RECORD_ENTITY = ObjAttachEvalRecordEntityService.getInstance();
    private static final ObjCustomAreaInsEntityService CUSTOM_AREA_RECORD_ENTITY = ObjCustomAreaInsEntityService.getInstance();
    private static final ObjSumAreaInsEntityService OBJ_SUM_AREA_INS_ENTITY_SERVICE = ObjSumAreaInsEntityService.getInstance();
    private static final ObjGenAreaInsEntityService OBJ_GEN_AREA_INS_ENTITY_SERVICE = ObjGenAreaInsEntityService.getInstance();
    private static final NormalConfigEntityService NORMAL_CONFIG_ENTITY_SERVICE = NormalConfigEntityService.getInstance();
    private static final CustomConfigEntityService CUSTOM_CONFIG_ENTITY_SERVICE = CustomConfigEntityService.getInstance();
    private static final String FAIL_PROCESSED_KEY = "processed";
    private static final String FAIL_RETURNED_KEY = "returned";
    private static final String FAIL_EXPIRED_KEY = "expired";
    private static final String FAIL_MUTEXED_KEY = "mutexed";
    private static final ActEvalObjDetailApplicationService ACTEVAL_APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List objIds = (List)SerializationUtils.deSerializeFromBase64((String)map.get("evaluationObjectIds").toString());
        HashMap taskMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)map.get("taskMap").toString());
        if (taskMap == null) {
            taskMap = new HashMap(16);
        }
        Map mergeTaskMap = (Map)SerializationUtils.deSerializeFromBase64((String)map.get("mergeTaskMap").toString());
        HashMap mustInputFields = (HashMap)SerializationUtils.deSerializeFromBase64((String)map.get("mustInputFields").toString());
        if (!HRObjectUtils.isEmpty((Object)mustInputFields)) {
            LOG.info("mustInputFields: {}", (Object)mustInputFields);
        }
        String currentShowTaskId = (String)SerializationUtils.deSerializeFromBase64((String)map.get("currentShowTaskId").toString());
        HashMap isAllImportIndicators = (HashMap)SerializationUtils.deSerializeFromBase64((String)map.get("isAllImportIndicators").toString());
        List tasklist = taskMap.keySet().stream().collect(Collectors.toList());
        String desc = ResManager.loadKDString((String)"\u63d0\u4ea4\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762\uff0c\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c", (String)"SubmitBatchEvalObjTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        this.feedbackProgress(20, desc, null);
        if (ObjectUtils.isEmpty((Object)objIds)) {
            return;
        }
        HashMap failMap = new HashMap(16);
        ArrayList<String> processedList = new ArrayList<String>(10);
        ArrayList<String> returnedList = new ArrayList<String>(10);
        ArrayList<String> expiredList = new ArrayList<String>(10);
        ArrayList mutexedList = new ArrayList(10);
        ArrayList<String> validateMustList = new ArrayList<String>(10);
        ArrayList<String> notEvalList = new ArrayList<String>(10);
        ArrayList<String> errorList = new ArrayList<String>(16);
        ArrayList<Object> canSubmitTask = new ArrayList<Object>(16);
        DynamicObject[] taskDys = FLOW_RU_PROC_APPLICATION_SERVICE.queryNoOperateTasksById(tasklist);
        Map<Long, String> personNameAndNumberMap = APP_SERVICE.getPersonNameAndNumberByIds(objIds);
        for (Map.Entry taskEntry : taskMap.entrySet()) {
            Long taskId = (Long)taskEntry.getKey();
            Long id = (Long)taskEntry.getValue();
            LOG.info("obj:{} ,submitTask taskId:{}", (Object)id, (Object)taskId);
            String taskStatus = this.getInNoOperateTaskStatus(taskId, taskDys);
            String string = personNameAndNumberMap.get(id);
            if (taskStatus != null) {
                this.setFailList(taskStatus, string, FlowRuTaskStatusEnum.PROCESSED.getCode(), processedList);
                this.setFailList(taskStatus, string, FlowRuTaskStatusEnum.RETURNED.getCode(), returnedList);
                this.setFailList(taskStatus, string, FlowRuTaskStatusEnum.EXPIRED.getCode(), expiredList);
                continue;
            }
            int flag = 0;
            int validateMust = this.isValidateMust(mustInputFields, validateMustList, taskId, string, flag != 0, notEvalList, currentShowTaskId, isAllImportIndicators);
            if (validateMust != 0) continue;
            canSubmitTask.add(taskId);
        }
        this.feedbackProgress(60, desc, null);
        LinkedList<Long> submitTaskSuccessList = new LinkedList<Long>();
        ArrayList<Object> canSubmitTaskWithMergeTask = new ArrayList<Object>(10);
        for (Object taskIdTmp : canSubmitTask) {
            String mergeTaskStr = (String)mergeTaskMap.get(taskIdTmp);
            if (HRStringUtils.isNotEmpty((String)mergeTaskStr) && mergeTaskStr.contains(",")) {
                for (String mergeTaskId : mergeTaskStr.split(",")) {
                    canSubmitTaskWithMergeTask.add(Long.valueOf(mergeTaskId));
                }
                continue;
            }
            canSubmitTaskWithMergeTask.add(taskIdTmp);
        }
        Map taskIdResultMap = FLOW_RU_PROC_APPLICATION_SERVICE.submitTask(canSubmitTaskWithMergeTask);
        for (Object taskId : canSubmitTask) {
            Long l = (Long)taskMap.get(taskId);
            LOG.info("obj:{} ,submitTask taskId:{}", (Object)l, taskId);
            boolean submitTask = (Boolean)taskIdResultMap.get(taskId);
            if (submitTask) {
                submitTaskSuccessList.add(l);
                continue;
            }
            String msg = ResManager.loadKDString((String)"{0}\uff1a\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\u3002", (String)"SubmitBatchEvalObjTask_1", (String)"opmc-epa-business", (Object[])new Object[]{personNameAndNumberMap.get(l)});
            errorList.add(msg);
        }
        ArrayList<Long> realSuccessTaskIdList = new ArrayList<Long>(10);
        if (taskIdResultMap != null) {
            for (Map.Entry entry : taskIdResultMap.entrySet()) {
                if (entry == null) continue;
                Long taskId = (Long)entry.getKey();
                Boolean success = (Boolean)entry.getValue();
                if (taskId == null || success == null || !success.booleanValue()) continue;
                realSuccessTaskIdList.add(taskId);
            }
        }
        if (!realSuccessTaskIdList.isEmpty()) {
            ACTEVAL_APP_SERVICE.updateGenIndRecordCanEditByTask(realSuccessTaskIdList, false);
            ACTEVAL_APP_SERVICE.updateAddSubIndRecordCanEditByTask(realSuccessTaskIdList, false);
            ACTEVAL_APP_SERVICE.updateAttachIndRecordCanEditByTask(realSuccessTaskIdList, false);
            ACTEVAL_APP_SERVICE.updateCustomRecordCanEditByTask(realSuccessTaskIdList, false);
        }
        this.feedbackProgress(80, desc, null);
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>(16);
        failMap.put(FAIL_PROCESSED_KEY, processedList);
        failMap.put(FAIL_RETURNED_KEY, returnedList);
        failMap.put(FAIL_EXPIRED_KEY, expiredList);
        failMap.put(FAIL_MUTEXED_KEY, mutexedList);
        failMap.put("validateMustList", validateMustList);
        failMap.put("notEvalList", notEvalList);
        failMap.put("errorList", errorList);
        resultMap.put("failMap", failMap);
        resultMap.put("success", Integer.valueOf(submitTaskSuccessList.size()));
        resultMap.put("fail", Integer.valueOf(tasklist.size() - submitTaskSuccessList.size()));
        resultMap.put("total", Integer.valueOf(tasklist.size()));
        this.feedbackCustomdata(resultMap);
    }

    private DynamicObject[] getAreaObjects(String areaKey, List<String> mustInputFieldList, Long taskId, String personNameAndNumber, List<String> notEvalList, String currentShowTaskId, HashMap<String, Object> isAllImportIndicators) {
        String[] areaKeyArr;
        DynamicObject[] areaObjects = null;
        StringBuilder mustInputField = new StringBuilder();
        for (int i = 0; i < mustInputFieldList.size(); ++i) {
            mustInputField.append(mustInputFieldList.get(i));
            if (i >= mustInputFieldList.size() - 1) continue;
            mustInputField.append(",");
        }
        String mustInputFieldStr = mustInputField.toString();
        QFilter qFilter = new QFilter("flowrutask", "=", (Object)taskId);
        QFilter[] flowrutasksFilter = new QFilter[]{qFilter};
        switch (areaKey) {
            case "PLUS_MINUS_AREA_mustInputFields": {
                areaObjects = ADD_SUB_EVAL_RECORD_ENTITY.query(mustInputFieldStr, flowrutasksFilter);
                break;
            }
            case "ATTACH_AREA_mustInputFields": {
                areaObjects = ATTACH_EVAL_RECORD_ENTITY.query(mustInputFieldStr, flowrutasksFilter);
                break;
            }
            case "SUM_AREA_mustInputFields": {
                areaObjects = OBJ_SUM_AREA_INS_ENTITY_SERVICE.query(mustInputFieldStr, flowrutasksFilter);
                break;
            }
        }
        if (areaKey.startsWith("NORMAREAMUST_")) {
            List<DynamicObject> normAreaList;
            areaKeyArr = areaKey.split("NORMAREAMUST_");
            String confId = areaKeyArr[1];
            DynamicObject[] normAreaObjects = GEN_EVAL_RECORD_ENTITY.query(mustInputFieldStr + ",area", flowrutasksFilter);
            if (!HRObjectUtils.isEmpty((Object)normAreaObjects) && !HRObjectUtils.isEmpty(normAreaList = Arrays.stream(normAreaObjects).filter(areaObject -> {
                long areaId = areaObject.getLong("area");
                DynamicObject[] genareainsObjects = OBJ_GEN_AREA_INS_ENTITY_SERVICE.query("areaconf", new QFilter[]{new QFilter("id", "=", (Object)areaId)});
                if (!HRObjectUtils.isEmpty((Object)genareainsObjects) && genareainsObjects.length > 0) {
                    String areaconfId = genareainsObjects[0].getString("areaconf.id");
                    return HRStringUtils.equals((String)confId, (String)areaconfId);
                }
                return false;
            }).collect(Collectors.toList()))) {
                areaObjects = normAreaList.toArray(new DynamicObject[normAreaList.size()]);
            }
        }
        if (areaKey.startsWith("CUSTAREAMUST_")) {
            List<DynamicObject> custAreaList;
            areaKeyArr = areaKey.split("CUSTAREAMUST_");
            String confId = areaKeyArr[1];
            DynamicObject[] custAreaObjects = CUSTOM_AREA_RECORD_ENTITY.query(mustInputFieldStr + ",areaconf", flowrutasksFilter);
            if (!HRObjectUtils.isEmpty((Object)custAreaObjects) && !HRObjectUtils.isEmpty(custAreaList = Arrays.stream(custAreaObjects).filter(areaObject -> {
                String areaconfId = areaObject.getString("areaconf");
                return HRStringUtils.equals((String)confId, (String)areaconfId);
            }).collect(Collectors.toList()))) {
                areaObjects = custAreaList.toArray(new DynamicObject[custAreaList.size()]);
            }
        }
        if (areaObjects != null && areaObjects.length == 0 && !HRStringUtils.equals((String)taskId.toString(), (String)currentShowTaskId) && !this.isValidateNotEval(areaKey, isAllImportIndicators)) {
            notEvalList.add(ResManager.loadKDString((String)"{0}\uff1a\u4efb\u52a1\u672a\u8bc4\u4f30\u5b8c\u6210\u3002", (String)"SubmitBatchEvalObjTask_2", (String)"opmc-epa-business", (Object[])new Object[]{personNameAndNumber}));
        }
        return areaObjects;
    }

    private boolean isValidateNotEval(String areaKey, HashMap<String, Object> isAllImportIndicators) {
        Object isAllImport;
        if (areaKey.startsWith("NORMAREAMUST_")) {
            String[] areaKeyArr = areaKey.split("NORMAREAMUST_");
            String confId = areaKeyArr[1];
            String isAllImportIndicatorsKey = "isAllImportIndicators_" + confId;
            Object isAllImport2 = isAllImportIndicators.get(isAllImportIndicatorsKey);
            if (isAllImport2 != null && HRStringUtils.equals((String)isAllImport2.toString(), (String)"true")) {
                return true;
            }
        } else if (areaKey.startsWith("PLUS_MINUS_AREA_") && (isAllImport = isAllImportIndicators.get("isAllImportIndicators_PLUS_MINUS")) != null && HRStringUtils.equals((String)isAllImport.toString(), (String)"true")) {
            return true;
        }
        return false;
    }

    private boolean isValidateMust(HashMap<Object, Object> mustInputFields, List<String> validateMustList, Long taskId, String personNameAndNumber, boolean flag, List<String> notEvalList, String currentShowTaskId, HashMap<String, Object> isAllImportIndicators) {
        if (!HRObjectUtils.isEmpty(mustInputFields)) {
            block0: for (Map.Entry<Object, Object> mustFieldsEntry : mustInputFields.entrySet()) {
                String areaKey = (String)mustFieldsEntry.getKey();
                List mustInputFieldList = (List)mustFieldsEntry.getValue();
                if (flag || HRObjectUtils.isEmpty((Object)mustInputFieldList)) break;
                DynamicObject[] areaObjects = this.getAreaObjects(areaKey, mustInputFieldList, taskId, personNameAndNumber, notEvalList, currentShowTaskId, isAllImportIndicators);
                if (areaObjects == null) continue;
                if (areaObjects.length == 0 && !HRStringUtils.equals((String)taskId.toString(), (String)currentShowTaskId) && !this.isValidateNotEval(areaKey, isAllImportIndicators)) {
                    flag = true;
                    break;
                }
                block1: for (DynamicObject areaObject : areaObjects) {
                    if (flag) continue block0;
                    for (String areaValiField : mustInputFieldList) {
                        Object fieldValue = areaObject.get(areaValiField);
                        if (HRObjectUtils.isEmpty((Object)fieldValue)) {
                            LOG.info("areaKey:{} ,areaValiField:{} ,fieldValue:{}", new Object[]{areaKey, areaValiField, fieldValue});
                            validateMustList.add(ResManager.loadKDString((String)"{0}\uff1a\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u672a\u586b\u5199", (String)"SubmitBatchEvalObjTask_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{personNameAndNumber}));
                            flag = true;
                            continue block1;
                        }
                        if (!(fieldValue instanceof MulBasedataDynamicObjectCollection) || !((MulBasedataDynamicObjectCollection)fieldValue).isEmpty()) continue;
                        LOG.info("areaKey:{} ,areaValiField:{} ,fieldValue:{}", new Object[]{areaKey, areaValiField, fieldValue});
                        validateMustList.add(ResManager.loadKDString((String)"{0}\uff1a\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u672a\u586b\u5199", (String)"SubmitBatchEvalObjTask_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{personNameAndNumber}));
                        flag = true;
                        continue block1;
                    }
                }
            }
        }
        return flag;
    }

    private void setFailList(String taskStatus, String personNameAndNumber, String code, List<String> failList) {
        if (HRStringUtils.equals((String)taskStatus, (String)code)) {
            failList.add(ResManager.loadKDString((String)"{0}\uff1a\u4efb\u52a1{1}", (String)"SubmitBatchEvalObjTask_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{personNameAndNumber, this.getStatusText(taskStatus)}));
        }
    }

    private String getStatusText(String taskStatus) {
        switch (taskStatus) {
            case "20": {
                return ResManager.loadKDString((String)"\u5f85\u8bc4\u4f30", (String)"SubmitBatchEvalObjTask_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            }
            case "30": {
                return ResManager.loadKDString((String)"\u8bc4\u4f30\u4e2d", (String)"SubmitBatchEvalObjTask_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            }
            case "40": {
                return ResManager.loadKDString((String)"\u5df2\u8bc4\u4f30", (String)"SubmitBatchEvalObjTask_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            }
            case "60": {
                return ResManager.loadKDString((String)"\u5df2\u5931\u6548", (String)"SubmitBatchEvalObjTask_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            }
            case "80": {
                return ResManager.loadKDString((String)"\u5df2\u9000\u56de", (String)"SubmitBatchEvalObjTask_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getInNoOperateTaskStatus(Long taskId, DynamicObject[] taskDys) {
        for (DynamicObject dy : taskDys) {
            if (dy == null || taskId.longValue() != dy.getLong("id")) continue;
            return dy.getString("taskstatus");
        }
        return null;
    }
}

