/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import org.apache.commons.collections.MapUtils;

public class SubmitBatchEvalOverallTask
extends AbstractTask {
    private static final String EVALUATION_OBJECTS = "evaluationObjects";
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final ActEvalObjOverallApplicationService APP_SERVICE = ActEvalObjOverallApplicationService.getInstance();
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();

    public void feedbackProgress(int progress, String desc, Map<String, Object> customData) {
        super.feedbackProgress(progress, desc, customData);
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
    }

    private boolean excuteValEval(DynamicObjectCollection evalObjs, int total) {
        HashMap<String, Object> validateDataMap = SubmitBatchEvalOverallTask.startCheckTask(evalObjs);
        this.builerProgressResult(validateDataMap, total, "0");
        this.builerProgressResult(validateDataMap, total, "1");
        String data = JSONObject.toJSONString(validateDataMap);
        return false;
    }

    public static HashMap<String, Object> startCheckTask(DynamicObjectCollection evalObjs) {
        int total;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (ObjectUtils.isEmpty((Object)evalObjs)) {
            return resultMap;
        }
        int successSize = total = evalObjs.size();
        ArrayList failList = Lists.newArrayListWithCapacity((int)10);
        List evalObjsIdList = evalObjs.stream().map(row -> row.getLong("actevalobj.id")).collect(Collectors.toList());
        FlowCommonResultBo flowCommonResultBo = FLOW_RU_PROC_DOMAIN_SERVICE.verifyHandlerBeforeStartProcess(evalObjsIdList);
        if (Objects.isNull(flowCommonResultBo) || HRStringUtils.equals((String)flowCommonResultBo.getCode(), (String)"-1")) {
            int failureNum = SubmitBatchEvalOverallTask.buiderFailResult(evalObjs, failList, flowCommonResultBo);
            successSize = total - failureNum;
        }
        return resultMap;
    }

    private static int buiderFailResult(DynamicObjectCollection evalObjs, List<Map<String, String>> failList, FlowCommonResultBo flowCommonResultBo) {
        int failureNum = 0;
        if (Objects.isNull(flowCommonResultBo)) {
            return failureNum;
        }
        for (DynamicObject evalObj : evalObjs) {
            Map msgMap = flowCommonResultBo.getMsgMap();
            Map corssNodemsgMap = flowCommonResultBo.getCorssNodemsgMap();
            if (MapUtils.isEmpty((Map)msgMap) && MapUtils.isEmpty((Map)corssNodemsgMap)) continue;
            List detail = (List)msgMap.get(evalObj.getLong("id"));
            List crossedDetail = (List)corssNodemsgMap.get(evalObj.getLong("id"));
            if (CollectionUtils.isEmpty((Collection)detail) && CollectionUtils.isEmpty((Collection)crossedDetail)) continue;
            ++failureNum;
            if (CollectionUtils.isNotEmpty((Collection)detail)) {
                SubmitBatchEvalOverallTask.setErrorInfo(failList, evalObj, detail);
            }
            if (!CollectionUtils.isNotEmpty((Collection)crossedDetail)) continue;
            SubmitBatchEvalOverallTask.setErrorInfo(failList, evalObj, crossedDetail);
        }
        return failureNum;
    }

    private static void setErrorInfo(List<Map<String, String>> failList, DynamicObject evalObj, List<Map<Long, String>> detail) {
        for (Map<Long, String> detailInfo : detail) {
            for (Map.Entry<Long, String> entry : detailInfo.entrySet()) {
                HashMap failMessage = Maps.newHashMapWithExpectedSize((int)16);
                failMessage.put("dealername", evalObj.getString("person.name"));
                failMessage.put("dealernum", evalObj.getString("person.number"));
                failMessage.put("preffileno", evalObj.getString("perffile.number"));
                failMessage.put("detail", entry.getValue());
                failList.add(failMessage);
            }
        }
    }

    private void builerProgressResult(HashMap<String, Object> resultMap, int val, String type) {
        if (HRStringUtils.equals((String)type, (String)"0")) {
            resultMap.put("valTotalNum", val);
            resultMap.put("startTotalNum", val);
        } else if (HRStringUtils.equals((String)type, (String)"1")) {
            resultMap.put("valDealNum", this.setDealNum(resultMap.get("valDealNum"), val));
        } else {
            resultMap.put("startDealNum", this.setDealNum(resultMap.get("startDealNum"), val));
        }
    }

    private int setDealNum(Object obj, int val) {
        if (Objects.isNull(obj)) {
            return val;
        }
        if (obj instanceof Integer) {
            return (Integer)obj + val;
        }
        return val;
    }

    private void buiderResult(int total, int successSize, int suspendcount, List<Map<String, String>> failList, HashMap<String, Object> resultMap) {
        HashMap message = Maps.newHashMapWithExpectedSize((int)16);
        message.put("totalcount", total);
        message.put("sucesscount", successSize);
        message.put("failcount", total - successSize);
        message.put("suspendcount", suspendcount);
        message.put("failList", failList);
        resultMap.put("data", message);
    }
}

