/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.task.extpoint.IndicatorBatchSubmitCheckService;
import kd.opmc.epa.business.task.extpoint.SubmitBatchIndicatorResultService;
import kd.opmc.epa.business.task.extpoint.impl.IndicatorBatchSubmitCheckServiceImpl;
import kd.opmc.epa.business.task.extpoint.impl.SubmitBatchIndicatorResultServiceImpl;
import kd.opmc.epa.business.task.extpoint.vo.IndicateSubmitParam;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.vo.NodeIdAndTaskIdMapVO;

public class SubmitBatchIndicatorTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(SubmitBatchIndicatorTask.class);
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List objIds = (List)SerializationUtils.deSerializeFromBase64((String)map.get("evaluationObjectIds").toString());
        Map taskMap = (Map)SerializationUtils.deSerializeFromBase64((String)map.get("taskMap").toString());
        Map indicatorMustInputMap = (Map)SerializationUtils.deSerializeFromBase64((String)map.get("indicatorMustInputMap").toString());
        ArrayList taskList = new ArrayList(taskMap.values());
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("valTotalNum", objIds.size());
        resultMap.put("valDealNum", 0);
        resultMap.put("startTotalNum", objIds.size());
        resultMap.put("startDealNum", 0);
        String desc = ResManager.loadKDString((String)"\u63d0\u4ea4\u8fc7\u7a0b\u4e2d\u8bf7\u52ff\u9000\u51fa\u9875\u9762\uff0c\u6216\u6267\u884c\u4fdd\u5b58\u7b49\u64cd\u4f5c", (String)"SubmitBatchIndicatorTask_0", (String)"opmc-epa-business", (Object[])new Object[0]);
        this.feedbackProgress(10, desc, resultMap);
        if (ObjectUtils.isEmpty((Object)objIds)) {
            return;
        }
        ArrayList<String> msgList = new ArrayList<String>(16);
        ArrayList successObj = new ArrayList(16);
        ArrayList canSubmitTask = new ArrayList(16);
        DynamicObject[] dynamicObjects = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcByEvaObjIds(objIds);
        DynamicObject[] taskDys = FLOW_RU_PROC_APPLICATION_SERVICE.queryNoOperateTasksById(taskList);
        NodeIdAndTaskIdMapVO nodeIdAndTaskIdMapVO = FLOW_RU_PROC_APPLICATION_SERVICE.getNodeIdAndTaskIdMapVO(taskList);
        List nodeIds = nodeIdAndTaskIdMapVO.getNodeId();
        Map taskNodeIdMap = nodeIdAndTaskIdMapVO.getTaskNodeIdMap();
        HashMap<Long, DynamicObject> nodeIdUserDyMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> taskIdUserDyMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, Boolean> isLastNodeMap = new HashMap<Long, Boolean>(16);
        List<Long> lockedNodeList = this.getLockedNode(nodeIds, nodeIdUserDyMap);
        ArrayList<Long> lockedTaskList = new ArrayList<Long>(10);
        for (Long lockedNodeId : lockedNodeList) {
            taskNodeIdMap.forEach((taskId, nodeId) -> {
                if (lockedNodeId.equals(nodeId)) {
                    lockedTaskList.add((Long)taskId);
                    taskIdUserDyMap.put((Long)taskId, (DynamicObject)nodeIdUserDyMap.get(nodeId));
                }
            });
        }
        this.feedbackProgress(20, desc, resultMap);
        Map<Long, String> personNameAndNumberMap = APP_SERVICE.getPersonNameAndNumberByIds(objIds);
        List<Long> flowVid = this.getFlowVid(objIds);
        List<DynamicObject> flowsDys = Arrays.stream(dynamicObjects).filter(dynamicObject -> flowVid.contains(dynamicObject.getLong("flowv.id"))).collect(Collectors.toList());
        Object[] evalDynamicObject = APP_SERVICE.loadDynamicObjectArray(objIds);
        if (HRArrayUtils.isEmpty((Object[])evalDynamicObject)) {
            LOG.error("evalDynamicObject is empty");
            return;
        }
        DynamicObject actObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(evalDynamicObject[0].getLong("activity.id"));
        if (HRObjectUtils.isEmpty((Object)actObj)) {
            LOG.error("actObj is empty");
            return;
        }
        long ruleId = actObj.getLong("assessform.id");
        DynamicObject ruleDy = APP_SERVICE.queryAssessForm(ruleId);
        if (HRObjectUtils.isEmpty((Object)ruleDy)) {
            LOG.error("ruleDy is empty");
            return;
        }
        for (DynamicObject dynamicObject2 : flowsDys) {
            long id = dynamicObject2.getLong("actevalobj");
            boolean isLastNode = this.currentIsLastNode(id);
            isLastNodeMap.put(id, isLastNode);
        }
        IndicateSubmitParam indicateSubmitParam = new IndicateSubmitParam();
        indicateSubmitParam.setEvalObjTaskMap(taskMap);
        indicateSubmitParam.setTaskDynamicObjects(taskDys);
        indicateSubmitParam.setTaskIdUserDynamicObjectMap(taskIdUserDyMap);
        indicateSubmitParam.setIsLastNodeMap(isLastNodeMap);
        indicateSubmitParam.setLockedTaskList(lockedTaskList);
        indicateSubmitParam.setPersonNameAndNumberMap(personNameAndNumberMap);
        indicateSubmitParam.setFlowDynamicObject(flowsDys);
        indicateSubmitParam.setEvalDynamicObject((DynamicObject[])evalDynamicObject);
        indicateSubmitParam.setAssessFormDynamicObject(ruleDy);
        indicateSubmitParam.setIndicatorMustInputMap(indicatorMustInputMap);
        IndicatorBatchSubmitCheckServiceImpl indicatorBatchSubmitCheckService = new IndicatorBatchSubmitCheckServiceImpl();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)indicatorBatchSubmitCheckService, IndicatorBatchSubmitCheckService.class, (String)"kd.opmc.epa.business.task.extpoint.IndicatorBatchSubmitCheckService#batchSubmitCheck", (PluginFilter)null);
        proxy.callReplaceIfPresent(validate -> validate.batchSubmitCheck(msgList, successObj, canSubmitTask, indicateSubmitParam));
        resultMap.put("valDealNum", objIds.size());
        this.feedbackProgress(60, desc, resultMap);
        LinkedList<Long> submitTaskSuccessList = new LinkedList<Long>();
        Map taskIdResultMap = FLOW_RU_PROC_APPLICATION_SERVICE.submitTask(canSubmitTask);
        for (Long id : successObj) {
            Long taskId2 = (Long)taskMap.get(id);
            LOG.info("obj:{} ,submitTask taskId:{}", (Object)id, (Object)taskId2);
            boolean submitTask = (Boolean)taskIdResultMap.get(taskId2);
            if (submitTask) {
                submitTaskSuccessList.add(id);
                continue;
            }
            String msg = ResManager.loadKDString((String)"{0}\uff1a\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\u3002", (String)"SubmitBatchIndicatorTask_1", (String)"opmc-epa-business", (Object[])new Object[]{personNameAndNumberMap.get(id)});
            msgList.add(msg);
        }
        APP_SERVICE.batchUpdateWeightAndIndctrScore(submitTaskSuccessList);
        resultMap.put("startDealNum", objIds.size());
        this.feedbackProgress(80, desc, resultMap);
        resultMap.put("msgList", !ObjectUtils.isEmpty(msgList) && msgList.size() > 1 ? msgList.stream().distinct().collect(Collectors.toList()) : msgList);
        resultMap.put("success", submitTaskSuccessList.size());
        resultMap.put("fail", objIds.size() - submitTaskSuccessList.size());
        resultMap.put("total", objIds.size());
        this.feedbackCustomdata(resultMap);
        resultMap.put("successObj", successObj);
        resultMap.put("evaluationObjectIds", objIds);
        resultMap.put("taskMap", taskMap);
        SubmitBatchIndicatorResultServiceImpl submitBatchIndicatorResultService = new SubmitBatchIndicatorResultServiceImpl();
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)submitBatchIndicatorResultService, SubmitBatchIndicatorResultService.class, (String)"kd.opmc.epa.business.task.extpoint.SubmitBatchIndicatorResultService#submitTaskResult", null);
        pluginProxy.callReplaceIfPresent(p -> p.submitTaskResult(resultMap));
    }

    private List<Long> getLockedNode(List<Long> nodeIds, Map<Long, DynamicObject> nodeIdUserDyMap) {
        ArrayList<Long> lockedNodeList = new ArrayList<Long>(10);
        HashMap<Long, Long> nodeIdUserIdMap = new HashMap<Long, Long>(16);
        ArrayList<Long> lockUserList = new ArrayList<Long>(10);
        for (Long nodeId2 : nodeIds) {
            Long userId2;
            DataMutex dataMutex = DataMutex.create();
            Map lockInfoMap = dataMutex.getLockInfo(nodeId2.toString(), "default_netctrl", "epa_actevalobj");
            if (lockInfoMap == null) continue;
            Long currentUserId = UserServiceHelper.getCurrentUserId();
            if (lockInfoMap.get("userid") == null || (userId2 = Long.valueOf((String)lockInfoMap.get("userid"))) != 0L && currentUserId.equals(userId2)) continue;
            lockedNodeList.add(nodeId2);
            lockUserList.add(userId2);
            nodeIdUserIdMap.put(nodeId2, userId2);
        }
        Map idUserMap = BusinessDataServiceHelper.loadFromCache((Object[])lockUserList.toArray(), (String)"bos_user");
        nodeIdUserIdMap.forEach((nodeId, userId) -> nodeIdUserDyMap.put((Long)nodeId, (DynamicObject)idUserMap.get(userId)));
        return lockedNodeList;
    }

    private boolean isReviewerCanEdit(Long taskId) {
        DynamicObject nodeRole = FLOW_RU_PROC_APPLICATION_SERVICE.queryNodeRoleByTask(taskId);
        if (HRObjectUtils.isEmpty((Object)nodeRole)) {
            LOG.warn("nodeRole is empty!");
            return true;
        }
        return nodeRole.getBoolean("reviewercanedit");
    }

    private boolean currentIsLastNode(Long objId) {
        DynamicObject dynamicObject = APP_SERVICE.queryEvaluatedObj(objId);
        long flowId = dynamicObject.getLong("formulateflow.id");
        ArrayList<Long> flowIds = new ArrayList<Long>(16);
        flowIds.add(flowId);
        ArrayList<Long> objIds = new ArrayList<Long>(16);
        objIds.add(objId);
        DynamicObject[] dynamicObjects = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcByEvaObjIds(objIds);
        List objects = Arrays.stream(dynamicObjects).filter(dyc -> HRObjectUtils.equals((Object)dyc.getLong("flowv.id"), (Object)flowId)).collect(Collectors.toList());
        LOG.info("objects size {}", (Object)objects.size());
        if (!ObjectUtils.isEmpty(objects)) {
            Object[] workFlows = this.WORK_FLOW_APPLICATION_SERVICE.getWorkflowsByVid(flowIds);
            long currentNode = ((DynamicObject)objects.get(0)).getLong("currentnode.id");
            if (currentNode != 0L) {
                FlowRuNodeBo ruNodeInstance = FLOW_RU_PROC_APPLICATION_SERVICE.getRuNodeInstance(Long.valueOf(currentNode));
                DynamicObject flowDefNode = ruNodeInstance.getFlowDefNode();
                String entrySeq = flowDefNode.getString("entryseq");
                LOG.info("entrySeq {}", (Object)entrySeq);
                if (HRArrayUtils.isNotEmpty((Object[])workFlows)) {
                    LOG.info("--------------currentIsLastNode entrySeq:{};nodenum:{};-----------------------", (Object)entrySeq, (Object)workFlows[0].getString("nodenum"));
                    return HRStringUtils.equals((String)entrySeq, (String)workFlows[0].getString("nodenum"));
                }
            }
        }
        LOG.info("currentIsLastNode false");
        return false;
    }

    private List<Long> getFlowVid(List<Long> ids) {
        DynamicObject[] dynamicObjects = APP_SERVICE.queryById("formulateflow", ids);
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("formulateflow.id")).collect(Collectors.toList());
    }
}

