/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.domain.scheme.service.ExecuteSchemeDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssFormatEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.common.utils.CommonResultBo;

public class UnifiedDistTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(UnifiedDistTask.class);
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final ExecuteSchemeDomainService EXECUTE_SCHEME_DOMAIN_SERVICE = ExecuteSchemeDomainService.getInstance();
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final FlowRuProcBatchDomainService FLOW_RU_PROC_BATCH_DOMAIN_SERVICE = FlowRuProcBatchDomainService.getInstance();
    private static final String ISSUCCESS = "issuccess";
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();

    public void feedbackProgress(int progress, String desc, Map<String, Object> customData) {
        super.feedbackProgress(progress, desc, customData);
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) {
        List evalObjectIds = (List)params.get("evalObjectIds");
        Object[] evalObjs = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(evalObjectIds);
        if (ObjectUtils.isEmpty((Object[])evalObjs)) {
            return;
        }
        int allSize = evalObjs.length;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("valTotalNum", allSize);
        resultMap.put("valDealNum", 0);
        resultMap.put("startTotalNum", allSize);
        resultMap.put("startDealNum", 0);
        DynamicObject activityDy = evalObjs[0].getDynamicObject("activity");
        DynamicObject schemeDy = ASSESS_SCHEME_APPLICATION_SERVICE.queryOneById(activityDy.getLong("scheme.id"));
        String settingMode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(activityDy.getLong("perfworkflow.id")), "4");
        DynamicObjectCollection flowEntryColl = EVALUATION_OBJECT_DOMAIN_SERVICE.getPerfWorkFlowEntryColl(activityDy);
        Map<String, Long> defaultWorkFlow = EVALUATION_OBJECT_DOMAIN_SERVICE.getDefaultWorkFlowMap(flowEntryColl);
        Long evaluatorWorkFlowId = defaultWorkFlow.get("2");
        ArrayList<String> failMessage = new ArrayList<String>(16);
        long validateTime = System.currentTimeMillis();
        log.info("UnifiedDistTask validate start: {}", (Object)validateTime);
        Tuple<List<DynamicObject>, String> checkResult = this.validateBeforeStart((DynamicObject[])evalObjs, failMessage, resultMap);
        List evalObjPassList = (List)checkResult.item1;
        String exporturl = (String)checkResult.item2;
        log.info("UnifiedDistTask validate end: {} s", (Object)((System.currentTimeMillis() - validateTime) / 1000L));
        this.updateEvalObjStartStatus(evalObjectIds, "20");
        int successSize = evalObjPassList.size();
        int nodeIndex = (Integer)params.get("nodeindex");
        Date date = new Date();
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<DynamicObject> activityRecordList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(10);
        String desc = ResManager.loadKDString((String)"\u7edf\u4e00\u6d3e\u53d1\u542f\u52a8\u4e2d...", (String)"UnifiedDistTask_0", (String)"opmc-pbs-business", (Object[])new Object[0]);
        long startTime = System.currentTimeMillis();
        log.info("UnifiedDistTask start: {}", (Object)startTime);
        ArrayList<FlowRuProcBo> evalFlowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        for (int i = 0; i < evalObjPassList.size(); ++i) {
            DynamicObject evalObj2 = (DynamicObject)evalObjPassList.get(i);
            FlowRuProcBo flowRuProcBo = this.buildEvaluationProcBo(evalObj2, schemeDy, settingMode, evaluatorWorkFlowId);
            evalFlowRuProcBoList.add(flowRuProcBo);
            this.updateEvalObj(nodeIndex, date, userId, evalObj2);
            activityRecordList.add(this.addActivityRecord(nodeIndex, evalObj2, date, userId));
            double process = (double)(i + 1) / ((double)evalObjs.length * 0.01);
            resultMap.put("startDealNum", i + 1);
            this.feedbackProgress((int)process, desc, resultMap);
            objectList.add(evalObj2);
        }
        if (!ObjectUtils.isEmpty(evalFlowRuProcBoList)) {
            List evalObjectIdList = evalObjPassList.stream().map(object -> object.getLong("evalflowins.id")).collect(Collectors.toList());
            FLOW_RUSECOND_DOMAIN_SERVICE.deleteRunProc(evalObjectIdList);
            CommonResultBo evaResultBo = FLOW_RU_PROC_BATCH_DOMAIN_SERVICE.preCreateProcessInstanceNoTx(evalFlowRuProcBoList, null);
            Map evaResMap = evaResultBo.getResultMap();
            Arrays.stream(evalObjs).forEach(evalObj -> {
                evalObj.set("evalflowins", evaResMap.get(evalObj.getLong("id")));
                evalObj.set("evalflow", (Object)evaluatorWorkFlowId);
            });
        }
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject((DynamicObject[])evalObjs);
        this.updateEvalObjStartStatus(evalObjectIds, "10");
        log.info("UnifiedDistTask end: {} s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveObjCrossIndicator(objectList.toArray(new DynamicObject[0]));
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveImportScoreInd(objectList.toArray(new DynamicObject[0]));
        if (successSize > 0) {
            ACTIVITY_RECORD_ENTITY.save(activityRecordList.toArray(new DynamicObject[0]));
        }
        String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u7edf\u4e00\u6d3e\u53d1\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"UnifiedDistTask_1", (String)"opmc-epa-business", (Object[])new Object[0]), allSize, successSize, allSize - successSize);
        Tuple message = Tuple.create((Object)title, (Object)String.join((CharSequence)"\n", failMessage));
        resultMap.put("data", message);
        resultMap.put(ISSUCCESS, "0");
        if (successSize == 0) {
            resultMap.put("downloadurl", exporturl);
            resultMap.put(ISSUCCESS, "2");
        } else if (successSize != allSize) {
            resultMap.put(ISSUCCESS, "1");
        }
        resultMap.put("opKey", "unifieddist");
        this.feedbackCustomdata(resultMap);
    }

    protected void updateEvalObjStartStatus(List<Long> evalObjectIds, String status) {
        DynamicObject[] startingObj = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjStatusById(evalObjectIds);
        Arrays.stream(startingObj).forEach(evalObj -> evalObj.set("startstatus", (Object)status));
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(startingObj);
    }

    private void updateEvalObj(int nodeIndex, Date date, long userId, DynamicObject evaluationObj) {
        log.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011ASSESSNODE:{},NODEINDEX:{},NODESTATUS:{},evalflowins:{}----------", new Object[]{AssessNodeStatusEnum.TO_BE_FORMULATED.getNodeId(), nodeIndex, AssessNodeStatusEnum.TO_BE_FORMULATED.getStatus()});
        evaluationObj.set("modifier", (Object)userId);
        evaluationObj.set("modifytime", (Object)date);
        evaluationObj.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId());
        evaluationObj.set("nodeindex", (Object)nodeIndex);
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus());
        evaluationObj.set("assessstaus", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
        evaluationObj.set("formulateflow", null);
    }

    private DynamicObject addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
        return activityRecord;
    }

    private FlowRuProcBo buildEvaluationProcBo(DynamicObject evaluationObj, DynamicObject schemeDy, String settingMode, Long evaluatorWorkFlowId) {
        DynamicObject person = evaluationObj.getDynamicObject("person");
        Integer assessYear = evaluationObj.getInt("assessyear");
        String assessPeriod = evaluationObj.getString("assessperiod");
        long actEvalObjId = evaluationObj.getLong("id");
        long perfOrgId = schemeDy.getLong("createorg.id");
        long adminOrgId = schemeDy.getLong("adminorg.id");
        long activityId = evaluationObj.getLong("activity.id");
        long empPosRelId = evaluationObj.getLong("empposrel.id");
        return FlowRuProcBo.builder().flowVid(evaluatorWorkFlowId).person(person).perfOrgId(Long.valueOf(perfOrgId)).adminOrgId(Long.valueOf(adminOrgId)).assessYear(assessYear).assessPeriod(assessPeriod).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).settingMode(settingMode).workflowType("2").build();
    }

    private Tuple<List<DynamicObject>, String> validateBeforeStart(DynamicObject[] evalObjs, List<String> failMessage, HashMap<String, Object> resultMap) {
        DynamicObject activityDy = evalObjs[0].getDynamicObject("activity");
        DynamicObject executeScheme = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        String assFormat = "";
        DynamicObject assessDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessFormByActivityId(activityDy.getLong("id"));
        if (assessDy != null && assessDy.getString("scorecalcway") != null) {
            assFormat = assessDy.getString("scorecalcway");
        }
        DynamicObject scoreSystemDy = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryScoreSystemByActId(activityDy.getLong("id"));
        BigDecimal maxScoreOfSystem = scoreSystemDy.getBigDecimal("maxscore");
        Map<Long, DynamicObject> areaInstanceMap = APP_SERVICE.queryEvaluationGenAreaInstance(Arrays.asList(evalObjs));
        log.info(MessageFormat.format("getNormalAreaSumMap====beforeQueryContent:{0}", System.currentTimeMillis()));
        String target = HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode()) ? "weight" : "indctrscore";
        Map<Long, BigDecimal> sumScoreMap = APP_SERVICE.getNormalAreaSumMap(evalObjs, areaInstanceMap, target);
        Map<Long, BigDecimal> ObjAreaSumWeightMap = APP_SERVICE.getNormalAreaWeightSumMap(evalObjs, areaInstanceMap);
        log.info(MessageFormat.format("getNormalAreaSumMap====afterQueryContent:{0}", System.currentTimeMillis()));
        log.info(MessageFormat.format("getAreaSumNotEqMap====beforeQueryContent:{0}", System.currentTimeMillis()));
        Map<Long, Long> areaSumScoreMap = APP_SERVICE.getAreaSumNotEqMap(evalObjs, areaInstanceMap, assFormat);
        log.info(MessageFormat.format("getAreaSumNotEqMap====afterQueryContent:{0}", System.currentTimeMillis()));
        log.info(MessageFormat.format("====beforeForeach:{0}", System.currentTimeMillis()));
        String desc = ResManager.loadKDString((String)"\u7edf\u4e00\u6d3e\u53d1\u6821\u9a8c\u4e2d...", (String)"UnifiedDistTask_2", (String)"opmc-pbs-business", (Object[])new Object[0]);
        ArrayList<DynamicObject> evalObjPassList = new ArrayList<DynamicObject>(10);
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(10);
        for (int i = 0; i < evalObjs.length; ++i) {
            double process = (double)(i + 1) / ((double)evalObjs.length * 0.01);
            resultMap.put("valDealNum", i + 1);
            this.feedbackProgress((int)process, desc, resultMap);
            DynamicObject evalObj = evalObjs[i];
            String personDesc = evalObj.getString("person.name") + " " + evalObj.getString("person.number") + ": ";
            if (!HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.JOINED.getStatus())) {
                String reason = ResManager.loadKDString((String)"{0}\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5f85\u5236\u5b9a\u201d\uff0c\u4e0d\u80fd\u7edf\u4e00\u6d3e\u53d1\u3002", (String)"UnifiedDistTask_3", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                failMessage.add(reason);
                this.genData2Excel(exportDataList, evalObj, reason);
                continue;
            }
            String startStatus = evalObj.getString("startstatus");
            if (HRStringUtils.equals((String)startStatus, (String)"20")) {
                String reason = ResManager.loadKDString((String)"{0}\u5236\u5b9a\u5bf9\u8c61\u7684\u7edf\u4e00\u6d3e\u53d1\u4efb\u52a1\u5df2\u5b8c\u6210\u3002", (String)"UnifiedDistTask_4", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                failMessage.add(reason);
                this.genData2Excel(exportDataList, evalObj, reason);
                continue;
            }
            long evalObjId = evalObj.getLong("id");
            if (HRStringUtils.equals((String)assFormat, (String)AssFormatEnum.WEIGHTING.getCode())) {
                String reason;
                BigDecimal sumWeightScore = sumScoreMap.get(evalObjId) == null ? new BigDecimal(0) : sumScoreMap.get(evalObjId);
                BigDecimal areaWeightSum = ObjAreaSumWeightMap.get(evalObjId);
                String evaSumLimit = assessDy.getString("evasumlimit");
                if (EvaSumLimit.WEIGHT_RATIO_LIMIT.getValue().equals(evaSumLimit)) {
                    BigDecimal limitMaxRatioBD = new BigDecimal(100);
                    BigDecimal HundredRatioBD = new BigDecimal(100);
                    if (assessDy.getBigDecimal("limitmaxratio") != null) {
                        limitMaxRatioBD = assessDy.getBigDecimal("limitmaxratio");
                    }
                    int numaccuracy = 0;
                    try {
                        numaccuracy = Integer.parseInt(assessDy.getString("numaccuracy"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (areaWeightSum.compareTo(HundredRatioBD) < 0 || areaWeightSum.compareTo(limitMaxRatioBD) > 0) {
                        String reason2 = ResManager.loadKDString((String)"%1$s\u201c\u533a\u57df\u7d2f\u8ba1\u6743\u91cd\u201d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u201c\u8bc4\u4f30\u8868\u5355\u6307\u5b9a\u6743\u91cd\u9650\u5236\u6700\u9ad8\u6bd4\u4f8b\u201d\uff1a%2$s%\uff0c\u5927\u4e8e\u7b49\u4e8e100%\u3002", (String)"UnifiedDistTask_14", (String)"opmc-epa-business", (Object[])new Object[]{personDesc, limitMaxRatioBD.setScale(numaccuracy)});
                        failMessage.add(reason2);
                        this.genData2Excel(exportDataList, evalObj, reason2);
                        continue;
                    }
                } else if (sumWeightScore.compareTo(new BigDecimal(100)) != 0) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700=100%\u3002", (String)"UnifiedDistTask_5", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaSumScoreMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u6743\u91cd\u9700=\u533a\u57df\u6743\u91cd\u3002", (String)"UnifiedDistTask_6", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
            } else {
                String reason;
                BigDecimal sumIndctrScore;
                BigDecimal bigDecimal = sumIndctrScore = sumScoreMap.get(evalObjId) == null ? new BigDecimal(0) : sumScoreMap.get(evalObjId);
                if (sumIndctrScore.compareTo(maxScoreOfSystem) < 0) {
                    reason = ResManager.loadKDString((String)"{0}\u533a\u57df\u5408\u8ba1\u5206\u503c\u9700=\u57fa\u51c6\u6700\u9ad8\u5206\u3002", (String)"UnifiedDistTask_7", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
                if (!ObjectUtils.isEmpty((Object)areaSumScoreMap.get(evalObjId))) {
                    reason = ResManager.loadKDString((String)"{0}\u6307\u6807\u5408\u8ba1\u5206\u503c\u9700=\u533a\u57df\u5206\u503c\u3002", (String)"UnifiedDistTask_8", (String)"opmc-epa-business", (Object[])new Object[]{personDesc});
                    failMessage.add(reason);
                    this.genData2Excel(exportDataList, evalObj, reason);
                    continue;
                }
            }
            evalObjPassList.add(evalObj);
        }
        String exportUrl = null;
        if (exportDataList.size() > 0) {
            String excelName = ResManager.loadKDString((String)"\u7edf\u4e00\u6d3e\u53d1\u6821\u9a8c_\u9519\u8bef\u62a5\u544a_{0}", (String)"UnifiedDistTask_9", (String)"opmc-epa-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss")});
            List<HRExportHeadObject> headDataList = this.getExportHead();
            try {
                exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, exportDataList, headDataList);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        Tuple result = Tuple.create(evalObjPassList, exportUrl);
        return result;
    }

    private void genData2Excel(List<Map<String, Object>> exportDataList, DynamicObject evalObj, String reason) {
        HashMap<String, Object> exportData = new HashMap<String, Object>(16);
        exportData.put("perffilenumber", evalObj.get("perffile.number"));
        exportData.put("name", evalObj.get("person.name"));
        exportData.put("number", evalObj.get("person.number"));
        exportData.put("reason", reason);
        exportDataList.add(exportData);
    }

    private List<HRExportHeadObject> getExportHead() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("perffilenumber", ResManager.loadKDString((String)"\u7ee9\u6548\u6863\u6848\u7f16\u7801", (String)"UnifiedDistTask_10", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"UnifiedDistTask_11", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"UnifiedDistTask_12", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"UnifiedDistTask_13", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        return headDataList;
    }
}

