/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.task.extpoint.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.task.SubmitBatchIndicatorTask;
import kd.opmc.epa.business.task.extpoint.IndicatorBatchSubmitCheckService;
import kd.opmc.epa.business.task.extpoint.vo.IndicateSubmitParam;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuRoleBo;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class IndicatorBatchSubmitCheckServiceImpl
implements IndicatorBatchSubmitCheckService {
    private static final Log LOG = LogFactory.getLog(SubmitBatchIndicatorTask.class);
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();

    private boolean isIndicatorLastNode(Long taskId) {
        return FLOW_RU_PROC_APPLICATION_SERVICE.isFormulateLastTask(taskId);
    }

    private String getInNoOperateTaskStatus(Long taskId, DynamicObject[] taskDys) {
        for (DynamicObject dy : taskDys) {
            if (dy == null || taskId.longValue() != dy.getLong("id")) continue;
            return dy.getString("taskstatus");
        }
        return null;
    }

    private boolean isReviewerCanEdit(Long taskId) {
        DynamicObject nodeRole = FLOW_RU_PROC_APPLICATION_SERVICE.queryNodeRoleByTask(taskId);
        if (HRObjectUtils.isEmpty((Object)nodeRole)) {
            LOG.warn("nodeRole is empty!");
            return true;
        }
        return nodeRole.getBoolean("reviewercanedit");
    }

    @Override
    public List<String> batchSubmitCheck(List<String> msgList, List<Long> successObj, List<Long> canSubmitTask, IndicateSubmitParam indicateSubmitParam) {
        Map<Long, Long> taskMap = indicateSubmitParam.getEvalObjTaskMap();
        DynamicObject[] taskDys = indicateSubmitParam.getTaskDynamicObjects();
        Map<Long, DynamicObject> taskIdUserDyMap = indicateSubmitParam.getTaskIdUserDynamicObjectMap();
        List<Long> lockedTaskList = indicateSubmitParam.getLockedTaskList();
        Map<Long, String> personNameAndNumberMap = indicateSubmitParam.getPersonNameAndNumberMap();
        DynamicObject[] evalDynamicObject = indicateSubmitParam.getEvalDynamicObject();
        List<DynamicObject> objects = indicateSubmitParam.getFlowDynamicObject();
        DynamicObject ruleDy = indicateSubmitParam.getAssessFormDynamicObject();
        for (DynamicObject dynamicObject : objects) {
            FlowRuNodeBo ruNodeInstance;
            DynamicObject flowDefNode;
            long id = dynamicObject.getLong("actevalobj");
            long currentNode = dynamicObject.getLong("currentnode.id");
            String taskStatus = this.getInNoOperateTaskStatus(taskMap.get(id), taskDys);
            if (taskStatus != null) {
                String noInOperateTaskMsg = ResManager.loadKDString((String)"{0}\uff1a{1}\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"IndicatorBatchSubmitCheckServiceImpl_0", (String)"opmc-epa-business", (Object[])new Object[]{personNameAndNumberMap.get(id), FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatus).getText()});
                msgList.add(noInOperateTaskMsg);
                continue;
            }
            if (taskMap.get(id) != null && lockedTaskList.contains(taskMap.get(id))) {
                String lockedMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0}\uff1a\u8be5\u4eba\u5458\u7684\u4efb\u52a1\u6b63\u5728\u88ab\u5236\u5b9a\u4eba\u3010{1} {2} \u3011\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"IndicatorBatchSubmitCheckServiceImpl_1", (String)"opmc-epa-business", (Object[])new Object[]{personNameAndNumberMap.get(id), taskIdUserDyMap.get(taskMap.get(id)).getString("name"), taskIdUserDyMap.get(taskMap.get(id)).getString("number")}));
                msgList.add(lockedMsg);
                continue;
            }
            Long typeId = 0L;
            boolean isCanEdit = false;
            if (currentNode != 0L && HRObjectUtils.equals((Object)(typeId = Long.valueOf((flowDefNode = (ruNodeInstance = FLOW_RU_PROC_APPLICATION_SERVICE.getRuNodeInstance(Long.valueOf(currentNode))).getFlowDefNode()).getLong("nodetype.id"))), (Object)NodeTypeConstants.INDICATOR_AUDIT) && ruNodeInstance.getFlowRuRoleBoList() != null && ruNodeInstance.getFlowRuRoleBoList().size() > 0) {
                FlowRuRoleBo nodeRole = (FlowRuRoleBo)ruNodeInstance.getFlowRuRoleBoList().get(0);
                DynamicObject flowDefRole = nodeRole.getFlowDefRole();
                isCanEdit = flowDefRole.getBoolean("reviewercanedit");
            }
            if (APP_SERVICE.checkMustInput(id, evalDynamicObject, indicateSubmitParam.getIndicatorMustInputMap(), currentNode, typeId, isCanEdit)) {
                DynamicObject dyn = Arrays.stream(evalDynamicObject).filter(dyc -> HRObjectUtils.equals((Object)dyc.getLong("id"), (Object)id)).findFirst().orElse(null);
                String errorMsg = ResManager.loadKDString((String)"{0} {1}\uff1a\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u672a\u586b\u5199", (String)"IndicatorBatchSubmitCheckServiceImpl_2", (String)"opmc-epa-business", (Object[])new Object[]{dyn == null ? "" : dyn.getString("person.name"), dyn == null ? "" : dyn.getString("person.number")});
                msgList.add(errorMsg);
                continue;
            }
            if (currentNode == 0L) continue;
            LOG.info("obj:{} , typeId:{}", (Object)id, (Object)typeId);
            if (this.isIndicatorLastNode(taskMap.get(id)) || HRObjectUtils.equals((Object)typeId, (Object)NodeTypeConstants.INDICATOR_AUDIT) && this.isReviewerCanEdit(taskMap.get(id))) {
                LOG.info("checkSubmitIndicator obj:{} ", (Object)id);
                List<String> msg = APP_SERVICE.checkSubmitIndicator(id, evalDynamicObject, ruleDy);
                LOG.info("checkSubmitIndicator  obj:{} result:{} ", (Object)id, msg);
                if (ObjectUtils.isEmpty(msg)) {
                    successObj.add(id);
                    canSubmitTask.add(taskMap.get(id));
                    continue;
                }
                msgList.addAll(msg);
                continue;
            }
            LOG.info("checkAreaEqual {}", (Object)id);
            List<String> areaMsgList = APP_SERVICE.checkAreaEqual(id, evalDynamicObject, ruleDy);
            LOG.info("checkAreaEqual result {} ", areaMsgList);
            LOG.info("checkSurpassSubmitIndicator obj:{} ", (Object)id);
            List<String> msg = APP_SERVICE.checkSurpassSubmitIndicator(id, evalDynamicObject, ruleDy);
            LOG.info("checkSurpassSubmitIndicator  obj:{} result:{} ", (Object)id, msg);
            if (ObjectUtils.isEmpty(msg) && ObjectUtils.isEmpty(areaMsgList)) {
                successObj.add(id);
                canSubmitTask.add(taskMap.get(id));
                continue;
            }
            if (!ObjectUtils.isEmpty(msg)) {
                msgList.addAll(msg);
            }
            if (ObjectUtils.isEmpty(areaMsgList)) continue;
            msgList.addAll(areaMsgList);
        }
        return msgList;
    }
}

