/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.utils;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessGroupApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.timetag.enums.TimeStampEnums;
import kd.opmc.epa.common.utils.activity.EvalObjectUtils;

public class ActivityManageUtils {
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessGroupApplicationService ASSESS_GROUP_APPLICATION_SERVICE = AssessGroupApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();

    public static void generatorFilter(DynamicObject activity, long schemeId, List<QFilter> qFilters) {
        QFilter schemeFilter = new QFilter("scheme", "=", (Object)schemeId);
        qFilters.add(schemeFilter);
        Set<Long> groupIds = ActivityManageUtils.getScopeGroupsByAct(activity);
        QFilter groupFilter = new QFilter("assgroup", "in", groupIds);
        qFilters.add(groupFilter);
        String period = activity.getString("period");
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryCycleInfoById(schemeId);
        if (scheme.getBoolean("isperiodassess")) {
            period = ActivityManageUtils.getPeriod(period, scheme);
        }
        Set<Long> objIds = ActivityManageUtils.getJoinedObjIdsByAct(activity);
        qFilters.add(new QFilter("perfile", "not in", objIds));
        qFilters.add(new QFilter("perfile.archivesstatus", "=", (Object)"1"));
        DynamicObject[] datas = ASSESS_OBJECT_APPLICATION_SERVICE.queryByFilters(qFilters.toArray(new QFilter[0]));
        HashSet leftTag = new HashSet(16);
        HashSet rightTag = new HashSet(16);
        String startTagYear = scheme.getDynamicObject("starttimetag").getString("name");
        String tag = startTagYear.substring(0, 1);
        if ("M".equals(tag)) {
            EvalObjectUtils.getSchemeMonthPeriodStr((DynamicObject)scheme, (String)period, leftTag, rightTag);
        }
        String topTimeTag = ActivityManageUtils.getTimeTag(scheme, period);
        List filterResults = Arrays.stream(datas).filter(data -> {
            String startCycle = data.getString("startcycle");
            String endCycle = data.getString("endcycle");
            boolean notContainsMonthPeriod = false;
            boolean notContainsOtherPeriod = false;
            if (StringUtils.isEmpty((CharSequence)startCycle)) {
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)endCycle)) {
                notContainsMonthPeriod = tag.charAt(0) == 'M' && !leftTag.contains(startCycle);
                notContainsOtherPeriod = tag.charAt(0) != 'M' && topTimeTag.compareTo(startCycle) < 0;
            } else {
                notContainsMonthPeriod = rightTag.isEmpty() ? tag.charAt(0) == 'M' && !leftTag.contains(startCycle) : tag.charAt(0) == 'M' && (!leftTag.contains(startCycle) || !rightTag.contains(endCycle));
                notContainsOtherPeriod = tag.charAt(0) != 'M' && (topTimeTag.compareTo(startCycle) < 0 || topTimeTag.compareTo(endCycle) > 0);
            }
            return !notContainsMonthPeriod && !notContainsOtherPeriod;
        }).collect(Collectors.toList());
        qFilters.add(new QFilter("id", "in", filterResults.stream().map(data -> data.getLong("id")).collect(Collectors.toList())));
    }

    public static Set<Long> getJoinedObjIdsByAct(DynamicObject activity) {
        DynamicObject[] evaluationObject = EVALUATION_OBJECT_APPLICATION_SERVICE.queryEvaluationObjectByActId((Long)activity.getPkValue());
        return Arrays.stream(evaluationObject).map(obj -> obj.getLong("perffile.id")).collect(Collectors.toSet());
    }

    private static Set<Long> getScopeGroupsByAct(DynamicObject activity) {
        DynamicObject executeScheme = activity.getDynamicObject("executescheme");
        Long assessScopeId = executeScheme.getDynamicObject("assessscope").getLong("id");
        DynamicObject[] assessGroups = ASSESS_GROUP_APPLICATION_SERVICE.queryListByScopeId(true, assessScopeId);
        return Arrays.stream(assessGroups).map(group -> group.getLong("id")).collect(Collectors.toSet());
    }

    private static String getPeriod(String period, DynamicObject scheme) {
        Long cycleTypeId = scheme.getLong("cycletype.id");
        if (cycleTypeId.equals(TimeStampEnums.M1.getTypeId())) {
            return period;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(period, 0, 4);
        if (cycleTypeId.equals(TimeStampEnums.Y.getTypeId())) {
            stringBuilder.append(TimeStampEnums.Y.getTag());
        } else if (cycleTypeId.equals(TimeStampEnums.H1.getTypeId())) {
            stringBuilder.append(ActivityManageUtils.calculateHalfTag(period));
        } else if (cycleTypeId.equals(TimeStampEnums.Q1.getTypeId())) {
            stringBuilder.append(ActivityManageUtils.calculateQuarterTag(period));
        }
        return stringBuilder.toString();
    }

    private static String calculateHalfTag(String period) {
        int value;
        if (period.charAt(4) == 'Q') {
            value = ActivityManageUtils.getValueFromPeriod(period);
            if (value > 2 && value <= 4) {
                return TimeStampEnums.H2.getTag();
            }
            if (value > 0 && value <= 2) {
                return TimeStampEnums.H1.getTag();
            }
        }
        if (period.charAt(4) == 'M') {
            value = ActivityManageUtils.getValueFromPeriod(period);
            if (value > 6 && value <= 12) {
                return TimeStampEnums.H2.getTag();
            }
            if (value > 0 && value <= 6) {
                return TimeStampEnums.H1.getTag();
            }
        }
        return period.substring(4);
    }

    private static String calculateQuarterTag(String period) {
        if (period.charAt(4) == 'M') {
            int value = ActivityManageUtils.getValueFromPeriod(period);
            if (value > 9 && value <= 12) {
                return TimeStampEnums.Q4.getTag();
            }
            if (value > 6 && value <= 9) {
                return "Q3";
            }
            if (value > 3 && value <= 6) {
                return "Q2";
            }
            if (value > 0 && value <= 3) {
                return TimeStampEnums.Q1.getTag();
            }
        }
        return period.substring(4);
    }

    private static int getValueFromPeriod(String period) {
        String lastTwoDigits = period.substring(5);
        return Integer.parseInt(lastTwoDigits);
    }

    public static void valid(List<Long> sucessList, List<Long> failedList, StringBuilder message, Object[] objIds, Long activityId) {
        DynamicObject[] assessObj = ASSESS_OBJECT_APPLICATION_SERVICE.loadDynamicObjectArrayByIds(objIds);
        List<Long> perffileIds = Arrays.stream(assessObj).map(obj -> obj.getDynamicObject("perfile").getLong("id")).collect(Collectors.toList());
        DynamicObject curActivity = ActivityManageUtils.getCurActivity(activityId);
        DynamicObjectCollection assGroupsEntry = curActivity.getDynamicObjectCollection("assgroupentry");
        Set actGroupIdSet = assGroupsEntry.stream().map(group -> group.getDynamicObject("assgroup").getLong("id")).collect(Collectors.toSet());
        Set<Long> scopeGroupsIds = ActivityManageUtils.getScopeGroupsByAct(curActivity);
        Set<Long> joinedObjIds = ActivityManageUtils.getJoinedObjIdsByAct(curActivity);
        Map<Long, DynamicObject> existedEvaMap = EVALUATION_OBJECT_APPLICATION_SERVICE.queryExistEvalObjectByPerfIds(curActivity.getString("period"), perffileIds);
        String period = curActivity.getString("period");
        long schemeId = curActivity.getDynamicObject("scheme").getLong("id");
        HashSet leftTag = new HashSet(16);
        HashSet rightTag = new HashSet(16);
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryCycleInfoById(schemeId);
        String startTagYear = scheme.getDynamicObject("starttimetag").getString("name");
        String tag = startTagYear.substring(0, 1);
        if ("M".equals(tag)) {
            EvalObjectUtils.getSchemeMonthPeriodStr((DynamicObject)scheme, (String)period, leftTag, rightTag);
        }
        String topTimeTag = ActivityManageUtils.getTimeTag(scheme, period);
        Date actStart = curActivity.getDate("periodstartdate");
        Date actEnd = curActivity.getDate("periodenddate");
        for (DynamicObject dataEntity : assessObj) {
            long groupId = dataEntity.getDynamicObject("assgroup").getLong("id");
            long perffileId = dataEntity.getLong("perfile.id");
            Long id = dataEntity.getLong("id");
            if (!actGroupIdSet.contains(groupId)) {
                ActivityManageUtils.recordGroupValidateMessage(dataEntity, message);
                failedList.add(id);
                continue;
            }
            Date perfStartDate = dataEntity.getDate("perfile.startdate");
            Date perfEndDate = dataEntity.getDate("perfile.enddate");
            if (perfStartDate != null && perfEndDate != null && (perfEndDate.compareTo(actStart) < 0 || perfStartDate.compareTo(actEnd) > 0)) {
                ActivityManageUtils.recordPerfTimeValidateMessage(dataEntity, message);
                failedList.add(id);
                continue;
            }
            String startCycle = dataEntity.getString("startcycle");
            String endCycle = dataEntity.getString("endcycle");
            boolean notContainsMonthPeriod = false;
            boolean notContainsOtherPeriod = false;
            if (StringUtils.isEmpty((CharSequence)startCycle)) {
                ActivityManageUtils.recordNotExistValidateMessage(dataEntity, message);
                failedList.add(id);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)endCycle)) {
                notContainsMonthPeriod = tag.charAt(0) == 'M' && !leftTag.contains(startCycle);
                notContainsOtherPeriod = tag.charAt(0) != 'M' && topTimeTag.compareTo(startCycle) < 0;
            } else {
                notContainsMonthPeriod = rightTag.isEmpty() ? tag.charAt(0) == 'M' && !leftTag.contains(startCycle) : tag.charAt(0) == 'M' && (!leftTag.contains(startCycle) || !rightTag.contains(endCycle));
                notContainsOtherPeriod = tag.charAt(0) != 'M' && (topTimeTag.compareTo(startCycle) < 0 || topTimeTag.compareTo(endCycle) > 0);
            }
            boolean notContainsScopeGroup = !scopeGroupsIds.contains(groupId);
            boolean joinedObj = joinedObjIds.contains(perffileId);
            if (notContainsMonthPeriod || notContainsOtherPeriod || notContainsScopeGroup || joinedObj) {
                ActivityManageUtils.recordNotExistValidateMessage(dataEntity, message);
                failedList.add(id);
                continue;
            }
            Set<Long> joinobjIds = ActivityManageUtils.getJoinedObjIdsByAct(curActivity);
            if (joinobjIds.contains(perffileId)) {
                ActivityManageUtils.recordPartInValidateMessage(dataEntity, message, existedEvaMap.get(perffileId));
                failedList.add(id);
                continue;
            }
            if (HRStringUtils.equals((String)dataEntity.getString("perfile.archivesstatus"), (String)"2")) {
                ActivityManageUtils.recordPerfileStopMessage(dataEntity, message);
                failedList.add(id);
                continue;
            }
            sucessList.add(id);
        }
    }

    private static String getTimeTag(DynamicObject scheme, String period) {
        String timeTag = null;
        String startTagYear = scheme.getDynamicObject("starttimetag").getString("name");
        String tag = startTagYear.substring(0, 1);
        int periodYear = Integer.parseInt(period.substring(0, 4));
        String periodTag = period.substring(4, 5);
        int periodNumber = 0;
        switch (tag) {
            case "Y": {
                timeTag = periodYear + tag;
                break;
            }
            case "H": {
                periodNumber = Integer.parseInt(period.substring(5));
                if ("H".equals(periodTag)) {
                    timeTag = periodYear + tag + periodNumber;
                    break;
                }
                if ("Q".equals(periodTag)) {
                    timeTag = periodYear + tag + (periodNumber / 3 + 1);
                    break;
                }
                timeTag = periodYear + tag + (periodNumber / 7 + 1);
                break;
            }
            case "Q": {
                periodNumber = Integer.parseInt(period.substring(5));
                if ("Q".equals(periodTag)) {
                    timeTag = periodYear + tag + periodNumber;
                    break;
                }
                timeTag = periodYear + tag + ((periodNumber - 1) / 3 + 1);
                break;
            }
        }
        return timeTag;
    }

    private static void recordPerfTimeValidateMessage(DynamicObject object, StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            message.append("\n");
        }
        message.append(ResManager.loadKDString((String)"{0}-{1}\uff1a\u6863\u6848\u6709\u6548\u671f\u95f4\u4e0d\u5728\u8003\u6838\u5468\u671f\u8d77\u6b62\u65e5\u671f\u5185", (String)"ActivityManageUtils_0", (String)"opmc-epa-business", (Object[])new Object[]{object.getDynamicObject("person").getString("name"), object.getDynamicObject("person").getString("number")}));
    }

    private static void recordGroupValidateMessage(DynamicObject object, StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            message.append("\n");
        }
        message.append(ResManager.loadKDString((String)"{0}-{1}\uff1a\u8003\u6838\u6d3b\u52a8\u4e2d\u4e0d\u5b58\u5728\u8003\u6838\u7ec4-{2}", (String)"ActivityManageUtils_1", (String)"opmc-epa-business", (Object[])new Object[]{object.getDynamicObject("person").getString("name"), object.getDynamicObject("person").getString("number"), object.getDynamicObject("assgroup").getString("name")}));
    }

    private static void recordNotExistValidateMessage(DynamicObject object, StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            message.append("\n");
        }
        message.append(ResManager.loadKDString((String)"{0}-{1}\uff1a\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u52a0\u5165\u8003\u6838\u6d3b\u52a8", (String)"ActivityManageUtils_2", (String)"opmc-epa-business", (Object[])new Object[]{object.getDynamicObject("person").getString("name"), object.getDynamicObject("person").getString("number")}));
    }

    private static void recordPartInValidateMessage(DynamicObject object, StringBuilder message, DynamicObject curActivity) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            message.append("\n");
        }
        message.append(ResManager.loadKDString((String)"{0}-{1}\uff1a\u5df2\u5728{2}\u4e2d\u53c2\u4e0e\u8003\u6838", (String)"ActivityManageUtils_3", (String)"opmc-epa-business", (Object[])new Object[]{object.getDynamicObject("person").getString("name"), object.getDynamicObject("person").getString("number"), curActivity.getString("name")}));
    }

    private static void recordPerfileStopMessage(DynamicObject object, StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            message.append("\n");
        }
        message.append(ResManager.loadKDString((String)"{0}-{1}\uff1a\u6863\u6848\u72b6\u6001\u4e3a\u201c\u505c\u6b62\u8003\u6838\u201d", (String)"ActivityManageUtils_4", (String)"opmc-epa-business", (Object[])new Object[]{object.getDynamicObject("person").getString("name"), object.getDynamicObject("person").getString("number")}));
    }

    private static DynamicObject getCurActivity(Long activityId) {
        return ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(activityId);
    }
}

