/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.domain.activity.service.AssessActivityDomainService;
import kd.opmc.epa.business.domain.perfworkflow.entutyservice.PerfWorkFlowEntityService;

public class ActivityPermissionUtils {
    private static Log LOGGER = LogFactory.getLog(ActivityPermissionUtils.class);
    private static final PerfWorkFlowEntityService PERF_WORK_FLOW_ENTITY_SERVICE = PerfWorkFlowEntityService.getInstance();
    private static final AssessActivityDomainService ASSESS_ACTIVITY_DOMAIN_SERVICE = AssessActivityDomainService.getInstance();
    private static final HRBaseServiceHelper dynamixcPermitService = new HRBaseServiceHelper("epa_dynamicpermission");
    private static final long OLE_ID = 1539882034862772224L;
    private static String EPA_ASSESSFORM = "epa_assessform";
    private static String SOURCE = "sourceEntryId";
    private static String ACTIVITY = "activity";

    public static void setActivityAndCopyFlow(DynamicObject[] dataEntities) {
        List<Long> ids = Arrays.stream(dataEntities).map(data -> data.getLong("executescheme.perfworkflow.id")).collect(Collectors.toList());
        DynamicObject[] perfWorkFlowDyns = PERF_WORK_FLOW_ENTITY_SERVICE.getPerfWorkflows(ids);
        Map<Long, DynamicObject> perfWorkMap = Arrays.stream(perfWorkFlowDyns).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        long[] activityIDs = ORM.create().genLongIds("epa_activity", dataEntities.length);
        int i = 0;
        for (DynamicObject activity : dataEntities) {
            if (activity.getLong("id") == 0L) {
                activity.set("id", (Object)activityIDs[i]);
                ++i;
            }
            Long workFlowId = activity.getLong("executescheme.perfworkflow.id");
            Long assessFormId = activity.getLong("executescheme.assessform.id");
            QFilter filter = null;
            filter = assessFormId == null || assessFormId == 0L ? new QFilter("assessform", "=", (Object)assessFormId).and(new QFilter("perfworkflow", "in", (Object)workFlowId)).and(new QFilter("excutescheme", "=", (Object)activity.getLong("executescheme.id"))) : new QFilter("perfworkflow", "in", (Object)workFlowId).and(new QFilter("excutescheme", "=", (Object)activity.getLong("executescheme.id")));
            DynamicObject[] dynPermitObjs = dynamixcPermitService.query("id", new QFilter[]{filter}, "createtime desc");
            Long processpermsetting = activity.getLong("processpermsetting.id");
            Long activityId = activity.getLong("id");
            if (activity.get("dynamicpermission") != null) continue;
            DynamicObject copyWorkFlowId = ASSESS_ACTIVITY_DOMAIN_SERVICE.copyWorkFlow(perfWorkMap.get(workFlowId), activityId);
            DynamicObject copyAssessForm = ASSESS_ACTIVITY_DOMAIN_SERVICE.copyAssessForm(assessFormId, activityId);
            Long copydynamicpermissionId = ASSESS_ACTIVITY_DOMAIN_SERVICE.copyDynamicpermission(dynPermitObjs[0].getLong("id"), copyWorkFlowId, copyAssessForm, assessFormId);
            activity.set("perfworkflow", (Object)copyWorkFlowId.getLong("id"));
            activity.set("assessform", copyAssessForm == null ? copyAssessForm : Long.valueOf(copyAssessForm.getLong("id")));
            activity.set("dynamicpermission", (Object)copydynamicpermissionId);
        }
    }

    public static void setActivityAndCopyFlowForUpdate(DynamicObject[] dataEntities) {
        List<Long> ids = Arrays.stream(dataEntities).map(data -> data.getLong("executescheme.perfworkflow.id")).collect(Collectors.toList());
        DynamicObject[] perfWorkFlowDyns = PERF_WORK_FLOW_ENTITY_SERVICE.getPerfWorkflows(ids);
        Map<Long, DynamicObject> perfWorkMap = Arrays.stream(perfWorkFlowDyns).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (DynamicObject activity : dataEntities) {
            Long workFlowId = activity.getLong("executescheme.perfworkflow.id");
            Long assessFormId = activity.getLong("executescheme.assessform.id");
            Long processpermsetting = activity.getLong("processpermsetting.id");
            Long activityId = activity.getLong("id");
            if (activity.get("dynamicpermission") != null) continue;
            DynamicObject copyWorkFlowId = ASSESS_ACTIVITY_DOMAIN_SERVICE.copyWorkFlow(perfWorkMap.get(workFlowId), activityId);
            DynamicObject copyAssessForm = ASSESS_ACTIVITY_DOMAIN_SERVICE.copyAssessForm(assessFormId, activityId);
            Long copyDynamicpermission = ASSESS_ACTIVITY_DOMAIN_SERVICE.copyDynamicpermission(processpermsetting, copyWorkFlowId, copyAssessForm, assessFormId);
            activity.set("perfworkflow", (Object)copyWorkFlowId.getLong("id"));
            activity.set("assessform", (Object)copyAssessForm.getLong("id"));
            activity.set("dynamicpermission", (Object)copyDynamicpermission);
        }
    }
}

