/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.business.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.outservice.IEvalLevelAndScoreService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcBatchDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.common.utils.CommonResultBo;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;
import org.apache.commons.collections.MapUtils;

public class EvalObjUtils {
    private static final Log log = LogFactory.getLog(EvalObjUtils.class);
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final FlowDefProcDomainService FLOW_DEF_PROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RUSECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final WorkFlowEntityService WORK_FLOW_ENTITY_SERVICE = WorkFlowEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final IEvalLevelAndScoreService I_EVAL_LEVEL_AND_SCORE_SERVICE = IEvalLevelAndScoreService.getInstance();

    private EvalObjUtils() {
    }

    public static FlowRuProcBo buildEvaluationProcBo(DynamicObject evaluationObj, Long flowVid, String workflowType) {
        DynamicObject person = evaluationObj.getDynamicObject("person");
        Integer assessYear = evaluationObj.getInt("assessyear");
        String assessPeriod = evaluationObj.getString("assessperiod");
        long actEvalObjId = evaluationObj.getLong("id");
        DynamicObject activityDy = evaluationObj.getDynamicObject("activity");
        DynamicObject schemeDy = ASSESS_SCHEME_APPLICATION_SERVICE.queryOneById(activityDy.getLong("scheme.id"));
        long perfOrgId = schemeDy.getLong("createorg.id");
        long adminOrgId = schemeDy.getLong("adminorg.id");
        long activityId = evaluationObj.getLong("activity.id");
        long empPosRelId = evaluationObj.getLong("empposrel.id");
        DynamicObject executeScheme = EXECUTE_SCHEME_ENTITY_SERVICE.queryOne(activityDy.getLong("executescheme.id"));
        String settingmode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(executeScheme.getLong("perfworkflow.id")), "1".equals(workflowType) ? "1" : "4");
        FlowRuProcBo flowRuProcBo = FlowRuProcBo.builder().flowVid(flowVid).person(person).perfOrgId(Long.valueOf(perfOrgId)).adminOrgId(Long.valueOf(adminOrgId)).assessYear(assessYear).assessPeriod(assessPeriod).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).settingMode(settingmode).workflowType(workflowType).build();
        return flowRuProcBo;
    }

    public static FlowRuProcBo buildIntProcBo(DynamicObject evaluationObj, Long flowVid, String workflowType, DynamicObject interActConf) {
        DynamicObject person = evaluationObj.getDynamicObject("person");
        long actEvalObjId = evaluationObj.getLong("id");
        long perfOrgId = interActConf.getLong("perforg.id");
        long adminOrgId = interActConf.getLong("adminorg.id");
        long activityId = interActConf.getLong("id");
        long empPosRelId = evaluationObj.getLong("empposrel.id");
        long perfWorkFlowId = interActConf.getLong("perfworkflow.id");
        String settingmode = FLOW_DEF_PROC_DOMAIN_SERVICE.getHandlerSettingMode(Long.valueOf(perfWorkFlowId), "7");
        FlowRuProcBo flowRuProcBo = FlowRuProcBo.builder().flowVid(flowVid).person(person).perfOrgId(Long.valueOf(perfOrgId)).adminOrgId(Long.valueOf(adminOrgId)).actEvalObjId(Long.valueOf(actEvalObjId)).activityId(Long.valueOf(activityId)).empPosRelId(Long.valueOf(empPosRelId)).settingMode(settingmode).workflowType("3").build();
        return flowRuProcBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Long> preCreateProcessInstance(DynamicObject[] evalObjs, Long flowVid, String workflowType) {
        HashMap<Long, Long> objRefProInstMap = new HashMap<Long, Long>(16);
        if (Objects.isNull(evalObjs) || evalObjs.length <= 0) {
            return objRefProInstMap;
        }
        try (TXHandle txhandle = TX.required();){
            Map<Long, Long> map = EvalObjUtils.preCreateProcessInstanceNoTx(evalObjs, flowVid, workflowType, objRefProInstMap);
            return map;
        }
        return objRefProInstMap;
    }

    public static Map<Long, Long> preCreateProcessInstanceNoTx(DynamicObject[] evalObjs, Long flowVid, String workflowType, Map<Long, Long> objRefProInstMap) {
        List evalObjectIdList = Arrays.stream(evalObjs).map(object -> "1".equals(workflowType) ? object.getLong("formulateflowins_id") : object.getLong("evalflowins_id")).collect(Collectors.toList());
        boolean deleteFlag = FLOW_RUSECOND_DOMAIN_SERVICE.deleteRunProc(evalObjectIdList);
        if (!deleteFlag) {
            return objRefProInstMap;
        }
        ArrayList<FlowRuProcBo> flowRuProcBoList = new ArrayList<FlowRuProcBo>(10);
        for (DynamicObject evalObj : evalObjs) {
            FlowRuProcBo flowRuProcBo = EvalObjUtils.buildEvaluationProcBo(evalObj, flowVid, workflowType);
            if (flowRuProcBo.getActEvalObjId() == 0L || flowRuProcBo.getActivityId() == 0L || flowRuProcBo.getAdminOrgId() == 0L || flowRuProcBo.getFlowVid() == null || flowRuProcBo.getFlowVid() == 0L || flowRuProcBo.getPerfOrgId() == 0L || HRStringUtils.isEmpty((String)flowRuProcBo.getAssessPeriod()) || flowRuProcBo.getAssessYear() == 0 || ObjectUtils.isEmpty((Object)flowRuProcBo.getPerson())) {
                log.error("\u9884\u5b9e\u4f8b\u5316\u6d41\u7a0b\u65f6\u6570\u636e\u6709\u8bef\uff0c\u65e0\u6cd5\u542f\u52a8\u6d41\u7a0b\uff0cFlowRuProcBo:[{}]", (Object)flowRuProcBo.toString());
                continue;
            }
            flowRuProcBoList.add(flowRuProcBo);
        }
        CommonResultBo resultBo = FlowRuProcBatchDomainService.getInstance().preCreateProcessInstanceNoTx(flowRuProcBoList, null);
        Map actevaobjProcMap = resultBo.getResultMap();
        for (DynamicObject evalObj : evalObjs) {
            Long actEvaObjId = evalObj.getLong("id");
            if (null == actevaobjProcMap || null == actevaobjProcMap.get(actEvaObjId)) continue;
            Long ruProcId = (Long)actevaobjProcMap.get(actEvaObjId);
            objRefProInstMap.put(actEvaObjId, ruProcId);
        }
        return objRefProInstMap;
    }

    private static void updateEvalObjFlowWithAssess(Long flowVid, DynamicObject[] evalObjs) {
    }

    public static Map<Long, List<DynamicObject>> saveRecord(DynamicObjectCollection dyColl, Long activityId, Date date, long userId) {
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        List<Long> evalObjectIdList = dyColl.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> recordMap = ACTIVITY_RECORD_ENTITY.queryRecordByActObjsAndActId(evalObjectIdList, activityId);
        DynamicObjectCollection recordDyColl = EvalObjUtils.dealRecordMap2Coll(recordMap, date, userId);
        ACTIVITY_RECORD_ENTITY.save(recordDyColl);
        return recordMap;
    }

    private static DynamicObjectCollection dealRecordMap2Coll(Map<Long, List<DynamicObject>> recordMap, Date date, long userId) {
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        if (Objects.isNull(recordMap)) {
            return dyColl;
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : recordMap.entrySet()) {
            DynamicObject dy;
            List<DynamicObject> dyList = entry.getValue();
            if (CollectionUtils.isEmpty(dyList) || Objects.isNull(dy = dyList.get(0))) continue;
            dy.set("modifier", (Object)userId);
            dy.set("modifytime", (Object)date);
            dy.set("endtime", (Object)date);
            dy.set("nodestatus", (Object)AssessNodeStatusEnum.EVALUATED.getStatus());
            dyColl.add((Object)dy);
        }
        return dyColl;
    }

    public static DynamicObject addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.EVALUATING.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.EVALUATED.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        Long activityId = evaluationObj.getLong("activity.id");
        if (activityId == null || activityId == 0L) {
            activityId = evaluationObj.getLong("activity");
        }
        activityRecord.set("activity", (Object)activityId);
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
        return activityRecord;
    }

    public static void saveRecordEntityColl(DynamicObjectCollection coll) {
        if (CollectionUtils.isEmpty((Collection)coll)) {
            return;
        }
        ACTIVITY_RECORD_ENTITY.save(coll);
    }

    public static HashMap<String, Object> startCheckTask(DynamicObject[] evalObjs) {
        int allSize;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (ObjectUtils.isEmpty((Object[])evalObjs)) {
            return resultMap;
        }
        int successSize = allSize = evalObjs.length;
        ArrayList failList = Lists.newArrayListWithCapacity((int)10);
        List evalFlowInsList = Arrays.asList(evalObjs).stream().map(row -> row.getLong("evalflowins.id")).collect(Collectors.toList());
        FlowCommonResultBo flowCommonResultBo = FLOW_RU_PROC_DOMAIN_SERVICE.verifyHandlerBeforeStartProcess(evalFlowInsList);
        if (Objects.isNull(flowCommonResultBo) || HRStringUtils.equals((String)flowCommonResultBo.getCode(), (String)"-1")) {
            int failureNum = EvalObjUtils.buiderFailResult(evalObjs, failList, flowCommonResultBo);
            successSize = allSize - failureNum;
        }
        EvalObjUtils.buiderResult(allSize, successSize, failList, resultMap);
        return resultMap;
    }

    private static void buiderResult(int allSize, int successSize, List<Map<String, String>> failList, HashMap<String, Object> resultMap) {
        HashMap message = Maps.newHashMapWithExpectedSize((int)16);
        message.put("totalcount", allSize);
        message.put("sucesscount", successSize);
        message.put("failcount", allSize - successSize);
        message.put("failList", failList);
        resultMap.put("data", message);
        resultMap.put("operationType", "0");
    }

    private static int buiderFailResult(DynamicObject[] evalObjs, List<Map<String, String>> failList, FlowCommonResultBo flowCommonResultBo) {
        int failureNum = 0;
        if (Objects.isNull(flowCommonResultBo)) {
            return failureNum;
        }
        for (DynamicObject evalObj : evalObjs) {
            Map msgMap = flowCommonResultBo.getMsgMap();
            Map corssNodemsgMap = flowCommonResultBo.getCorssNodemsgMap();
            if (MapUtils.isEmpty((Map)msgMap) && MapUtils.isEmpty((Map)corssNodemsgMap)) continue;
            List detail = (List)msgMap.get(evalObj.getLong("id"));
            List crossedDetail = (List)corssNodemsgMap.get(evalObj.getLong("id"));
            if (CollectionUtils.isEmpty((Collection)detail) && CollectionUtils.isEmpty((Collection)crossedDetail)) continue;
            ++failureNum;
            if (CollectionUtils.isNotEmpty((Collection)detail)) {
                EvalObjUtils.setErrorInfo(failList, evalObj, detail);
            }
            if (!CollectionUtils.isNotEmpty((Collection)crossedDetail)) continue;
            EvalObjUtils.setErrorInfo(failList, evalObj, crossedDetail);
        }
        return failureNum;
    }

    private static void setErrorInfo(List<Map<String, String>> failList, DynamicObject evalObj, List<Map<Long, String>> detail) {
        for (Map<Long, String> detailInfo : detail) {
            for (Map.Entry<Long, String> entry : detailInfo.entrySet()) {
                HashMap failMessage = Maps.newHashMapWithExpectedSize((int)16);
                failMessage.put("dealername", evalObj.getString("person.name"));
                failMessage.put("dealernum", evalObj.getString("person.number"));
                failMessage.put("preffileno", evalObj.getString("perffile.number"));
                failMessage.put("detail", entry.getValue());
                failList.add(failMessage);
            }
        }
    }

    public static boolean checkActivityPermission(IFormView formView) {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EvalObjUtils_0", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
        return isPass;
    }

    public static Map<String, Long> reqFormScoreAndLevel(DynamicObject activityDy) {
        HashMap scoreAndLevelMap = Maps.newHashMapWithExpectedSize((int)16);
        long assessFormId = activityDy.getLong("assessform.id");
        DynamicObject assessFormDy = ASSESS_FORM_ENTITY_SERVICE.queryAssessForm(assessFormId);
        Long scoreSystemIdByForm = assessFormDy.getLong("scoresystem.id");
        scoreAndLevelMap.put("scoreSystem", scoreSystemIdByForm);
        Long sumPerfLevelIdForm = assessFormDy.getLong("sumperflevel.id");
        scoreAndLevelMap.put("sumPerfLevel", sumPerfLevelIdForm);
        return scoreAndLevelMap;
    }

    public static Map<String, Boolean> requireLevelAndScoreShowType() {
        HRPluginProxy proxy = new HRPluginProxy((Object)I_EVAL_LEVEL_AND_SCORE_SERVICE, IEvalLevelAndScoreService.class, "kd.opmc.epa.business.domain.outservice.impl.IEvalLevelAndScoreService#requireLevelAndScoreShowType", (PluginFilter)null);
        List results = proxy.callReplaceIfPresent(p -> p.requireLevelAndScoreShowType());
        return CollectionUtils.isEmpty((Collection)results) ? Maps.newHashMapWithExpectedSize((int)16) : (Map)results.get(0);
    }

    public static boolean requireLevelAndScoreParam(String field) {
        Map<String, Boolean> paramMap = EvalObjUtils.requireLevelAndScoreShowType();
        Boolean fieldType = paramMap.get(field);
        return null == fieldType ? Boolean.TRUE : fieldType;
    }
}

